#
# $Id: constants.c.PL,v 14.1 2000/08/15 20:50:39 wpm Exp $
#
# (c) 1999, 2000 Morgan Stanley Dean Witter and Co.
# See ..../src/LICENSE for terms of distribution.
#

use English;
use File::Basename;

require "../util/parse_config";
require "../util/parse_headers";

open(CONSTANTS,">constants.c")
  or die "Unable to open constants.c: $ERRNO\n";

select(CONSTANTS); 

print <<"EndOfHeader";
/*
 * This file is auto-generated by constants.c.PL
 *
 * Constants were found from the following header files:
 */

#include <errno.h>

EndOfHeader

#
# cmqc.h must be included first, otherwise, cmqbc.h will explode.
#
foreach my $header ( grep(/cmqc\.h$/,@headers),
		     grep(!/cmqc\.h$/,@headers) ) {
    my $filename = basename($header);
    print "#include <$filename>\n";
}
	    
print "\n\n";

#
# Generate the constant_hex function 
#
print <<"EndOfText";
unsigned long
constant_hex(name)
char *name;
{
    errno = 0;

EndOfText

foreach $constant ( sort keys %constant_hex ) {
    print <<"EndOfText";
    if ( strcmp(name, "$constant") == 0 )
       return $constant;
    
EndOfText
}

print <<"EndOfText";
    errno = ENOENT;
    return 0;
}

EndOfText

#
# Generate the constant_numeric function
#
print <<"EndOfText";
MQLONG
constant_numeric(name)
char *name;
{
    errno = 0;

EndOfText

foreach $constant ( sort keys %constant_numeric ) {
    print <<"EndOfText";
    if ( strcmp(name, "$constant") == 0 )
       return $constant;
    
EndOfText
}

print <<"EndOfText";
    errno = ENOENT;
    return 0;
}

EndOfText

#
# Now generate the constant_string function
#
print <<"EndOfText";
int
constant_string(name,value)
char * name;
char * value;
{
    errno = 0;

EndOfText

foreach $constant ( sort keys %constant_string ) {

    print <<"EndOfText";

    if ( strcmp(name, "$constant") == 0 ) {
	strcpy(value,$constant);
	return 1;
    }

EndOfText
}

print <<"EndOfText";

    errno = ENOENT;
    return 0;
    
}
EndOfText

#
# Now generate the constant_char function
#
print <<"EndOfText";
int
constant_char(name,value)
char * name;
char * value;
{
    errno = 0;

EndOfText

foreach $constant ( sort keys %constant_char ) {

    print <<"EndOfText";

    if ( strcmp(name, "$constant") == 0 ) {
	value[0] = $constant;
	return 1;
    }

EndOfText
}

print <<"EndOfText";

    errno = ENOENT;
    return 0;
    
}
EndOfText

close(CONSTANTS);

