
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'Flexible event handling over the power of AnyEvent',
  'AUTHOR' => 'Becca <becca@referencethis.com>',
  'BUILD_REQUIRES' => {
    'Coro' => '0',
    'Coro::Timer' => '0',
    'Test::More' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'On-Event',
  'EXE_FILES' => [],
  'LICENSE' => 'perl',
  'NAME' => 'On::Event',
  'PREREQ_PM' => {
    'Any::Moose' => '0',
    'AnyEvent' => '0',
    'Carp' => '0',
    'Scalar::Util' => '0'
  },
  'VERSION' => 'v0.1.0',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



