# -*- cperl -*-
# ABSTRACT: LaTeX operator object


package SpeL::Object::Operator;

use SpeL::Object::Environment;
use SpeL::Object::Group;
use SpeL::Object::MathInline;
use SpeL::Object::MathEnvironment;
use SpeL::Object::Item;
use SpeL::Object::Command;
use SpeL::Object::TokenSequence;
use SpeL::Object::Variable;
use SpeL::Object::Realnumber;
;

use SpeL::I18n;

use parent 'Exporter';
use Carp;

use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  $self->{''} eq '='      and return $SpeL::I18n::lh->maketext( '=' );
  $self->{''} =~ /<|\\lt/ and return $SpeL::I18n::lh->maketext( '<' );
  $self->{''} =~ />|\\gt/ and return $SpeL::I18n::lh->maketext( '>' );
  $self->{''} eq '\le'    and return $SpeL::I18n::lh->maketext( '<=' );
  $self->{''} eq '\ge'    and return $SpeL::I18n::lh->maketext( '>=' );

  return 'Error: Operator';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Operator - LaTeX operator object

=head1 VERSION

version 20240617.1359

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX operator

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
