# -*- cperl -*-
# ABSTRACT: LaTeX limitscommand object


package SpeL::Object::Limitscommand;

use parent 'Exporter';
use Carp;

use SpeL::I18n;
use Data::Dumper;
use SpeL::Object::MathElement;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  $self->{''} =~ /int/ and return $SpeL::I18n::lh->maketext( 'Int' );
  $self->{''} =~ /sum/ and return $SpeL::I18n::lh->maketext( 'Sum' );
  $self->{''} =~ /lim/ and return $SpeL::I18n::lh->maketext( 'Limit' );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Limitscommand - LaTeX limitscommand object

=head1 VERSION

version 20240610

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX limitscommand

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
