# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Language-Lisp-ECL.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More ('no_plan'); # tests => 30?;
BEGIN { use_ok('Language::Lisp::ECLs') };

#########################

my $cl = new Language::Lisp::ECLs;

ok($cl->eval_string("(+ 1 2)")==3, '1+2=3');
is($cl->eval_string("(format nil \"[~S]\" 'qwerty)"), '[QWERTY]');
is($cl->eval_string("'qwerty")->stringify, 'symbol n=QWERTY p=COMMON-LISP-USER', 'symbol stringification');
is($cl->eval_string("(defpackage :qw)")->stringify, 'package n=QW', 'package');
is($cl->eval_string("(defpackage \"qw\")")->stringify, 'package n=qw', 'package');
