#!perl
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/examples.t
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Manifest-Write. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use strict;
use warnings;
use if $ENV{AUTOMATED_TESTING}, 'Test::DiagINC';
use lib 'ex';
use lib 't';

use Path::Tiny;
use Test::More;
use Test::Routine;
use Test::Routine::Util;

with 'ManifestWriteTester';

my $ruler = '-' x 80;

#   Not an actual test. This method just shows content of built `MANIFEST` file.
test 'Show MANIFEST' => sub {
    my ( $self ) = @_;
    if ( $self->exception ) {
        plan skip_all => 'exception occurred';
    }
    #~ my $manifest = path( $self->tzil->built_in )->child( 'MANIFEST' )->slurp_utf8();
    #~ diag( "\n$ruler\n" . $manifest . "$ruler\n" );
    pass;
};

plan tests => 2;

#   Use plugin from the main module synopsis.
run_me 'Synopsis' => {
    plugins => [
        'GatherDir',
        [ '=ManifestWithFileSize', { source_provider => 'GatherDir' } ],
        #  ^^^^^^^^^^^^^^^^^^^^^
    ],
    expected => {
        files => {
            MANIFEST => path( 'ex/ManifestWithFileSize.out' )->slurp_utf8(),
        },
    },
};

run_me 'Example of MANIFEST' => {
    extra_files => {
        'COPYING'       => 'license',
        'Changes'       => 'release history log',
        'README'        => 'documentation',
    },
    options => {
        source_provider => 'GatherDir',
    },
    extra_plugins => [
        'PkgVersion',
        'Test::Compile',
        'Test::EOL',
        'Test::NoTabs',
        'ModuleBuildTiny',
    ],
    expected => {
        # No exception expected.
        files => {
            MANIFEST => path( 'ex/MANIFEST' )->slurp_utf8(),
        },
    },
};

done_testing;

exit( 0 );

# end of file #
