#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/ManifestWriteTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Manifest-Write. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package ManifestWriteTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use autodie ':all';
use namespace::autoclean;

use ExtUtils::Manifest qw{};
use Path::Tiny;
use Perl::Version;
use Test::Deep qw{ re cmp_deeply };
use Test::More;
use Test::Routine;

has extra_files => (
    isa         => 'HashRef',
    is          => 'ro',
    default     => sub { {} },
);

sub _build_files {
    my ( $self ) = @_;
    return {
        'lib/Dummy.pm' => [
            'package Dummy.pm;',
            '',     # Empty line for `PkgVersion`.
            '1;',
        ],
        %{ $self->extra_files },
    };
};

sub _build_message_filter {
    my ( $self ) = @_;
    return sub {
        map( { ( my $r = $_ ) =~ s{^\[[^\]]*\] }{}; $r } grep( $_ =~ m{^\Q[Manifest::Write]\E }, @_ ) );
    };
};

has options => (
    isa         => 'HashRef',
    is          => 'ro',
    default     => sub { {} },
);

has extra_plugins => (
    isa         => 'ArrayRef',
    is          => 'ro',
    default     => sub { [] },
);

sub _build_plugins {
    my ( $self ) = @_;
    return [
        'GatherDir',
        'MetaYAML',
        [ 'Manifest::Write' => $self->options ],
        @{ $self->extra_plugins },
    ];
};

with 'Test::Dist::Zilla::Build';

#   Regular expression to match against the first line of manifest written by `Manifest::Write`.
my $first_line = re( qr{
    \A
    \# \Q This file was generated with Dist::Zilla::Plugin::Manifest::Write \E
        @{ [ Perl::Version::REGEX ] }
    \z
}x );

#   I expect this (pseudo)test will be executed after `Build` but before `BuiltFiles`.
#   It converts `$self->expected->manifest` to `$self->expected->{ files }->{ MANUAL }` to let
#   `BuiltFiles` do the work.
test 'before BuiltFiles' => sub {
    my ( $self ) = @_;
    my $expected = $self->expected;
    if ( $expected->{ manifest } ) {
        $expected->{ files }->{ MANIFEST } = [
            $first_line,
            @{ $expected->{ manifest } },
        ];
    };
    pass;
};

with 'Test::Dist::Zilla::BuiltFiles';

#   Make sure our manifest can be read by `ExtUtils::Manifest::readmani` and result of reading
#   matches list of files in the distribution.
test 'Read manifest' => sub {
    my ( $self ) = @_;
    if ( $self->exception ) {
        plan skip_all => 'exception occurred';
    };
    my $path      = path( $self->tzil->built_in )->child( 'MANIFEST' ) . '';
    my $manifest  = ExtUtils::Manifest::maniread( $path );
    my @manifiles = sort( keys( %$manifest ) );
    my @distfiles = sort( map( { $_->name } @{ $self->tzil->files } ) );
    cmp_deeply( \@manifiles, \@distfiles, 'manifiles == distfiles' );
};

1;

# end of file #
