#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: lib/Dist/Zilla/Plugin/Hook.pm

#pod =encoding UTF-8
#pod
#pod =head1 COPYRIGHT AND LICENSE
#pod
#pod Copyright © 2015 Van de Bugger
#pod
#pod This file is part of perl-Dist-Zilla-Plugin-Hook.
#pod
#pod perl-Dist-Zilla-Plugin-Hook is free software: you can redistribute it and/or modify it under
#pod the terms of the GNU General Public License as published by the Free Software Foundation,
#pod either version 3 of the License, or (at your option) any later version.
#pod
#pod perl-Dist-Zilla-Plugin-Hook is distributed in the hope that it will be useful, but WITHOUT ANY
#pod WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#pod PURPOSE. See the GNU General Public License for more details.
#pod
#pod You should have received a copy of the GNU General Public License along with
#pod perl-Dist-Zilla-Plugin-Hook. If not, see <http://www.gnu.org/licenses/>.
#pod
#pod =cut

#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#pod =for :this This is C<Dist::Zilla::Plugin::Hook> module documentation. Read this if you are going to hack
#pod or extend C<Dist-Zilla-Plugin-Hook>.
#pod
#pod =for :that If you want to write C<Dist::Zilla> plugin directly in F<dist.ini>, read the L<manual|Dist::Zilla::Plugin::Hook::Manual>.
#pod General topics like getting source, building, installing, bug reporting and some others are covered
#pod in the L<readme|Dist::Zilla::Plugin::Hook::ReadMe>.
#pod
#pod =head1 DESCRIPTION
#pod
#pod C<Dist::Zilla> and CPAN do not handle well distributions with no main module. This is a stub "main"
#pod module of C<Dist-Zilla-Plugin-Hook> distribution, its purpose is making C<Dist::Zilla> and C<CPAN> indexer
#pod happy. You should not use it.
#pod
#pod =head1 SEE ALSO
#pod
#pod =for :list
#pod = L<Dist::Zilla>
#pod = L<Dist::Zilla::Plugin::Hook::Manual>
#pod = L<Dist::Zilla::Plugin::Hook::ReadMe>
#pod
#pod =cut

package Dist::Zilla::Plugin::Hook;

use Moose;
use namespace::autoclean;

# ABSTRACT: Write C<Dist::Zilla> plugin directly in F<dist.ini>
our $VERSION = '0.001'; # VERSION

with 'Dist::Zilla::Role::Plugin';
with 'Dist::Zilla::Role::ErrorLogger' => { -version => 0.005 };

#pod =for Pod::Coverage BUILD
#pod
#pod =cut

sub BUILD {
    my ( $self ) = @_;
    $self->log_error( join( "\n",
        "This is a stub and should not be used.",
        "Use Hook subclasses, like Hook::Config or Hook::BeforeBuild.",
    ) );
    $self->abort();
    return;
};

__PACKAGE__->meta->make_immutable();

1;

# doc/what.pod #

#pod =encoding UTF-8
#pod
#pod =head1 WHAT?
#pod
#pod C<Dist-Zilla-Plugin-Hook> (or just C<Hook>) is a set of C<Dist-Zilla> plugins. Every plugin executes Perl
#pod code inlined into F<dist.ini> at particular stage of build process.
#pod
#pod =cut

# end of file #


# end of file #

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Hook - Write C<Dist::Zilla> plugin directly in F<dist.ini>

=head1 VERSION

Version 0.001, released on 2015-07-22 08:39 UTC.

=head1 WHAT?

C<Dist-Zilla-Plugin-Hook> (or just C<Hook>) is a set of C<Dist-Zilla> plugins. Every plugin executes Perl
code inlined into F<dist.ini> at particular stage of build process.

This is C<Dist::Zilla::Plugin::Hook> module documentation. Read this if you are going to hack
or extend C<Dist-Zilla-Plugin-Hook>.

If you want to write C<Dist::Zilla> plugin directly in F<dist.ini>, read the L<manual|Dist::Zilla::Plugin::Hook::Manual>.
General topics like getting source, building, installing, bug reporting and some others are covered
in the L<readme|Dist::Zilla::Plugin::Hook::ReadMe>.

=head1 DESCRIPTION

C<Dist::Zilla> and CPAN do not handle well distributions with no main module. This is a stub "main"
module of C<Dist-Zilla-Plugin-Hook> distribution, its purpose is making C<Dist::Zilla> and C<CPAN> indexer
happy. You should not use it.

=for Pod::Coverage BUILD

=head1 SEE ALSO

=over 4

=item L<Dist::Zilla>

=item L<Dist::Zilla::Plugin::Hook::Manual>

=item L<Dist::Zilla::Plugin::Hook::ReadMe>

=back

=head1 AUTHOR

Van de Bugger <van.de.bugger@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright © 2015 Van de Bugger

This file is part of perl-Dist-Zilla-Plugin-Hook.

perl-Dist-Zilla-Plugin-Hook is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

perl-Dist-Zilla-Plugin-Hook is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
perl-Dist-Zilla-Plugin-Hook. If not, see <http://www.gnu.org/licenses/>.

=cut
