/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
 *    2007 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by opcode.pl from its data.  Any changes made here
 *  will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADAV	 = 10,
	OP_PADHV	 = 11,
	OP_PADANY	 = 12,
	OP_PUSHRE	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_SASSIGN	 = 36,
	OP_AASSIGN	 = 37,
	OP_CHOP		 = 38,
	OP_SCHOP	 = 39,
	OP_CHOMP	 = 40,
	OP_SCHOMP	 = 41,
	OP_DEFINED	 = 42,
	OP_UNDEF	 = 43,
	OP_STUDY	 = 44,
	OP_POS		 = 45,
	OP_PREINC	 = 46,
	OP_I_PREINC	 = 47,
	OP_PREDEC	 = 48,
	OP_I_PREDEC	 = 49,
	OP_POSTINC	 = 50,
	OP_I_POSTINC	 = 51,
	OP_POSTDEC	 = 52,
	OP_I_POSTDEC	 = 53,
	OP_POW		 = 54,
	OP_MULTIPLY	 = 55,
	OP_I_MULTIPLY	 = 56,
	OP_DIVIDE	 = 57,
	OP_I_DIVIDE	 = 58,
	OP_MODULO	 = 59,
	OP_I_MODULO	 = 60,
	OP_REPEAT	 = 61,
	OP_ADD		 = 62,
	OP_I_ADD	 = 63,
	OP_SUBTRACT	 = 64,
	OP_I_SUBTRACT	 = 65,
	OP_CONCAT	 = 66,
	OP_STRINGIFY	 = 67,
	OP_LEFT_SHIFT	 = 68,
	OP_RIGHT_SHIFT	 = 69,
	OP_LT		 = 70,
	OP_I_LT		 = 71,
	OP_GT		 = 72,
	OP_I_GT		 = 73,
	OP_LE		 = 74,
	OP_I_LE		 = 75,
	OP_GE		 = 76,
	OP_I_GE		 = 77,
	OP_EQ		 = 78,
	OP_I_EQ		 = 79,
	OP_NE		 = 80,
	OP_I_NE		 = 81,
	OP_NCMP		 = 82,
	OP_I_NCMP	 = 83,
	OP_REF_EQ	 = 84,
	OP_REF_NE	 = 85,
	OP_SEQ		 = 86,
	OP_SNE		 = 87,
	OP_SCMP		 = 88,
	OP_BIT_AND	 = 89,
	OP_BIT_XOR	 = 90,
	OP_BIT_OR	 = 91,
	OP_NEGATE	 = 92,
	OP_I_NEGATE	 = 93,
	OP_NOT		 = 94,
	OP_COMPLEMENT	 = 95,
	OP_SMARTMATCH	 = 96,
	OP_ATAN2	 = 97,
	OP_SIN		 = 98,
	OP_COS		 = 99,
	OP_RAND		 = 100,
	OP_SRAND	 = 101,
	OP_EXP		 = 102,
	OP_LOG		 = 103,
	OP_SQRT		 = 104,
	OP_INT		 = 105,
	OP_HEX		 = 106,
	OP_OCT		 = 107,
	OP_ABS		 = 108,
	OP_LENGTH	 = 109,
	OP_SUBSTR	 = 110,
	OP_VEC		 = 111,
	OP_INDEX	 = 112,
	OP_RINDEX	 = 113,
	OP_SPRINTF	 = 114,
	OP_ORD		 = 115,
	OP_CHR		 = 116,
	OP_CRYPT	 = 117,
	OP_UCFIRST	 = 118,
	OP_LCFIRST	 = 119,
	OP_UC		 = 120,
	OP_LC		 = 121,
	OP_QUOTEMETA	 = 122,
	OP_RV2AV	 = 123,
	OP_AELEMFAST	 = 124,
	OP_AELEM	 = 125,
	OP_ASLICE	 = 126,
	OP_EACH		 = 127,
	OP_VALUES	 = 128,
	OP_KEYS		 = 129,
	OP_DELETE	 = 130,
	OP_EXISTS	 = 131,
	OP_RV2HV	 = 132,
	OP_HELEM	 = 133,
	OP_HSLICE	 = 134,
	OP_UNPACK	 = 135,
	OP_PACK		 = 136,
	OP_SPLIT	 = 137,
	OP_JOIN		 = 138,
	OP_LIST		 = 139,
	OP_LSLICE	 = 140,
	OP_ANONLIST	 = 141,
	OP_ANONHASH	 = 142,
	OP_SPLICE	 = 143,
	OP_PUSH		 = 144,
	OP_POP		 = 145,
	OP_SHIFT	 = 146,
	OP_UNSHIFT	 = 147,
	OP_SORT		 = 148,
	OP_REVERSE	 = 149,
	OP_GREPSTART	 = 150,
	OP_GREPWHILE	 = 151,
	OP_MAPSTART	 = 152,
	OP_MAPWHILE	 = 153,
	OP_RANGE	 = 154,
	OP_FLIP		 = 155,
	OP_FLOP		 = 156,
	OP_AND		 = 157,
	OP_OR		 = 158,
	OP_XOR		 = 159,
	OP_DOR		 = 160,
	OP_COND_EXPR	 = 161,
	OP_ANDASSIGN	 = 162,
	OP_ORASSIGN	 = 163,
	OP_DORASSIGN	 = 164,
	OP_METHOD	 = 165,
	OP_ENTERSUB	 = 166,
	OP_LEAVESUB	 = 167,
	OP_LEAVESUBLV	 = 168,
	OP_CALLER	 = 169,
	OP_WARN		 = 170,
	OP_DIE		 = 171,
	OP_LINESEQ	 = 172,
	OP_NEXTSTATE	 = 173,
	OP_DBSTATE	 = 174,
	OP_UNSTACK	 = 175,
	OP_ENTER	 = 176,
	OP_LEAVE	 = 177,
	OP_SCOPE	 = 178,
	OP_ENTERITER	 = 179,
	OP_ITER		 = 180,
	OP_ENTERLOOP	 = 181,
	OP_LEAVELOOP	 = 182,
	OP_RETURN	 = 183,
	OP_LAST		 = 184,
	OP_NEXT		 = 185,
	OP_REDO		 = 186,
	OP_DUMP		 = 187,
	OP_GOTO		 = 188,
	OP_EXIT		 = 189,
	OP_METHOD_NAMED	 = 190,
	OP_ENTERGIVEN	 = 191,
	OP_LEAVEGIVEN	 = 192,
	OP_ENTERWHEN	 = 193,
	OP_LEAVEWHEN	 = 194,
	OP_BREAK	 = 195,
	OP_CONTINUE	 = 196,
	OP_OPEN		 = 197,
	OP_CLOSE	 = 198,
	OP_PIPE_OP	 = 199,
	OP_FILENO	 = 200,
	OP_UMASK	 = 201,
	OP_BINMODE	 = 202,
	OP_TIE		 = 203,
	OP_UNTIE	 = 204,
	OP_TIED		 = 205,
	OP_SSELECT	 = 206,
	OP_SELECT	 = 207,
	OP_GETC		 = 208,
	OP_READ		 = 209,
	OP_PRTF		 = 210,
	OP_PRINT	 = 211,
	OP_SYSOPEN	 = 212,
	OP_SYSSEEK	 = 213,
	OP_SYSREAD	 = 214,
	OP_SYSWRITE	 = 215,
	OP_EOF		 = 216,
	OP_TELL		 = 217,
	OP_SEEK		 = 218,
	OP_TRUNCATE	 = 219,
	OP_FCNTL	 = 220,
	OP_IOCTL	 = 221,
	OP_FLOCK	 = 222,
	OP_SEND		 = 223,
	OP_RECV		 = 224,
	OP_SOCKET	 = 225,
	OP_SOCKPAIR	 = 226,
	OP_BIND		 = 227,
	OP_CONNECT	 = 228,
	OP_LISTEN	 = 229,
	OP_ACCEPT	 = 230,
	OP_SHUTDOWN	 = 231,
	OP_GSOCKOPT	 = 232,
	OP_SSOCKOPT	 = 233,
	OP_GETSOCKNAME	 = 234,
	OP_GETPEERNAME	 = 235,
	OP_LSTAT	 = 236,
	OP_STAT		 = 237,
	OP_FTRREAD	 = 238,
	OP_FTRWRITE	 = 239,
	OP_FTREXEC	 = 240,
	OP_FTEREAD	 = 241,
	OP_FTEWRITE	 = 242,
	OP_FTEEXEC	 = 243,
	OP_FTIS		 = 244,
	OP_FTSIZE	 = 245,
	OP_FTMTIME	 = 246,
	OP_FTATIME	 = 247,
	OP_FTCTIME	 = 248,
	OP_FTROWNED	 = 249,
	OP_FTEOWNED	 = 250,
	OP_FTZERO	 = 251,
	OP_FTSOCK	 = 252,
	OP_FTCHR	 = 253,
	OP_FTBLK	 = 254,
	OP_FTFILE	 = 255,
	OP_FTDIR	 = 256,
	OP_FTPIPE	 = 257,
	OP_FTSUID	 = 258,
	OP_FTSGID	 = 259,
	OP_FTSVTX	 = 260,
	OP_FTLINK	 = 261,
	OP_FTTTY	 = 262,
	OP_FTTEXT	 = 263,
	OP_FTBINARY	 = 264,
	OP_CHDIR	 = 265,
	OP_CHOWN	 = 266,
	OP_CHROOT	 = 267,
	OP_UNLINK	 = 268,
	OP_CHMOD	 = 269,
	OP_UTIME	 = 270,
	OP_RENAME	 = 271,
	OP_LINK		 = 272,
	OP_SYMLINK	 = 273,
	OP_READLINK	 = 274,
	OP_MKDIR	 = 275,
	OP_RMDIR	 = 276,
	OP_OPEN_DIR	 = 277,
	OP_READDIR	 = 278,
	OP_TELLDIR	 = 279,
	OP_SEEKDIR	 = 280,
	OP_REWINDDIR	 = 281,
	OP_CLOSEDIR	 = 282,
	OP_FORK		 = 283,
	OP_WAIT		 = 284,
	OP_WAITPID	 = 285,
	OP_SYSTEM	 = 286,
	OP_EXEC		 = 287,
	OP_KILL		 = 288,
	OP_GETPPID	 = 289,
	OP_GETPGRP	 = 290,
	OP_SETPGRP	 = 291,
	OP_GETPRIORITY	 = 292,
	OP_SETPRIORITY	 = 293,
	OP_TIME		 = 294,
	OP_TMS		 = 295,
	OP_LOCALTIME	 = 296,
	OP_GMTIME	 = 297,
	OP_ALARM	 = 298,
	OP_SLEEP	 = 299,
	OP_SHMGET	 = 300,
	OP_SHMCTL	 = 301,
	OP_SHMREAD	 = 302,
	OP_SHMWRITE	 = 303,
	OP_MSGGET	 = 304,
	OP_MSGCTL	 = 305,
	OP_MSGSND	 = 306,
	OP_MSGRCV	 = 307,
	OP_SEMOP	 = 308,
	OP_SEMGET	 = 309,
	OP_SEMCTL	 = 310,
	OP_REQUIRE	 = 311,
	OP_DOFILE	 = 312,
	OP_HINTSEVAL	 = 313,
	OP_ENTEREVAL	 = 314,
	OP_LEAVEEVAL	 = 315,
	OP_ENTERTRY	 = 316,
	OP_LEAVETRY	 = 317,
	OP_GHBYNAME	 = 318,
	OP_GHBYADDR	 = 319,
	OP_GHOSTENT	 = 320,
	OP_GNBYNAME	 = 321,
	OP_GNBYADDR	 = 322,
	OP_GNETENT	 = 323,
	OP_GPBYNAME	 = 324,
	OP_GPBYNUMBER	 = 325,
	OP_GPROTOENT	 = 326,
	OP_GSBYNAME	 = 327,
	OP_GSBYPORT	 = 328,
	OP_GSERVENT	 = 329,
	OP_SHOSTENT	 = 330,
	OP_SNETENT	 = 331,
	OP_SPROTOENT	 = 332,
	OP_SSERVENT	 = 333,
	OP_EHOSTENT	 = 334,
	OP_ENETENT	 = 335,
	OP_EPROTOENT	 = 336,
	OP_ESERVENT	 = 337,
	OP_GPWNAM	 = 338,
	OP_GPWUID	 = 339,
	OP_GPWENT	 = 340,
	OP_SPWENT	 = 341,
	OP_EPWENT	 = 342,
	OP_GGRNAM	 = 343,
	OP_GGRGID	 = 344,
	OP_GGRENT	 = 345,
	OP_SGRENT	 = 346,
	OP_EGRENT	 = 347,
	OP_GETLOGIN	 = 348,
	OP_SYSCALL	 = 349,
	OP_LOCK		 = 350,
	OP_COMPSUB	 = 351,
	OP_CUSTOM	 = 352,
	OP_max		
} opcode;

#define MAXO 353
#define OP_phoney_INPUT_ONLY -1
#define OP_phoney_OUTPUT_ONLY -2


/* the OP_IS_(SOCKET|FILETEST) macros are optimized to a simple range
    check because all the member OPs are contiguous in opcode.pl
    <DATA> table.  opcode.pl verifies the range contiguity.  */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

/* ex: set ro: */
