#!/usr/bin/perl -w

BEGIN {
    if( %ENV{PERL_CORE} ) {
        chdir 't';
        @INC = @('../lib', 'lib/');
    }
    else {
        unshift @INC, 't/lib/';
    }
}
chdir 't';

my $Is_VMS = $^O eq 'VMS';

use File::Spec;

use Test::More tests => 4;

my @cd_args = @("some/dir", "command1", "command2");

{
    package Test::MM_Win32;
    use ExtUtils::MM_Win32;
    our @ISA = qw(ExtUtils::MM_Win32);

    my $mm = bless \%(), 'Test::MM_Win32';

    {
        local *make = sub { "nmake" };

        my @dirs = @( (File::Spec->updir) x 2 );
        my $expected_updir = File::Spec->catdir(< @dirs);
        
        main::is $mm->cd(< @cd_args),
qq{cd some/dir
	command1
	command2
	cd $expected_updir};
    }
    
    {
        local *make = sub { "dmake" };

        main::is $mm->cd(< @cd_args),
q{cd some/dir && command1
	cd some/dir && command2};
    }
}

{
    is +ExtUtils::MM_Unix->cd(< @cd_args),
q{cd some/dir && command1
	cd some/dir && command2};
}

SKIP: {
    skip("VMS' cd requires vmspath which is only on VMS", 1) unless $Is_VMS;
    
    use ExtUtils::MM_VMS;
    is +ExtUtils::MM_VMS->cd(< @cd_args),
q{startdir = F$Environment("Default")
	Set Default [.some.dir]
	command1
	command2
	Set Default 'startdir'};
}
