$! OpenVMS configuration procedure for Perl -- do not attempt to run under DOS
$ sav_ver = 'F$VERIFY(0)'
$ on control_y then goto clean_up
$! SET VERIFY
$!
$! For example, if you unpacked perl into: [USER.PERL-5n...] then you will 
$! want to cd into the tree and execute Configure:
$!
$! $ SET DEFAULT [USER.PERL5_xxx]
$! $ @Configure 
$!
$! or
$!
$! $ SET DEFAULT [USER.PERL5_xxx]
$! $ @Configure "-des"
$!
$! That's it. If you get into a bind trying to build perl on VMS then 
$! definitely read through the README.VMS file.
$! Beyond that send email to vmsperl@perl.org
$!
$! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$!
$! send suggestions to: 
$!  Dan Sugalski <dan@sidhe.org>
$! Thank you!!!!
$!
$! Adapted and converted from Larry Wall & Andy Dougherty's
$! "Configure generated by metaconfig 3.0 PL60." by Peter Prymmer
$! (a Bourne sh[ell] script for configuring the installation of perl 
$! on non-VMS systems) in the perl5.002|3 epoch (spring/summer 1996)
$! with much valuable help from Charles Bailey & 
$! the whole VMSPerl crew.
$! Extended and messed about with by Dan Sugalski
$!
$! VMS-isms we will need:
$ echo = "write sys$output "
$ cat  = "type"
$ delete := delete ! local symbol overrides globals with qualifiers
$ gcc_symbol = "gcc"
$ ld = "Link/nodebug"
$ ans = ""
$ macros = ""
$ extra_flags = ""
$ user_c_flags = ""
$ use_ieee_math = "y"
$ be_case_sensitive = "n"
$ unlink_all_versions = "n"
$ builder = "MMK"
$ use_vmsdebug_perl = "n"
$ use64bitall = "n"
$ use64bitint = "n"
$ uselongdouble = "n"
$ uselargefiles = "n"
$ usestdstat = "n"
$ usedecterm = "n"
$ usesitecustomize = "n"
$ C_Compiler_Replace = "CC="
$ thread_upcalls = "MTU="
$ thread_kernel = "MTK="
$ use_two_pot_malloc = "N"
$ use_pack_malloc = "N"
$ use_debugmalloc = "N"
$ ccflags = ""
$ static_ext = ""
$ nonxs_ext = ""
$ vms_default_directory_name = F$ENVIRONMENT("DEFAULT")
$ max_allowed_dir_depth = 3  ! e.g. [A.B.PERLxxx] not [A.B.C.PERLxxx]
$! max_allowed_dir_depth = 2 ! e.g. [A.PERLxxx] not [A.B.PERLxxx]
$!
$! Sebastian Bazley's request: close the CONFIG handle with /NOLOG
$! qualifier "just in case" (configure.com is re @ed in a bad state).
$! This construct was tested to be not a problem as far back as
$! VMS V5.5-2, hopefully earlier versions are OK as well.
$!
$ CLOSE/NOLOG CONFIG
$!
$! Now keep track of open files
$!
$ vms_filcnt = F$GETJPI ("","FILCNT")
$!
$!: compute my invocation name
$ me = F$ENVIRONMENT("PROCEDURE")
$!
$! Many null statements (begin with colon ':') in the Bourne shell version of
$! this script serve as comments/placeholders. I have retained some of the ones
$! that will help you compare this .COM file to the sh version - as well as
$! leave placeholders for future improvements to this .COM file.
$! sfn = VMS "skipped for now"
$!
$!: Proper PATH separator                              !sfn
$!: Proper PATH setting                                !sfn
$!: Sanity checks                                      !sfn "Say '@''$me''"
$!: On HP-UX, large Configure scripts may exercise a bug in /bin/sh !sfn
$!: Configure runs within the UU subdirectory          !->after find MANIFEST
$!   <big long list of default values (mostly null)>
$!: We must find out about Eunice early                !(?)
$!: list of known cpp symbols, sorted alphabetically   !sfn
$!   al = al + "..."
$!: default library list                               !sfn
$!   <no hints files in use (yet?)>
$!: Extra object files, if any, needed on this platform. !sfn
$!: Possible local include directories to search.      !sfn
$!: Set locincpth to "" in a hint file to defeat local include searches. !sfn
$!locincpth="/usr/local/include /opt/local/include /usr/gnu/include" !sfn
$!locincpth="$locincpth /opt/gnu/include /usr/GNU/include /opt/GNU/include"
$!: no include file wanted by default                  !sfn
$!inclwanted=''                                        !sfn
$!: Possible local library directories to search.      !sfn
$!loclibpth="/usr/local/lib /opt/local/lib /usr/gnu/lib" !sfn
$!loclibpth="$loclibpth /opt/gnu/lib /usr/GNU/lib /opt/GNU/lib" !sfn
$!: general looking path for locating libraries        !sfn
$!glibpth="/lib/pa1.1 /usr/shlib /usr/lib/large /lib /usr/lib" !sfn
$!glibpth="$glibpth $xlibpth /lib/large /usr/lib/small /lib/small" !sfn
$!glibpth="$glibpth /usr/ccs/lib /usr/ucblib /usr/shlib" !sfn
$!: Private path used by Configure to find libraries.  Its value !sfn
$!: is prepended to libpth. This variable takes care of special !sfn
$!: machines, like the mips.  Usually, it should be empty. !sfn
$!plibpth=''                                           !sfn
$!: full support for void wanted by default            !sfn
$!defvoidused=15                                       !sfn
$!: List of libraries we want.                         !sfn
$!libswanted='net socket inet nsl nm ndbm gdbm dbm db malloc dl' !sfn
$!libswanted="$libswanted dld ld sun m c cposix posix ndir dir crypt" !sfn
$!libswanted="$libswanted ucb bsd BSD PW x"            !sfn
$!: We probably want to search /usr/shlib before most other libraries. !sfn
$!: This is only used by the lib/ExtUtils/MakeMaker.pm routine extliblist. !sfn
$!glibpth=`echo " $glibpth " | sed -e 's! /usr/shlib ! !'` !sfn
$!glibpth="/usr/shlib $glibpth"                        !sfn
$!: Do not use vfork unless overridden by a hint file. !sfn
$!usevfork=false                                       !sfn
$!: script used to extract .SH files with variable substitutions !sfn
$!: produce awk script to parse command line options   !sfn
$!sfn (assume no sed awk) see below
$!: process the command line options         
$!
$!: set up default values
$ fastread=""
$ reuseval="false"
$ maniskip = "false"
$ IF F$TYPE(config_sh) .EQS. "" THEN config_sh=""
$ alldone=""
$ error=""
$ silent=""
$ extractsh=""
$ override=""
$ knowitall=""
$ ccname="VAX"
$ Dec_C_Version = ""
$ cxxversion = ""
$ use_threads = "F"
$ use_5005_threads = "N"
$ use_ithreads = "N"
$!
$!: option parsing
$ config_args = ""
$ IF (P1 .NES. "")
$ THEN            !one or more switches was thrown
$   i = 1
$   bang = 0
$Param_loop:
$   IF (P'i'.NES."") 
$   THEN
$     bang = bang + 1
$     config_args = config_args + F$FAO(" !AS",P'i')
$   ENDIF
$   i = i + 1
$   IF (i.LT.9) THEN GOTO Param_loop !DCL allows P1..P8
$!
$   i = 1
$Opt_loop:
$   IF (F$EXTRACT(0,1,P'i') .EQS. "-") THEN P'i' = P'i' - "-"
$   IF (F$EXTRACT(0,1,P'i') .EQS. "/") THEN P'i' = P'i' - "/"
$Remove_quotation_mark:
$   P'i' = P'i' - """"
$   IF F$LOCATE("""",P'i') .LT. F$LENGTH(P'i') THEN GOTO Remove_quotation_mark
$   gotopt      = "f" !"alse"
$   gotshortopt = "f" !"alse"
$   IF (F$EXTRACT(0,1,P'i') .EQS. "d")
$   THEN
$     fastread    = "yes"
$     gotopt      = "t" !"rue"
$     P'i'        = P'i' - "d"
$     gotshortopt = "t" !"rue"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "e")
$   THEN
$     alldone = "cont"
$     gotopt = "t"
$     P'i' = P'i' - "e"
$     gotshortopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "f") ! "-f"
$   THEN
$     P'i' = P'i' - "f"
$     config_sh = P'i'
$     IF (F$SEARCH(config_sh).NES."")
$     THEN
$       test_config_sh = F$FILE_ATTRIBUTES(config_sh,"PRO")
$       IF (F$LOCATE("R",test_config_sh).NE.F$LENGTH(test_config_sh)) 
$       THEN
$         config_dflt = "y"
$         CONTINUE !at this point check UIC && if test allows...
$                  !to be continued ?
$       ELSE
$         echo "''me': cannot read config file ''config_sh'."
$         error="true"
$       ENDIF
$     ELSE
$       echo "''me': cannot read config file ''config_sh'."
$       error="true"
$     ENDIF
$     gotopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "h") ! "-h"
$   THEN
$     error = "true"
$     gotopt = "t"
$     P'i' = P'i' - "h"
$     gotshortopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "m")  ! "-m"
$   THEN
$     maniskip = "true"
$     gotopt = "t"
$     P'i' = P'i' - "m"
$     gotshortopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "r")  ! "-r"
$   THEN
$     reuseval = "true"
$     gotopt = "t"
$     P'i' = P'i' - "r"
$     gotshortopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "s") ! "-s"
$   THEN
$     silent = "true"
$     gotopt = "t"
$     P'i' = P'i' - "s"
$     gotshortopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "E") ! "-E"
$   THEN
$     alldone = "exit"
$     gotopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "K") ! "-K"
$   THEN
$     knowitall = "true"
$     gotopt = "t"
$     P'i' = P'i' - "K"
$     gotshortopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "O") ! "-O"
$   THEN
$     override = "true"
$     gotopt = "t"
$     P'i' = P'i' - "O"
$     gotshortopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "S") ! "-S"
$   THEN
$     extractsh = "true"  !VMS?  Yes with munchconfig
$     gotopt = "t"
$     P'i' = P'i' - "S"
$     gotshortopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "D") ! "-D"
$   THEN
$     P'i' = P'i' - "D"
$     IF (F$LOCATE("=",P'i') .EQ. F$LENGTH(P'i'))
$     THEN
$       tmp = P'i' + "=""define"""
$       'tmp'
$       DELETE/SYMBOL tmp
$     ELSE 
$       IF (F$LOCATE("=",P'i') .EQ. (F$LENGTH(P'i') - 1))
$       THEN
$         me = F$PARSE(me,,,"NAME") + F$PARSE(me,,,"TYPE")
$         echo "''me': use ""-Usymbol=val"" not ""-Dsymbol=""."
$         echo "''me': ignoring -D",P'i'
$       ELSE
$          tmp = F$EXTRACT(0,F$LOCATE("=",P'i'),P'i')
$          tmp = tmp + "=""" + F$EXTRACT(F$LOCATE("=",P'i')+1,F$LENGTH(P'i'),P'i') + """"
$         'tmp'
$         DELETE/SYMBOL tmp
$       ENDIF
$     ENDIF
$     gotopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "U") ! "-U"
$   THEN
$     P'i' = P'i' - "U"
$     IF (F$LOCATE("=",P'i') .EQ. F$LENGTH(P'i'))
$     THEN
$       tmp = P'i' + "="""""
$       'tmp'
$       DELETE/SYMBOL tmp
$     ELSE 
$       IF (F$LOCATE("=",P'i') .LT. (F$LENGTH(P'i') - 1))
$       THEN
$         me = F$PARSE(me,,,"NAME") + F$PARSE(me,,,"TYPE")
$         echo "''me': use ""-Dsymbol=val"" not ""-Usymbol=val""."
$         echo "''me': ignoring -U",P'i'
$       ELSE
$         tmp = P'i' + "=""undef"""
$         'tmp'
$         DELETE/SYMBOL tmp
$       ENDIF
$     ENDIF
$     gotopt = "t"
$   ENDIF
$   IF (F$EXTRACT(0,1,P'i') .EQS. "V")
$   THEN
$     me = F$PARSE(me,,,"NAME") + F$PARSE(me,,,"TYPE")
$     echo "''me' generated by an unknown version of EDT."
$     STOP
$     EXIT
$   ENDIF
$   IF .NOT.gotopt 
$   THEN
$     echo "''me': unknown option ",P'i'
$     error = "true"
$   ENDIF
$   IF (F$LENGTH(P'i').GT.0).AND.(gotshortopt) THEN i = i - 1 !clustered switch
$   i = i + 1 
$   IF (i .LT. (bang + 1)) THEN GOTO Opt_loop
$!
$ ENDIF  ! (P1 .NES. "")
$ config_args = F$EDIT(config_args,"TRIM")
$!
$ IF (error)
$ THEN
$   me = F$PARSE(me,,,"DIRECTORY")+ F$PARSE(me,,,"NAME")
$   echo "Usage: @''me' [-dehmr""EKOSV""] [-fconfig.sh] [""-Dsymbol""] [""-Dsymbol=value""]"
$   echo "                [-Usymbol]  [-Usymbol=]"
$   TYPE SYS$INPUT:
$   DECK
 "-d" : use defaults for all answers.
 "-e" : go on without questioning past the production of config.sh.    *
 "-f" : specify an alternate default configuration file.
 "-h" : print this help message and exit (with an error status).
 "-m" : skip the MANIFEST check to see that all files are present
 "-r" : reuse C symbols value if possible (skips costly nm extraction).*
 "-s" : silent mode, only echoes questions and essential information.
 -"D" : define symbol to have some value:                              *
         -"Dsymbol"         symbol gets the value 'define'
         -"Dsymbol=value"   symbol gets the value 'value'
  -E  : stop at the end of questions, after having produced config.sh. *
  -K  : do not use unless you know what you are doing.
  -O  : let -D and -U override definitions from loaded configuration file. *
  -S  : perform variable substitutions on all .SH files (can mix with -f) *
 -"U" : undefine symbol:                                               *
         -"Usymbol"    symbol gets the value 'undef'
         -"Usymbol="   symbol gets completely empty
  -V  : print version number and exit (with a zero status).
$   EOD
$   echo "%Config-I-VMS, lower case switches must be enclosed"
$   echo "-Config-I-VMS, in double quotation marks, e.g.:"
$   echo "-Config-I-VMS,   @Configure ""-des"""
$   echo "-Config-I-VMS, * indicates switch may not be fully implemented for VMS."
$   SET DEFAULT 'vms_default_directory_name' !be kind rewind
$   STOP
$   EXIT 3 ! $STATUS = "%X00000003" (informational)
$ ENDIF
$!
$ GOTO Check_silence
$!
$Shut_up:
$ IF F$Mode() .eqs. "BATCH"
$ THEN
$   STDOUT = F$PARSE(F$GETQUI("DISPLAY_ENTRY", "JOB_NAME"), -
                    F$GETQUI("DISPLAY_ENTRY", "LOG_SPECIFICATION"), ".LOG")
$   WRITE SYS$OUTPUT "Warning: Executing in batch mode.  To avoid file locking conflicts,"
$   WRITE SYS$OUTPUT "output intended for SYS$OUTPUT will be sent to a new version"
$   WRITE SYS$OUTPUT STDOUT
$ ELSE
$   STDOUT = F$TRNLNM("SYS$OUTPUT")
$ ENDIF
$ DEFINE SYS$OUTPUT "_NLA0:"
$ echo4 = "write STDOUT "
$ cat4 = "TYPE/OUTPUT=''STDOUT'"
$ open/write/share=read STDOUT 'STDOUT'
$ RETURN
$!
$Check_silence:
$ IF (silent) 
$ THEN
$   GOSUB Shut_up
$ ELSE
$   echo4 = "write SYS$OUTPUT "
$   cat4 = "TYPE"
$ ENDIF
$!
$!: run the defines and the undefines, if any, but leave the file out there...
$! Unfortunately Configure.COM in DCL is not yet set up to do this - 
$! maybe someday
$!
$!: set package name
$ package = "perl5"
$ packageup = F$EDIT((package - "5"),"UPCASE")
$!
$!: Eunice requires " " instead of "", can you believe it
$ echo ""
$!: Here we go...
$ echo "Beginning of configuration questions for ''package'."
$ echo ""
$!
$!: Some greps do not return status, grrr.
$ contains = "SEARCH"
$!
$!: first determine how to suppress newline on echo command !cant DCL is record oriented
$! echo "Checking ''echo' to see how to suppress newlines..."
$! echo "giving up..."
$! echo "The star should be here-->*"
$!
$!: Now test for existence of everything in MANIFEST
$ echo ""
$ echo4 "First let's make sure your kit is complete.  Checking..."
$ manifestfound = "" 
$ miss_list = "" 
$! Here I assume we are in the [foo.PERLxxx...] tree
$! because the search routine simply does set def [-] if necessary.
$ file_2_find = "MANIFEST" !I hope this one is not in [foo.PERL5xxx.VMS...] 
$Research_manifest:
$ manifestfound = F$SEARCH(file_2_find)
$ IF (manifestfound .EQS. "")
$ THEN
$   IF F$PARSE(F$ENVIRONMENT("DEFAULT"),,,"DIRECTORY",).NES."[000000]"
$   THEN
$     SET DEFAULT [-]
$     GOTO Research_manifest
$   ELSE
$     echo ""
$     echo "There is no MANIFEST file.  I hope your kit is complete !"
$     miss_list = ""
$     GOTO Beyond_manifest
$   ENDIF
$ ELSE
$! MANIFEST. has been found and we have set def'ed there.
$! Time to bail out before it's too late, i.e. too deep.
$! Depth check is unnecessary on Alpha VMS V7.2++ (even for ODS-2).
$   tmp = f$extract(1,3,f$edit(f$getsyi("VERSION"),"TRIM,COLLAPSE"))
$   IF (tmp .GES. "7.2") .AND. (F$GETSYI("HW_MODEL") .GE. 1024) THEN GOTO Beyond_depth_check
$! Depth check also unnecessary on ODS 5 (or later) file systems.
$   tmp = F$INTEGER(F$GETDVI(F$ENVIRONMENT("DEFAULT"),"ACPTYPE") - "F11V")
$   IF (tmp .GE. 5) THEN GOTO Beyond_depth_check
$   IF (F$ELEMENT(max_allowed_dir_depth,".",F$ENVIRONMENT("DEFAULT")).nes.".")
$   THEN
$     TYPE SYS$INPUT:
$     DECK
%Config-E-VMS, ERROR:
 Sorry! It apears as though your perl build sub-directory is already too
 deep into the VMS file system. Please try moving stuff into a shallower 
 directory (or altering the "max_allowed_dir_depth" parameter).
$     EOD
$     echo4 "ABORTING..."
$     SET DEFAULT 'vms_default_directory_name' !be kind rewind
$     STOP
$     EXIT !2 !$STATUS = "%X00000002" (error)
$   ENDIF
$Beyond_depth_check:
$!
$! after finding MANIFEST let's create (but not yet enter) the UU subdirectory
$!
$   IF (manifestfound .NES. "")
$   THEN
$     IF ( F$SEARCH("UU.DIR").EQS."" )
$     THEN
$       CREATE/DIRECTORY [.UU]
$     ELSE
$       IF ( F$SEARCH("[.UU]*.*").NES."" ) THEN DELETE/NOLOG/NOCONFIRM [.UU]*.*;*
$     ENDIF
$!: Configure runs within the UU subdirectory
$     SET DEFAULT [.UU]
$!
$! a little redundancy never hurt anybody?
$     file_2_find = "[-]" + file_2_find
$     manifestfound = F$SEARCH(file_2_find)
$!
$     OPEN/WRITE MISSING MISSING.
$!change to "FALSE" if you wish to skip the manifest search 
$!(which after all is rather slow in DCL :-)
$     IF (maniskip)
$     THEN
$       echo "Skipping MANIFEST check as requested"
$     ELSE
$!
$       OPEN/READ CONFIG 'manifestfound'
$Read_loop_manifest:
$       READ/END_OF_FILE = Done_manifest CONFIG line
$! This algorithm turns "foo/bar/baz.c" into "[.foo.bar]baz.c"
$! pvhp@lns62.lns.cornell.edu 10-JUN-1996 20:31:46
$! 2-MAR-1998 15:46:11 Improved to turn "foo/bar/baz.c.buz"
$! into "[.foo.bar]baz.c_buz as happens with vmstar and unzip
$       line = F$EDIT(line,"TRIM, COMPRESS")
$       file_2_find = F$EXTRACT(0,F$LOCATE(" ",line),line) 
$       IF F$LOCATE("/",file_2_find) .NE. F$LENGTH(file_2_find) 
$       THEN 
$Re_strip_line_manifest:
$         loca = F$LOCATE("/",file_2_find)
$         ante = F$EXTRACT(0,loca,file_2_find)
$         post = F$EXTRACT(loca,F$LENGTH(file_2_find),file_2_find)
$         test_this = ante + "." + (post - "/")
$         IF F$LOCATE("/",test_this) .NE. F$LENGTH(test_this)
$         THEN 
$           file_2_find = ante + "." + (post - "/")
$           GOTO Re_strip_line_manifest
$         ELSE
$           file_2_find = ante + "]" + (post - "/")
$         ENDIF
$           file_2_find = "[-."+file_2_find
$       ELSE
$         file_2_find = "[-]" + file_2_find
$       ENDIF
$!
$       tmp = F$PARSE(file_2_find + ";",,,,"SYNTAX_ONLY")
$       IF F$SEARCH(tmp) .NES. "" THEN file_2_find = tmp
$       dirname = F$EXTRACT(0,F$LOCATE("]",file_2_find),file_2_find) + "]"
$       file_2_find = file_2_find - dirname
$!
$!      may not need double dot check on ODS-5 volumes
$       found = F$SEARCH(dirname + file_2_find)
$       IF found .NES. "" THEN GOTO Read_loop_manifest
$!
$       dots = 0
$Dot_loop:
$       dot_ele = F$ELEMENT(dots,".",file_2_find)
$       IF dot_ele .EQS. "." THEN GOTO Eo_dot_loop
$       IF dots .eq. 0
$       THEN basename = f$extract(0,f$locate(".",file_2_find),file_2_find) + "."
$       ELSE basename = basename + dot_ele + "_"
$       ENDIF
$       dots = dots + 1
$       GOTO dot_loop
$Eo_dot_loop:
$       IF (((f$length(file_2_find)+1) .eq. f$length(basename)) .and. -
             (f$extract(f$length(basename)-1,1,basename) .eqs. "_")) THEN -
          basename = f$extract(0,f$length(basename)-1,basename)
$       file_2_find = dirname + basename
$!
$       found = F$SEARCH(file_2_find)
$       IF (found .EQS. "" .AND. dots .GT. 2)
$       THEN
$! 17-DEC-1999 Improved to turn "[.foo.bar]baz.c_buz" into
$! "[.foo.bar]baz_c.buz" to cover unzipped archives and put
$! "[.foo.bar]baz.c_buz,baz_c.buz" into missing list if neither is found.
$         dotloc = f$locate(".",basename)
$         basename[dotloc,1] := "_"
$         dot_ele = F$ELEMENT(dots - 1,"_",f$extract(dotloc,f$length(basename),basename))
$         basename = -
            f$extract(0,f$length(basename)-(f$length(dot_ele)+1),basename) -
              + "." + dot_ele
$         found = F$SEARCH(dirname + basename)
$         file_2_find = file_2_find + "," + basename
$       ENDIF
$       IF (found .EQS. "")
$       THEN
$         WRITE MISSING file_2_find
$         IF ((F$LENGTH(miss_list)+F$LENGTH(file_2_find)).LT.250)
$         THEN
$           miss_list = miss_list + "," + file_2_find
$         ENDIF
$       ENDIF
$       GOTO Read_loop_manifest
$Done_manifest:
$       CLOSE CONFIG
$     ENDIF  !"TRUE"
$     CLOSE MISSING
$   ENDIF ! (manifestfound .NES. "")
$Beyond_manifest:
$   IF (miss_list .NES. "")
$   THEN
$     echo "Some of the files not found include:"
$     cat4 MISSING.
$   ENDIF
$   IF ((miss_list .NES. "").OR.(manifestfound .EQS. ""))
$   THEN
$     TYPE SYS$INPUT:
$     DECK


THIS PACKAGE SEEMS TO BE INCOMPLETE.

You have the option of continuing the configuration process, despite the
distinct possibility that your kit is damaged, by typing 'y'es.  If you
do, don't blame me if something goes wrong.  I advise you to type 'n'o
and contact the author (dan@sidhe.org)

$     EOD
$     READ SYS$COMMAND/PROMPT="Continue? [n] " ans
$     IF ans
$     THEN
$       echo4 "Continuing..."
$     ELSE
$       echo4 "ABORTING..."
$       GOTO Clean_up
$     ENDIF
$   ELSE
$     echo4 "Looks good..."
$     DELETE/NOLOG/NOCONFIRM MISSING.;
$   ENDIF ! (miss_list .NES. "")
$ ENDIF   ! (manifestfound .EQS. "") ELSE 
$!
$! after finding MANIFEST (see above)
$!: Configure runs within the UU subdirectory 
$!
$!: compute the number of columns on the terminal for proper question formatting
$ IF F$MODE() .EQS. "BATCH"
$! else it winds up being 512 in batch
$ THEN COLUMNS = 80
$ ELSE COLUMNS = F$GETDVI("SYS$OUTPUT","DEVBUFSIZ")
$ ENDIF
$! "-des" sets SYS$OUTPUT to NL: with a DEVBUFSIZ too large (512 again)
$ IF COLUMNS .GT. 210 THEN COLUMNS = 80
$! not sure if this would actually be needed - it hopefully will not hurt
$ IF COLUMNS .LT. 40 THEN COLUMNS = 40
$!
$!: set up the echo used in my read              !sfn
$!: now set up to do reads with possible shell escape and default assignment !sfn
$ GOTO Beyond_myread
$!
$! The sub_rp splitting is intended to handle long symbols such as the dflt for
$! extensions.
$!
$myread:
$ ans = ""
$ len_rp = F$LENGTH(rp)
$   If (.NOT. silent) Then echo ""
$   IF len_rp .GT. 210
$   THEN
$     i_rp = 0
$   rp_loop:
$       sub_rp = F$EXTRACT(i_rp,COLUMNS,rp)
$       i_rp = i_rp + COLUMNS
$       if i_rp .LT. len_rp THEN echo4 "''sub_rp'"
$     IF i_rp .LT. len_rp THEN GOTO rp_loop
$   ELSE
$   sub_rp = rp
$   ENDIF
$ if (fastread)
$ then
$     echo4 "''sub_rp'"
$ else
$     READ SYS$COMMAND/PROMPT="''sub_rp'" ans
$ endif
$   IF (ans .EQS. "&-d")
$   THEN
$     echo4 "(OK, I will run with -d after this question.)"
$   echo ""
$   deferred_fastread =1
$   goto myread
$   ENDIF
$   IF (ans .EQS. "&-s")
$   THEN
$     echo4 "(OK, I will run with -s after this question.)"
$     echo ""
$   deferred_silent = 1
$   goto myread
$     ENDIF
$ if (bool_dflt .nes. "")
$ then
$   if (ans .eqs. "") then ans = bool_dflt
$   ans = f$extract(0,1,f$edit(ans,"collapse,upcase"))
$   if (ans .eqs. "Y" .or. ans .eqs. "1" .or. ans .eqs. "T") 
$   then
$       ans = "Y"
$   else
$       if (ans .eqs. "N" .or. ans .eqs. "0" .or. ans .eqs. "F") 
$       then
$           ans = "N"
$       else
$           echo4 "Input not understood please answer 'Yes' or 'No'"
$           goto myread
$       endif
$   endif
$   bool_dflt = ""
$ else
$   ans = f$edit(ans,"trim,compress")
$   if (ans .eqs. "") then ans = dflt
$   if (f$edit(ans,"upcase") .eqs. "NONE") then ans = ""
$ endif
$ if f$type(deferred_silent) .nes. ""  
$ then
$     silent := true
$     GOSUB Shut_up
$     delete/symbol deferred_silent
$   ENDIF
$ if f$type(deferred_fastread) .nes. ""
$ then 
$   fastread = 1
$   delete/symbol deferred_fastread
$ endif
$ RETURN
$!
$Beyond_myread:
$!
$!: create .config dir to save info across Configure sessions
$ IF ( F$SEARCH("[-]CONFIG.DIR").EQS."" )
$ THEN
$   CREATE/DIRECTORY [-.CONFIG]
$   OPEN/WRITE CONFIG [-.CONFIG]README.
$   WRITE CONFIG -
      "This directory created by Configure to save information that should"
$   WRITE CONFIG -
      "persist across sessions."
$   WRITE CONFIG ""
$   WRITE CONFIG -
      "You may safely delete it if you wish."
$   CLOSE CONFIG
$ ENDIF
$!
$ IF F$TYPE(usedevel) .EQS. "" THEN usedevel := n
$ patchlevel_h = F$SEARCH("[-]patchlevel.h")
$ IF (patchlevel_h.NES."")
$ THEN
$   SEARCH 'patchlevel_h' "define","PERL_VERSION","epoch"/match=and/out=[]ver.out
$   IF .NOT. usedevel .AND. usedevel .NES. "define"
$   THEN
$     OPEN/READ CONFIG []ver.out
$     READ CONFIG line
$     CLOSE CONFIG
$     tmp = F$EDIT(line,"TRIM,COMPRESS")
$     xpatchlevel = F$INTEGER(F$ELEMENT(2," ",tmp))
$     line = xpatchlevel / 2
$     tmp = xpatchlevel - ( line * 2 )
$     IF tmp .NE. 0
$     THEN
$       echo4 "patchlevel is " + F$STRING(xpatchlevel)
$       cat4 SYS$INPUT:
$       DECK
*** WHOA THERE!!! ***

    This is an UNSTABLE DEVELOPMENT release.
    (The patchlevel, is odd--as opposed to even,
     and that signifies a development release.  If you want a
     maintenance release, you want an even-numbered release.)

    Do ***NOT*** install this into production use.
    Data corruption and crashes are possible.

    It is most seriously suggested that you do not continue any further
    unless you want to help in developing and debugging Perl.

$       EOD
$       bool_dflt="n"
$       rp="Do you really want to continue? [''bool_dflt'] "
$       fastread_save = fastread
$       fastread := FALSE
$       GOSUB myread
$       fastread = fastread_save
$       delete/symbol fastread_save
$       IF ans
$       THEN
$         echo4 "Okay, continuing."
$       ELSE
$         echo4 "Okay, bye."
$         DELETE/NOLOG/NOCONFIRM []ver.out;
$         GOTO Clean_up
$       ENDIF
$     ENDIF
$     DELETE/SYMBOL line
$     DELETE/SYMBOL tmp
$   ENDIF
$   DELETE/NOLOG/NOCONFIRM []ver.out;
$ ENDIF
$!: general instructions
$ needman = "true"
$ firsttime = "true"
$ user = F$EDIT(F$GETJPI("","USERNAME"),"TRIM,COLLAPSE")
$ IF .NOT.(F$SEARCH("[-.CONFIG]INSTRUCT.").EQS."")
$ THEN
$   messages = F$ENVIRONMENT("MESSAGE")
$   SET MESSAGE/NOFAC/NOSEV/NOIDENT/NOTEXT
$   contains /NOOUTPUT [-.CONFIG]INSTRUCT. 'user'
$   IF .NOT.($status.EQ.%X08D78053)
$   THEN
$     firsttime=""
$     bool_dflt = "n"
$     rp = "Would you like to see the instructions? [''bool_dflt'] "
$     GOSUB myread
$     if .NOT.ans THEN needman=""
$   ENDIF
$   SET MESSAGE 'messages'
$ ENDIF
$ if (fastread.AND.silent.AND.(alldone.eqs."cont")) THEN needman=""
$!
$ IF (needman)
$ THEN
$   TYPE SYS$INPUT:
$   DECK

This installation shell script will examine your system and ask you questions
to determine how the perl5 package should be installed. If you get
stuck on a question, you may use a ^C or ^Y shell escape to STOP this
process, edit something, then restart this process as you just did.
Many of the questions will have default answers in square
brackets; typing carriage return will give you the default.

$   EOD
$   if (fastread)
$   then
$     echo4 ""
$   else
$     READ SYS$COMMAND/PROMPT="Type carriage return to continue " ans
$   endif
$   TYPE SYS$INPUT:
$   DECK

In a hurry? You may run '@Configure "-d"'.  This will bypass nearly all
the questions and use the computed defaults (or the previous answers provided 
there was already a config.sh file). Type '@Configure "-h"' for a list of 
options.

$   EOD
$   if (fastread)
$   then
$     echo4 ""
$   else
$     READ SYS$COMMAND/PROMPT="Type carriage return to continue " ans
$   endif
$   TYPE SYS$INPUT:
$   DECK

Much effort has been expended to ensure that this shell script will
run on any VMS system.  If despite that it blows up on yours, your
best bet is to edit Configure.com and @ it again.  Whatever problems
you have with Configure.com, let me (dan@sidhe.org) know how I blew
it.

$   EOD
$!This installation script affects things in two ways:
$!
$!1) it may do direct variable substitutions on some of the files included
$!   in this kit.
$!2) it builds a config.h file for inclusion in C programs.  You may edit
$!   any of these files as the need arises after running this script.
$!
$!If you make a mistake on a question, there is no easy way to back up to it
$!currently.
$!
$   if (fastread)
$   then
$     echo4 ""
$   else
$     READ SYS$COMMAND/PROMPT="Type carriage return to continue " ans
$   endif
$   IF (F$SEARCH("[-.CONFIG]INSTRUCT.").EQS."")
$   THEN
$     OPEN/WRITE CONFIG [-.CONFIG]INSTRUCT.
$     WRITE CONFIG user 
$     CLOSE CONFIG
$   ENDIF
$ ENDIF  !(needman .EQS. "true")
$!
$!: see if sh knows # comments             !sfn
$ sharpbang = "$ "
$!: figure out how to guarantee sh startup !sfn
$!: find out where common programs are     !sfn
$!loclist="awk/cat/comm/cp/echo/expr/find/grep/ln/ls/mkdir/rm/sed/sort/touch/tr/uniq"
$!trylist="byacc/cpp/csh/date/egrep/less/line/more/nroff/perl/pg/sendmail/test/uname"
$! echo "I don't know where '$file' is, and my life depends on it."
$! echo "Go find a public domain implementation or fix your PATH setting!"
$! echo ""
$! echo "Don't worry if any of the following aren't found..."
$!: determine whether symbolic links are supported !sfn !jem- further down
$!: see whether [:lower:] and [:upper:] are supported character classes !sfn
$!: set up the translation script tr, must be called with ./tr of course !sfn
$!
$!: Try to determine whether config.sh was made on this system
$!: Get old answers from old config file if Configure was run on the
$!: same system, otherwise use the hints.
$ config_sh_es = "''config_sh'/[-]config.sh/[-.vms]config.vms/"
$ i = 0
$ max = 3
$Config_sh_look:
$ config_sh = F$ELEMENT(i,"/",config_sh_es)
$ i = i + 1
$ IF (config_sh.NES."/").AND.(config_sh.NES."")
$ THEN
$   configshfound = F$SEARCH(config_sh)
$   IF (configshfound.NES."") THEN GOTO Config_sh_found
$ ENDIF
$ IF (i.LT.max) THEN GOTO Config_sh_look
$! genconfig.pl has "osname='VMS'"
$ osname = F$EDIT(F$GETSYI("NODE_SWTYPE"),"COLLAPSE")
$ IF (configshfound.EQS."")
$ THEN
$   config_sh = "[-]config.sh" ! the fallback default
$   GOTO Beyond_config_sh
$ ENDIF
$Config_sh_found:
$ IF F$TYPE(osname) .EQS. "" THEN osname = F$EDIT(F$GETSYI("NODE_SWTYPE"),"COLLAPSE")
$ bool_dflt = "n"
$ IF F$TYPE(config_dflt) .NES. "" THEN bool_dflt = config_dflt
$ rp = "Shall I use ''config_sh' for default answers? [''bool_dflt'] "
$ GOSUB myread
$ IF ans
$ THEN
$   echo ""
$   echo "Fetching default answers from ''config_sh'..."
$!
$!  we do our own parsing of the shell-script stuff
$!  ...and only accept symbols if they're in the | delimited list below
$!
$   config_symbols0 ="|archlib|archlibexp|bin|binexp|builddir|cf_email|config_sh|installarchlib|installbin|installman1dir|installman3dir|"
$   config_symbols1 ="|installprivlib|installscript|installsitearch|installsitelib|most|oldarchlib|oldarchlibexp|osname|pager|perl_symbol|perl_verb|"
$   config_symbols2 ="|prefix|privlib|privlibexp|scriptdir|sitearch|sitearchexp|sitebin|sitelib|sitelib_stem|sitelibexp|try_cxx|use64bitall|use64bitint|"
$   config_symbols3 ="|usecasesensitive|usedefaulttypes|usedevel|useieee|useithreads|uselongdouble|usemultiplicity|usemymalloc|usedebugging_perl|"
$   config_symbols4 ="|useperlio|usesecurelog|usethreads|usevmsdebug|usefaststdio|usemallocwrap|unlink_all_versions|uselargefiles|usesitecustomize|"
$   config_symbols5 ="|buildmake|builder|usethreadupcalls|usekernelthreads|usedecterm"
$!  
$   open/read CONFIG 'config_sh'
$   rd_conf_loop:
$     read/end=erd_conf_loop CONFIG line
$     line = f$edit(line,"trim")
$     if line .eqs. "" .or. f$extract(0,1,line) .eqs. "#" then goto rd_conf_loop
$     sym = f$element(0,"=",line)
$     if sym .eqs. "=" then goto rd_conf_loop
$     dsym = "|"+sym+"|"
$     k = 0
$     rd_ck_loop:
$         syms = config_symbols'k'
$         j = f$locate(dsym, syms)
$         if j .lt. f$length(syms) then goto erd_ck_loop
$         k = k + 1
$     if k .lt. 6 then goto rd_ck_loop
$     goto rd_conf_loop
$     erd_ck_loop:
$     val = f$element(1,"=",line)
$     val = f$extract(1,f$length(val)-2,val)
$     write sys$output "''sym' = ""''val'"""
$    'sym' = "''val'"
$   goto rd_conf_loop
$   erd_conf_loop:
$   close CONFIG
$   delete/symbol config_symbols0
$   delete/symbol config_symbols1
$   delete/symbol config_symbols2
$   delete/symbol config_symbols3
$   delete/symbol config_symbols4
$   delete/symbol config_symbols5
$   delete/symbol sym
$   delete/symbol val
$   delete/symbol dsym
$   if f$type(usedebugging_perl) .nes. ""
$   then
$       useperldebug = usedebugging_perl
$       delete/symbol usedebugging_perl
$   endif
$!
$ ENDIF
$ if f$type(config_dflt) .nes. "" then DELETE/SYMBOL config_dflt
$!
$!we actually do not have "hints/" for VMS
$!     TYPE SYS$INPUT:
$!     DECK
$!
$!First time through, eh?  I have some defaults handy for the following systems:
$!
$!     EOD
$!     echo "     ","VMS_VAX"
$!     echo "     ","VMS_AXP"
$!     echo "     ","VMS_IA64"
$!        : Now look for a hint file osname_osvers, unless one has been
$!        : specified already.
$!     TYPE SYS$INPUT:
$!
$!You may give one or more space-separated answers, or "none" if appropriate.
$!If your OS version has no hints, DO NOT give a wrong version -- say "none".
$!
$!     READ SYS$COMMAND/PROMPT="Which of these apply, if any? " ans
$!
$Beyond_config_sh:
$!
$!: Restore computed paths          !sfn
$!
$! %Config-I-VMS, a necessary error trap (could be PC running VCL)
$!
$ IF (osname .NES. "VMS")
$ THEN
$   echo4 "Hmm.. I wonder what ''osname' is (?)"
$   TYPE SYS$INPUT:
$   DECK

%Config-E-VMS, ERROR:

           Err, you do not appear to be running VMS!
 This procedure is intended to Configure the building of Perl for VMS.

$   EOD
$   bool_dflt = "n"
$   GOSUB myread
$   IF ans
$   THEN
$     echo4 "Continuing..."
$   ELSE
$     echo4 "ABORTING..."
$     SET DEFAULT 'vms_default_directory_name' !be kind rewind
$     STOP
$     EXIT 2 !$STATUS = "%X00000002" (error)
$   ENDIF
$ ENDIF !(osname .NES./.EQS. "VMS")
$!
$!: who configured the system
$ cf_by = F$EDIT(user,"LOWERCASE")
$ osvers = F$EDIT(F$GETSYI("VERSION"),"TRIM")
$!
$! Peter Prymmer has seen:
$!  "SYS$TIMEZONE_DIFFERENTIAL" = "-46800"  (sic)
$!  "SYS$TIME_ZONE" = "EDT"
$!
$! Charles Lane recommended:
$!  "SYS$TIMEZONE_DIFFERENTIAL" = "-14400"
$!  "NEWS_TIMEZONE" = "-0500"
$!  "ST_TIMEZONE" = "EDT"
$!  "JAN_TIME_ZONE" = "EST  "
$!  "MULTINET_TIMEZONE" = "EST"
$!  "DAYLIGHT_SAVINGS"  = "1"
$!
$! Charles Bailey recommends (in ANU NEWS Doc Jan 1995):
$!   "PMDF_Timezone"
$!   "Multinet_Timezone"
$!   "TCPware_Timezone"
$!   "WIN$Time_Zone"
$!
$! This snippet o' DCL returns a string in default Unix `date` format,
$! and it will prompt to set SYS$TIMEZONE_DIFFERENTIAL.
$!
$ MIN_TZO = -840  !units are minutes here
$ MAX_TZO =  840
$!
$ wkday  = F$EXTRACT(0,3,F$CVTIME(,,"WEEKDAY"))
$ monn   = F$CVTIME(,,"MONTH")
$ mday   = F$EXTRACT(8,2,F$CVTIME(,,"DATE"))
$ hour   = F$CVTIME(,,"HOUR")
$ min    = F$CVTIME(,,"MINUTE")
$ sec    = F$CVTIME(,,"SECOND")
$ year   = F$CVTIME(,,"YEAR")
$!
$ months = "/Jan/Feb/Mar/Apr/May/Jun/Jul/Aug/Sep/Oct/Nov/Dec/"
$ i = 0
$Mon_loop:
$ i = i + 1
$ mon = F$ELEMENT(i,"/",months)
$ IF i.LT.monn THEN GOTO Mon_loop
$!
$ tzneedset = "t"
$ systz = F$TRNLNM("SYS$TIMEZONE_DIFFERENTIAL")
$ IF systz.NES.""
$ THEN
$   tzhour = F$INTEGER(systz)/3600
$   tzmins = F$INTEGER(systz)/60
$   tzminrem = tzmins - tzhour*60
$   IF tzminrem.lt.0 THEN tzminrem = -1*tzminrem  !keeps !2ZL happy
$   IF tzhour.ge.0 
$   THEN signothetime = "+" 
$     IF tzhour.EQ.0.AND.tzminrem.EQ.0 
$     THEN direction = "on GMT/"
$     ELSE direction = "east of "
$     ENDIF
$   ELSE signothetime = "-"
$     tzhour = -1*tzhour                          !keeps !UL happy
$     direction = "west of "
$   ENDIF
$   echo ""
$   echo "According to the setting of your ""SYS$TIMEZONE_DIFFERENTIAL"" (= ''systz')"
$   IF tzminrem.ne.0
$   THEN
$     tzspan = "''tzhour' hours & ''tzminrem' minutes"
$   ELSE
$     tzspan = "''tzhour' hours"
$   ENDIF
$   bool_dflt = "y"
$   echo "Your system is ''tzspan' ''direction'UTC in England."
$   rp = "(''systz') Is this UTC Time Zone Offset correct? [''bool_dflt'] "
$   GOSUB myread
$   IF ans
$   THEN 
$     tzneedset = "f"
$     tzd = systz
$     GOTO Beyond_TimeZone
$   ENDIF
$ ELSE
$   echo ""
$   echo4 """SYS$TIMEZONE_DIFFERENTIAL"" does not appear to be DEFINEd on your system"
$ ENDIF
$!
$TZSet:
$ echo ""
$ echo "Please tell me in hh:mm form what time offset from GMT/UTC in England"
$ echo "you are.  As an example Eastern (US) Standard Time is -5:00 offset, but"
$ echo "Eastern Daylight Time (summer) is -4:00 offset."
$ dflt = "0:00"
$ rp = "Enter the Time Zone offset: [''dflt'] "
$ GOSUB myread
$ ans = F$Edit(ans,"collapse,trim,uncomment,upcase")
$ IF ans.EQS."" THEN ans = dflt
$ tzhour   = F$ELEMENT(0,":","''ans'") !first
$ IF tzhour.EQS."" THEN tzhour = 0
$ tzhour   = F$INTEGER(tzhour)
$ tzminrem = F$ELEMENT(1,":","''ans'") !second
$ IF tzminrem.NES."" 
$ THEN 
$   tzminrem = F$INTEGER(tzminrem)
$   IF F$EXTRACT(0,1,"''ans'") .EQS. "-" THEN tzminrem = tzminrem * -1
$ ELSE 
$   tzminrem = 0
$ ENDIF
$ tzmins = tzhour*60 + tzminrem
$ tzd = F$STRING(tzmins*60)
$ IF tzhour .GE. 0 
$ THEN
$   signothetime = "+" 
$ ELSE
$   tzhour = -1*tzhour       !keeps !UL happy
$   signothetime = "-"
$ ENDIF
$ IF (tzmins.GT.MAX_TZO).OR.(tzmins.LT.MIN_TZO)
$ THEN
$   echo ""
$   echo "%Config-W-VMS-TIMERANGE, Response must be in the range -14:00 to 14:00."
$   goto TZSet
$ ENDIF
$!
$Beyond_TimeZone:
$ tz = f$fao("UTC!AS!UL:!2ZL",signothetime,tzhour,tzminrem)
$ cf_time = "''wkday' ''mon' ''mday' ''hour':''min':''sec' ''tz' ''year'"
$!
$!: determine the architecture name  
$! genconfig.pl has either archname='VMS_AXP' or 'VMS_VAX'
$! Note that DCL in VMS V5.4 does not have F$GETSYI("ARCH_NAME")
$! but does have F$GETSYI("HW_MODEL").
$! Please try to use either archname .EQS. "VMS_VAX" or archname .EQS. 
$! "VMS_AXP" from here on to allow cross-platform configuration (e.g.
$! configure a VAX build on an Alpha).
$!
$ IF (F$GETSYI("HW_MODEL") .LT. 1024 .AND. F$GETSYI("HW_MODEL") .GT. 0)
$ THEN 
$   archname = "VMS_VAX"
$   otherarch = "an Alpha or IA64"
$   alignbytes="8"
$   arch_type = "ARCH-TYPE=__VAX__"
$ ELSE
$   IF (F$GETSYI("ARCH_TYPE") .EQ. 2)
$   THEN
$       archname = "VMS_AXP"
$       otherarch = "a VAX or IA64"
$       arch_type = "ARCH-TYPE=__AXP__"
$   ELSE
$       archname = "VMS_IA64"
$       otherarch = "a VAX or Alpha"
$       arch_type = "ARCH-TYPE=__IA64__"
$   ENDIF
$   alignbytes="8"
$ ENDIF
$ dflt = archname
$ rp = "What is your architecture name? [''archname'] "
$ GOSUB myread
$ IF ans.NES.""
$ THEN
$   ans = F$EDIT(ans,"COLLAPSE, UPCASE")
$   IF (ans.NES.archname) !.AND.knowitall
$   THEN
$     echo4 "I'll go with ''archname' anyway..."
$   ENDIF
$ ENDIF
$ bool_dflt = "n"
$ vms_prefix = "perl_root"
$ vms_prefixup = F$EDIT(vms_prefix,"UPCASE")
$ rp = "Will you be sharing your ''vms_prefixup' with ''otherarch'? [''bool_dflt'] "
$ GOSUB myread
$ IF .NOT. ans
$ THEN
$   sharedperl = "N"
$ ELSE
$   sharedperl = "Y"
$   IF (archname.EQS."VMS_AXP")
$   THEN
$     macros = macros + """AXE=1"","
$   ENDIF
$   IF (archname.EQS."VMS_IA64")
$   THEN
$     macros = macros + """IXE=1"","
$   ENDIF
$ ENDIF
$!
$!: is AFS running?                       !sfn
$!: decide how portable to be.  Allow command line overrides. !sfn
$!: set up shell script to do ~ expansion !sfn
$!: expand filename                       !sfn
$!: now set up to get a file name         !sfn
$!
$ IF F$TYPE(prefix) .EQS. ""
$ THEN
$   prefix = F$ENVIRONMENT("DEFAULT") - ".UU]" + "]"
$   prefix = F$PARSE(prefix,,,,"NO_CONCEAL") - "][" - "000000." - ".000000" - ".;"
$   prefixbase = prefix - "]"
$!  Add _ROOT to make install PERL_ROOT differ from build directory.
$   prefix = prefixbase + "_ROOT.]"
$ ENDIF
$ ! more redundant scrubbing of values
$ prefix = prefix - "000000."
$ IF F$LOCATE(".]",prefix) .EQ. F$LENGTH(prefix) THEN prefix = prefix - "]" + ".]"
$ src = prefix
$!: determine root of directory hierarchy where package will be installed.
$ dflt = prefix
$ IF .NOT.silent 
$ THEN 
$   echo ""
$   echo "By default, ''package' will be installed in ''dflt', pod"
$   echo "pages under ''prefixbase'.LIB.POD], etc..., i.e. with ''dflt' as prefix for"
$   echo "all installation directories."
$   echo "On ''osname' the prefix is used to DEFINE the ''vms_prefixup' prior to installation"
$   echo "as well as during subsequent use of ''package' via ''packageup'_SETUP.COM."
$ ENDIF
$ rp = "Installation prefix to use (for ''vms_prefixup')? [ ''dflt' ] "
$ GOSUB myread
$ IF ans.NES.""
$ THEN 
$   prefix = ans
$   IF F$LOCATE(".]",ans) .EQ. F$LENGTH(ans) THEN prefix = prefix - "]" + ".]"
$ ELSE 
$   prefix = dflt
$ ENDIF
$ perl_root = prefix
$!
$! Check here for pre-existing PERL_ROOT.
$!  -> ask if removal desired.
$! Check here for writability of requested PERL_ROOT if it is not the default (cwd).
$!  -> recommend letting PERL_ROOT be PERL_SRC if requested PERL_ROOT is not writable.
$!
$   tmp = perl_root - ".]" + "]"
$ dflt = f$parse(tmp,,,,)
$   IF dflt .eqs. ""
$   THEN
$       echo4 "''tmp' does not yet exist."
$!      create/directory 'tmp'
$   ELSE
$       echo4 "''tmp' already exists."
$   ENDIF
$!
$ vms_skip_install = "true"
$ bool_dflt = "y"
$! echo ""
$ rp = "Skip the remaining """"where install"""" questions? [''bool_dflt'] "
$ GOSUB myread
$ IF (.NOT.ans) THEN vms_skip_install = "false"
$ IF (.NOT.vms_skip_install)
$ THEN
$!
$!: set the prefixit variable, to compute a suitable default value
$!
$!: determine where private library files go
$!: Usual default is /usr/local/lib/perl5.  Also allow things like 
$!: /opt/perl/lib, since /opt/perl/lib/perl5 would be redundant.
$   IF .NOT.silent 
$   THEN
$     TYPE SYS$INPUT:
$     DECK

There are some auxiliary files for perl5 that need to be put into a
private library directory that is accessible by everyone.
$     EOD
$   ENDIF
$   IF F$TYPE(privlib) .NES. ""
$   THEN dflt = privlib
$   ELSE dflt = "''vms_prefix':[lib]"
$   ENDIF
$   rp = "Pathname where the private library files will reside? " 
$   rp = F$FAO("!AS!/!AS",rp,"[ ''dflt' ] ")
$   GOSUB myread
$   privlib = ans
$!
$ ENDIF !%Config-I-VMS, skip remaining "where install" questions
$!
$ IF F$TYPE(perl_symbol) .EQS. "" THEN perl_symbol := true
$ IF F$TYPE(perl_verb) .EQS. "" THEN perl_verb = ""
$ IF perl_symbol
$ THEN bool_dflt = "y"
$ ELSE bool_dflt = "n"
$ ENDIF
$ IF .NOT.silent 
$ THEN 
$   echo ""
$   echo "You may choose to write ''packageup'_SETUP.COM to assign a foreign"
$   echo "symbol to invoke ''package', which is the usual method."
$   echO "If you do not do so then you would need a DCL command verb at the"
$   echo "process or the system wide level."
$ ENDIF
$ rp = "Invoke perl as a global symbol foreign command? [''bool_dflt'] "
$ GOSUB myread
$ IF (.NOT.ans) THEN perl_symbol = "false"
$!
$ IF (.NOT.perl_symbol)
$ THEN
$   IF perl_verb .EQS. "DCLTABLES"
$   THEN bool_dflt = "n"
$   ELSE bool_dflt = "y"
$   ENDIF
$   IF .NOT.silent 
$   THEN 
$     echo ""
$     echo "Since you won't be using a symbol you must choose to put the ''packageup'"
$     echo "verb in a per-process table or in the system wide DCLTABLES (which"
$     echo "would require write privilege)."
$   ENDIF
$   rp = "Invoke perl as a per process command verb? [ ''bool_dflt' ] "
$   GOSUB myread
$   IF (.NOT.ans)
$   THEN perl_verb = "DCLTABLES"
$   ELSE perl_verb = "PROCESS"
$   ENDIF
$ ENDIF ! (.NOT.perl_symbol)
$!
$!: set the base revision
$ baserev="5.0"
$ revision = baserev - ".0"
$!: get the patchlevel
$ echo ""
$ echo4 "Getting the current patchlevel..."
$ patchlevel="0"
$ subversion="0"
$ api_revision="0"
$ api_version="0"
$ api_subversion="0"
$ perl_patchlevel="0"
$ patchlevel_h = F$SEARCH("[-]patchlevel.h")
$ IF (patchlevel_h.NES."")
$ THEN
$   got_patch = "false"
$   got_sub   = "false"
$   got_api_revision   = "false"
$   got_api_version    = "false"
$   got_api_subversion = "false"
$   got_perl_patchlevel= "false"
$   OPEN/READONLY CONFIG 'patchlevel_h' 
$Patchlevel_h_loop:
$   READ/END_Of_File=Close_patch/ERROR=Close_patch CONFIG line
$   IF ((F$LOCATE("#define PERL_VERSION",line).NE.F$LENGTH(line)).AND.(.NOT.got_patch))
$   THEN
$     line = F$EDIT(line,"COMPRESS, TRIM")
$     patchlevel = F$ELEMENT(2," ",line)
$     got_patch = "true"
$   ENDIF
$   IF ((F$LOCATE("#define PERL_SUBVERSION",line).NE.F$LENGTH(line)).AND.(.NOT.got_sub))
$   THEN
$     line = F$EDIT(line,"COMPRESS, TRIM")
$     subversion = F$ELEMENT(2," ",line)
$     got_sub = "true"
$   ENDIF
$   IF ((F$LOCATE("#define PERL_API_REVISION",line).NE.F$LENGTH(line)).AND.(.NOT.got_api_revision))
$   THEN
$     line = F$EDIT(line,"COMPRESS, TRIM")
$     api_revision = F$ELEMENT(2," ",line)
$     got_api_revision = "true"
$   ENDIF
$   IF ((F$LOCATE("#define PERL_API_VERSION",line).NE.F$LENGTH(line)).AND.(.NOT.got_api_version))
$   THEN
$     line = F$EDIT(line,"COMPRESS, TRIM")
$     api_version = F$ELEMENT(2," ",line)
$     got_api_version = "true"
$   ENDIF
$   IF ((F$LOCATE("#define PERL_API_SUBVERSION",line).NE.F$LENGTH(line)).AND.(.NOT.got_api_subversion))
$   THEN
$     line = F$EDIT(line,"COMPRESS, TRIM")
$     api_subversion = F$ELEMENT(2," ",line)
$     got_api_subversion = "true"
$   ENDIF
$   IF ((F$LOCATE("""DEVEL",line).NE.F$LENGTH(line)).AND.(.NOT.got_perl_patchlevel))
$   THEN
$     line = F$EDIT(line,"COMPRESS, TRIM")
$     perl_patchlevel = F$ELEMENT(1,"""",line)
$     perl_patchlevel = perl_patchlevel - "DEVEL"
$     got_perl_patchlevel = "true"
$   ENDIF
$   IF (.NOT. got_patch) .OR. -
       (.NOT. got_sub) .OR. - 
       (.NOT. got_api_revision) .OR. -
       (.NOT. got_api_version) .OR. -
       (.NOT. got_api_subversion) .OR. -
       (.NOT. got_perl_patchlevel) -
      THEN GOTO Patchlevel_h_loop
$Close_patch:
$   CLOSE CONFIG
$ ENDIF
$!
$ IF F$SEARCH("[-].patch") .NES. ""
$ THEN
$   SET NOON
$   OPEN/READ PATCH [-].patch
$   READ PATCH line
$   CLOSE PATCH
$   tmp = F$EDIT(line,"COLLAPSE")
$   SET ON
$   IF tmp .GT. perl_patchlevel then perl_patchlevel = tmp
$ ENDIF
$!
$ version_patchlevel_string = "version ''patchlevel' subversion ''subversion'"
$ IF got_perl_patchlevel .AND. perl_patchlevel .NES. "0"
$ THEN
$   version_patchlevel_string = "''version_patchlevel_string' patch ''perl_patchlevel'"
$ ENDIF
$ echo "(You have ''package' ''version_patchlevel_string'.)"
$!
$ version = revision + "_" + patchlevel + "_" + subversion
$!
$ IF (.NOT.vms_skip_install)
$ THEN
$!: set the prefixup variable, to restore leading tilde escape !sfn
$!
$!: determine where public architecture dependent libraries go
$   IF (.NOT.silent) 
$   THEN 
$     echo ""
$     echo "''package' contains architecture-dependent library files.  If you are"
$   ENDIF
$   IF (.NOT.silent) 
$   THEN
$     TYPE SYS$INPUT:
$     DECK
sharing libraries in a heterogeneous environment, you might store
these files in a separate location.  Otherwise, you can just include
them with the rest of the public library files.
$     EOD
$   ENDIF
$   IF F$TYPE(archlib) .NES. ""
$   THEN dflt = archlib
$   ELSE dflt = privlib - "]" + "." + archname + "." + version + "]"
$   ENDIF
$   rp = "Where do you want to put the public architecture-dependent libraries? "
$   rp = F$FAO("!AS!/!AS",rp,"[ ''dflt' ] ")
$   GOSUB myread
$   archlib = ans
$!
$ ENDIF !%Config-I-VMS, skip "where install" questions
$!
$! This quotation from Configure has to be included on VMS:
$!
$ TYPE SYS$INPUT:
$ DECK

There is, however, a strange, musty smell in the air that reminds me of
something...hmm...yes...I've got it...there's a VMS nearby, or I'm a Blit.
$ EOD
$ IF (.NOT.vms_skip_install)
$ THEN
$!: it so happens the Eunice I know will not run shell scripts in Unix format
$!
$!: see if setuid scripts can be secure           !sfn
$!: now see if they want to do setuid emulation   !sfn
$!
$!: determine where site specific libraries go.
$   IF .NOT.silent 
$   THEN
$     TYPE SYS$INPUT:
$     DECK

The installation process will also create a directory for
site-specific extensions and modules.  Some users find it convenient
to place all local files in this directory rather than in the main
distribution directory.
$     EOD
$   ENDIF
$   IF F$TYPE(sitelib) .NES. ""
$   THEN dflt = sitelib
$   ELSE dflt = privlib - "]" + ".SITE_PERL]"
$   ENDIF
$   rp = "Pathname for the site-specific library files? "
$   rp = F$FAO("!AS!/!AS",rp,"[ ''dflt' ] ")
$   GOSUB myread
$   sitelib = ans
$!
$!: determine where site specific architecture-dependent libraries go.
$   IF .NOT.silent 
$   THEN TYPE SYS$INPUT:
$     DECK

The installation process will also create a directory for
architecture-dependent site-specific extensions and modules.
$     EOD
$   ENDIF
$   IF F$TYPE(sitearch) .NES. ""
$   THEN dflt = sitearch
$   ELSE dflt = sitelib - "]" + "." + archname + "]"
$   ENDIF
$   rp = "Pathname for the site-specific architecture-dependent library files? "
$   rp = F$FAO("!AS!/!AS",rp,"[ ''dflt' ] ")
$   GOSUB myread
$   sitearch = ans
$!
$!: determine where old public architecture dependent libraries might be
$!
$!: determine where public executables go
$   IF F$TYPE(bin) .NES. ""
$   THEN dflt = bin
$!   ELSE dflt = prefix - ".]" + ".BIN]"
$   ELSE dflt = "/''vms_prefix'"
$   ENDIF
$   rp = "Pathname where the public executables will reside? "
$   rp = F$FAO("!AS!/!AS",rp,"[ ''dflt' ] ")
$   GOSUB myread
$   bin = ans
$!
$!: determine where add-on public executables go
$   IF F$TYPE(sitebin) .NES. ""
$   THEN dflt = sitebin
$   ELSE dflt = "''vms_prefix':[bin.''archname']"
$   ENDIF
$   rp = "Pathname where the add-on public executables should be installed? "
$   rp = F$FAO("!AS!/!AS",rp,"[ ''dflt' ] ")
$   GOSUB myread
$   sitebin = ans
$!
$!: determine where manual pages are on this system
$!: What suffix to use on installed man pages
$!: see if we can have long filenames
$!: determine where library module manual pages go
$!: What suffix to use on installed man pages
$!: see what memory models we can support
$!
$ ELSE ! skipping "where install" questions, we must set some symbols
$   IF F$TYPE(archlib).EQS."" THEN -
      archlib="''vms_prefix':[lib.''archname'.''version']"
$   IF F$TYPE(bin) .EQS. "" THEN -
      bin="/''vms_prefix'"
$   IF F$TYPE(privlib) .EQS. "" THEN -
      privlib ="''vms_prefix':[lib]"
$   IF F$TYPE(sitearch) .EQS. "" THEN -
      sitearch="''vms_prefix':[lib.site_perl.''archname']"
$   IF F$TYPE(sitelib) .EQS. "" THEN -
      sitelib ="''vms_prefix':[lib.site_perl]"
$   IF F$TYPE(sitebin) .EQS. "" THEN -
      sitebin="''vms_prefix':[bin.''archname']"
$ ENDIF !%Config-I-VMS, skip "where install" questions
$!
$! These derived locations can be set whether we've opted to
$! skip the where install questions or not.
$!
$ IF F$TYPE(archlibexp) .EQS. "" THEN -
    archlibexp="''vms_prefix':[lib.''archname'.''version']"
$ IF F$TYPE(binexp) .EQS. "" THEN -
    binexp ="''vms_prefix':[000000]"
$ IF F$TYPE(builddir) .EQS. "" THEN -
    builddir ="''vms_prefix':[000000]"
$ IF F$TYPE(installarchlib) .EQS. "" THEN -
    installarchlib="''vms_prefix':[lib.''archname'.''version']"
$ IF F$TYPE(installbin) .EQS. "" THEN -
    installbin ="''vms_prefix':[000000]"
$ IF F$TYPE(installscript) .EQS. "" THEN -
    installscript ="''vms_prefix':[utils]"
$ IF F$TYPE(installman1dir) .EQS. "" THEN -
    installman1dir ="''vms_prefix':[man.man1]"
$ IF F$TYPE(installman3dir) .EQS. "" THEN -
    installman3dir ="''vms_prefix':[man.man3]"
$ IF F$TYPE(installprivlib) .EQS. "" THEN -
    installprivlib ="''vms_prefix':[lib]"
$ IF F$TYPE(installsitearch) .EQS. "" THEN -
    installsitearch="''vms_prefix':[lib.site_perl.''archname']"
$ IF F$TYPE(installsitelib) .EQS. "" THEN -
    installsitelib ="''vms_prefix':[lib.site_perl]"
$ IF F$TYPE(oldarchlib) .EQS. "" THEN -
    oldarchlib="''vms_prefix':[lib.''archname']"
$ IF F$TYPE(oldarchlibexp) .EQS. "" THEN -
    oldarchlibexp="''vms_prefix':[lib.''archname']"
$ IF F$TYPE(privlibexp) .EQS. "" THEN -
    privlibexp ="''vms_prefix':[lib]"
$ IF F$TYPE(scriptdir) .EQS. "" THEN -
    scriptdir ="''vms_prefix':[utils]"
$ IF F$TYPE(sitearchexp) .EQS. "" THEN -
    sitearchexp ="''vms_prefix':[lib.site_perl.''archname']"
$ IF F$TYPE(sitelib_stem) .EQS. "" THEN -
    sitelib_stem ="''vms_prefix':[lib.site_perl]"
$ IF F$TYPE(sitelibexp) .EQS. "" THEN -
    sitelibexp ="''vms_prefix':[lib.site_perl]"
$!
$!: see if we need a special compiler
$! cc_list = "cc/decc|gcc" !%Config-I-VMS, compiler symbols/commands
$!
$ nocc = "f"
$ vms_cc_dflt = ""
$ vms_cc_available = ""
$!
$ OPEN/WRITE CONFIG ccvms.c
$ WRITE CONFIG "#ifdef __DECC"
$ WRITE CONFIG "#include <stdlib.h>"  !DECC is sooo picky
$ WRITE CONFIG "#endif"
$ WRITE CONFIG "#include <stdio.h>"
$ WRITE CONFIG "int main() {"
$ WRITE CONFIG "#ifdef __DECC"
$ WRITE CONFIG "        printf(""/DECC\n"");"
$ WRITE CONFIG "#else"
$ WRITE CONFIG "        printf(""/VAXC\n"");"
$ WRITE CONFIG "#endif"
$ WRITE CONFIG "        exit(0);"
$ WRITE CONFIG "}"
$ CLOSE CONFIG
$!
$ SET NOON
$ DEFINE/USER_MODE SYS$ERROR _NLA0:
$ DEFINE/USER_MODE SYS$OUTPUT _NLA0:
$ cc/NoObj/list=ccvms.lis ccvms.c
$ tmp = $status
$ SET ON
$ IF (silent) THEN GOSUB Shut_up
$ IF tmp.NE.%X10B90001
$ THEN 
$  IF tmp.NE.%X10000001
$  THEN 
$    nocc = "t"  !%X10000001 is return from gcc
$    GOTO Gcc_initial_check
$  ENDIF
$ ENDIF
$!
$ GOSUB List_Parse
$ IF .NOT.silent THEN echo ""
$ echo "Default ""cc"" is ''line' ''archsufx' ''F$GETSYI("VERSION")'" 
$ IF F$LOCATE("VAX",line).NE.F$LENGTH(line) 
$ THEN 
$   IF .NOT.silent
$   THEN 
$     echo "Will try cc/decc..."
$   ENDIF
$   SET NOON
$   DEFINE/USER_MODE SYS$ERROR NL:
$   DEFINE/USER_MODE SYS$OUTPUT NL:
$   cc/decc/NoObj/list=ccvms.lis ccvms.c
$   tmp = $status
$   SET ON
$   IF (silent) THEN GOSUB Shut_up
$   IF tmp.NE.%X10B90001
$   THEN
$     echo "Apparently you don't have that one."
$   ELSE
$     GOSUB List_parse
$     echo "You also have: ''line' ''archsufx' ''F$GETSYI("VERSION")'"
$     vms_cc_available = vms_cc_available + "cc/decc "
$   ENDIF
$ ELSE
$   IF (F$LOCATE("DEC",line).NE.F$LENGTH(line)).or.(F$LOCATE("Compaq",line).NE.F$LENGTH(line)) -
    .or.(F$LOCATE("HP",F$EDIT(line,"UPCASE")).NE.F$LENGTH(line))
$   THEN 
$     vms_cc_dflt = "/decc"
$     vms_cc_available = vms_cc_available + "cc/decc "
$   ENDIF
$ ENDIF
$!
$Gcc_initial_check:
$ echo "Checking for gcc"
$ OPEN/WRITE CONFIG gccvers.lis
$ SET NOON
$ DEFINE/USER_MODE SYS$ERROR CONFIG
$ DEFINE/USER_MODE SYS$OUTPUT CONFIG
$ 'gcc_symbol'/noobj/version _nla0:
$ tmp = $status
$ SET ON
$ IF (silent) THEN GOSUB Shut_up
$ CLOSE CONFIG
$ IF (tmp.NE.%X10000001).and.(tmp.ne.%X00030001)
$ THEN
$   echo "Symbol ""''gcc_symbol'"" is not defined. I guess you do not have it."
$   DELETE/NOLOG/NOCONFIRM gccvers.lis;
$   GOTO Cxx_initial_check
$ ENDIF
$ OPEN/READ CONFIG gccvers.lis
$GCC_List_Read:
$ READ/END_OF_FILE=GCC_List_End CONFIG line
$ GOTO GCC_List_Read
$GCC_List_End:
$ CLOSE CONFIG
$ echo line
$ vms_cc_available = vms_cc_available + "''gcc_symbol' "
$ DELETE/NOLOG/NOCONFIRM gccvers.lis;
$!
$Cxx_initial_check:
$!
$! Do note that [vms]perl source files have a ways to go before they will 
$! compile under CXX.
$! In order to test Configure.com with CXX invoke it with "-Dtry_cxx" on
$! the command line.
$!
$ IF F$TYPE(try_cxx) .EQS. "" THEN try_cxx := n
$ IF try_cxx .OR. try_cxx .EQS. "define"
$!
$ THEN
$!
$ echo "Checking for CXX..."
$ OPEN/WRITE CONFIG ccvms.c
$ WRITE CONFIG "#include <iostream>"
$ WRITE CONFIG "int main() {"
$ WRITE CONFIG "#ifdef __DECCXX"
$ WRITE CONFIG "        cout << __DECCXX, endl;"
$ WRITE CONFIG "#else"
$ WRITE CONFIG "        cout << 0,endl;"
$ WRITE CONFIG "#endif"
$! Todo: add G++ identifier check ??
$ WRITE CONFIG "        return(0);"
$ WRITE CONFIG "}"
$ CLOSE CONFIG
$ SET NOON
$ DEFINE/USER_MODE SYS$OUTPUT NL:
$ DEFINE/USER_MODE SYS$ERROR NL:
$ cxx ccvms.c
$ tmp = $status
$ SET ON
$! success $status with:
$! DEC C++ V1.1-001 on VMS VAX V5.5-2
$! DEC C++ V5.6-013 on OpenVMS VAX V7.1
$! DEC C++ V6.1-003 on OpenVMS Alpha V7.1
$! Compaq C++ V6.2-016 for OpenVMS Alpha V7.2-1
$ IF tmp .eq. %X15F60001  
$ THEN
$! Which linker?
$   SET NOON
$   DEFINE/USER_MODE SYS$OUTPUT NL:
$   DEFINE/USER_MODE SYS$ERROR NL:
$   link/nodebug ccvms.obj
$   tmp = $status
$   SET ON
$   ! success $status with:
$   ! link && DEC C++ V1.1-001 on VMS VAX V5.5-2
$   ! link && DEC C++ V5.6-013 on OpenVMS VAX V7.1
$   IF tmp .eq. %X10000001
$   THEN
$     ld_try = "Link"
$     vms_cc_available = vms_cc_available + "cxx "
$     echo "CXX and LINK are available."
$   ELSE
$     IF F$SEARCH("ccvms.exe") .NES. "" THEN DELETE/NOLOG/NOCONFIRM ccvms.exe;
$     SET NOON
$     DEFINE/USER_MODE SYS$OUTPUT NL:
$     DEFINE/USER_MODE SYS$ERROR NL:
$     cxxlink ccvms.obj
$     tmp = $status
$     SET ON
$     ! success $status with:
$     ! cxxlink && DEC C++ V6.1-003 on OpenVMS Alpha V7.1
$     ! cxxlink && Compaq C++ V6.2-016 for OpenVMS Alpha V7.2-1
$     IF tmp .eq. %X10000001 
$     THEN 
$       ld_try = "cxxlink"
$       vms_cc_available = vms_cc_available + "cxx "
$       echo "CXX and CXXLINK are available."
$     ENDIF
$   ENDIF
$   IF F$SEARCH("ccvms.exe") .NES. "" THEN DELETE/NOLOG/NOCONFIRM ccvms.exe;
$ ELSE
$   echo "Nope."
$ ENDIF
$ DELETE/NOLOG/NOCONFIRM ccvms.c;
$ IF F$SEARCH("ccvms.obj") .NES. "" THEN DELETE/NOLOG/NOCONFIRM ccvms.obj;
$ CALL Cxx_demangler_cleanup
$!
$ ENDIF ! 1 .eq. 0 or 1 .eq. 1
$!
$CC_Cleanup:
$ DELETE/NOLOG/NOCONFIRM ccvms.*;
$CC_Desired:
$!: see if we need a special compiler
$! echo ""
$ echo "Available compiler(s):"
$ echo "( ''vms_cc_available')"
$ IF .NOT.nocc 
$ THEN
$   dflt = "cc''vms_cc_dflt'"  !-> "cc" in case first compile went OK
$ ELSE
$   dflt = gcc_symbol
$ ENDIF
$ rp = "Use which C compiler? [''dflt'] "
$ GOSUB myread
$ IF ans.NES.""
$ THEN
$   ans = F$EDIT(ans,"TRIM, COMPRESS, LOWERCASE")
$   Mcc = ans
$   IF (F$LOCATE("dec",ans).NE.F$LENGTH(ans)).or.(F$LOCATE("compaq",ans).NE.F$LENGTH(ans)) -
    .or.(F$LOCATE("hp",ans).NE.F$LENGTH(ans))
$   THEN
$     Mcc = "cc/decc"
$! CPQ ?
$     ccname := DEC
$     C_COMPILER_Replace = "CC=cc=''Mcc'"
$   ENDIF
$   IF F$LOCATE("cxx",F$EDIT(ans,"COLLAPSE,LOWERCASE")) .NE. F$LENGTH(ans)
$   THEN
$     Mcc = "cxx"
$     ccname := CXX
$     ld = ld_try
$     C_COMPILER_Replace = "CC=cc=''Mcc'"
$   ELSE ! Not_cxx
$     IF Mcc.NES.dflt
$     THEN
$       IF F$LOCATE("dec",dflt) .NE. F$LENGTH(dflt) .or. -
           F$LOCATE("compaq",dflt) .NE. F$LENGTH(dflt)
$       THEN 
$         C_COMPILER_Replace = "CC=cc=''Mcc'"
$       ELSE
$         ccname := DEC
$       ENDIF
$     ELSE
$       IF Mcc .EQS. "cc/decc"
$       THEN
$         ccname := DEC
$         C_COMPILER_Replace = "CC=cc=''Mcc'"
$       ENDIF
$     ENDIF
$   ENDIF
$ ELSE 
$   Mcc = dflt
$   IF Mcc .EQS. "cc/decc"
$   THEN
$     ccname := DEC
$     C_COMPILER_Replace = "CC=cc=''Mcc'"
$   ENDIF
$   IF Mcc .EQS. "gcc"
$   THEN
$     ccname := GCC
$     C_COMPILER_Replace = "CC=cc=''Mcc'"
$   ENDIF
$ ENDIF
$Decc_Version_check:
$ ccversion=""
$ IF ccname .EQS. "DEC"
$ THEN
$   echo ""
$   echo4 "Checking for the Dec C version number..."
$   OPEN/WRITE CONFIG deccvers.c
$   WRITE CONFIG "#include <stdlib.h>"  !DECC is sooo picky
$   WRITE CONFIG "#include <stdio.h>"
$   WRITE CONFIG "int main() {"
$   WRITE CONFIG "#ifdef __DECC"
$   WRITE CONFIG "#ifdef __DECC_VER"
$   WRITE CONFIG "        printf(""%i\n"", __DECC_VER);"
$   WRITE CONFIG "#else"
$   WRITE CONFIG "        printf(""%i\n"", ""1"");"
$   WRITE CONFIG "#endif"
$   WRITE CONFIG "#endif"
$   WRITE CONFIG "        exit(0);"
$   WRITE CONFIG "}"
$   CLOSE CONFIG
$   SET NOON
$   DEFINE/USER_MODE SYS$ERROR NL:
$   DEFINE/USER_MODE SYS$OUTPUT NL:
$   'Mcc' deccvers.c
$   tmp = $status
$   IF (silent) THEN GOSUB Shut_up
$   DEFINE/USER_MODE SYS$ERROR NL:
$   DEFINE/USER_MODE SYS$OUTPUT NL:
$   link/nodebug deccvers.obj
$   tmp = $status
$   IF (silent) THEN GOSUB Shut_up
$   OPEN/WRITE CONFIG deccvers.out
$   DEFINE/USER_MODE SYS$ERROR CONFIG
$   DEFINE/USER_MODE SYS$OUTPUT CONFIG
$   mcr []deccvers.exe
$   tmp = $status
$   SET ON
$   CLOSE CONFIG
$   IF (silent) THEN GOSUB Shut_up
$   OPEN/READ CONFIG deccvers.out
$   READ/END_OF_FILE=Dec_c_cleanup CONFIG line
$Dec_c_cleanup:
$   CLOSE CONFIG
$   echo "You are using Dec C ''line'"
$   ccversion = line
$   Dec_C_Version = F$INTEGER(line)
$   IF Dec_C_Version .GE. 60200000 .AND. archname .NES. "VMS_VAX"
$   THEN
$     echo4 "adding /NOANSI_ALIAS qualifier to ccflags."
$     ccflags = ccflags + "/NOANSI_ALIAS"
$   ENDIF
$   DELETE/NOLOG/NOCONFIRM deccvers.*;
$ ENDIF
$Gcc_check:
$ gccversion = ""
$ IF ccname .EQS. "GCC"
$ THEN
$   vaxcrtl_olb = F$SEARCH("SYS$LIBRARY:VAXCRTL.OLB")
$   vaxcrtl_exe = F$SEARCH("SYS$SHARE:VAXCRTL.EXE")
$   gcclib_olb  = F$SEARCH("GNU_CC:[000000]GCCLIB.OLB")
$   IF gcclib_olb .EQS. "" 
$   THEN 
$!    These objects/libs come w/ gcc 2.7.2 for AXP:
$     tmp = F$SEARCH("GNU_CC:[000000]libgcc2.olb")
$     IF tmp .NES. "" then gcclib_olb = tmp
$     tmp = F$SEARCH("GNU_CC:[000000]libgcclib.olb")
$     IF tmp .NES. "" 
$     THEN 
$       IF gcclib_olb .EQS. "" 
$       THEN gcclib_olb = tmp
$       ELSE gcclib_olb = gcclib_olb + "/lib," + tmp
$       ENDIF
$     ENDIF
$     tmp = F$SEARCH("SYS$LIBRARY:VAXCRTL.OLB")
$     IF tmp .NES. "" 
$     THEN 
$       IF gcclib_olb .EQS. "" 
$       THEN gcclib_olb = tmp
$       ELSE gcclib_olb = gcclib_olb + "/lib," + tmp
$       ENDIF
$     ENDIF
$     tmp = F$SEARCH("GNU_CC:[000000]crt0.obj")
$     IF tmp .NES. "" 
$     THEN 
$       IF gcclib_olb .EQS. "" 
$       THEN gcclib_olb = tmp
$       ELSE gcclib_olb = gcclib_olb + "/lib," + tmp
$       ENDIF
$     ENDIF
$     IF gcclib_olb .EQS. vaxcrtl_olb THEN gcclib_olb = "" !goofy order of axplibs
$   ELSE
$     gcclib_olb = gcclib_olb + "/lib"
$   ENDIF
$   IF   gcclib_olb .NES. "" .AND. -
     (vaxcrtl_olb .NES. "" .OR. -
      vaxcrtl_exe .NES. "" )
$   THEN
$     echo ""
$     echo4 "Checking for GNU cc in disguise and/or its version number..." !>&4
$     OPEN/WRITE CONFIG gccvers.c
$     WRITE CONFIG "#include <stdio.h>"
$     WRITE CONFIG "int main() {"
$     WRITE CONFIG "#ifdef __GNUC__"
$     WRITE CONFIG "#ifdef __VERSION__"
$     WRITE CONFIG "        printf(""%s\n"", __VERSION__);"
$     WRITE CONFIG "#else"
$     WRITE CONFIG "        printf(""%s\n"", ""1"");"
$     WRITE CONFIG "#endif"
$     WRITE CONFIG "#endif"
$     WRITE CONFIG "        exit(0);"
$     WRITE CONFIG "}"
$     CLOSE CONFIG
$     DEFINE SYS$ERROR _NLA0:
$     DEFINE SYS$OUTPUT _NLA0:
$     'Mcc' gccvers.c
$     tmp = $status
$     DEASSIGN SYS$ERROR _NLA0:
$     DEASSIGN SYS$OUTPUT _NLA0:
$     IF (silent) THEN GOSUB Shut_up
$     DEFINE SYS$ERROR _NLA0:
$     DEFINE SYS$OUTPUT _NLA0:
$     IF vaxcrtl_exe .EQS. ""
$     THEN 
$       IF F$LOCATE("VAXCRTL",gcclib_olb).NE.F$LENGTH(gcclib_olb)
$       THEN 
$         link/nodebug gccvers.obj,'gcclib_olb',SYS$LIBRARY:VAXCRTL/Library
$         tmp = $status
$       ELSE
$         link/nodebug gccvers.obj,'gcclib_olb'
$         tmp = $status
$       ENDIF
$     ELSE
$       OPEN/WRITE CONFIG GCCVERS.OPT
$       WRITE CONFIG "SYS$SHARE:VAXCRTL/SHARE"
$       CLOSE CONFIG
$       link/nodebug gccvers.obj,GCCVERS.OPT/OPT,'gcclib_olb'
$       tmp = $status
$     ENDIF
$     DEASSIGN SYS$ERROR
$     DEASSIGN SYS$OUTPUT
$     IF (silent) THEN GOSUB Shut_up
$     OPEN/WRITE CONFIG gccvers.out
$     DEFINE SYS$ERROR CONFIG
$     DEFINE SYS$OUTPUT CONFIG
$     mcr []gccvers.exe
$     tmp = $status
$     CLOSE CONFIG
$     DEASSIGN SYS$OUTPUT
$     DEASSIGN SYS$ERROR
$     IF (silent) THEN GOSUB Shut_up
$     OPEN/READ CONFIG gccvers.out
$     READ/END_OF_FILE=Gcc_cleanup CONFIG line
$Gcc_cleanup:
$     CLOSE CONFIG
$     DELETE/NOLOG/NOCONFIRM gccvers.*;
$     IF F$LOCATE("GNU C version ",line).NE.F$LENGTH(line)
$     THEN 
$       echo "You are not using GNU cc."
$       GOTO Host_name
$     ELSE 
$       echo "You are using GNU cc ''line'"
$       gccversion = line
$       ccname := "GCC"
$       C_COMPILER_Replace = "CC=cc=''Mcc'"
$       GOTO Include_dirs
$     ENDIF
$   ENDIF
$ ENDIF
$Cxx_Version_check:
$ IF ccname .EQS. "CXX"
$ THEN
$   OPEN/WRITE CONFIG cxxvers.c
$   WRITE CONFIG "#include <stdio.h>"
$   WRITE CONFIG "int main() {"
$   WRITE CONFIG "#ifdef __DECCXX_VER"
$   WRITE CONFIG "        printf(""%i\n"", __DECCXX_VER);"
$   WRITE CONFIG "#else"
$   WRITE CONFIG "        printf(""%i\n"", ""0"");"
$   WRITE CONFIG "#endif"
$   WRITE CONFIG "        return(0);"
$   WRITE CONFIG "}"
$   CLOSE CONFIG
$   SET NOON
$   DEFINE/USER_MODE SYS$ERROR NL:
$   DEFINE/USER_MODE SYS$OUTPUT NL:
$   'Mcc' cxxvers.c
$   tmp = $status
$   SET ON
$   IF (silent) THEN GOSUB Shut_up
$   SET NOON
$   DEFINE/USER_MODE SYS$ERROR NL:
$   DEFINE/USER_MODE SYS$OUTPUT NL:
$   'ld' cxxvers.obj
$   tmp = $status
$   SET ON
$   IF (silent) THEN GOSUB Shut_up
$   OPEN/WRITE CONFIG cxxvers.out
$   SET NOON
$   DEFINE/USER_MODE SYS$ERROR CONFIG
$   DEFINE/USER_MODE SYS$OUTPUT CONFIG
$   mcr []cxxvers.exe
$   tmp = $status
$   SET ON
$   CLOSE CONFIG
$   IF (silent) THEN GOSUB Shut_up
$   OPEN/READ CONFIG cxxvers.out
$   READ/END_OF_FILE=Cxx_cleanup CONFIG line
$Cxx_cleanup:
$   CLOSE CONFIG
$   DELETE/NOLOG/NOCONFIRM cxxvers.*;
$   echo "You are using CXX ''line'"
$   cxxversion = line
$   ccversion = line
$   d_cplusplus = "define"
$   CALL Cxx_demangler_cleanup
$ ELSE
$   d_cplusplus = "undef"
$ ENDIF
$!
$Cxx_demangler_cleanup: SUBROUTINE
$!
$!  If we do build with CXX these demangler Dbs will be left all over.
$!  However, configure.com does try to remove the [.UU] sub directory.
$!  Be sure to set default to the correct place before calling this sub.
$!
$ SET NOON
$ IF F$SEARCH("[.CXX_REPOSITORY]*.*") .NES. "" THEN DELETE/NOLOG/NOCONFIRM [.CXX_REPOSITORY]*.*;*
$ IF F$SEARCH("CXX_REPOSITORY.DIR") .NES. ""
$ THEN
$   SET PROTECTION=(SYSTEM:RWED,OWNER:RWED) CXX_REPOSITORY.DIR
$   DELETE/NOLOG/NOCONFIRM CXX_REPOSITORY.DIR;
$ ENDIF
$ SET ON
$ EXIT
$ ENDSUBROUTINE ! Cxx_demangler_cleanup
$!
$ GOTO Host_name
$!
$List_Parse:
$ OPEN/READ CONFIG ccvms.lis
$ READ CONFIG line
$ IF archname .EQS. "VMS_VAX"
$ THEN
$   read CONFIG line
$   archsufx = "VAX"
$ ELSE
$   IF archname .EQS. "VMS_AXP"
$   THEN
$       archsufx = "AXP"
$   ELSE
$       archsufx = "IA64"
$   ENDIF
$ ENDIF
$ CLOSE CONFIG
$ line = F$EDIT(line,"TRIM,COMPRESS")
$ line = line - "Page 1"           ! occurs at end all compilers
$ line = line - "CCVMS "           ! filename appears w/ VAXC
$ line = line - "Source Listing "  ! Seen w/ AXP DECC
$ tmp = F$EXTRACT(0,20,line)       !timestamp, e.g. "30-JUL-1996 21:12:54 "
$ line = line - tmp
$ line = F$EDIT(line,"TRIM")       !bit redundant but we're in no big hurry
$ DELETE/NOLOG/NOCONFIRM ccvms.lis;
$ RETURN
$!
$Include_dirs:
$!: What should the include directory be ? (.TLB text libraries)
$ dflt = gcclib_olb 
$ rp = "Where are the include files you want to use? "
$ IF f$length( rp + "[''dflt'] " ) .GT. 76
$ THEN rp = F$FAO("!AS!/!AS",rp,"[''dflt'] ")
$ ELSE rp = rp + "[''dflt'] "
$ ENDIF
$ GOSUB myread
$ usrinc = ans
$!
$!: see if we have to deal with yellow pages, now NIS.
$!: now get the host name
$Host_name:
$ echo ""
$ echo4 "Figuring out host name..." !>&4
$ myhostname = ""
$  IF myhostname.eqs."" THEN myhostname = F$TRNLNM("ARPANET_HOST_NAME")
$  IF myhostname.eqs."" THEN myhostname = F$TRNLNM("INTERNET_HOST_NAME")
$  IF myhostname.eqs."" THEN myhostname = F$TRNLNM("MULTINET_HOST_NAME")
$  IF myhostname.eqs."" THEN myhostname = F$TRNLNM("UCX$INET_HOST_NAME")
$  IF myhostname.eqs."".and. -
      F$TRNLNM("UCX$INET_HOST") .nes. "" .and. -
      F$TRNLNM("UCX$INET_DOMAIN") .nes. "" THEN - 
     myhostname = F$TRNLNM("UCX$INET_HOST") + "." + F$TRNLNM("UCX$INET_DOMAIN") 
$  IF myhostname.eqs."".and. -
      F$TRNLNM("TCPIP$INET_HOST") .nes. "" .and. -
      F$TRNLNM("TCPIP$INET_DOMAIN") .nes. "" THEN - 
     myhostname = F$TRNLNM("TCPIP$INET_HOST") + "." + F$TRNLNM("TCPIP$INET_DOMAIN") 
$  IF myhostname.eqs."" THEN myhostname = F$TRNLNM("TCPWARE_DOMAINNAME")
$  IF myhostname.eqs."" THEN myhostname = F$TRNLNM("NEWS_ADDRESS")
$  IF myhostname.eqs."" THEN myhostname = F$TRNLNM("SYS$NODE") - "::"
$  IF myhostname.eqs."" THEN myhostname = F$EDIT(F$GETSYI("SCSNODE"),"TRIM")
$!: you do not want to know about this
$!: verify guess
$ rp = "Your host name appears to be """"''myhostname'"""". Right? "
$ bool_dflt = "y"
$ GOSUB myread
$ IF (.not.ans)
$   THEN 
$     READ SYS$COMMAND/PROMPT= - 
 "Please type the (one word) name of your host: " ans
$     myhostname = ans
$ ENDIF
$!: translate upper to lower if necessary
$ myhostname = F$EDIT(myhostname,"COLLAPSE")
$ mylowhostname = F$EDIT(myhostname," LOWERCASE")
$ IF mylowhostname.NES.myhostname
$ THEN
$   echo "(Normalizing case in your host name)"
$   myhostname = mylowhostname
$ ENDIF
$!
$ fp = F$LOCATE(".",myhostname)
$ mydomain = F$EXTRACT(fp,(F$LENGTH(myhostname)-fp)+1,myhostname)
$ IF mydomain.NES.""  !no periods in DECnet names like "MYDECNODE::"
$ THEN
$   rp = "What is your domain name? [''mydomain'] "
$   dflt = mydomain
$   GOSUB myread
$   mydomain = ans
$!: translate upper to lower if necessary
$   mydomain = F$EDIT(mydomain,"COLLAPSE")
$   mylowdomain = F$EDIT(mydomain," LOWERCASE")
$   IF mylowdomain.NES.mydomain
$   THEN
$     echo "(Normalizing case in your domain name)"
$     mydomain = mylowdomain
$   ENDIF
$ ENDIF
$ myhostname = myhostname - mydomain
$ echo "(Trimming domain name from host name--host name is now ''myhostname')"
$ IF .NOT.silent 
$ THEN
$   TYPE SYS$INPUT:
$   DECK

I need to get your e-mail address in Internet format if possible, i.e.
something like user@host.domain. Please answer accurately since I have
no easy means to double check it. The default value provided below
is most probably close to the reality but may not be valid from outside
your organization...
$   EOD
$ ENDIF
$ IF F$TYPE(cf_email) .EQS. "" 
$ THEN 
$   dflt = "''cf_by'@''myhostname'"+"''mydomain'"
$   rp = "What is your e-mail address? [''dflt'] "
$   GOSUB myread
$   cf_email = ans
$ ENDIF
$!
$ IF .NOT.silent 
$ THEN
$   TYPE SYS$INPUT:
$   DECK

If you or somebody else will be maintaining perl at your site, please
fill in the correct e-mail address here so that they may be contacted
if necessary. Currently, the "perlbug" program included with perl
will send mail to this address in addition to perlbug@perl.com. You may
enter "none" for no administrator.
$   EOD
$ ENDIF
$ dflt = "''cf_email'"
$ rp = "Perl administrator e-mail address [''dflt'] "
$ GOSUB myread
$ perladmin = ans
$!
$!: determine where public executable scripts go
$!: determine perl absolute location
$!: figure out how to guarantee perl startup
$!
$!: see how we invoke the C preprocessor
$! echo ""
$! echo4 "Now, how can we feed standard input to your C preprocessor..." !>&4
$!: Set private lib path
$!: Now check and see which directories actually exist, avoiding duplicates
$!: determine optimize, if desired, or use for debug flag also
$!: We will not override a previous value, but we might want to
$!: augment a hint file
$!: the following weeds options from ccflags that are of no interest to cpp
$!: flags used in final linking phase
$!: Try to guess additional flags to pick up local libraries.
$!: coherency check
$! echo ""
$! echo4 "Checking your choice of C compiler and flags for coherency..." !>&4
$!: compute shared library extension
$!: Looking for optional libraries
$!: see if nm is to be used to determine whether a symbol is defined or not
$!: get list of predefined functions in a handy place
$!: see if we have sigaction or sigprocmask
$!: see whether socketshr exists
$ IF (F$SEARCH(F$PARSE("SocketShr","Sys$Share:.Exe")).NES."")
$ THEN
$   Has_socketshr     = "T"
$   echo ""
$   echo4 "Hmm... Looks like you have SOCKETSHR Berkeley networking support."
$ ELSE
$   Has_socketshr     = "F"
$ ENDIF
$ IF (ccname .EQS. "DEC" .AND. Dec_C_Version .GE. 50200000) .OR. (ccname .EQS. "CXX")
$ THEN
$   Has_Dec_C_Sockets = "T"
$   echo ""
$   echo4 "Hmm... Looks like you have Dec C Berkeley networking support."
$ ELSE
$   Has_Dec_C_Sockets = "F"
$ ENDIF
$ ! Hey, we've got both. Default to Dec C, then, since it's better
$ IF Has_socketshr .OR. Has_Dec_C_Sockets
$ THEN
$   echo ""
$   echo "You have sockets available.  Which socket stack do you want to"
$   echo "build into Perl?"
$   IF Has_Dec_C_Sockets
$   THEN
$     dflt = "DECC"
$   ELSE
$     dflt = "SOCKETSHR"
$   ENDIF
$   rp = "Choose socket stack (NONE"
$   IF Has_socketshr THEN rp = rp + ",SOCKETSHR"
$   IF Has_Dec_C_Sockets THEN rp = rp + ",DECC"
$   rp = rp + ") [''dflt'] "
$   GOSUB myread
$   Has_Dec_C_Sockets = "F"
$   Has_socketshr = "F"
$   ans = F$EDIT(ans,"TRIM,COMPRESS,LOWERCASE")
$   IF ans.eqs."decc" THEN Has_Dec_C_Sockets = "T"
$   IF ans.eqs."socketshr" THEN Has_socketshr = "T"
$ ENDIF
$!
$!
$! Ask if they want to build with VMS_DEBUG perl
$ echo ""
$ echo "Perl can be built to run under the VMS debugger."
$ echo "You should only select this option if you are debugging"
$ echo "perl itself.  This can be a useful feature if you are "
$ echo "embedding perl in a program."
$ bool_dflt = "n"
$ if f$type(usevmsdebug) .nes. "" 
$ then
$   if usevmsdebug .or. usevmsdebug .eqs. "define" then bool_dflt="y"
$ endif
$ rp = "Build a VMS-DEBUG version of Perl? [''bool_dflt'] "
$ GOSUB myread
$ use_vmsdebug_perl = ans
$ IF use_vmsdebug_perl
$ THEN
$   usevmsdebug = "define"
$   macros = macros + """__DEBUG__=1"","
$ ELSE
$   usevmsdebug = "undef"
$ ENDIF
$!
$! Ask if they want to build with DEBUGGING
$ echo ""
$ echo "Perl can be built with extra runtime debugging enabled. This"
$ echo "enables the -D switch, at the cost of some performance.  It"
$ echo "was mandatory on perl 5.005 and before on VMS, but is now"
$ echo "optional.  If you do not generally use it you should probably"
$ echo "leave this off and gain a bit of extra speed."
$ bool_dflt = "y"
$ if f$type(useperldebug) .nes. "" 
$ then
$   if f$extract(0,1,f$edit(useperldebug,"collapse,upcase")).eqs."N"  .or. useperldebug .eqs. "undef" then bool_dflt="n"
$ endif
$ rp = "Build a DEBUGGING version of Perl? [''bool_dflt'] "
$ GOSUB myread
$ use_debugging_perl = ans
$!
$! Ask if they want to build with MULTIPLICITY
$ echo ""
$ echo "Perl can be built so that multiple Perl interpreters can coexist"
$ echo "within the same Perl executable."
$ echo "There is some performance overhead, however, so you"
$ echo "probably do not want to choose this unless you are going to be" 
$ echo "doing things with embedded perl."
$ bool_dflt = "n"
$ if f$type(usemultiplicity) .nes. "" 
$ then
$   if usemultiplicity .or. usemultiplicity .eqs. "define" then bool_dflt = "y"
$ endif
$ rp = "Build Perl for multiplicity? [''bool_dflt'] "
$ GOSUB myread
$ IF ans
$ THEN
$   usemultiplicity="define"
$ ELSE
$   usemultiplicity="undef"
$ ENDIF
$!
$! Ask if they want to build with 64-bit support
$ IF (archname.NES."VMS_VAX").and.("''f$extract(1,3, f$getsyi(""version""))'".ges."7.1")
$ THEN
$   bool_dflt = "n"
$   IF F$TYPE(use64bitint) .NES. "" 
$   THEN
$       IF use64bitint .OR. use64bitint .eqs. "define" THEN bool_dflt = "y"
$   ENDIF
$   echo ""
$   echo "You have natively 64-bit long integers."
$   echo ""
$   echo "Perl can be built to take advantage of 64-bit integer types"
$   echo "on some systems, To do so, Configure can be run with -Duse64bitint."
$   echo "Choosing this option will most probably introduce binary incompatibilities."
$   echo ""
$   echo "If this does not make any sense to you, just accept the default '" + bool_dflt + "'."
$   rp = "Try to use 64-bit integers, if available? [''bool_dflt'] "
$   GOSUB myread
$   use64bitint = ans
$!
$   bool_dflt = "n"
$   IF F$TYPE(use64bitall) .NES. "" 
$   THEN
$       IF use64bitall .OR. use64bitall .eqs. "define" THEN bool_dflt = "y"
$   ENDIF
$   echo ""
$   echo "You may also choose to try maximal 64-bitness.  It means using as much"
$   echo "64-bitness as possible on the platform.  This in turn means even more"
$   echo "binary incompatibilities.  On the other hand, your platform may not"
$   echo "have any more 64-bitness available than what you already have chosen."
$   echo ""
$   echo "If this does not make any sense to you, just accept the default '" + bool_dflt + "'."
$   rp = "Try to use maximal 64-bit support, if available? [''bool_dflt'] "
$   GOSUB myread
$   use64bitall=ans
$   IF use64bitall .AND. .NOT. use64bitint
$   THEN
$     echo ""
$     echo "Since you have chosen a maximally 64-bit build, I'm also turning on"
$     echo "the use of 64-bit integers."
$     use64bitint="Y"
$   ENDIF
$!
$   bool_dflt = use64bitall
$   IF F$TYPE(uselargefiles) .NES. "" 
$   THEN
$       IF uselargefiles .OR. uselargefiles .eqs. "define" THEN bool_dflt = "y"
$   ENDIF
$   echo ""
$   echo "Perl can be built to understand large files (files larger than 2 gigabytes)"
$   echo "on some systems.  To do so, Configure can be run with -Duselargefiles."
$   echo ""
$   echo "If this does not make any sense to you, just accept the default '" + bool_dflt + "'."
$   rp = "Try to understand large files, if available? [''bool_dflt'] "
$   GOSUB myread
$   uselargefiles=ans
$!
$   bool_dflt = "n"
$   IF F$TYPE(uselongdouble) .NES. "" 
$   THEN
$       IF uselongdouble .OR. uselongdouble .eqs. "define" THEN bool_dflt = "y"
$   ENDIF
$   echo ""
$   echo "Perl can be built to take advantage of long doubles which"
$   echo "(if available) may give more accuracy and range for floating point numbers."
$   echo ""
$   echo "If this does not make any sense to you, just accept the default '" + bool_dflt + "'."
$   rp = "Try to use long doubles, if available? [''bool_dflt'] "
$   GOSUB myread
$   uselongdouble = ans
$!
$ ENDIF ! not VAX && >= 7.1
$!
$ IF usesitecustomize .OR. usesitecustomize .eqs. "define" 
$ THEN 
$       usesitecustomize = "define"
$ ELSE
$       usesitecustomize = "undef"
$ ENDIF
$!
$! Ask about threads, if appropriate
$ IF ccname .EQS. "DEC" .OR. ccname .EQS. "CXX"
$ THEN
$   echo ""
$   echo "Perl can be built to take advantage of threads on some systems."
$   echo "To do so, configure.com can be run with -""Dusethreads""."
$   echo ""
$   echo "Note that Perl built with threading support runs slightly slower"
$   echo "and uses more memory than plain Perl. The current implementation"
$   echo "is believed to be stable, but it is fairly new, and so should be"
$   echo "treated with caution."
$   echo ""
$   bool_dflt = "n"
$   if f$type(usethreads) .nes. "" 
$   then 
$       if usethreads .or. usethreads .eqs. "define" then bool_dflt="y"
$   endif
$!  Catch cases where user specified ithreads or 5005threads but
$!  forgot -Dusethreads 
$   if f$type(useithreads) .nes. ""
$   then
$         if useithreads .or. useithreads .eqs. "define" then bool_dflt="y"
$   endif
$   if f$type(use5005threads) .nes. ""
$   then
$         if use5005threads .or. use5005threads .eqs. "define" then bool_dflt="y"
$   endif
$   echo "If this doesn't make any sense to you, just accept the default '" + bool_dflt + "'."
$   rp = "Build a threading Perl? [''bool_dflt'] "
$   GOSUB myread
$   if ans
$   THEN
$     use_threads="T"
$     ! Shall we do the 5.005-type threads, or IThreads?
$     echo "Since release 5.6, Perl has had two different threading implementations,"
$     echo "the newer interpreter-based version (ithreads) with one interpreter per"
$     echo "thread, and the older 5.005 version (5005threads)."
$     echo "The 5005threads version is effectively unmaintained and will probably be"
$     echo "removed in Perl 5.10, so there should be no need to build a Perl using it"
$     echo "unless needed for backwards compatibility with some existing 5.005threads"
$     echo "code."
$     echo ""
$     bool_dflt = "y"
$     if f$type(useithreads) .nes. ""
$     then
$         if useithreads .eqs. "undef" then bool_dflt="n"
$     endif
$     if f$type(use5005threads) .nes. ""
$     then
$         if use5005threads .or. use5005threads .eqs. "define" then bool_dflt="n"
$     endif
$     rp = "Use the newer intepreter-based ithreads? [''bool_dflt'] "
$     GOSUB myread
$     use_ithreads=ans
$     if use_ithreads 
$     THEN
$       use_5005_threads="N"
$     ELSE
$       use_5005_threads="Y"
$     ENDIF
$     ! Are they on VMS 7.1 or greater?
$     IF "''f$extract(1,3, f$getsyi(""version""))'" .GES. "7.1"
$     THEN
$       echo ""
$	echo "Threaded Perl can be linked to use system upcalls on your system. This feature"
$	echo "allows the thread scheduler to be made aware of system events (such as I/O)"
$	echo "so as to prevent a single thread from blocking all the threads in a program,"
$	echo "even on a single-processor machine."
$	bool_dflt = "y"
$	IF f$type(usethreadupcalls) .NES. ""
$	THEN
$       	if .not. usethreadupcalls .or. usethreadupcalls .eqs. "undef" then bool_dflt="n"
$	ENDIF
$       rp = "Enable thread upcalls? [''bool_dflt'] "
$       gosub myread
$       IF ans
$       THEN
$           thread_upcalls = "MTU=MTU=1"
$	    usethreadupcalls = "define"
$     	    ! Are they on alpha or itanium?
$	    IF (archname .NES. "VMS_VAX") .AND. ("''f$extract(1,3, f$getsyi(""version""))'" .GES. "7.2")
$     	    THEN
$       	echo ""
$       	echo "Threaded Perl can be linked to use multiple kernel threads on your system."
$       	echo "This feature allows multiple user threads to make use of multiple CPUs on"
$		echo "a multi-processor machine."
$       	bool_dflt = "n"
$		IF f$type(usekernelthreads) .nes. ""
$		THEN
$       		if usekernelthreads .or. usekernelthreads .eqs. "define" then bool_dflt="y"
$		ENDIF
$       	rp = "Enable multiple kernel threads? [''bool_dflt'] "
$       	gosub myread
$       	IF ans
$		THEN
$           	    thread_kernel = "MTK=MTK=1"
$	    	    usekernelthreads = "define"
$           	ENDIF
$           ENDIF
$       ENDIF
$     ENDIF
$   ENDIF
$ ENDIF
$ IF F$TYPE(usethreadupcalls) .EQS. "" THEN usethreadupcalls = "undef"
$ IF F$TYPE(usekernelthreads) .EQS. "" THEN usekernelthreads = "undef"
$ IF archname .NES. "VMS_VAX"
$ THEN
$! Case sensitive?
$   echo ""
$   echo "By default, perl (and pretty much everything else on VMS) uses"
$   echo "case-insensitive linker symbols. Which is to say, when the"
$   echo "underlying C code makes a call to a routine called Perl_foo in"
$   echo "the source, the name in the object modules or shareable images"
$   echo "is really PERL_FOO. There are some packages that use an"
$   echo "embedded perl interpreter that instead require case-sensitive"
$   echo "linker symbols."
$   echo ""
$   echo "If you have no idea what this means, and do not have"
$   echo "any program requiring anything, choose the default."
$   bool_dflt = be_case_sensitive
$   if f$type(usecasesensitive) .nes. ""
$   then
$       if usecasesensitive .or. usecasesensitive .eqs. "define" then bool_dflt = "y"
$       if f$extract(0,1,f$edit(usecasesensitive,"collapse,upcase")).eqs."N" .or. usecasesensitive .eqs. "undef"  then bool_dflt = "n"
$   endif
$   rp = "Build with case-sensitive symbols? [''bool_dflt'] "
$   GOSUB myread
$   be_case_sensitive = ans
$! IEEE math?
$   echo ""
$   echo "Perl normally uses IEEE format (T_FLOAT) floating point numbers"
$   echo "internally on Alpha, but if you need G_FLOAT for binary compatibility"
$   echo "with an external library or existing data, you may wish to disable"
$   echo "the IEEE math option."
$   bool_dflt = use_ieee_math
$   if f$type(useieee) .nes. "" 
$   then
$       if useieee .or. useieee .eqs. "define" 
$       then 
$         bool_dflt="y"
$       else
$         bool_dflt="n"
$       endif
$   endif
$   rp = "Use IEEE math? [''bool_dflt'] "
$   GOSUB myread
$   use_ieee_math = ans
$ ELSE
$   be_case_sensitive = "n"
$   use_ieee_math = "n"
$ ENDIF
$ useieee = "undef"
$ usecasesensitive = "undef"
$ if (use_ieee_math) then useieee = "define"
$ if (be_case_sensitive) then usecasesensitive = "define"
$! Unlink all versions?
$ echo ""
$ echo "By default, Perl's unlink() provides VMS-like behavior and only"
$ echo "deletes the latest version of a file.  Enabling this option builds"
$ echo "Perl so that unlink() deletes all versions of a file."
$ bool_dflt = unlink_all_versions
$ if f$type(unlink_all_versions) .nes. ""
$ then
$       if unlink_all_versions .or. unlink_all_versions .eqs. "define"
$       then
$         bool_dflt="y"
$       else
$         bool_dflt="n"
$       endif
$ endif
$ rp = "Make unlink() delete all versions of a file? [''bool_dflt'] "
$ GOSUB myread
$ unlink_all_versions = ans
$ IF unlink_all_versions
$ THEN
$     d_unlink_all_versions = "define"
$ ELSE
$     d_unlink_all_versions = "undef"
$ ENDIF
$!
$! To avoid 'SYSTEM-F-PROTINSTALL, protected images must be installed'
$! at run time, we must check that the DECterm image is both present
$! and installed as a known image.
$!
$ decterm_capable = "FALSE"
$ dflt = "SYS$SHARE:DECW$TERMINALSHR12.EXE"
$ IF F$SEARCH(dflt) .NES. "" 
$ THEN 
$    decterm_capable = F$FILE_ATTRIBUTES(dflt, "KNOWN")
$ ELSE
$     dflt = "SYS$SHARE:DECW$TERMINALSHR.EXE"
$     IF F$SEARCH(dflt) .NES. "" THEN decterm_capable = F$FILE_ATTRIBUTES(dflt, "KNOWN")
$ ENDIF
$!
$ IF F$TYPE(usedecterm) .NES. ""
$ THEN
$       if usedecterm .or. usedecterm .eqs. "define"
$       then
$         bool_dflt="y"
$       else
$         bool_dflt="n"
$       endif
$ ELSE
$       bool_dflt="n"
$ ENDIF
$ IF .NOT. use_debugging_perl THEN bool_dflt = "n"
$ echo ""
$ echo "Perl can be built to support DECterms from the Perl debugger"
$ echo ""
$ echo "If this does not make any sense to you, just accept the default '" + bool_dflt + "'."
$ rp = "Build with DECterm Perl debugger support, if available? [''bool_dflt'] "
$ GOSUB myread
$ usedecterm=ans
$ IF (usedecterm .OR. usedecterm .EQS. "define") .AND. .NOT. decterm_capable
$ THEN
$     echo4 "No installed DECterm image found, disabling..."
$     usedecterm = "n"
$ ENDIF
$! CC Flags
$ echo ""
$ echo "Your compiler may want other flags.  For this question you should include"
$ echo "/INCLUDE=(whatever) and /DEFINE=(whatever), flags and any other flags"
$ echo "or qualifiers used by the compiler."
$ echo ""
$ echo "To use no flags, specify the word ""none""."
$ dflt = user_c_flags
$ rp = "Any additional cc flags? [''dflt'] "
$ GOSUB myread
$ IF ans .EQS. "none" THEN ans = ""
$ user_c_flags = "''ans'"
$!
$! Ask whether they want to use secure logical translation when tainting
$ echo ""
$ echo "As Perl starts up, it checks several logical names, such as"
$ echo "PERL5LIB and PERL_ENV_TABLES, which allow you to modify aspects"
$ echo "of its behavior.  For additional security, you may limit this"
$ echo "process to executive- and kernel-mode translation when tainting"
$ echo "is enabled.  In this case, logical names normally skipped when"
$ echo "tainting is enabled (e.g. PERL5OPTS) are translated as well."
$ echo "If you do not choose to do this, the usual order of access modes"
$ echo "is used for logical name translation."
$ echo ""
$ echo "This restriction does not apply to the %ENV hash or to implicit"
$ echo "logical name translation during parsing of file specifications;"
$ echo "these always use the normal sequence of access modes for logical"
$ echo "name translation."
$ bool_dflt = "y"
$ if f$type(usesecurelog) .nes. "" 
$ then
$   if f$extract(0,1,f$edit(usesecurelog,"collapse,upcase")).eqs."N" .or. usesecurelog .eqs. "undef" then bool_dflt = "n"
$ endif
$ rp = "Use secure logical name translation? [''bool_dflt'] "
$ GOSUB myread
$ d_secintgenv  = ans
$ usesecurelog = "undef"
$ if (d_secintgenv) then usesecurelog = "define"
$!
$! Ask whether they want to default filetypes
$ echo ""
$ echo "When you pass the name of a program to Perl on the command line,"
$ echo "it generally doesn't supply any defaults unless the -S command"
$ echo "line switch is specified.  In keeping with the VMS tradition of"
$ echo "default file types, however, you can configure Perl to try default"
$ echo "file types of nothing, .pl, and .com, in that order (e.g. typing"
$ echo """$ perl foo"" would cause Perl to look for foo., then foo.pl, and"
$ echo "finally foo.com)."
$ echo ""
$ echo "This is currently broken in some configurations. Only enable it if"
$ echo "you know what you are doing."
$ bool_dflt = "n"
$ if f$type(usedefaulttypes) .nes. "" 
$ then
$     if usedefaulttypes .or. usedefaulttypes .eqs. "define" then bool_dflt="y"
$ endif
$ rp = "Always use default file types? [''bool_dflt'] "
$ GOSUB myread
$ d_alwdeftype = ans
$ usedefaulttypes = "undef"
$ if (d_alwdeftype) then usedefaulttypes = "define"
$!
$! determine whether to use malloc wrapping
$ echo ""
$ bool_dflt = "y"
$ IF F$TYPE(usemallocwrap) .nes. ""
$ then
$   if .NOT. usemallocwrap .or. usemallocwrap .eqs. "undef" then bool_dflt = "n"
$ endif
$ rp = "Do you wish to wrap malloc calls to protect against potential overflows? [''bool_dflt'] "
$ GOSUB myread
$ IF ans
$ THEN usemallocwrap = "define"
$ ELSE usemallocwrap = "undef"
$ ENDIF
$!
$! Ask if they want to use perl's memory allocator
$ echo ""
$ echo "Perl has a built-in memory allocator that is tuned for normal"
$ echo "memory usage.  It is oftentimes better than the standard system"
$ echo "memory allocator.  It also has the advantage of providing memory"
$ echo "allocation statistics, if you choose to enable them."
$ bool_dflt = "n"
$ IF F$TYPE(usemymalloc) .nes. ""
$ then
$   if usemymalloc .or. usemymalloc .eqs. "define" then bool_dflt = "y"
$ endif
$ rp = "Do you wish to attempt to use the malloc that comes with ''package'? [''bool_dflt'] "
$ GOSUB myread
$ mymalloc = ans
$ IF mymalloc
$ THEN
$   IF use_debugging_perl
$   THEN
$     echo ""
$     echo "Perl can keep statistics on memory usage if you choose to use"
$     echo "them.  This is useful for debugging, but does have some"
$     echo "performance overhead."
$     bool_dflt = "n"
$     rp = "Do you want the debugging memory allocator? [''bool_dflt'] "
$     gosub myread
$     use_debugmalloc = ans
$   ENDIF
$   ! Check which memory allocator we want
$   echo ""
$   echo "There are currently three different memory allocators: the"
$   echo "default (which is a pretty good general-purpose memory manager),"
$   echo "the TWO_POT allocator (which is optimized to save memory for"
$   echo "larger allocations), and PACK_MALLOC (which is optimized to save"
$   echo "memory for smaller allocations). They're all good, but if your"
$   echo "usage tends towards larger chunks use TWO_POT, otherwise use"
$   echo "PACK_MALLOC."
$   dflt = "DEFAULT"
$   rp = "Memory allocator (DEFAULT, TWO_POT, PACK_MALLOC) [''dflt'] "
$   GOSUB myread
$   if ans.eqs."TWO_POT" then use_two_pot_malloc = "Y"
$   if ans.eqs."PACK_MALLOC" then use_pack_malloc = "Y"
$ ENDIF
$!
$ known_extensions = ""
$ xxx = ""
$ OPEN/READ CONFIG 'manifestfound'
$ext_loop:
$   READ/END_OF_FILE=end_ext/ERROR=end_ext CONFIG line
$   IF F$EXTRACT(0,4,line) .NES. "ext/" .AND. -
       F$EXTRACT(0,8,line) .NES. "vms/ext/" THEN goto ext_loop
$   line = F$EDIT(line,"COMPRESS")
$   line = F$ELEMENT(0," ",line)
$   line_len = F$LENGTH(line)
$   IF F$EXTRACT(line_len - 12,12,line) .NES. "/Makefile.PL" THEN goto ext_loop
$   IF F$EXTRACT(0,4,line) .EQS. "ext/" THEN -
      xxx = F$EXTRACT(4,line_len - 16,line)
$   IF xxx .EQS. "DynaLoader" THEN goto ext_loop     ! omit
$   IF xxx .EQS. "SDBM_File/sdbm" THEN goto ext_loop ! sub extension - omit
$   IF xxx .EQS. "Devel/PPPort/harness" THEN goto ext_loop ! sub extension - omit
$   IF F$EXTRACT(0,7,xxx) .EQS. "Encode/" THEN goto ext_loop  ! sub extension - omit
$   IF xxx .EQS. "B/C" THEN goto ext_loop  ! sub extension - omit
$   IF F$EXTRACT(0,8,line) .EQS. "vms/ext/" THEN -
      xxx = "VMS/" + F$EXTRACT(8,line_len - 20,line)
$   known_extensions = known_extensions + " ''xxx'"
$   goto ext_loop
$end_ext:
$ close CONFIG
$ DELETE/SYMBOL xxx
$ known_extensions = F$EDIT(known_extensions,"TRIM,COMPRESS")
$ dflt = known_extensions
$ IF ccname .NES. "DEC" .AND. ccname .NES. "CXX"
$ THEN
$   dflt = dflt - "POSIX"             ! not with VAX C or GCC
$ ENDIF
$ dflt = dflt - "ByteLoader"          ! needs to be ported
$ dflt = dflt - "DB_File"             ! needs to be ported
$ dflt = dflt - "GDBM_File"           ! needs porting/special library
$ dflt = dflt - "IPC/SysV"            ! needs to be ported
$ dflt = dflt - "NDBM_File"           ! needs porting/special library
$ dflt = dflt - "ODBM_File"           ! needs porting/special library
$ dflt = dflt - "Sys/Syslog"          ! needs porting/special library "GDBM_File macro LOG_DEBUG"
$ IF .NOT. Has_socketshr .AND. .NOT. Has_Dec_C_Sockets
$ THEN
$   dflt = dflt - "Socket"            ! optional on VMS
$ ENDIF
$ ! Build this one only for threads without ithreads
$ IF useithreads .OR. useithreads .EQS. "define" .OR. .NOT. use_threads THEN dflt = dflt - "Thread"
$ dflt = dflt - "Win32API/File" - "Win32CORE" - "Win32"  ! need Dave Cutler's other project
$ dflt = F$EDIT(dflt,"TRIM,COMPRESS")
$!
$! Ask for their default list of extensions to build
$ echo ""
$ echo "It is time to specify which modules you want to build into"
$ echo "perl. Most of these are standard and should be chosen, though"
$ echo "you might, for example, want to build GDBM_File instead of"
$ echo "SDBM_File if you have the GDBM library built on your machine."
$ echo ""
$ echo "Which modules do you want to build into perl?"
$ rp = "[''dflt'] "
$ GOSUB myread
$ extensions = F$EDIT(ans,"TRIM,COMPRESS")
$!
$! %Config-I-VMS, determine build/make utility here (make gmake mmk mms)
$ echo ""
$ echo "Checking your ""make"" utilities..."
$! If the 'build' that you use is not here add it and it's test
$! switch to the _END_ of these strings (and increment max_build)
$! (e.g. builders = builders + "/FOOMAKE" 
$!       probers  = probers + " -fooVersionSwitch"
$! ) & please let me know about it.
$ builders = "IMAKE/GNUMAKE/MGMAKE/GMAKE/MAKE/MMS/MMK"
$ probers  = "-f Makefile. -v!-f Makefile. -v!-f Makefile. -v!-f Makefile. -v!-f Makefile. -v!/IDENT!/IDENT"
$ max_build = 7
$!
$ orig_dflt = f$edit(builder,"UPCASE")
$ if orig_dflt .eqs. "" then orig_dflt = "MMK"
$ default_set = ""
$ ok_builders = ""
$ OPEN/WRITE/ERROR=Open_error CONFIG Makefile.
$ WRITE CONFIG "dont_make_anything_yet:"
$ WRITE CONFIG F$FAO("!_")
$ CLOSE CONFIG
$ n = 0
$ messages = F$ENVIRONMENT("MESSAGE")
$Build_probe:
$ build = F$ELEMENT(n,"/",builders)
$ probe  = F$ELEMENT(n,"!",probers)
$ echo "Testing whether you have ''build' on your system..."
$!
$! Noted with GNU Make version 3.60  that the $status and $severity
$! with the 'probe' Makefile appear to be: $STATUS == "%X1000000C"
$! $SEVERITY == "4".
$!
$ SET NOON
$ ON CONTROL_Y THEN GOTO Reenable_messages_build
$ SET MESSAGE/NOFAC/NOSEV/NOIDENT/NOTEXT
$ 'build' 'probe'
$ IF ($SEVERITY .EQ. 1) ! not adequate?
$ THEN 
$   echo "OK."
$   IF (build .EQS. orig_dflt) 
$   THEN 
$     default_set = "TRUE"
$     dflt = build
$   ENDIF
$   ok_builders = ok_builders + " " + build
$   IF (.NOT. default_set) THEN dflt = build
$ ELSE 
$   echo "Nope."
$ ENDIF
$Reenable_messages_build:
$ SET MESSAGE 'messages'
$ SET ON
$ on control_y then goto clean_up
$ n = n + 1
$ IF (n .LT. max_build) THEN GOTO Build_probe
$!
$ echo ""
$ IF (ok_builders .NES. "") 
$ THEN
$   echo "Here is the list of builders you can apparently use:"
$   echo "(",ok_builders," )"
$   rp = "Which """"make"""" utility do you wish to use? [''dflt'] "
$   GOSUB myread
$   ans = F$EDIT(ans,"TRIM, COMPRESS")
$   ans = F$EXTRACT(0,F$LOCATE(" ",ans),ans) !throw out "-f Makefile." here
$   IF (ans .EQS. "") 
$   THEN build = dflt
$   ELSE build = ans
$   ENDIF
$ ELSE
$   TYPE SYS$INPUT:
$   DECK

%Config-E-VMS, ERROR:
 Well this looks pretty serious. Perl5 cannot be compiled without a "make"
 utility of some sort and after checking my "builders" list I cannot find
 the symbol or command you use on your system to compile programs.

$   EOD
$   READ SYS$COMMAND/PROMPT="Which ""MMS"" do you use? " ans
$   ans = F$EDIT(ans,"TRIM, COMPRESS")
$   ans = F$EXTRACT(0,F$LOCATE(" ",ans),ans) !throw out "-f Makefile." here
$   IF (ans .EQS. "") 
$   THEN build = dflt
$     echo "I do not know where ""make"" is, and my life depends on it."
$     echo "Go find a make program or fix your DCL$PATH setting!"
$     echo "ABORTING..."
$     SET DEFAULT 'vms_default_directory_name' !be kind rewind
$     STOP
$     EXIT 2 !$STATUS = "%X00000002" (error)
$   ELSE 
$     build = ans
$   ENDIF
$ ENDIF
$!
$ DELETE/NOLOG/NOCONFIRM Makefile.;
$ GOTO Beyond_open
$Open_error:
$ TYPE SYS$INPUT:
$ DECK

 There seems to be trouble. I just tried to create a file in
$ EOD
$ echo4 'F$ENVIRONMENT("DEFAULT")'
$ TYPE SYS$INPUT:
$ DECK
 but was unsuccessful. I am stopping now. Please check that directories'
 PROTECTION bits. I will leave you in the directory where you started
 Configure.com
$ EOD
$ echo4 "ABORTING..."
$ GOTO Clean_up
$ STOP
$ EXIT
$!
$Beyond_open:
$! echo " Very well I will proceed with ""''build'"""
$ make = F$EDIT(build,"UPCASE")
$!
$!: locate the preferred pager for this system
$!pagers = "most|more|less|type/page"
$ IF osvers .GES. "V6.1"
$ THEN
$   dflt = "type/page=save=10"
$ ELSE
$   dflt = "type/page"
$ ENDIF
$! assume that the presence of a most symbol indicates the presence
$! of the pager.
$ IF F$TYPE(most) .EQS. "STRING" THEN dflt = "most"
$ IF F$TYPE(pager) .EQS. "STRING" THEN dflt = pager
$ rp="What pager is used on your system? [''dflt'] "
$ GOSUB myread
$ pager = ans
$!
$! update [.vms]config.vms here
$!
$! update makefile here
$! echo4 "Updating makefile..."
$!
$ IF (make .EQS. "MMS").OR.(make .EQS. "MMK")
$ THEN 
$   makefile    = "" 		   !wrt MANIFEST dir
$   UUmakefile  = "[-]DESCRIP.MMS" !wrt CWD dir
$   DEFmakefile = "DESCRIP.MMS"    !wrt DEF dir (?)
$   Makefile_SH = "descrip_mms.template"
$ ELSE
$   makefile    = " -f Makefile."  !wrt MANIFEST dir
$   UUmakefile  = "[-]Makefile."   !wrt CWD dir
$   DEFmakefile = "Makefile."      !wrt DEF dir (?)
$   Makefile_SH = "Makefile.in"
$ ENDIF
$!
$ IF macros .NES. "" 
$ THEN
$   tmp = F$LENGTH(macros)
$   macros = F$EXTRACT(0,(tmp-1),macros) !miss trailing comma
$   macros = "/macro=(" + macros  + ")"
$ ENDIF
$! Build up the extra C flags
$!
$ IF use_ieee_math
$ THEN
$   extra_flags = "''extra_flags'" + "/float=ieee/ieee=denorm"
$ ENDIF
$ IF be_case_sensitive
$ THEN
$   extra_flags = "''extra_flags'" + "/Names=As_Is"
$ ENDIF
$ extra_flags = "''extra_flags'" + "''user_c_flags'"
$!
$ min_pgflquota = "100000"
$ pgflquota = F$STRING(F$GETJPI("","PGFLQUOTA"))
$ IF pgflquota .LES. min_pgflquota
$ THEN
$   echo4 "Your PGFLQUOTA of ''pgflquota' appears too small to build ''package'."
$   READ SYS$COMMAND/PROMPT="Continue? [n] " ans
$   IF ans
$   THEN
$     echo4 "Continuing..."
$   ELSE
$     echo4 "ABORTING..."
$     GOTO Clean_up
$   ENDIF
$ ENDIF
$!
$! PerlIO abstraction
$!
$ bool_dflt = "y"
$ IF F$TYPE(useperlio) .NES. ""
$ then
$   if f$extract(0,1,f$edit(useperlio,"collapse,upcase")) .eqs. "N" .or. useperlio .eqs. "undef" then bool_dflt = "n"
$ endif
$ IF .NOT. silent
$ THEN
$   echo "Previous versions of ''package' used the standard IO mechanisms as"
$   TYPE SYS$INPUT:
$   DECK
defined in <stdio.h>.  Versions 5.003_02 and later of perl allow
alternate IO mechanisms via the PerlIO abstraction layer, but the
stdio mechanism is still available if needed.  The abstraction layer
can use AT&T's sfio (if you already have sfio installed) or regular stdio.
Using PerlIO with sfio may cause problems with some extension modules.

$   EOD
$   echo "If this does not make any sense to you, just accept the default '" + bool_dflt + "'."
$ ENDIF
$ rp = "Use the PerlIO abstraction layer? [''bool_dflt'] "
$ GOSUB myread
$ IF ans
$ THEN
$   useperlio = "define"
$ ELSE
$   echo "Ok, doing things the stdio way."
$   useperlio = "undef"
$ ENDIF
$!
$ echo ""
$ echo4 "Checking the C run-time library."
$!
$! Former SUBCONFIGURE.COM
$!
$!  - build a config.sh for VMS Perl.
$!  - use built config.sh to take config_h.SH -> config.h
$!  - also take vms/descrip_mms.template -> descrip.mms (VMS Makefile)
$!              vms/Makefile.in -> Makefile. (VMS GNU Makefile?)
$!              vms/Makefile.SH -> Makefile. (VMS GNU Makefile?)
$!
$! Note for folks from other platforms changing things in here:
$!
$!   Fancy changes (based on compiler capabilities or VMS version or
$!   whatever) are tricky, so go ahead and punt on those.
$!
$!   Simple changes, though (say, always setting something to 1, or undef,
$!   or something like that) are straightforward.  Adding a new constant 
$!   item for the ultimately created config.sh requires at least one 
$!   (possibly more) line(s) to this file.
$!
$!   Add a line in the format:
$!
$!     $ WC "foo='undef'"
$!
$!   somewhere between the line tagged '##BEGIN WRITE NEW CONSTANTS HERE##'
$!   and the one tagged '##END WRITE NEW CONSTANTS HERE##' (note the order
$!   is sorted ASCII and corresponds to the output of config.sh in the 
$!   Bourne shell version of Configure).
$!   Be very careful with quoting, as it can be tricky.
$!   For example if instead of a constant string like 'undef' or 'define' 
$!   you wanted to add something to VMS's config.sh that looks like:
$!
$!     blank_string=''
$!
$!   then add a line that looks like this before the 
$!   '##END WRITE NEW CONSTANTS HERE##' tagged line:
$!
$!     $ WC "blank_string='" + "'"
$!
$!   (+ is the string concatenator and "''var'" has the effect 
$!    of "${var}" in perl or sh, but "'const'" is not interpolated).
$!
$!   Note that unitialized variables, such as a line like:
$!
$!     $ WC "new_var='" + new_var + "'"
$!
$!   should be avoided unless new_var has a value assigned prior 
$!   to that line (think of perl's -w warnings).
$!
$!     %DCL-W-UNDSYM, undefined symbol - check validity and spelling
$!     \NEW_VAR\
$!
$!
$ vms_ver = F$EXTRACT(1,3, osvers)
$ IF F$LENGTH(Mcc) .EQ. 0 THEN Mcc := "cc"
$ MCC = f$edit(mcc, "UPCASE")
$ C_Compiler_Replace := "CC=CC=''Mcc'''ccflags'"
$ IF ccname .EQS. "DEC"
$ THEN
$   Checkcc := "''Mcc'/prefix=all"
$ ELSE
$   IF ccname .EQS. "CXX"
$   THEN
$     Checkcc := cxx
$   ELSE
$     Checkcc := "''Mcc'"
$   ENDIF
$ ENDIF
$ ccflags = ccflags + extra_flags
$ IF be_case_sensitive
$ THEN
$   d_vms_be_case_sensitive = "define"
$ ELSE
$   d_vms_be_case_sensitive = "undef"
$ ENDIF
$! Some constant defaults.
$ hwname = f$getsyi("HW_NAME")
$ myname = myhostname
$ IF myname .EQS. "" THEN myname = F$TRNLNM("SYS$NODE")
$!
$ ccdlflags=""
$ cccdlflags=""
$!
$! FIXME -- This section does not really handle all the different permutations 
$! of 64-bitness, and it does not provide for the /POINTER_SIZE=64 compiler
$! option that would be necessary to support the "explicit 64-bit interfaces"
$! promised by -Dusemorebits.
$!
$ usemorebits = "undef"
$ IF use64bitint .OR. use64bitint .EQS. "define"
$ THEN
$   use64bitint = "define"
$   ivdformat="""Ld"""
$   uvuformat="""Lu"""
$   uvoformat="""Lo"""
$   uvxformat="""Lx"""
$   uvXUformat="""LX"""
$ ELSE
$   use64bitint = "undef"
$   ivdformat="""ld"""
$   uvuformat="""lu"""
$   uvoformat="""lo"""
$   uvxformat="""lx"""
$   uvXUformat="""lX"""
$ ENDIF
$ IF uselongdouble .OR. uselongdouble .EQS. "define"
$ THEN
$   uselongdouble = "define"
$   alignbytes="16"
$   nveformat="""Le"""
$   nvfformat="""Lf"""
$   nvgformat="""Lg"""
$ ELSE
$   uselongdouble = "undef"
$   nveformat="""e"""
$   nvfformat="""f"""
$   nvgformat="""g"""
$ ENDIF
$ IF use64bitall .OR. use64bitall .EQS. "define"
$ THEN
$   use64bitall = "define"
$ ELSE
$   use64bitall = "undef"
$ ENDIF
$ IF uselargefiles .OR. uselargefiles .EQS. "define"
$ THEN
$   uselargefiles = "define"
$ ELSE
$   uselargefiles = "undef"
$ ENDIF
$!
$ usemymalloc = "undef"
$ if mymalloc then usemymalloc = "define"
$!
$ perl_cc=Mcc
$!
$ IF (sharedperl .AND. archname .EQS. "VMS_AXP")
$ THEN
$   obj_ext=".abj"
$   so="axe"
$   dlext="axe"
$   exe_ext=".axe"
$   lib_ext=".alb"
$ ELSE
$   IF (sharedperl .AND. archname .EQS. "VMS_IA64")
$   THEN
$     obj_ext=".ibj"
$     so="ixe"
$     dlext="ixe"
$     exe_ext=".ixe"
$     lib_ext=".ilb"
$   ELSE
$     obj_ext=".obj"
$     so="exe"
$     dlext="exe"
$     exe_ext=".exe"
$     lib_ext=".olb"
$   ENDIF
$ ENDIF
$ dlobj="dl_vms''obj_ext'"
$!
$ cppstdin="''perl_cc'/noobj/comments=as_is/preprocess=sys$output sys$input"
$ cppminus=" "
$ cpprun="''perl_cc'/noobj/comments=as_is/preprocess=sys$output sys$input"
$ cpplast=" "
$!
$ timetype="time_t"
$ signal_t="void"
$ stdchar="char"
$!
$ IF mymalloc
$ THEN d_mymalloc="define"
$ ELSE d_mymalloc="undef"
$ ENDIF
$!
$ usedl="define"
$ startperl="""$ perl 'f$env(\""procedure\"")' \""'"+"'p1'\"" \""'"+"'p2'\"" \""'"+"'p3'\"" \""'"+"'p4'\"" \""'"+"'p5'\"" \""'"+"'p6'\"" \""'"+"'p7'\"" \""'"+"'p8'\""!\n"
$ startperl=startperl + "$ exit++ + ++$status!=0 and $exit=$status=undef; while($#ARGV != -1 and $ARGV[$#ARGV] eq '"+"'){pop @ARGV;}"""
$!
$ IF ((use_threads) .AND. (vms_ver .LES. "6.2"))
$ THEN
$   libs="SYS$SHARE:CMA$LIB_SHR.EXE/SHARE SYS$SHARE:CMA$RTL.EXE/SHARE SYS$SHARE:CMA$OPEN_LIB_SHR.exe/SHARE SYS$SHARE:CMA$OPEN_RTL.exe/SHARE"
$ ELSE
$   libs=" "
$ ENDIF
$ IF ccname .EQS. "DEC" .OR. ccname .EQS. "CXX"
$ THEN
$   libc="(DECCRTL)"
$ ELSE
$   libc=" "
$ ENDIF
$!
$! perllibs should be libs with all non-core libs (such as gdbm) removed.
$!
$ perllibs=libs
$!
$! Are we 64 bit?
$!
$ IF use64bitint .OR. use64bitint .EQS. "define"
$ THEN
$   d_PRId64 = "define"
$   d_PRIu64 = "define"
$   d_PRIo64 = "define"
$   d_PRIx64 = "define"
$   d_PRIXU64 = "define"
$   sPRId64 = """Ld"""
$   sPRIXU64 = """LX"""
$   sPRIi64 = """Li"""
$   sPRIo64 = """Lo"""
$   sPRIu64 = """Lu"""
$   sPRIx64 = """Lx"""
$   d_quad = "define"
$   quadtype = "long long"
$   uquadtype = "unsigned long long"
$   quadkind  = "QUAD_IS_LONG_LONG"
$ ELSE
$   d_PRId64 = "undef"
$   d_PRIXU64 = "undef"
$   d_PRIu64 = "undef"
$   d_PRIo64 = "undef"
$   d_PRIx64 = "undef"
$   sPRId64 = ""
$   sPRIXU64 = """lX"""
$   sPRIi64 = ""
$   sPRIo64 = ""
$   sPRIu64 = ""
$   sPRIx64 = ""
$   d_quad = "undef"
$   quadtype = "long"
$   uquadtype = "unsigned long"
$   quadkind  = "QUAD_IS_LONG"
$ ENDIF
$!
$ IF archname .NES. "VMS_VAX"
$ THEN
$   d_frexpl = "define"
$   d_modfl = "define"
$   d_modflproto = "define"
$ ELSE
$   d_frexpl = "undef"
$   d_modfl = "undef"
$   d_modflproto = "undef"
$ ENDIF
$!
$ IF useieee .OR. useieee .EQS. "define"
$ THEN
$   d_isnan = "define"
$   d_isnanl = "define"
$ ELSE
$   d_isnan = "undef"
$   d_isnanl = "undef"
$ ENDIF
$!
$! Now some that we build up
$!
$ IF use_threads
$ THEN
$   IF use_5005_threads
$   THEN
$     arch = "''arch'-thread"
$     archname = "''archname'-thread"
$     d_old_pthread_create_joinable = "undef"
$     old_pthread_create_joinable = " "
$     use5005threads = "define"
$     useithreads = "undef"
$   ELSE
$     arch = "''arch'-ithread"
$     archname = "''archname'-ithread"
$     d_old_pthread_create_joinable = "undef"
$     old_pthread_create_joinable = " "
$     use5005threads = "undef"
$     useithreads = "define"
$   ENDIF
$ ELSE
$   d_old_pthread_create_joinable = "undef"
$   old_pthread_create_joinable = " "
$   use5005threads = "undef"
$   useithreads = "undef"
$ ENDIF
$!
$! Some that we need to invoke the compiler for
$!
$!
$! handy construction aliases/symbols
$!
$ OS := "open/write CONFIG []try.c"
$ WS := "write CONFIG"
$ CS := "close CONFIG"
$ DS := "delete/nolog/noconfirm []try.*;*"
$ Needs_Opt := N
$ good_compile = %X10B90001
$ IF ccname .EQS. "GCC"
$ THEN
$   open/write OPTCHAN []try.opt
$   write OPTCHAN "Gnu_CC:[000000]gcclib.olb/library"
$   write OPTCHAN "Sys$Share:VAXCRTL/Share"
$   Close OPTCHAN
$   Needs_Opt := Y
$   good_compile = %X10000001
$ ENDIF
$ IF ccname .EQS. "CXX"
$ THEN
$   good_compile = %X15F60001
$ ENDIF
$ good_link = %X10000001
$ tmp = "" ! null string default
$!
$ GOTO beyond_compile_ok
$!
$! Check for type sizes 
$!
$type_size_check: 
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "printf(""%d\n"", sizeof(''tmp'));"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB compile
$ RETURN
$!
$!: locate header file
$findhdr:
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <''tmp'>"
$ WS "int main()"
$ WS "{"
$ WS "printf(""define\n"");"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB link_ok
$ RETURN
$!
$!: define an alternate in-header-list? function
$inhdr:
$!
$ GOSUB findhdr
$ IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$ THEN
$   echo4 "<''tmp'> found."
$   tmp = "define"
$ ELSE
$   echo4 "<''tmp'> NOT found."
$   tmp = "undef"
$ ENDIF
$ RETURN
$!
$!: define an is-in-libc? function
$inlibc: 
$ GOSUB link_ok
$ IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$ THEN
$   echo4 "''tmp'() found."
$   tmp = "define"
$ ELSE
$   echo4 "''tmp'() NOT found."
$   tmp = "undef"
$ ENDIF
$ RETURN
$!
$!: define a shorthand compile call
$compile:
$ GOSUB link_ok
$just_mcr_it:
$ IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$ THEN
$   OPEN/WRITE CONFIG []try.out
$   DEFINE/USER_MODE SYS$ERROR CONFIG
$   DEFINE/USER_MODE  SYS$OUTPUT CONFIG
$   MCR []try.exe
$   CLOSE CONFIG
$   OPEN/READ CONFIG []try.out
$   READ CONFIG tmp
$   CLOSE CONFIG
$   DELETE/NOLOG/NOCONFIRM []try.out;
$   DELETE/NOLOG/NOCONFIRM []try.exe;
$ ELSE
$   tmp = "" ! null string default
$ ENDIF
$ RETURN
$!
$link_ok:
$ GOSUB compile_ok
$ DEFINE/USER_MODE SYS$ERROR _NLA0:
$ DEFINE/USER_MODE SYS$OUTPUT _NLA0:
$ SET NOON
$ IF Needs_Opt
$ THEN
$   'ld' try.obj,try.opt/opt
$   link_status = $status
$ ELSE
$   'ld' try.obj
$   link_status = $status
$ ENDIF
$ SET ON
$ IF F$SEARCH("try.obj") .NES. "" THEN DELETE/NOLOG/NOCONFIRM try.obj;
$ RETURN
$!
$!: define a shorthand compile call for compilations that should be ok.
$compile_ok:
$ DEFINE/USER_MODE SYS$ERROR _NLA0:
$ DEFINE/USER_MODE SYS$OUTPUT _NLA0:
$ SET NOON
$ 'Checkcc' try.c
$ compile_status = $status
$ SET ON
$ DELETE/NOLOG/NOCONFIRM try.c;
$ RETURN
$!
$beyond_compile_ok:
$!
$! Check for __STDC__
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "#ifdef __STDC__"
$ WS "printf(""42\n"");"
$ WS "#else"
$ WS "printf(""1\n"");"
$ WS "#endif"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB compile
$ cpp_stuff=tmp
$ IF F$INTEGER(tmp) .eq. 42
$ THEN
$   echo4 "Your C compiler and pre-processor defines the symbol:"
$   echo4 "__STDC__"
$ ENDIF
$!
$! Check for double size
$!
$ echo4 "Checking to see how big your double precision numbers are..."
$ tmp="double"
$ GOSUB type_size_check
$ doublesize = tmp
$ echo "Your double is ''doublesize' bytes long."
$!
$! Check for long double size
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#pragma message disable ALL"  ! VAX compilers may have distracting informationals
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "printf(""%d\n"", sizeof(long double));"
$ WS "exit(0);"
$ WS "}"
$ CS
$ echo4 "Checking to see if you have long double..."
$ GOSUB link_ok
$ IF link_status .NE. good_link
$ THEN
$   longdblsize="0"
$   d_longdbl="undef"
$   echo "You do not have long double."
$ ELSE
$   echo "You have long double."
$   echo4 "Checking to see how big your long doubles are..."
$   GOSUB just_mcr_it
$   longdblsize = tmp
$   d_longdbl = "define"
$   echo "Your long doubles are ''longdblsize' bytes long."
$ ENDIF
$!
$ IF d_longdbl .OR. d_longdbl .EQS. "define"
$ THEN
$   d_PRIEUldbl = "define"
$   d_PRIFUldbl = "define"
$   d_PRIGUldbl = "define"
$   d_PRIeldbl = "define"
$   d_PRIfldbl = "define"
$   d_PRIgldbl = "define"
$   sPRIEUldbl = """LE"""
$   sPRIFUldbl = """LF"""
$   sPRIGUldbl = """LG"""
$   sPRIeldbl = """Le"""
$   sPRIfldbl = """Lf"""
$   sPRIgldbl = """Lg"""
$ ELSE
$   d_PRIEUldbl = "undef"
$   d_PRIFUldbl = "undef"
$   d_PRIGUldbl = "undef"
$   d_PRIeldbl = "undef"
$   d_PRIfldbl = "undef"
$   d_PRIgldbl = "undef"
$   sPRIEUldbl = ""
$   sPRIFUldbl = ""
$   sPRIGUldbl = ""
$   sPRIeldbl = ""
$   sPRIfldbl = ""
$   sPRIgldbl = ""
$ ENDIF
$ d_SCNfldbl = d_PRIfldbl
$ sSCNfldbl = sPRIfldbl ! expect consistency
$!
$!: check for long long
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "printf(""%d\n"", sizeof(long long));"
$ WS "exit(0);"
$ WS "}"
$ CS
$ echo4 "Checking to see if you have long long..."
$ GOSUB link_ok
$ IF link_status .NE. good_link
$ THEN
$   longlongsize="0"
$   d_longlong="undef"
$   echo "You do not have long long."
$ ELSE
$   echo "You have long long."
$   echo4 "Checking to see how big your long longs are..."
$   GOSUB just_mcr_it
$   longlongsize = tmp
$   d_longlong = "define"
$   echo "Your long longs are ''longlongsize' bytes long."
$ ENDIF
$!
$! Check the prototype for getgid
$!
$ echo "Looking for the type for group ids returned by getgid()."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <types.h>"
$ WS "int main()"
$ WS "{"
$ WS "gid_t foo;"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB compile_ok
$ IF compile_status .NE. good_compile
$ THEN
$!   Okay, gid_t failed. Must be unsigned int
$   gidtype = "unsigned int"
$   echo4 "assuming ""''gidtype'""."
$ ELSE
$   gidtype = "gid_t"
$   echo4 "gid_t found."
$ ENDIF
$!
$! Check to see if we've got dev_t
$!
$ echo "Looking for the type for dev."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <types.h>"
$ WS "int main()"
$ WS "{"
$ WS "dev_t foo;"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB compile_ok
$ IF compile_status .NE. good_compile
$ THEN
$!   Okay, dev_t failed. Must be unsigned int
$   devtype = "unsigned int"
$   echo4 "assuming ""''devtype'""."
$ ELSE
$   devtype = "dev_t"
$   echo4 "dev_t found."
$ ENDIF
$!
$! Check to see if we've got unistd.h (which we ought to, but you never know)
$!
$ i_netdb = "undef"
$ tmp = "unistd.h"
$ GOSUB inhdr
$ i_unistd = tmp
$!
$! Check to see if we've got utime.h (which we should use if we have)
$!
$ i_netdb = "undef"
$ tmp = "utime.h"
$ GOSUB inhdr
$ i_utime = tmp
$!
$! do we have getppid()?
$!
$ IF i_unistd .EQS. "define"
$ THEN
$   OS
$   WS "#include <stdio.h>"
$   WS "#include <unistd.h>"
$   WS "int main() {"
$   WS "printf(""%d\n"",getppid());"
$   WS "return(0);"
$   WS "}"
$   CS
$   tmp = "getppid"
$   GOSUB inlibc
$   d_getppid = tmp
$ ELSE
$   d_getppid = "undef"
$ ENDIF
$!
$!: see if this is a libutil.h system
$!
$ tmp = "libutil.h"
$ GOSUB inhdr
$ i_libutil = tmp
$!
$! Check to see if we've got shadow.h (probably not, but...)
$!
$ tmp = "shadow.h"
$ GOSUB inhdr
$ i_shadow = tmp
$!
$! Check to see if we've got socks.h (probably not, but...)
$!
$ tmp = "socks.h"
$ GOSUB inhdr
$ i_socks = tmp
$!
$! Check the prototype for select
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   WS "#include <types.h>"
$   IF i_unistd .EQS. "define" THEN WS "#include <unistd.h>"
$   IF Has_Socketshr
$   THEN
$     WS "#include <socketshr.h>"
$   ELSE
$     WS "#include <time.h>"
$     WS "#include <socket.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "fd_set *foo;"
$   WS "int bar;"
$   WS "foo = NULL;"
$   WS "bar = select(2, foo, foo, foo, NULL);"
$   WS "exit(0);"
$   WS "}"
$   CS
$   GOSUB compile_ok
$   IF compile_status .NE. good_compile
$   THEN
$!   Okay, select failed.  Must be an int *
$     selecttype = "int *"
$     echo4 "select() NOT found."
$   ELSE
$     selecttype="fd_set *"
$     echo4 "select() found."
$   ENDIF
$ ELSE
$   ! No sockets, so stick in an int * : no select, so pick a harmless default
$   selecttype = "int *"
$ ENDIF
$!
$! Check to see if fd_set exists
$!
$ echo "Checking to see how well your C compiler handles fd_set and friends ..."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <types.h>"
$ IF Has_Socketshr
$ THEN
$   WS "#include <socketshr.h>"
$ ENDIF
$ IF Has_Dec_C_Sockets
$ THEN
$   WS "#include <time.h>"
$   WS "#include <socket.h>"
$ ENDIF
$ WS "int main()"
$ WS "{"
$ WS "fd_set *foo;"
$ WS "int bar;"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB compile_ok
$ IF compile_status .ne. good_compile
$ THEN
$!  Okay, fd_set failed. Must not exist
$   d_fd_set = "undef"
$   echo4 "Hmm, your compiler has some difficulty with fd_set."
$ ELSE
$   d_fd_set="define"
$   echo4 "Well, your system knows about the normal fd_set typedef..."
$ ENDIF
$!
$! Check for inttypes.h
$!
$ tmp = "inttypes.h"
$ GOSUB inhdr
$ i_inttypes = tmp
$!
$! Check to see if off64_t exists
$!
$ echo4 "Checking to see if you have off64_t..."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <types.h>"
$ WS "#''i_inttypes' IIH"
$ WS "#ifdef IIH"
$ WS "#include <inttypes.h>"
$ WS "#endif"
$ WS "int main()"
$ WS "{"
$ WS "off64_t bar;"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB compile_ok
$ IF compile_status .EQ. good_compile
$ THEN
$   d_off64_t="define"
$   echo "You have off64_t."
$ ELSE
$   d_off64_t = "undef"
$   echo "You do not have off64_t."
$ ENDIF
$!
$! Check to see if fpos64_t exists
$!
$ echo4 "Checking to see if you have fpos64_t..."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <types.h>"
$ WS "#''i_inttypes' IIH"
$ WS "#ifdef IIH"
$ WS "#include <inttypes.h>"
$ WS "#endif"
$ WS "int main()"
$ WS "{"
$ WS "fpos64_t bar;"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB compile_ok
$ IF compile_status .EQ. good_compile
$ THEN
$   d_fpos64_t="define"
$   echo "You have fpos64_t."
$ ELSE
$   d_fpos64_t = "undef"
$   echo "You do not have fpos64_t."
$ ENDIF
$!
$! Check to see if int64_t exists
$!
$ echo4 "Checking to see if you have int64_t..."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <types.h>"
$ WS "#''i_inttypes' IIH"
$ WS "#ifdef IIH"
$ WS "#include <inttypes.h>"
$ WS "#endif"
$ WS "int main()"
$ WS "{"
$ WS "int64_t bar;"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB compile_ok
$ IF compile_status .EQ. good_compile
$ THEN
$   d_int64_t="define"
$   echo "You have int64_t."
$ ELSE
$   d_int64_t = "undef"
$   echo "You do not have int64_t."
$ ENDIF
$!
$! Check to see if fseeko exists
$!
$ OS
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "FILE *f=NULL;"
$ WS "fseeko(f,(off_t)0,SEEK_SET);"
$ WS "return(0);"
$ WS "}"
$ CS
$ tmp = "fseeko"
$ GOSUB inlibc
$ d_fseeko = tmp
$!
$! Check to see if ftello exists
$!
$ OS
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "FILE *f=NULL; off_t o=0;"
$ WS "o=ftello(f);"
$ WS "return(0);"
$ WS "}"
$ CS
$ tmp = "ftello"
$ GOSUB inlibc
$ d_ftello = tmp
$!
$!: see if this is a netdb.h system
$ IF Has_Dec_C_Sockets
$ THEN 
$   tmp = "netdb.h"
$   GOSUB inhdr
$   i_netdb = tmp
$ ENDIF
$!
$! Check for h_errno
$!
$ echo4 "Checking to see if you have h_errno..."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ IF i_unistd .EQS. "define" THEN WS "#include <unistd.h>"
$ IF i_netdb  .EQS. "define" THEN WS "#include <netdb.h>"
$ WS "int main()"
$ WS "{"
$ WS "h_errno = 3;"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB link_ok
$ IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$ THEN
$   d_herrno="define"
$   echo "You have h_errno."
$ ELSE
$   d_herrno="undef"
$   echo "You do not have h_errno."
$ ENDIF
$!
$! Check to see if gethostname exists
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   WS "#include <types.h>"
$   IF Has_Socketshr
$   THEN
$     WS "#include <socketshr.h>"
$   ELSE
$     WS "#include <time.h>"
$     WS "#include <socket.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "char name[100];"
$   WS "int bar, baz;"
$   WS "bar = 100;"
$   WS "baz = gethostname(name, bar);"
$   WS "exit(0);"
$   WS "}"
$   CS
$   GOSUB link_ok
$   IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$   THEN
$     d_gethname="define"
$     echo4 "gethostname() found."
$   ELSE
$     d_gethname="undef"
$   ENDIF
$ ELSE
$   ! No sockets, so no gethname
$   d_gethname = "undef"
$ ENDIF
$!
$! Check for sys/file.h
$!
$ tmp = "sys/file.h"
$ GOSUB inhdr
$ i_sysfile = tmp
$!
$!
$! Check for sys/ioctl.h
$!
$ tmp = "sys/ioctl.h"
$ GOSUB inhdr
$ i_sysioctl = tmp
$!
$! Check for sys/utsname.h
$!
$ tmp = "sys/utsname.h"
$ GOSUB inhdr
$ i_sysutsname = tmp
$!
$! Check for syslog.h
$!
$ tmp = "syslog.h"
$ GOSUB inhdr
$ i_syslog = tmp
$!
$! Check for poll.h
$!
$ tmp = "poll.h"
$ GOSUB inhdr
$ i_poll = tmp
$!
$! Check for sys/uio.h
$!
$ tmp = "sys/uio.h"
$ GOSUB inhdr
$ i_sysuio = tmp
$!
$! Check for sys/mode.h
$!
$ tmp = "sys/mode.h"
$ GOSUB inhdr
$ i_sysmode = tmp
$!
$! Check for sys/access.h
$!
$ tmp = "sys/access.h"
$ GOSUB inhdr
$ i_sysaccess = tmp
$!
$! Check for sys/security.h
$!
$ tmp = "sys/security.h"
$ GOSUB inhdr
$ i_syssecrt = tmp
$!
$! Check for fcntl.h
$!
$ tmp = "fcntl.h"
$ GOSUB inhdr
$ i_fcntl = tmp
$!
$! Check for fcntl
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <fcntl.h>"
$ WS "int main()"
$ WS "{"
$ WS "fcntl(1,2,3);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "fcntl"
$ GOSUB inlibc
$ d_fcntl = tmp
$!
$! Check for fcntl locking capability
$!
$ echo4 "Checking if fcntl-based file locking works... "
$ tmp = "undef"
$ IF d_fcntl .EQS. "define"
$ THEN
$   OS
$   WS "#include <stdio.h>"
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <fcntl.h>"
$   WS "#include <unistd.h>"
$   WS "int main() {"
$   WS "#if defined(F_SETLK) && defined(F_SETLKW)"
$   WS "     struct flock flock;"
$   WS "     int retval, fd;"
$   WS "     fd = open(""try.c"", O_RDONLY);"
$   WS "     flock.l_type = F_RDLCK;"
$   WS "     flock.l_whence = SEEK_SET;"
$   WS "     flock.l_start = flock.l_len = 0;"
$   WS "     retval = fcntl(fd, F_SETLK, &flock);"
$   WS "     close(fd);"
$   WS "     (retval < 0 ? printf(""undef\n"") : printf(""define\n""));"
$   WS "#else"
$   WS "     printf(""undef\n"");"
$   WS "#endif"
$   WS "}"
$   CS
$   GOSUB link_ok
$   IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$   THEN
$     GOSUB just_mcr_it
$     IF tmp .EQS. "define"
$     THEN
$       echo4 "Yes, it seems to work."
$     ELSE
$       echo4 "Nope, it didn't work."
$     ENDIF
$   ELSE
$     echo4 "I'm unable to compile the test program, so I'll assume not."
$     tmp = "undef"
$   ENDIF
$ ELSE
$   echo4 "Nope, since you don't even have fcntl()."
$ ENDIF
$ d_fcntl_can_lock = tmp
$!
$! Check for memchr
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <string.h>"
$ WS "int main()"
$ WS "{"
$ WS "char * place;"
$ WS "place = memchr(""foo"", 47, 3);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "memchr"
$ GOSUB inlibc
$ d_memchr = tmp
$!
$! Check for strtoull
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <string.h>"
$ WS "int main()"
$ WS "{"
$ WS "unsigned __int64 result;"
$ WS "result = strtoull(""123123"", NULL, 10);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "strtoull"
$ GOSUB inlibc
$ d_strtoull = tmp
$!
$! Check for strtouq
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <string.h>"
$ WS "int main()"
$ WS "{"
$ WS "unsigned __int64 result;"
$ WS "result = strtouq(""123123"", NULL, 10);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "strtouq"
$ GOSUB inlibc
$ d_strtouq = tmp
$!
$! Check for strtoll
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <string.h>"
$ WS "int main()"
$ WS "{"
$ WS "__int64 result;"
$ WS "result = strtoll(""123123"", NULL, 10);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "strtoll"
$ GOSUB inlibc
$ d_strtoll = tmp
$!
$! Check for strtoq
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <string.h>"
$ WS "int main()"
$ WS "{"
$ WS "__int64 result;"
$ WS "result = strtoq(""123123"", NULL, 10);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "strtoq"
$ GOSUB inlibc
$ d_strtoq = tmp
$!
$! Check for strtold
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <string.h>"
$ WS "int main()"
$ WS "{"
$ WS "long double result;"
$ WS "result = strtold(""123123"", NULL, 10);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "strtold"
$ GOSUB inlibc
$ d_strtold = tmp
$!
$! Check for atoll
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <string.h>"
$ WS "int main()"
$ WS "{"
$ WS " __int64 result;"
$ WS "result = atoll(""123123"");"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "atoll"
$ GOSUB inlibc
$ d_atoll = tmp
$!
$! Check for atolf
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <string.h>"
$ WS "int main()"
$ WS "{"
$ WS "long double"
$ WS "result = atolf(""123123"");"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "atolf"
$ GOSUB inlibc
$ d_atolf = tmp
$!
$! Check for access
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "access(""foo"", F_OK);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "acess"
$ GOSUB inlibc
$ d_access = tmp
$!
$! Check for bzero
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <strings.h>"
$ WS "int main()"
$ WS "{"
$ WS "char foo[10];"
$ WS "bzero(foo, 10);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "bzero"
$ GOSUB inlibc
$ d_bzero = tmp
$!
$! Check for bcopy
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "#include <strings.h>"
$ WS "int main()"
$ WS "{"
$ WS "char foo[10], bar[10];"
$ WS "bcopy(""foo"", bar, 3);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "bcopy"
$ GOSUB inlibc
$ d_bcopy = tmp
$!
$! Check for mkstemp
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "mkstemp(""foo"");"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "mkstemp"
$ GOSUB inlibc
$ d_mkstemp = tmp
$!
$! Check for mkstemps
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "mkstemps(""foo"", 1);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "mkstemps"
$ GOSUB inlibc
$ d_mkstemps = tmp
$!
$! Check for mkdtemp
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "mkdtemp(""foo"");"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "mkdtemp"
$ GOSUB inlibc
$ d_mkdtemp = tmp
$!
$! Check for poll
$!
$ if i_poll .eqs. "define"
$ then
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <poll.h>"
$   WS "int main()"
$   WS "{"
$   WS "struct pollfd pfd;"
$   WS "int count=poll(&pfd,1,0);"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "poll"
$   GOSUB inlibc
$   d_poll = tmp
$ else
$   d_poll = "undef"
$ endif
$!
$! Check for setvbuf
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "FILE *foo;"
$ WS "char Buffer[99];"
$ WS "foo = fopen(""foo"", ""r"");"
$ WS "setvbuf(foo, Buffer, 0, 0);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "setvbuf"
$ GOSUB inlibc
$ d_setvbuf = tmp
$!
$! see if sfio.h is available
$! see if sfio library is available
$! Ok, but do we want to use it.
$! IF F$TYPE(usesfio) .EQS. "" THEN usesfio = "undef"
$! IF val .EQS. "define"
$! THEN
$!   IF usesfio .EQS. "define"
$!   THEN dflt = "y"
$!   ELSE dflt = "n"
$!   ENDIF
$!   echo "''package' can use the sfio library, but it is experimental."
$!   IF useperlio .EQS. "undef"
$!   THEN
$!     echo "For sfio also the PerlIO abstraction layer is needed."
$!     echo "Earlier you said you would not want that."
$!   ENDIF
$!   rp="You seem to have sfio available, do you want to try using it? [''dflt'] "
$!   GOSUB myread
$!   IF ans .EQS. "" THEN ans = dflt
$!   IF ans
$!   THEN
$!     echo "Ok, turning on both sfio and PerlIO, then."
$!     useperlio="define"
$!     val="define"
$!   ELSE
$!     echo "Ok, avoiding sfio this time.  I'll use stdio instead."
$!     val="undef"
$!   ENDIF
$! ELSE
$!   IF usesfio .EQS. "define"
$!   THEN
$!     echo4 "Sorry, cannot find sfio on this machine."
$!     echo4 "Ignoring your setting of usesfio=''usesfio'."
$!     val="undef"
$!   ENDIF
$! ENDIF
$!
$! Check for setenv
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "setenv(""FOO"", ""BAR"", 0);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "setenv"
$ GOSUB inlibc
$ d_setenv = tmp
$!
$! Check for setproctitle
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "setproctitle(""%s"", ""FOO"");"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "setproctitle"
$ GOSUB inlibc
$ d_setproctitle = tmp
$!
$! Check for <netinet/in.h>
$!
$ IF Has_Dec_C_Sockets .or. Has_Socketshr
$ THEN
$   tmp = "netinet/in.h"
$   GOSUB inhdr
$   i_niin = tmp
$ ELSE
$   i_niin="undef"
$ ENDIF
$!
$! Check for <netinet/tcp.h>
$!
$ IF Has_Dec_C_Sockets .or. Has_Socketshr
$ THEN
$   tmp = "netinet/tcp.h"
$   GOSUB inhdr
$   i_netinettcp = tmp
$ ELSE
$   i_netinettcp="undef"
$ ENDIF
$!
$! Check for endhostent
$!
$ IF Has_Dec_C_Sockets .or. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "endhostent();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "endhostent"
$   GOSUB inlibc
$   d_endhent = tmp
$ ELSE
$   d_endhent="undef"
$ ENDIF
$!
$! Check for endnetent
$!
$ IF Has_Dec_C_Sockets .or. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "endnetent();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "endnetent"
$   GOSUB inlibc
$   d_endnent = tmp
$ ELSE
$   d_endnent="undef"
$ ENDIF
$!
$! Check for endprotoent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "endprotoent();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "endprotoent"
$   GOSUB inlibc
$   d_endpent = tmp
$ ELSE
$   d_endpent="undef"
$ ENDIF
$!
$! Check for endservent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "endservent();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "endservent"
$   GOSUB inlibc
$   d_endsent = tmp
$ ELSE
$   d_endsent="undef"
$ ENDIF
$!
$! Check for sethostent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "sethostent(1);"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "sethostent"
$   GOSUB inlibc
$   d_sethent = tmp
$ ELSE
$   d_sethent="undef"
$ ENDIF
$!
$! Check for setnetent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "setnetent(1);"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "setnetent"
$   GOSUB inlibc
$   d_setnent = tmp
$ ELSE
$   d_setnent="undef"
$ ENDIF
$!
$! Check for setprotoent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "setprotoent(1);"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "setprotoent"
$   GOSUB inlibc
$   d_setpent = tmp
$ ELSE
$   d_setpent="undef"
$ ENDIF
$!
$! Check for setservent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "setservent(1);"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "setservent"
$   GOSUB inlibc
$   d_setsent = tmp
$ ELSE
$   d_setsent="undef"
$ ENDIF
$!
$! Check for gethostent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "gethostent();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "gethostent"
$   GOSUB inlibc
$   d_gethent = tmp
$ ELSE
$   d_gethent="undef"
$ ENDIF
$!
$! Check for getnetent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "getnetent();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "getnetent"
$   GOSUB inlibc
$   d_getnent = tmp
$ ELSE
$   d_getnent="undef"
$ ENDIF
$!
$! Check for getprotoent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "getprotoent();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "getprotoent"
$   GOSUB inlibc
$   d_getpent = tmp
$ ELSE
$   d_getpent="undef"
$ ENDIF
$!
$! Check for getservent
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "getservent();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "getservent"
$   GOSUB inlibc
$   d_getsent = tmp
$ ELSE
$   d_getsent="undef"
$ ENDIF
$!
$! Check for nanosleep
$!
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <time.h>"
$ WS "int main()"
$ WS "{"
$ WS "int asleep = nanosleep(NULL,NULL);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "nanosleep"
$ GOSUB inlibc
$ d_nanosleep = tmp
$!
$! Check for socklen_t
$!
$ IF Has_Dec_C_Sockets .OR. Has_Socketshr
$ THEN
$   echo4 "Checking to see if you have socklen_t..."
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   IF Has_Socketshr
$   THEN WS "#include <socketshr.h>"
$   ELSE IF i_netdb .EQS. "define" THEN WS "#include <netdb.h>"
$   ENDIF
$   WS "int main()"
$   WS "{"
$   WS "socklen_t x = 16;"
$   WS "exit(0);"
$   WS "}"
$   CS
$   GOSUB link_ok
$   IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$   THEN
$     d_socklen_t="define"
$     echo "You have socklen_t."
$   ELSE
$     d_socklen_t="undef"
$     echo "You do not have socklen_t."
$   ENDIF
$ ELSE
$   d_socklen_t="undef"
$ ENDIF
$!
$! Check for pthread_yield
$!
$ IF use_threads
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <pthread.h>"
$   WS "#include <stdio.h>"
$   WS "int main()"
$   WS "{"
$   WS "pthread_yield();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "pthread_yield"
$   GOSUB inlibc
$   d_pthread_yield = tmp
$ ELSE
$   d_pthread_yield="undef"
$ ENDIF
$!
$! Check for sched_yield
$!
$ IF use_threads
$ THEN
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <pthread.h>"
$   WS "#include <stdio.h>"
$   WS "int main()"
$   WS "{"
$   WS "sched_yield();"
$   WS "exit(0);"
$   WS "}"
$   CS
$   tmp = "sched_yield"
$   GOSUB inlibc
$   d_sched_yield = tmp
$   IF d_sched_yield .EQS. "define"
$   THEN sched_yield = "sched_yield"
$   ELSE sched_yield = " "
$   ENDIF
$ ELSE
$   d_sched_yield="undef"
$   sched_yield = " "
$ ENDIF
$!
$! Check for pthread_attr_setscope and PTHREAD_SCOPE_SYSTEM.
$! (The actual test is to be written.)
$!
$ d_pthread_attr_setscope="undef"
$!
$! Check for generic pointer size
$!
$ echo4 "Checking to see how big your pointers are..." 
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "int foo;"
$ WS "foo = sizeof(char *);"
$ WS "printf(""%d\n"", foo);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ tmp = "char *"
$ GOSUB type_size_check
$ ptrsize = tmp
$ echo "Your pointers are ''ptrsize' bytes long."
$!
$! Check for size_t size
$!
$ tmp = "size_t"
$ zzz = tmp
$ echo4 "Checking the size of ''zzz'..."
$ GOSUB type_size_check
$ sizesize = tmp
$ echo "Your ''zzz' size is ''sizesize' bytes."
$!
$! Check for _LARGEFILE capability.
$!
$ off_t_size = 4
$ OS
$ WS "#define _LARGEFILE"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "printf(""%d\n"", sizeof(off_t));"
$ WS "return(0);"
$ WS "}"
$ CS
$ GOSUB link_ok
$ IF link_status .EQ. good_link
$ THEN
$   GOSUB just_mcr_it
$   off_t_size = tmp
$ ENDIF
$ echo "Your off_t size is ''off_t_size' bytes when _LARGEFILE is defined."
$ IF off_t_size .ne. 8 .AND. (uselargefiles .OR. uselargefiles .eqs. "define")
$ THEN
$   echo4 "You configured with -Duselargefiles but your CRTL does not support _LARGEFILE."
$   echo4 "I'm disabling large file support."
$   uselargefiles = "undef"
$ ENDIF
$!
$! Tests for hard link, symbolic links, and 7.3 + CRTL features
$!
$  d_lchown = "undef"
$  d_link = "undef"
$  d_lstat = "undef"
$  d_readlink = "undef"
$  d_symlink = "undef"
$  d_realpath = "undef"
$!
$! Hard link support has been present since 7.3-1 except for the
$! easy to use DCL test to see if hardlinks are enabled on the build
$! disk.  That would require more work to test, and I am only testing
$! this on 8.2, so that is why the 8.2 test.
$!
$  IF (vms_ver .GES. "8.2") .AND. (archname .NES. "VMS_VAX")
$  THEN
$   IF f$getdvi("SYS$DISK","HARDLINKS_SUPPORTED")
$   THEN
$       echo "I Found 64 bit OpenVMS 8.2 or later, and hard links enabled on build disk."
$	echo "I will build with hard link support"
$	d_link = "define"
$   ELSE
$	echo "I Found 64 bit OpenVMS 8.2 or later, and hard links disabled on build disk."
$	echo "I will not build with hard link support."
$   ENDIF
$  ELSE
$    echo4 "I can not detect if your CRTL and build disk support hard links."
$    echo4 "I am disabling hard link support."
$  ENDIF
$!
$  IF uselargefiles .OR. uselargefiles .eqs. "define"
$  THEN
$    echo4 "Largefile support enabled (plus standard stat support on V8.2 and later)"
$    usestdstat = "y"
$    IF (vms_ver .GES. "8.2") .AND. (archname .NES. "VMS_VAX")
$    THEN
$      echo4 -
   "Looking for the realpath() function to indicate symbolic link support..."
$      OS
$!      WS "#include <stdlib.h>"
$      WS "void exit(int foo);"
$      WS "char *realpath(const char *file_name, char * resolved_name, ...);"
$      WS "int main()"
$      WS "{"
$      WS "char result[255];"
$      WS "realpath(""foo"",result);"
$      WS "exit(0);"
$      WS "}"
$      CS
$      GOSUB link_ok
$      IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$      THEN
$        echo -
           "Found realpath() which indicates symbolic link support is present."
$	 d_lchown = "define"
$	 d_lstat = "define"
$	 d_readlink = "define"
$	 d_symlink = "define"
$!	 d_realpath = "define" ! Perl will not put it in the config.h file?
$!	Perl apparently does not use a built in realpath() on other platforms,
$!      but there is a severe performance penatly on OpenVMS to use the Perl
$!      script that implements a realpath().  The d_symlink symbol is used
$!      as a replacement for the d_realpath since they are related and both
$!      were activated by the CRTL at the same time.
$!
$	 ELSE
$	  echo4 "Your system does not support symbolic links."
$	  echo4 "I am disabling symbolic link support."
$	ENDIF
$    ELSE
$       echo4 "Your system does not support symbolic links."
$       echo4 "I am disabling symbolic link support."
$    ENDIF
$  ELSE
$    IF (vms_ver .GES. "8.2") .AND. (archname .NES. "VMS_VAX")
$    THEN
$       echo4 "-Duselargefiles is required for symbolic link support."
$       echo4 "You did not specify that, so I am disabling symbolic link support."
$    ENDIF
$  ENDIF
$!
$!
$! Check for grp.h -- should be 7.3 and later, but test to be sure
$!
$ tmp = "grp.h"
$ GOSUB inhdr
$ i_grp = tmp
$!
$! VMS V7.3-2 powered options
$! We know that it is only available for V7.3-2 and later on 64 bit platforms.
$!
$  d_getgrgid_r = "undef"
$  getgrgid_r_proto = "0"
$  d_getgrnam_r = "undef"
$  getgrnam_r_proto = "0"
$  d_getpgid = "undef"
$  d_getpgrp = "undef"
$! N.B.  We already have home-grown thread-safe versions of
$!       getpwnam and getpwuid -- no need to use CRTL versions
$  d_getpwnam_r = "undef"
$  getpwnam_r_proto = "0"
$  d_getpwuid_r = "undef"
$  getpwuid_r_proto = "0"
$  d_setgrent = "undef"
$  d_ttyname_r = "undef"
$  ttyname_r_proto = "0"
$  d_snprintf = "undef"
$  d_vsnprintf = "undef"
$  if (vms_ver .GES. "7.3-2") .AND. (archname .NES. "VMS_VAX")
$  then
$    echo "Found 64 bit OpenVMS ''vms_ver' -- will build with V7.3-2 routines"
$    d_getgrgid_r = "define"
$    getgrgid_r_proto = "1"
$    d_getgrnam_r = "define"
$    getgrnam_r_proto = "1"
$    if d_symlink .or. d_symlink .EQS. "define"
$    then
$!	 FIXME: Need to find how to activate this.
$!       d_getpgid = "define"
$!       d_getpgrp = "define"
$    endif
$    d_setgrent = "define"
$    d_ttyname_r = "define"
$    ttyname_r_proto = "1"
$    d_snprintf = "define"
$    d_vsnprintf = "define"
$  endif
$!
$! VMS V7.3-2 powered options
$! We know that it is only available for V7.3-2 and later on 64 bit platforms.
$! Only implementing right now on 8.2 because that is what I am testing
$! These functions may require POSIX UIDs/GIDs to be active, so I am
$! not activating the features at this time, just preparing this file
$! to easily use them in the future.
$!
$  d_seteuid = "undef"
$  d_setpgid = "undef"
$  d_setpgrp = "undef"
$  d_setregid = "undef"
$  d_setreuid = "undef"
$  d_setsid = "undef"
$  ! Disable this section for now.
$!$  if (vms_ver .GES. "8.2") .AND. (archname .NES. "VMS_VAX")
$  if .NOT. 1
$  then
$    echo "Found 64 bit OpenVMS ''vms_ver' -- will build with V7.3-2 UID setting routines"
$    d_seteuid = "define"
$    d_setpgid = "define"
$    d_setpgrp = "define"
$    d_setregid = "define"
$    d_setreuid = "define"
$    d_setsid = "define"
$  endif
$!
$! VMS V8 powered options
$! We know that it is only available for 8.2 and later on 64 bit platforms.
$!
$  d_fstatvfs = "undef"
$!  d_statvfs = "undef"
$  i_sysstatvfs = "undef"
$  if (vms_ver .GES. "8.2") .AND. (archname .NES. "VMS_VAX")
$  then
$    echo "Found 64 bit OpenVMS ''vms_ver' -- will build with 8.2 routines"
$    d_fstatvfs = "define"
$!    d_statvfs = "define"
$    i_sysstatvfs = "define"
$  endif
$!
$! Check rand48 and its ilk
$!
$ echo4 "Looking for a random number function..."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "srand48(12L);"
$ WS "exit(0);"
$ WS "}"
$ CS
$ GOSUB link_ok
$ IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$ THEN
$   drand01 = "drand48()"
$   randbits = "48"
$   randfunc = "drand48"
$   randseedtype = "long int"
$   seedfunc = "srand48"
$   echo4 "Good, found drand48()."
$   d_drand48proto = "define"
$ ELSE
$   d_drand48proto = "undef"
$   drand01="random()"
$   randbits = "31"
$   randfunc = "random"
$   randseedtype = "unsigned"
$   seedfunc = "srandom"
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   WS "int main()"
$   WS "{"
$   WS "srandom(12);"
$   WS "exit(0);"
$   WS "}"
$   CS
$   GOSUB link_ok
$   IF compile_status .EQ. good_compile .AND. link_status .EQ. good_link
$   THEN
$     echo4 "OK, found random()."
$   ELSE
$     drand01="(((float)rand())*MY_INV_RAND_MAX)"
$     randfunc = "rand"
$     randseedtype = "unsigned"
$     seedfunc = "srand"
$     echo4 "Yick, looks like I have to use rand()."
$   ENDIF
$ ENDIF
$! Done with compiler checks. Clean up.
$ IF F$SEARCH("try.c")  .NES."" THEN DELETE/NOLOG/NOCONFIRM try.c;*
$ IF F$SEARCH("try.obj").NES."" THEN DELETE/NOLOG/NOCONFIRM try.obj;*
$ IF F$SEARCH("try.exe").NES."" THEN DELETE/NOLOG/NOCONFIRM try.exe;*
$ IF F$SEARCH("try.opt").NES."" THEN DELETE/NOLOG/NOCONFIRM try.opt;*
$ IF F$SEARCH("try.out").NES."" THEN DELETE/NOLOG/NOCONFIRM try.out;*
$ IF ccname .EQS. "CXX"
$ THEN
$   CALL Cxx_demangler_cleanup
$ ENDIF
$!
$! Some that are compiler or VMS version sensitive
$!
$! Gnu C stuff
$ IF ccname .EQS. "GCC"
$ THEN
$   d_attribut="define"
$   vms_cc_type="gcc"
$ ELSE
$   vms_cc_type="cc"
$   d_attribut="undef"
$ ENDIF
$!
$! Dec C >= 5.2 and VMS ver >= 7.0
$ IF (ccname .EQS. "DEC") .AND. -
     (F$INTEGER(Dec_C_Version).GE.50200000) .AND. (vms_ver .GES. "7.0")
$ THEN
$   d_bcmp="define"
$   d_getitimer="define"
$   d_gettimeod="define"
$   d_mmap="define"
$   d_mprotect="define"
$   d_munmap="define"
$   d_msync="define"
$   d_ualarm="define"
$   d_uname="define"
$!   d_unsetenv="define" ! Fix me - Activating requires changing VMS code
$   d_unsetenv="undef"   ! Change will be needed to allow GNV integration
$   d_clearenv="undef"
$   d_usleep="define"
$   d_setitimer="define"
$   d_sigaction="define"
$   d_sigprocmask="define"
$   d_truncate="define"
$   d_wait4="define"
$   d_index="define"
$   pidtype="pid_t"
$   sig_name1="ZERO HUP INT QUIT ILL TRAP ABRT EMT FPE KILL BUS SEGV SYS PIPE"
$   sig_name2=" ALRM TERM USR1 USR2 NUM18 NUM19 CHLD CONT STOP TSTP TTIN TTOU DEBUG"
$   IF (vms_ver .GES. "7.3")
$   THEN
$     sig_name2 = sig_name2 + " NUM27 WINCH"
$   ENDIF
$!* signal.h defines SIGRTMIN as 33 and SIGRTMAX as 64, but there is no 
$!* sigqueue function or other apparent means to do realtime signalling,
$!* so let's not try to include the realtime range for now.
$!* sig_name3=" NUM29 NUM30 NUM31 NUM32 RTMIN NUM34 NUM35 NUM36 NUM37 NUM38 NUM39 NUM40 NUM41 NUM42 NUM43"
$!* sig_name4=" NUM44 NUM45 NUM46 NUM47 NUM48 NUM49 NUM50 NUM51 NUM52 NUM53 NUM54 NUM55 NUM56 NUM57 NUM58"
$!* sig_name5=" NUM59 NUM60 NUM61 NUMT62 NUM63 RTMAX"
$   sig_name = sig_name1 + sig_name2
$   sig_num = ""
$   sig_num_init = ""
$   sig_name_init = ""
$   sig_index = 0
$!
$ PARSE_SIG_NAME_LOOP:
$!
$   tmp = F$ELEMENT(sig_index, " ", sig_name)
$   IF F$LENGTH(F$EDIT(tmp,"TRIM")) .eq. 0 THEN GOTO END_SIG_NAME_LOOP
$   sig_name_init = sig_name_init + """''tmp'"","
$   sig_num = sig_num + "''sig_index' "
$   sig_num_init = sig_num_init + "''sig_index',"
$   sig_index = sig_index + 1
$   GOTO PARSE_SIG_NAME_LOOP
$!
$ END_SIG_NAME_LOOP:
$!
$   sig_name_init = sig_name_init + "0"
$   sig_num_init = sig_num_init + "0"
$   sig_size = "''sig_index'"
$   sig_index = sig_index - 1
$   sig_count = "''sig_index'"
$   uidtype="uid_t"
$   d_pathconf="define"
$   d_fpathconf="define"
$   d_sysconf="define"
$   d_sigsetjmp="define"
$ ELSE
$   pidtype="unsigned int"
$   d_bcmp="undef"
$   d_getitimer="undef"
$   d_gettimeod="undef"
$   d_mmap="undef"
$   d_mprotect="undef"
$   d_munmap="undef"
$   d_msync="undef"
$   d_ualarm="undef"
$   d_uname="undef"
$   d_unsetenv="undef"
$   d_clearenv="undef"
$   d_usleep="undef"
$   d_setitimer="undef"
$   d_sigaction="undef"
$   d_sigprocmask="undef"
$   d_truncate="undef"
$   d_wait4="undef"
$   d_index="undef"
$   sig_name="ZERO HUP INT QUIT ILL TRAP IOT EMT FPE KILL BUS SEGV SYS PIPE ALRM TERM ABRT USR1 USR2"
$   psnwc1="""ZERO"",""HUP"",""INT"",""QUIT"",""ILL"",""TRAP"",""IOT"",""EMT"",""FPE"",""KILL"",""BUS"",""SEGV"",""SYS"","
$   psnwc2="""PIPE"",""ALRM"",""TERM"",""ABRT"",""USR1"",""USR2"",0"
$   sig_name_init = psnwc1 + psnwc2
$   sig_num="0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 6 16 17"
$   sig_num_init="0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,6,16,17,0"
$   sig_size="19"
$   sig_count="15"
$   if (vms_ver .GES. "6.2") then sig_count="17"
$   uidtype="unsigned int"
$   d_pathconf="undef"
$   d_fpathconf="undef"
$   d_sysconf="undef"
$   d_sigsetjmp="undef"
$ ENDIF
$!: see if tzname[] exists
$ OS
$ WS "#include <stdio.h>"
$ WS "#include <time.h>"
$ WS "int main() { extern short tzname[]; printf(""%hd"", tzname[0]); }"
$ CS
$ GOSUB compile_ok
$ IF compile_status .EQ. good_compile
$ THEN
$   d_tzname = "undef"
$   echo4 "tzname[] NOT found."
$ ELSE
$   d_tzname = "define"
$   echo4 "tzname[] found."
$ ENDIF
$ IF F$SEARCH("try.obj") .NES. "" THEN DELETE/NOLOG/NOCONFIRM try.obj;
$!
$ IF d_gethname .EQS. "undef" .AND. d_uname .EQS. "undef"
$ THEN
$   d_phostname="define"
$ ELSE
$   d_phostname="undef"
$ ENDIF
$!
$! Dec C alone
$ IF ccname .EQS. "DEC"
$ THEN
$   d_mbstowcs="define"
$   d_mbtowc="define"
$   d_stdiobase="define"
$   d_stdio_cnt_lval="define"
$   d_stdio_ptr_lval="define"
$   d_stdstdio="define"
$   d_faststdio="define"
$   d_wcstombs="define"
$   d_mblen="define"
$   d_mktime="define"
$   d_strcoll="define"
$   d_strxfrm="define"
$   d_wctomb="define"
$   i_locale="define"
$   i_langinfo="define"
$   d_locconv="define"
$   IF vms_ver .GES. "6.2"
$   THEN
$     d_nl_langinfo="define"
$   ELSE
$     d_nl_langinfo="undef"
$   ENDIF
$   d_setlocale="define"
$   vms_cc_type="decc"
$ ELSE
$   d_mbstowcs="undef"
$   d_mbtowc="undef"
$   d_stdiobase="undef"
$   d_stdio_cnt_lval="undef"
$   d_stdio_ptr_lval="undef"
$   d_stdstdio="undef"
$   d_faststdio="undef"
$   d_wcstombs="undef"
$   d_mblen="undef"
$   d_mktime="undef"
$   d_strcoll="undef"
$   d_strxfrm="undef"
$   d_wctomb="undef"
$   i_locale="undef"
$   i_langinfo="undef"
$   d_locconv="undef"
$   d_nl_langinfo="undef"
$   d_setlocale="undef"
$ ENDIF
$ d_stdio_ptr_lval_sets_cnt="undef"
$ d_stdio_ptr_lval_nochange_cnt="define"
$ usefaststdio="undef"
$!
$! Sockets?
$ if Has_Socketshr .OR. Has_Dec_C_Sockets
$ THEN
$   d_vms_do_sockets="define"
$   d_htonl="define"
$   d_socket="define"
$   d_sockpair = "undef"
$   if (vms_ver .GES. "8.2") .AND. (archname .NES. "VMS_VAX")
$   then
$     echo "Found 64 bit OpenVMS 8.2, will build with socketpair support"
$     d_sockpair = "define"
$   endif
$   d_select="define"
$   netdb_hlen_type="int"
$   netdb_host_type="char *"
$   netdb_name_type="char *"
$   netdb_net_type="long"
$   d_gethbyaddr="define"
$   d_gethbyname="define"
$   d_getnbyaddr="define"
$   d_getnbyname="define"
$   d_getpbynumber="define"
$   d_getpbyname="define"
$   d_getsbyport="define"
$   d_getsbyname="define"
$   d_gethostprotos="define"
$   d_getnetprotos="define"
$   d_getprotoprotos="define"
$   d_getservprotos="define"
$   IF ccname .EQS. "DEC" .OR. ccname .EQS. "CXX"
$   THEN
$     socksizetype="unsigned int"
$   ELSE
$     socksizetype="int *"
$   ENDIF
$ ELSE
$   d_vms_do_sockets="undef"
$   d_htonl="undef"
$   d_socket="undef"
$   d_socketpair = "undef"
$   d_select="undef"
$   netdb_hlen_type="int"
$   netdb_host_type="char *"
$   netdb_name_type="char *"
$   netdb_net_type="long"
$   d_gethbyaddr="undef"
$   d_gethbyname="undef"
$   d_getnbyaddr="undef"
$   d_getnbyname="undef"
$   d_getpbynumber="undef"
$   d_getpbyname="undef"
$   d_getsbyport="undef"
$   d_getsbyname="undef"
$   d_gethostprotos="undef"
$   d_getnetprotos="undef"
$   d_getprotoprotos="undef"
$   d_getservprotos="undef"
$   socksizetype="undef"
$ ENDIF
$! Threads
$ IF use_threads
$ THEN
$   usethreads="define"
$   d_pthreads_created_joinable="define"
$   if (vms_ver .GES. "7.0")
$   THEN
$     d_oldpthreads="undef"
$   ELSE
$     d_oldpthreads="define"
$   ENDIF
$ ELSE
$   d_oldpthreads="undef"
$   usethreads="undef"
$   d_pthreads_created_joinable="undef"
$ ENDIF
$! 
$! new (5.005_62++) typedefs for primitives
$!
$ echo "Choosing the C types to be used for Perl's internal types..."
$ ivtype="long"
$ uvtype="unsigned long"
$ i8type="char"
$ u8type="unsigned char"
$ i16type="short"
$ u16type="unsigned short"
$ i32type="int"
$ u32type="unsigned int"
$ i64type="long long"
$ u64type="unsigned long long"
$ nvtype="double"
$!
$ IF use64bitint .OR. use64bitint .EQS. "define"
$ THEN
$   ivtype = "''i64type'"
$   uvtype = "''u64type'"
$ ELSE
$   i64size="undef"
$   u64size="undef"
$ ENDIF
$!
$ IF uselongdouble .OR. uselongdouble .EQS. "define"
$ THEN
$   nvtype="long double"
$ ENDIF
$!
$ tmp = "''ivtype'"
$ GOSUB type_size_check
$ ivsize = tmp
$ IF use64bitint .OR. use64bitint .EQS. "define" THEN i64size = tmp
$ IF ivtype .eqs. "long"
$ THEN longsize = tmp
$ ELSE
$   tmp = "long"
$   GOSUB type_size_check
$   longsize = tmp
$ ENDIF
$!
$ tmp = "''uvtype'"
$ GOSUB type_size_check
$ uvsize = tmp
$ IF use64bitint .OR. use64bitint .EQS. "define" THEN u64size = tmp
$!
$ tmp = "''i8type'"
$ GOSUB type_size_check
$ i8size = tmp
$!
$ tmp = "''u8type'"
$ GOSUB type_size_check
$ u8size = tmp
$!
$ tmp = "''i16type'"
$ GOSUB type_size_check
$ i16size = tmp
$ IF i16type .eqs. "short"
$ THEN shortsize = tmp
$ ELSE
$   tmp = "short"
$   gosub type_size_check
$   shortsize = tmp
$ ENDIF
$!
$ tmp = "''u16type'"
$ GOSUB type_size_check
$ u16size = tmp
$!
$ tmp = "''i32type'"
$ GOSUB type_size_check
$ i32size = tmp
$ IF i32type .eqs. "int"
$ THEN intsize = tmp
$ ELSE
$   tmp = "int"
$   gosub type_size_check
$   intsize = tmp
$ ENDIF
$!
$ tmp = "''u32type'"
$ gosub type_size_check
$ u32size = tmp
$!
$ tmp = "''nvtype'"
$ GOSUB type_size_check
$ nvsize = tmp
$!
$ echo "(IV will be ""''ivtype'"", ''ivsize' bytes)"
$ echo "(UV will be ""''uvtype'"", ''uvsize' bytes)"
$ echo "(NV will be ""''nvtype'"", ''nvsize' bytes)"
$!
$ echo4 "Checking whether your NVs can preserve your UVs..."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <stdio.h>"
$ WS "int main() {"
$ WS "    ''uvtype' k = (''uvtype')~0, l;"
$ WS "    ''nvtype' d;"
$ WS "    l = k;"
$ WS "    d = (''nvtype')l;"
$ WS "    l = (''uvtype')d;"
$ WS "    if (l == k)"
$ WS "       printf(""preserve\n"");"
$ WS "    exit(0);"
$ WS "}"
$ CS
$ GOSUB compile
$ IF tmp .EQS. "preserve"
$ THEN 
$   d_nv_preserves_uv = "define"
$   echo "Yes, they can." 
$   nv_preserves_uv_bits = F$STRING(F$INTEGER(uvsize) * 8)
$ ELSE
$   d_nv_preserves_uv = "undef"
$   echo "No, they can't."
$   echo4 "Checking how many bits of your UVs your NVs can preserve..."
$   OS
$   WS "#if defined(__DECC) || defined(__DECCXX)"
$   WS "#include <stdlib.h>"
$   WS "#endif"
$   WS "#include <stdio.h>"
$   WS "int main() {"
$   WS "    ''uvtype' u = 0;"
$   WS "    int     n = 8 * ''uvsize';"
$   WS "    int     i;"
$   WS "    for (i = 0; i < n; i++) {"
$   WS "      u = u << 1 | (''uvtype')1;"
$   WS "      if ((''uvtype')(''nvtype')u != u)"
$   WS "        break;"
$   WS "    }"
$   WS "    printf(""%d\n"", i);"
$   WS "    exit(0);"
$   WS "}"
$   CS
$   GOSUB compile
$   nv_preserves_uv_bits = tmp
$ ENDIF
$!
$! Check for signbit (must already know nvtype)
$!
$ echo4 "Checking to see if you have signbit() available to work on ''nvtype'..."
$ OS
$ WS "#if defined(__DECC) || defined(__DECCXX)"
$ WS "#include <stdlib.h>"
$ WS "#endif"
$ WS "#include <fp.h>"
$ WS "#include <stdio.h>"
$ WS "int main()"
$ WS "{"
$ WS "    ''nvtype' x = 0.0;"
$ WS "    ''nvtype' y = -0.0;"
$ WS "    if ((signbit(x) == 0) && (signbit(y) != 0))"
$ WS "        printf(""1\n"");"
$ WS "    else"
$ WS "        printf(""0\n"");"
$ WS "}"
$ CS
$ GOSUB compile
$ IF tmp .EQS. "1" 
$ THEN 
$     d_signbit = "define"
$     echo4 "Yes."
$ ELSE
$     d_signbit = "undef"
$     echo4 "Nope."
$ ENDIF
$!
$ echo4 "Checking if kill() uses SYS$FORCEX or can't be called from a signal handler..."
$ kill_by_sigprc = "undef"
$ OS
$ WS "#include <stdio.h>"
$ WS "#include <signal.h>"
$ WS "#include <unistd.h>"
$ WS "void handler1(int s) { printf(""%d"",s); kill(getpid(),2); }"
$ WS "void handler2(int s) { printf(""%d"",s); }"
$ WS "main(){"
$ WS "    printf(""0"");"
$ WS "    signal(1,handler1);"
$ WS "    signal(2,handler2);"
$ WS "    kill(getpid(),1);"
$ WS "    sleep(1);"
$ WS "    printf(""\n"");"
$ WS "}"
$ CS
$ ON ERROR THEN CONTINUE
$ GOSUB compile
$ IF tmp .NES. "012"
$ THEN 
$   echo4 "Yes, it has at least one of those limitations."
$   echo4 "Checking whether we can use SYS$SIGPRC instead..."
$   OS
$   WS "#include <stdio.h>"
$   WS "#include <lib$routines.h>"
$   WS "unsigned long code = 0;"
$   WS "int handler(unsigned long *args) {"
$   WS "    code = args[1];"
$   WS "    return 1;"
$   WS "}"
$   WS "main() { "
$   WS "    int iss, sys$sigprc();"
$   WS "    lib$establish(handler);"
$   WS "    iss = sys$sigprc(0,0,0x1234);"
$   WS "    iss =  ((iss&1)==1 && code == 0x1234);" 
$   WS "    printf(""%d\n"",iss);"
$   WS "}"
$   CS
$   ON ERROR THEN CONTINUE
$   GOSUB compile
$   IF tmp .EQS. "1"
$   THEN
$       echo4 "Yep, we can."
$       kill_by_sigprc = "define"
$!
$!	Use the same list of signals the CRTL does for recent systems, but cook our own for very old systems.
$!	Note that the list controls what signals can be caught by name as well as what can be raised via kill().
$!
$       if  vms_ver .LTS. "6.2"
$	then
$!          since SIGBUS and SIGSEGV indistinguishable, make them the same here.
$           sig_name="ZERO HUP INT QUIT ILL TRAP IOT EMT FPE KILL BUS SEGV SYS PIPE ALRM TERM ABRT"
$           psnwc1="""ZERO"",""HUP"",""INT"",""QUIT"",""ILL"",""TRAP"",""IOT"",""EMT"",""FPE"",""KILL"",""BUS"",""SEGV"",""SYS"","
$           psnwc2="""PIPE"",""ALRM"",""TERM"",""ABRT"",0"
$           sig_name_init = psnwc1 + psnwc2
$           sig_num="0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 6"
$           sig_num_init="0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,6,0"
$           sig_size="17"
$	    sig_count="15"
$       endif
$   ELSE
$       echo4 "Nope, we can't."
$   ENDIF
$ ELSE
$   echo4 "Nope, it doesn't."
$ ENDIF
$ DELETE/SYMBOL tmp
$!
$! Finally the composite ones. All config
$!
$ myuname="''osname' ''myname' ''osvers' ''F$EDIT(hwname, "TRIM")'"
$!
$ IF ccname .EQS. "DEC"
$ THEN
$   ccflags="/Include=[]/Standard=Relaxed_ANSI/Prefix=All/Obj=''obj_ext' ''ccflags'"
$ ENDIF
$ i_dirent = "undef"
$ IF ccname .EQS. "CXX"
$ THEN
$   i_dirent = "define"
$   ccflags="/Include=[]/Standard=ANSI/Prefix=All/Obj=''obj_ext' ''ccflags'"
$ ENDIF
$ IF use_vmsdebug_perl
$ THEN
$   optimize="/List/Debug/NoOpt"
$   ldflags="/Debug/Trace/Map"
$   dbgprefix = "DBG"
$ ELSE
$   optimize= "/NoList"
$   ldflags="/NoTrace/NoMap"
$   dbgprefix = ""
$ ENDIF
$!
$! Okay, we've got everything configured. Now go write out a config.sh.
$ basename_config_sh = F$PARSE(config_sh,,,"NAME",)+F$PARSE(config_sh,,,"TYPE",)
$ echo4 "Creating ''basename_config_sh'..."
$ open/write CONFIG 'config_sh'
$ WC := write CONFIG
$!
$! ##BEGIN WRITE NEW CONSTANTS HERE##
$!
$ WC "#!/bin/sh"
$ WC "#"
$ WC "# This file was produced by Configure.COM on a ''osname' system."
$ WC "#"
$ WC "# Package name      : ''package'"
$ WC "# Source directory  : ''src'"
$ WC "# Configuration time: " + cf_time
$ WC "# Configuration by  : " + cf_by
$ WC "# Target system     : " + myuname
$ WC ""
$ WC "Makefile_SH='" + Makefile_SH + "'"
$ WC "Mcc='" + Mcc + "'"
$ WC "PERL_REVISION='" + revision + "'"
$ WC "PERL_VERSION='" + patchlevel + "'" 
$ WC "PERL_SUBVERSION='" + subversion + "'" 
$ WC "PERL_API_REVISION='" + api_revision + "'"
$ WC "PERL_API_VERSION='" + api_version + "'" 
$ WC "PERL_API_SUBVERSION='" + api_subversion + "'"
$ WC "PERL_PATCHLEVEL='" + perl_patchlevel + "'"
$ WC "PERL_CONFIG_SH='true'"
$ WC "_a='" + lib_ext + "'"
$ WC "_exe='" + exe_ext + "'"
$ WC "_o='" + obj_ext + "'"
$ WC "alignbytes='" + alignbytes + "'"
$ WC "aphostname='write sys$output f$edit(f$getsyi(\""SCSNODE\""),\""TRIM,LOWERCASE\"")'"
$ WC "ar='" + "'"
$ WC "archlib='" + archlib + "'"
$ WC "archlibexp='" + archlibexp + "'"
$ WC "archname='" + archname + "'"
$ WC "baserev='" + baserev + "'"
$ WC "bin='" + bin + "'"
$ WC "binexp='" + binexp + "'"
$ WC "builddir='" + builddir + "'"
$ WC "byteorder='1234'"
$ WC "castflags='0'"
$ WC "cc='" + perl_cc + "'"
$ WC "cccdlflags='" + cccdlflags + "'"
$ WC "ccdlflags='" + ccdlflags + "'"
$ IF uselargefiles .OR. uselargefiles .EQS. "define"
$ THEN
$    IF usestdstat .OR. usestdstat .EQS. "define"
$    THEN
$	ccdefines = "_USE_STD_STAT=1"
$    ELSE
$	ccdefines = "_LARGEFILE=1"
$    ENDIF
$ ELSE
$     ccdefines = ""
$ ENDIF
$ IF ccdefines .NES. ""
$ THEN
$   WC "ccflags='" + ccflags + "/Define=" + ccdefines + "'"
$ ELSE
$   WC "ccflags='" + ccflags + "'"
$ ENDIF
$ WC "ccflags_uselargefiles='" + "'"
$ WC "ccname='" + ccname + "'"
$ WC "ccversion='" + ccversion + "'"
$ WC "cf_by='" + cf_by + "'"
$ WC "cf_email='" + cf_email + "'"
$ WC "cf_time='" + cf_time + "'"
$ WC "config_args='" + config_args + "'"
$ WC "config_sh='" + config_sh + "'"
$ WC "cpp_stuff='" + cpp_stuff + "'"
$ WC "cpplast='" + cpplast + "'"
$ WC "cppminus='" + cppminus + "'"
$ WC "cpprun='" + cpprun + "'"
$ WC "cppstdin='" + cppstdin + "'"
$ IF use64bitint .OR. use64bitint .EQS. "define"
$ THEN
$!  gcvt() does not work for > 16 decimal places; fallback to sprintf
$   WC "d_Gconvert='sprintf((b),""%.*" + (nvgformat-"""") + ",(n),(x))'"
$ ELSE
$   WC "d_Gconvert='my_gconvert(x,n,t,b)'"
$ ENDIF
$ WC "d_PRIEldbl='" + d_PRIEUldbl + "'"
$ WC "d_PRIFldbl='" + d_PRIFUldbl + "'"
$ WC "d_PRIGldbl='" + d_PRIGUldbl + "'"
$ WC "d_PRIXU64='" + d_PRIXU64 + "'"
$ WC "d_PRId64='" + d_PRId64 + "'"
$ WC "d_PRIeldbl='" + d_PRIeldbl + "'"
$ WC "d_PRIfldbl='" + d_PRIfldbl + "'"
$ WC "d_PRIgldbl='" + d_PRIgldbl + "'"
$ WC "d_PRIo64='" + d_PRIo64 + "'"
$ WC "d_PRIu64='" + d_PRIu64 + "'"
$ WC "d_PRIx64='" + d_PRIx64 + "'"
$ WC "d_SCNfldbl='" + d_SCNfldbl + "'"
$ WC "d__fwalk='undef'"
$ WC "d_access='" + d_access + "'"
$ WC "d_accessx='undef'"
$ WC "d_aintl='undef'"
$ WC "d_alarm='define'"
$ WC "d_archlib='define'"
$ WC "d_atolf='" + d_atolf + "'"
$ WC "d_atoll='" + d_atoll + "'"
$ WC "d_attribute_format='" + d_attribut + "'"
$ WC "d_attribute_malloc='undef'"
$ WC "d_attribute_nonnull='undef'"
$ WC "d_attribute_noreturn='undef'"
$ WC "d_attribute_pure='undef'"
$ WC "d_attribute_unused='undef'"
$ WC "d_attribute_warn_unused_result='undef'"
$ WC "d_printf_format_null='undef'"
$ WC "d_bcmp='" + d_bcmp + "'"
$ WC "d_bcopy='" + d_bcopy + "'"
$ WC "d_bincompat3='undef'"
$! WC "d_bsdpgrp='undef'"
$ WC "d_bsdgetpgrp='undef'"
$ WC "d_bsdsetpgrp='undef'"
$ WC "d_builtin_choose_expr='undef'" ! GCC only
$ WC "d_builtin_expect='undef'" ! GCC only
$ WC "d_bzero='" + d_bzero + "'"
$ WC "d_casti32='define'"
$ WC "d_castneg='define'"
$ WC "d_charvspr='undef'"
$ WC "d_chown='define'"
$ WC "d_chroot='undef'"
$ WC "d_chsize='undef'"
$ WC "d_class='undef'"
$ WC "d_cmsghdr_s='undef'"
$ WC "d_const='define'"
$ WC "d_copysignl='define'"
$ WC "d_cplusplus='" + d_cplusplus + "'"
$ WC "d_crypt='define'"
$ WC "d_csh='undef'"
$ WC "d_ctermid='define'"
$ WC "d_cuserid='define'"
$ WC "d_c99_variadic_macros='undef'"
$ WC "d_dbl_dig='define'"
$ WC "d_dbminitproto='undef'"
$ WC "d_difftime='define'"
$ WC "d_dir_dd_fd='undef'"
$ WC "d_dirfd='undef'"
$ WC "d_dirnamlen='define'"
$ WC "d_dlerror='undef'"
$ WC "d_dlsymun='undef'"
$ WC "d_dosuid='undef'"
$ WC "d_drand48proto='" + d_drand48proto + "'"
$ WC "d_dup2='define'"
$ WC "d_eaccess='undef'"
$ WC "d_endgrent='define'"
$ WC "d_endhent='" + d_endhent + "'"
$ WC "d_endnent='" + d_endnent + "'"
$ WC "d_endpent='" + d_endpent + "'"
$ WC "d_endpwent='define'"
$ WC "d_endsent='" + d_endsent + "'"
$ WC "d_eofnblk='undef'"
$ WC "d_eunice='undef'"
$ WC "d_fchmod='undef'"
$ WC "d_fchdir='undef'"
$ WC "d_fchown='undef'"
$ WC "d_fcntl='" + d_fcntl + "'"
$ WC "d_fcntl_can_lock='" + d_fcntl_can_lock + "'"
$ WC "d_fd_set='" + d_fd_set + "'"
$ WC "d_fgetpos='define'"
$ WC "d_finite='undef'"
$ WC "d_finitel='undef'"
$ WC "d_flexfnam='define'"
$ WC "d_flock='undef'"
$ WC "d_flockproto='undef'"
$ WC "d_fork='undef'"
$ WC "d_fp_class='undef'"
$ WC "d_fpathconf='" + d_fpathconf + "'"
$ WC "d_fpclass='undef'"
$ WC "d_fpclassify='undef'"
$ WC "d_fpclassl='undef'"
$ WC "d_fpos64_t='" + d_fpos64_t + "'"
$ WC "d_frexpl='" + d_frexpl + "'"
$ WC "d_fs_data_s='undef'"
$ WC "d_fseeko='" + d_fseeko + "'"
$ WC "d_fsetpos='define'"
$ WC "d_fstatfs='undef'"
$ WC "d_fstatvfs='" + d_fstatvfs + "'"
$ WC "d_fsync='undef'"
$ WC "d_ftello='" + d_ftello + "'"
$ WC "d_futimes='undef'"
$ WC "d_getcwd='define'"
$ WC "d_getespwnam='undef'"
$ WC "d_getfsstat='undef'"
$ WC "d_getgrent='define'"
$ WC "d_getgrps='undef'"
$ WC "d_gethbyaddr='" + d_gethbyaddr + "'"
$ WC "d_gethbyname='" + d_gethbyname + "'"
$ WC "d_gethent='" + d_gethent + "'"
$ WC "d_gethname='" + d_gethname + "'"
$ WC "d_gethostprotos='" + d_gethostprotos + "'"
$ WC "d_getitimer='" + d_getitimer + "'"
$ WC "d_getlogin='define'"
$ WC "d_getmnt='undef'"
$ WC "d_getmntent='undef'"
$ WC "d_getnbyaddr='" + d_getnbyaddr + "'"
$ WC "d_getnbyname='" + d_getnbyname + "'"
$ WC "d_getnent='" + d_getnent + "'"
$ WC "d_getnetprotos='" + d_getnetprotos + "'"
$ WC "d_getpagsz='undef'"
$ WC "d_getpbyname='" + d_getpbyname + "'"
$ WC "d_getpbynumber='" + d_getpbynumber + "'"
$ WC "d_getpent='" + d_getpent + "'"
$ WC "d_getpgid='" + d_getpgid + "'"
$ WC "d_getpgrp2='undef'"
$ WC "d_getpgrp='" + d_getpgrp + "'"
$ WC "d_getppid='" + d_getppid + "'"
$ WC "d_getprior='undef'"
$ WC "d_getprotoprotos='" + d_getprotoprotos + "'"
$ WC "d_getprpwnam='undef'"
$ WC "d_getpwent='define'"
$ WC "d_getsbyname='" + d_getsbyname + "'"
$ WC "d_getsbyport='" + d_getsbyport + "'"
$ WC "d_getsent='" + d_getsent + "'"
$ WC "d_getservprotos='" + d_getservprotos + "'"
$ WC "d_getspnam='undef'"
$ WC "d_gettimeod='" + d_gettimeod + "'"
$ WC "d_gnulibc='undef'"
$ WC "d_grpasswd='undef'"
$ WC "d_hasmntopt='undef'"
$ WC "d_htonl='" + d_htonl + "'"
$ WC "d_ilogbl='undef'"
$ WC "d_inc_version_list='undef'"
$ WC "d_index='" + d_index + "'"
$ WC "d_inetaton='undef'"
$ WC "d_int64_t='" + d_int64_t + "'"
$ WC "d_isascii='define'"
$ WC "d_isfinite='undef'"
$ WC "d_isinf='undef'"
$ WC "d_isnan='" + d_isnan + "'"
$ WC "d_isnanl='" + d_isnanl + "'"
$ WC "d_killpg='undef'"
$ WC "d_lchown='" + d_lchown + "'"
$ WC "d_ldbl_dig='define'"
$ WC "d_libm_lib_version='undef'"
$ WC "d_link='" + d_link + "'"
$ WC "d_llseek='undef'"
$ WC "d_locconv='" + d_locconv + "'"
$ WC "d_lockf='undef'"
$ WC "d_longdbl='" + d_longdbl + "'"
$ WC "d_longlong='" + d_longlong + "'"
$ WC "d_lseekproto='define'"
$ WC "d_lstat='" + d_lstat + "'"
$ WC "d_madvise='undef'"
$ WC "d_malloc_size='undef'"
$ WC "d_malloc_good_size='undef'"
$ WC "d_mblen='" + d_mblen + "'"
$ WC "d_mbstowcs='" + d_mbstowcs + "'"
$ WC "d_mbtowc='" + d_mbtowc + "'"
$ WC "d_memchr='" + d_memchr + "'"
$ WC "d_memcmp='define'"
$ WC "d_memcpy='define'"
$ WC "d_memmove='define'"
$ WC "d_memset='define'"
$ WC "d_mkdir='define'"
$ WC "d_mkdtemp='" + d_mkdtemp + "'"
$ WC "d_mkfifo='undef'"
$ WC "d_mknod='undef'"
$ WC "d_mkstemp='" + d_mkstemp + "'"
$ WC "d_mkstemps='" + d_mkstemps + "'"
$ WC "d_mktime='" + d_mktime + "'"
$ WC "d_mmap='" + d_mmap + "'"
$ WC "d_modfl='" + d_modfl + "'"
$ WC "d_modflproto='" + d_modflproto + "'"
$ WC "d_modfl_pow32_bug='undef'"
$ WC "d_mprotect='" + d_mprotect + "'"
$ WC "d_msg='undef'"
$ WC "d_msg_ctrunc='undef'"
$ WC "d_msg_dontroute='undef'"
$ WC "d_msg_oob='undef'"
$ WC "d_msg_peek='undef'"
$ WC "d_msg_proxy='undef'"
$ WC "d_msghdr_s='undef'"
$ WC "d_msync='" + d_msync + "'"
$ WC "d_munmap='" + d_munmap + "'"
$ WC "d_mymalloc='" + d_mymalloc + "'"
$ WC "d_nanosleep='" + d_nanosleep + "'"
$ WC "d_nice='define'"
$ WC "d_nl_langinfo='" + d_nl_langinfo + "'"
$ WC "d_nv_preserves_uv='" + d_nv_preserves_uv + "'"
$ WC "nv_preserves_uv_bits='" + nv_preserves_uv_bits + "'"
$ WC "d_nv_zero_is_allbits_zero='define'"
$ WC "d_off64_t='" + d_off64_t + "'"
$ WC "d_old_pthread_create_joinable='" + d_old_pthread_create_joinable + "'"
$ WC "d_oldarchlib='define'"
$ WC "d_oldpthreads='" + d_oldpthreads + "'"
$ WC "d_open3='define'"
$ WC "d_pathconf='" + d_pathconf + "'"
$ WC "d_pause='define'"
$ WC "d_perl_otherlibdirs='undef'"
$ WC "d_phostname='" + d_phostname + "'"
$ WC "d_pipe='define'"
$ WC "d_poll='" + d_poll + "'"
$ WC "d_procselfexe='undef'"
$ WC "d_pseudofork='undef'"
$ WC "d_pthread_atfork='undef'"
$ WC "d_pthread_attr_setscope='" + d_pthread_attr_setscope + "'"
$ WC "d_pthread_yield='" + d_pthread_yield + "'"
$ WC "d_pthreads_created_joinable='" + d_pthreads_created_joinable + "'"
$ WC "d_pwage='undef'"
$ WC "d_pwchange='undef'"
$ WC "d_pwclass='undef'"
$ WC "d_pwcomment='define'"
$ WC "d_pwexpire='undef'"
$ WC "d_pwgecos='define'"
$ WC "d_pwpasswd='define'"
$ WC "d_pwquota='undef'"
$ WC "d_qgcvt='undef'"
$ WC "d_quad='" + d_quad + "'"
$ WC "d_readdir='define'"
$ WC "d_readlink='" + d_readlink + "'"
$ WC "d_readv='undef'"
$ WC "d_realpath='" + d_realpath + "'"
$ WC "d_recvmsg='undef'"
$ WC "d_rename='define'"
$ WC "d_rewinddir='define'"
$ WC "d_rmdir='define'"
$ WC "d_safebcpy='undef'"
$ WC "d_safemcpy='define'"
$ WC "d_sanemcmp='define'"
$ WC "d_sbrkproto='define'"
$ WC "d_scalbnl='undef'"
$ WC "d_sched_yield='" + d_sched_yield + "'"
$ WC "d_scm_rights='undef'"
$ WC "d_seekdir='define'"
$ WC "d_select='" + d_select + "'"
$ WC "d_sem='undef'"
$ WC "d_semctl_semid_ds='undef'"
$ WC "d_semctl_semun='undef'"
$ WC "d_sendmsg='undef'"
$ WC "d_setegid='undef'"
$ WC "d_setenv='" + d_setenv + "'"
$ WC "d_seteuid='" + d_seteuid + "'"
$ WC "d_setgrent='" + d_setgrent + "'"
$ WC "d_setgrps='undef'"
$ WC "d_sethent='" + d_sethent + "'"
$ WC "d_setitimer='" + d_setitimer + "'"
$ WC "d_setlinebuf='undef'"
$ WC "d_setlocale='" + d_setlocale + "'"
$ WC "d_setnent='" + d_setnent + "'"
$ WC "d_setpent='" + d_setpent + "'"
$ WC "d_setpgid='" + d_setpgid + "'"
$ WC "d_setpgrp2='undef'"
$ WC "d_setpgrp='" + d_setpgrp + "'"
$ WC "d_setprior='undef'"
$ WC "d_setproctitle='" + d_setproctitle + "'"
$ WC "d_setpwent='define'"
$ WC "d_setregid='" + d_setregid + "'"
$ WC "d_setresgid='undef'"
$ WC "d_setresuid='undef'"
$ WC "d_setreuid='" + d_setreuid + "'"
$ WC "d_setrgid='undef'"
$ WC "d_setruid='undef'"
$ WC "d_setsent='" + d_setsent + "'"
$ WC "d_setsid='" + d_setsid + "'"
$ WC "d_setvbuf='" + d_setvbuf + "'"
$ WC "d_sfio='undef'"
$ WC "d_shm='undef'"
$ WC "d_shmatprototype='undef'"
$ WC "d_sigaction='" + d_sigaction + "'"
$ WC "d_signbit='" + d_signbit + "'"
$ WC "d_sigprocmask='" + d_sigprocmask + "'"
$ WC "d_sigsetjmp='" + d_sigsetjmp + "'"
$ WC "d_sitearch='define'"
$ WC "d_sockatmark='undef'"
$ WC "d_sockatmarkproto='undef'"
$ WC "d_socket='" + d_socket + "'"
$ WC "d_socklen_t='" + d_socklen_t + "'"
$ WC "d_sockpair='" + d_sockpair + "'"
$ WC "d_socks5_init='undef'"
$ WC "d_sprintf_returns_strlen='define'"
$ WC "d_sqrtl='define'"
$ WC "d_sresgproto='undef'"
$ WC "d_sresgproto='undef'"
$ WC "d_sresproto='undef'"
$ WC "d_sresuproto='undef'"
$ WC "d_statblks='undef'"
$ WC "d_statfs_f_flags='undef'"
$ WC "d_statfs_s='undef'"
$ WC "d_statfsflags='undef'"
$ WC "d_stdio_cnt_lval='" + d_stdio_cnt_lval + "'"
$ WC "d_stdio_ptr_lval='" + d_stdio_ptr_lval + "'"
$ WC "d_stdio_ptr_lval_nochange_cnt='" + d_stdio_ptr_lval_nochange_cnt + "'"
$ WC "d_stdio_ptr_lval_sets_cnt='" + d_stdio_ptr_lval_sets_cnt + "'"
$ WC "d_stdio_stream_array='undef'"
$ WC "d_stdiobase='" + d_stdiobase + "'"
$ WC "d_stdstdio='" + d_stdstdio + "'"
$ WC "d_faststdio='" + d_faststdio + "'"
$ WC "d_strchr='define'"
$ WC "d_strcoll='" + d_strcoll + "'"
$ WC "d_strctcpy='define'"
$ WC "d_strerrm='strerror((e),vaxc$errno)'"
$ WC "d_strerror='define'"
$ WC "d_strftime='define'"
$ WC "d_strlcat='undef'"
$ WC "d_strlcpy='undef'"
$ WC "d_strtod='define'"
$ WC "d_strtol='define'"
$ WC "d_strtold='" + d_strtold + "'"
$ WC "d_strtoll='" + d_strtoll + "'"
$ WC "d_strtoq='" + d_strtoq + "'"
$ WC "d_strtoul='define'"
$ WC "d_strtoull='" + d_strtoull + "'"
$ WC "d_strtouq='" + d_strtouq + "'"
$ WC "d_strxfrm='" + d_strxfrm  + "'"
$ WC "d_suidsafe='undef'"
$ WC "d_symlink='" + d_symlink + "'"
$ WC "d_syscall='undef'"
$ WC "d_syscallproto='undef'"
$ WC "d_sysconf='" + d_sysconf + "'"
$ WC "d_syserrlst='undef'"
$ WC "d_system='define'"
$ WC "d_tcgetpgrp='undef'"
$ WC "d_tcsetpgrp='undef'"
$ WC "d_telldir='define'"
$ WC "d_telldirproto='define'"
$ WC "d_time='define'"
$ WC "d_times='define'"
$ IF ("''F$EXTRACT(1,3, F$GETSYI(""VERSION""))'".GES."7.0")
$ THEN
$   WC "d_tm_tm_gmtoff='define'"
$   WC "d_tm_tm_zone='define'"
$ ELSE
$   WC "d_tm_tm_gmtoff='undef'"
$   WC "d_tm_tm_zone='undef'"
$ ENDIF
$ WC "d_truncate='" + d_truncate + "'"
$ WC "d_tzname='" + d_tzname + "'"
$ WC "d_u32align='define'"
$ WC "d_ualarm='" + d_ualarm + "'"
$ WC "d_umask='define'"
$ WC "d_uname='" + d_uname + "'"
$ WC "d_union_semun='undef'"
$ WC "d_unlink_all_versions='" + d_unlink_all_versions + "'"	! VMS-specific
$ WC "d_unordered='undef'"
$ WC "d_unsetenv='" + d_unsetenv + "'"
$ WC "d_clearenv='" + d_clearenv + "'"
$ WC "d_usleep='" + d_usleep + "'"
$ WC "d_usleepproto='" + d_usleep + "'"
$ WC "d_ustat='undef'"
$ WC "d_vendorarch='undef'"
$ WC "d_vendorlib='undef'"
$ WC "d_vfork='define'"
$ WC "d_vms_case_sensitive_symbols='" + d_vms_be_case_sensitive + "'" ! VMS
$ WC "d_vms_do_sockets='" + d_vms_do_sockets + "'" ! VMS
$ WC "d_void_closedir='define'"
$ WC "d_volatile='define'"
$ WC "d_vprintf='define'"
$ WC "d_vsnprintf='" + d_vsnprintf + "'"
$ WC "d_wait4='" + d_wait4 + "'"
$ WC "d_waitpid='define'"
$ WC "d_wcstombs='" + d_wcstombs + "'"
$ WC "d_wctomb='" + d_wctomb + "'"
$ WC "d_writev='undef'"
$ WC "db_hashtype=' '"
$ WC "db_prefixtype=' '"
$ WC "db_version_major='" + "'"
$ WC "db_version_minor='" + "'"
$ WC "db_version_patch='" + "'"
$ WC "dbgprefix='" + dbgprefix + "'"
$ WC "defvoidused='15'"
$ WC "devtype='" + devtype + "'"
$ WC "direntrytype='struct dirent'"
$ WC "dlext='" + dlext + "'"
$ WC "dlobj='" + dlobj + "'"
$ WC "dlsrc='dl_vms.c'"
$ WC "doublesize='" + doublesize + "'"
$ WC "drand01='" + drand01 + "'"
$!
$! The extensions symbol may be quite long
$!
$ tmp = "dynamic_ext='" + extensions + "'"
$ WC/symbol tmp
$ DELETE/SYMBOL tmp
$ WC "eagain=' '"
$ WC "ebcdic='undef'"
$ WC "embedmymalloc='" + usemymalloc + "'"
$ WC "eunicefix=':'"
$ WC "exe_ext='" + exe_ext + "'"
$!
$! The extensions symbol may be quite long
$!
$ tmp = "extensions='" + extensions + "'"
$ WC/symbol tmp
$ DELETE/SYMBOL tmp
$ WC "fflushNULL='define'"
$ WC "fflushall='undef'"
$ WC "fpostype='fpos_t'"
$ WC "freetype='void'"
$ WC "full_ar='" + "'"
$ WC "full_csh='" + " '"
$ WC "full_sed='_NLA0:'"
$ WC "gccversion='" + gccversion + "'"
$ WC "gidformat='lu'"
$ WC "gidsign='1'"
$ WC "gidsize='4'"
$ WC "gidtype='" + gidtype + "'"
$ WC "groupstype='Gid_t'"
$ WC "hint='none'"
$ WC "hintfile='" + "'"
$ WC "i16size='" + i16size + "'"
$ WC "i16type='" + i16type + "'"
$ WC "i32size='" + i32size + "'"
$ WC "i32type='" + i32type + "'"
$ WC "i64size='" + i64size + "'"
$ WC "i64type='" + i64type + "'"
$ WC "i8size='" + i8size + "'"
$ WC "i8type='" + i8type + "'"
$ WC "i_arpainet='undef'"
$ WC "i_crypt='undef'"
$ WC "i_db='undef'"
$ WC "i_dbm='undef'"
$ WC "i_dirent='" + i_dirent + "'"
$ WC "i_dlfcn='undef'"
$ WC "i_fcntl='" + i_fcntl + "'"
$ WC "i_float='define'"
$ WC "i_fp='undef'"
$ WC "i_fp_class='undef'"
$ WC "i_gdbm='undef'"
$ WC "i_grp='" + i_grp + "'"
$ WC "i_ieeefp='undef'"
$ WC "i_inttypes='" + i_inttypes + "'"
$ WC "i_langinfo='" + i_langinfo + "'"
$ WC "i_libutil='" + i_libutil + "'"
$ WC "i_limits='define'"
$ WC "i_locale='" + i_locale + "'"
$ WC "i_machcthr='undef'"
$ WC "i_machcthreads='undef'"
$ WC "i_math='define'"
$ WC "i_memory='undef'"
$ WC "i_mntent='undef'"
$ WC "i_ndbm='undef'"
$ WC "i_netdb='" + i_netdb + "'"
$ WC "i_neterrno='define'"
$ WC "i_netinettcp='" + i_netinettcp + "'"
$ WC "i_niin='" + i_niin + "'"
$ WC "i_poll='" + i_poll + "'"
$ WC "i_prot='undef'"
$ WC "i_pthread='define'"
$ WC "i_pwd='undef'"
$ WC "i_rpcsvcdbm='undef'"
$ WC "i_sfio='undef'"
$ WC "i_sgtty='undef'"
$ WC "i_shadow='" + i_shadow + "'"
$ WC "i_socks='" + i_socks + "'"
$ WC "i_stdarg='define'"
$ WC "i_stddef='define'"
$ WC "i_stdlib='define'"
$ WC "i_string='define'"
$ WC "i_sunmath='undef'"
$ WC "i_sysaccess='" + i_sysaccess + "'"
$ WC "i_sysdir='undef'"
$ WC "i_sysfile='" + i_sysfile + "'"
$ WC "i_sysioctl='" + i_sysioctl + "'"
$ WC "i_syslog='" + i_syslog + "'"
$ WC "i_sysmman='undef'"
$ WC "i_sysmode='" + i_sysmode + "'"
$ WC "i_sysmount='undef'"
$ WC "i_sysndir='undef'"
$ WC "i_sysparam='undef'"
$ WC "i_sysresrc='undef'"
$ WC "i_syssecrt='" + i_syssecrt + "'"
$ WC "i_sysselct='undef'"
$ WC "i_syssockio='undef'"
$ WC "i_sysstat='define'"
$ WC "i_sysstatfs='undef'"
$ WC "i_sysstatvfs='" + i_sysstatvfs + "'"
$ WC "i_systime='undef'"
$ WC "i_systimek='undef'"
$ WC "i_systimes='undef'"
$ WC "i_systypes='define'"
$ WC "i_sysuio='" + i_sysuio + "'"
$ WC "i_sysun='undef'"
$ WC "i_sysutsname='" + i_sysutsname + "'"
$ WC "i_sysvfs='undef'"
$ WC "i_syswait='undef'"
$ WC "i_termio='undef'"
$ WC "i_termios='undef'"
$ WC "i_time='define'"
$ WC "i_unistd='" + i_unistd + "'"
$ WC "i_ustat='undef'"
$ WC "i_utime='" + i_utime + "'"
$ WC "i_values='undef'"
$ WC "i_varargs='undef'"
$ WC "i_vfork='undef'"
$ WC "inc_version_list='0'"
$ WC "inc_version_list_init='0'"
$ WC "installarchlib='" + installarchlib + "'"
$ WC "installbin='" + installbin + "'"
$ WC "installman1dir='" + installman1dir + "'"
$ WC "installman3dir='" + installman3dir + "'"
$ WC "installprefix='" + vms_prefix + "'"
$ WC "installprefixexp='" + vms_prefix + ":'"
$ WC "installprivlib='" + installprivlib + "'"
$ WC "installscript='" + installscript + "'"
$ WC "installsitearch='" + installsitearch + "'"
$ WC "installsitebin='" + sitebin + "'"
$ WC "installsitelib='" + installsitelib + "'"
$ WC "installusrbinperl='undef'"
$ WC "intsize='" + intsize + "'"
$ WC "ivdformat='" + ivdformat + "'"
$ WC "ivsize='" + ivsize + "'"
$ WC "ivtype='" + ivtype + "'"
$!
$! The known_extensions symbol may be quite long
$!
$ tmp = "known_extensions='" + known_extensions + "'"
$ WC/symbol tmp
$ DELETE/SYMBOL tmp
$ WC "ld='" + ld + "'"
$ WC "lddlflags='/Share'"
$ WC "ldflags='" + ldflags + "'"
$ WC "ldflags_uselargefiles='" + "'"
$ WC "lib_ext='" + lib_ext + "'"
$ WC "libc='" + libc + "'"
$ WC "libpth='/sys$share /sys$library'"
$ WC "libs='" + libs + "'"
$ WC "libswanted='" + "'"
$ WC "libswanted_uselargefiles='" + "'"
$ WC "longdblsize='" + longdblsize + "'"
$ WC "longlongsize='" + longlongsize + "'"
$ WC "longsize='" + longsize + "'"
$ IF uselargefiles .OR. uselargefiles .EQS. "define"
$ THEN
$   WC "lseeksize='8'"
$   WC "lseektype='off_t'"
$ ELSE
$   WC "lseeksize='4'"
$   WC "lseektype='int'"
$ ENDIF
$ WC "mab='" + "'"
$ WC "mad='undef'"
$ WC "make='" + make + "'"
$ WC "malloctype='void *'"
$ WC "usemallocwrap='" + usemallocwrap + "'"
$ WC "man1ext='rno'"
$ WC "man3ext='rno'"
$ WC "mmaptype='void *'"
$ WC "modetype='unsigned int'"
$ WC "multiarch='undef'"
$ WC "mydomain='" + mydomain + "'"
$ WC "myhostname='" + myhostname + "'"
$ WC "myuname='" + myuname + "'"
$ WC "need_va_copy='undef'"
$ WC "netdb_hlen_type='" + netdb_hlen_type + "'"
$ WC "netdb_host_type='" + netdb_host_type + "'"
$ WC "netdb_name_type='" + netdb_name_type + "'"
$ WC "netdb_net_type='" + netdb_net_type + "'"
$ WC "nonxs_ext='" + nonxs_ext + "'"
$ WC "nveformat='" + nveformat + "'"
$ WC "nvfformat='" + nvfformat + "'"
$ WC "nvgformat='" + nvgformat + "'"
$ WC "nvsize='" + nvsize + "'"
$ WC "nvtype='" + nvtype + "'"
$ WC "o_nonblock=' '"
$ WC "obj_ext='" + obj_ext + "'"
$ WC "old_pthread_create_joinable='" + old_pthread_create_joinable + "'"
$ WC "oldarchlib='" + oldarchlib + "'"
$ WC "oldarchlibexp='" + oldarchlibexp + "'"
$ WC "optimize='" + optimize + "'"
$ WC "osname='" + osname + "'"
$ WC "osvers='" + osvers + "'"
$ WC "otherlibdirs='" + "'"
$ WC "package='" + package + "'"
$ WC "pager='" + pager + "'"
$ WC "patchlevel='" + patchlevel + "'"
$ WC "path_sep='|'"
$ WC "perl_root='" + perl_root + "'" ! VMS specific $trnlnm()
$ WC "perladmin='" + perladmin + "'"
$ WC "perllibs='" + perllibs + "'"
$ WC "perlpath='" + "''vms_prefix':[000000]Perl''exe_ext'" + "'"
$ WC "perl_symbol='" + perl_symbol + "'"  ! VMS specific
$ WC "perl_verb='" + perl_verb + "'"      ! VMS specific
$ WC "pgflquota='" + pgflquota + "'"
$ WC "pidtype='" + pidtype + "'"
$ WC "prefix='" + vms_prefix + "'"
$ WC "prefixexp='" + vms_prefix + ":'"
$ WC "privlib='" + privlib + "'"
$ WC "privlibexp='" + privlibexp + "'"
$ WC "procselfexe=' '"
$ WC "prototype='define'"
$ WC "ptrsize='" + ptrsize + "'"
$ WC "quadkind='" + quadkind + "'"
$ WC "quadtype='" + quadtype + "'" 
$ WC "randbits='" + randbits + "'"
$ WC "randfunc='" + randfunc + "'"
$ WC "randseedtype='" + randseedtype + "'"
$ WC "ranlib='" + "'"
$ WC "rd_nodata=' '"
$ WC "revision='" + revision + "'"
$ WC "sPRId64='" + sPRId64 + "'"
$ WC "sPRIEldbl='" + sPRIEUldbl + "'"
$ WC "sPRIFldbl='" + sPRIFUldbl + "'"
$ WC "sPRIGldbl='" + sPRIGUldbl + "'"
$ WC "sPRIX64='" + sPRIXU64 + "'"
$ WC "sPRIeldbl='" + sPRIeldbl + "'"
$ WC "sPRIfldbl='" + sPRIfldbl + "'"
$ WC "sPRIgldbl='" + sPRIgldbl + "'"
$! WC "sPRIi64='" + sPRIi64 + "'"
$ WC "sPRIo64='" + sPRIo64 + "'"
$ WC "sPRIu64='" + sPRIu64 + "'"
$ WC "sPRIx64='" + sPRIx64 + "'"
$ WC "sSCNfldbl='" + sSCNfldbl + "'"
$ WC "sched_yield='" + sched_yield + "'"
$ WC "scriptdir='" + scriptdir + "'"
$ WC "scriptdirexp='" + scriptdir + "'"  ! use scriptdir for now
$ WC "seedfunc='" + seedfunc + "'"
$ WC "selectminbits='32'"
$ WC "selecttype='" + selecttype + "'"
$ WC "sh='MCR'"
$ WC "shmattype='" + " '"
$ WC "shortsize='" + shortsize + "'"
$ WC "shrplib='define'"
$ IF (f$length(sig_name) .GE. 244)
$ THEN
$     tmp = "sig_name='" + sig_name + "'"
$     WC/symbol tmp
$     DELETE/SYMBOL tmp
$ ELSE
$     WC "sig_name='" + sig_name + "'"
$ ENDIF
$ IF (f$length(sig_name_init) .GE. 244)
$ THEN
$     tmp = "sig_name_init='" + sig_name_init + "'"
$     WC/symbol tmp
$     DELETE/SYMBOL tmp
$ ELSE
$     WC "sig_name_init='" + sig_name_init + "'"
$ ENDIF
$ WC "sig_num='" + sig_num + "'"
$ WC "sig_num_init='" + sig_num_init + "'"
$ WC "sig_count='" + sig_count + "'"
$ WC "sig_size='" + sig_size + "'"
$ WC "signal_t='" + signal_t + "'"
$ WC "sitearch='" + sitearch + "'"
$ WC "sitearchexp='" + sitearchexp + "'"
$ WC "sitebin='" + sitebin + "'"
$ WC "sitebinexp='" + sitebin + "'"
$ WC "sitelib='" + sitelib + "'"
$ WC "sitelib_stem='" + sitelib_stem + "'"
$ WC "sitelibexp='" + sitelibexp + "'"
$ WC "siteprefix='" + vms_prefix + "'"
$ WC "siteprefixexp='" + vms_prefix + ":'"
$ WC "sizesize='" + sizesize + "'"
$ WC "sizetype='size_t'"
$ WC "so='" + so + "'"
$ WC "socksizetype='" + socksizetype + "'"
$ WC "spitshell='write sys$output '"
$ WC "src='" + src + "'"
$ WC "ssizetype='int'"
$ WC "startperl=" + startperl ! This one's special--no enclosing single quotes
$ WC "static_ext='" + static_ext + "'"
$ WC "stdchar='" + stdchar + "'"
$ WC "stdio_base='((*fp)->_base)'"
$ WC "stdio_bufsiz='((*fp)->_cnt + (*fp)->_ptr - (*fp)->_base)'"
$ WC "stdio_cnt='((*fp)->_cnt)'"
$ WC "stdio_ptr='((*fp)->_ptr)'"
$ WC "stdio_stream_array=' " + "'"
$ WC "subversion='" + subversion + "'"
$ WC "targetarch='" + "'"
$ WC "timetype='" + timetype + "'"
$ WC "u16size='" + u16size + "'"
$ WC "u16type='" + u16type + "'"
$ WC "u32size='" + u32size + "'"
$ WC "u32type='" + u32type + "'"
$ WC "u64size='" + u64size + "'"
$ WC "u64type='" + u64type + "'"
$ WC "u8size='" + u8size + "'"
$ WC "u8type='" + u8type + "'"
$ WC "uidformat='lu'"
$ WC "uidsign='1'"
$ WC "uidsize='4'"
$ WC "uidtype='" + uidtype + "'"
$ WC "uquadtype='" + uquadtype + "'" 
$ WC "use5005threads='" + use5005threads + "'"
$ WC "use64bitall='" + use64bitall + "'"
$ WC "use64bitint='" + use64bitint + "'"
$ WC "usecasesensitive='" + be_case_sensitive + "'"    ! VMS-specific
$ WC "usedebugging_perl='"+use_debugging_perl+"'"
$ WC "usedefaulttypes='" + usedefaulttypes + "'"    ! VMS-specific
$ WC "usecrosscompile='undef'"
$ WC "usedl='" + usedl + "'"
$ WC "usefaststdio='" + usefaststdio + "'"
$ WC "useieee='" + useieee + "'"                    ! VMS-specific
$ WC "useithreads='" + useithreads + "'"
$ WC "usekernelthreads='" + usekernelthreads + "'"	! VMS-specific
$ WC "uselargefiles='" + uselargefiles + "'"
$ WC "uselongdouble='" + uselongdouble + "'"
$ WC "usemorebits='" + usemorebits + "'"
$ WC "usemultiplicity='" + usemultiplicity + "'"
$ WC "usemymalloc='" + usemymalloc + "'"
$ WC "useperlio='" + useperlio + "'"
$ WC "useposix='false'"
$ WC "usereentrant='undef'"
$ WC "userelocatableinc='undef'"
$ WC "usesecurelog='" + usesecurelog + "'"  ! VMS-specific
$ WC "usesitecustomize='" + usesitecustomize + "'"
$ WC "usesocks='undef'"
$ WC "usethreads='" + usethreads + "'"
$ WC "usethreadupcalls='" + usethreadupcalls + "'"	! VMS-specific
$ WC "usevendorprefix='" + "'" ! try to say no, though we'll be ignored as of MM 5.90_01
$ WC "usevfork='true'"
$ WC "usevmsdebug='" + usevmsdebug + "'"     ! VMS-specific
$ WC "uvoformat='" + uvoformat + "'"
$ WC "uvsize='" + uvsize + "'"
$ WC "uvtype='" + uvtype + "'"
$ WC "uvuformat='" + uvuformat + "'"
$ WC "uvxformat='" + uvxformat + "'"
$ WC "uvXUformat='" + uvXUformat + "'"
$ WC "vendorarch='" + "'"
$ WC "vendorarchexp='" + "'"
$ WC "vendorbin='" + "'"
$ WC "vendorbinexp='" + "'"
$ WC "vendorlib_stem='" + "'"
$ WC "vendorlib='" + "'"
$ WC "vendorlibexp='" + "'"
$ WC "vendorprefix='" + "'"
$ WC "vendorprefixexp='" + "'"
$ WC "version='" + version + "'"
$ WC "version_patchlevel_string='" + version_patchlevel_string + "'"
$ WC "vms_cc_type='" + vms_cc_type + "'" ! VMS specific
$ WC "vms_prefix='" + vms_prefix + "'" ! VMS specific
$ WC "vms_ver='" + vms_ver + "'" ! VMS specific
$ WC "voidflags='15'"
$!
$! ## The UNIXy POSIXy reentrantey thingys ##
$! See "Appendix B, Version-Dependency Tables" in the C RTL
$! manual for when assorted _r functions became available.
$!
$ IF use_threads .AND. vms_ver .GES. "7.2"
$ THEN
$   WC "asctime_r_proto='REENTRANT_PROTO_B_SB'"
$   WC "d_asctime_r='define'"
$   WC "ctime_r_proto='REENTRANT_PROTO_B_SB'"
$   WC "d_ctime_r='define'"
$ ELSE
$   WC "asctime_r_proto='0'"
$   WC "d_asctime_r='undef'"
$   WC "ctime_r_proto='0'"
$   WC "d_ctime_r='undef'"
$ ENDIF
$ WC "d_crypt_r='undef'"
$ WC "d_ctermid_r='undef'"
$ WC "d_drand48_r='undef'"
$ WC "d_endgrent_r='undef'"
$ WC "d_endhostent_r='undef'"
$ WC "d_endnetent_r='undef'"
$ WC "d_endprotoent_r='undef'"
$ WC "d_endpwent_r='undef'"
$ WC "d_endservent_r='undef'"
$ WC "d_getgrent_r='undef'"
$ WC "d_getgrgid_r='" + d_getgrgid_r + "'"
$ WC "d_getgrnam_r='" + d_getgrnam_r + "'"
$ WC "d_gethostbyaddr_r='undef'"
$ WC "d_gethostbyname_r='undef'"
$ WC "d_gethostent_r='undef'"
$ WC "d_getlogin_r='undef'"
$ WC "d_getnetbyaddr_r='undef'"
$ WC "d_getnetbyname_r='undef'"
$ WC "d_getnetent_r='undef'"
$ WC "d_getprotobyname_r='undef'"
$ WC "d_getprotobynumber_r='undef'"
$ WC "d_getprotoent_r='undef'"
$ WC "d_getpwent_r='undef'"
$ WC "d_getpwnam_r='" + d_getpwnam_r + "'"
$ WC "d_getpwuid_r='" + d_getpwuid_r + "'"
$ WC "d_getservbyname_r='undef'"
$ WC "d_getservbyport_r='undef'"
$ WC "d_getservent_r='undef'"
$ WC "d_getspnam_r='undef'"
$ WC "d_gmtime_r='undef'"      ! leave undef'd; we use my_gmtime
$ WC "d_localtime_r='undef'"   ! leave undef'd; we use my_localtime
$ WC "d_localtime_r_needs_tzset='undef'"
$ WC "d_random_r='undef'"
$ WC "d_readdir_r='define'"	! always defined; we roll our own
$ WC "d_readdir64_r='undef'"
$ WC "d_setgrent_r='undef'"
$ WC "d_sethostent_r='undef'"
$ WC "d_setlocale_r='undef'"
$ WC "d_setnetent_r='undef'"
$ WC "d_setprotoent_r='undef'"
$ WC "d_setpwent_r='undef'"
$ WC "d_setservent_r='undef'"
$ WC "d_snprintf='" + d_snprintf + "'"
$ WC "d_srand48_r='undef'"
$ WC "d_srandom_r='undef'"
$ WC "d_strerror_r='undef'"
$ WC "d_tmpnam_r='undef'"
$ WC "d_ttyname_r='" + d_ttyname_r + "'"
$ WC "ctermid_r_proto='0'"
$ WC "crypt_r_proto='0'"
$ WC "drand48_r_proto='0'"
$ WC "endgrent_r_proto='0'"
$ WC "endhostent_r_proto='0'"
$ WC "endnetent_r_proto='0'"
$ WC "endprotoent_r_proto='0'"
$ WC "endpwent_r_proto='0'"
$ WC "endservent_r_proto='0'"
$ WC "getgrent_r_proto='0'"
$ WC "getgrgid_r_proto='" + getgrgid_r_proto + "'"
$ WC "getgrnam_r_proto='" + getgrnam_r_proto + "'"
$ WC "gethostbyaddr_r_proto='0'"
$ WC "gethostbyname_r_proto='0'"
$ WC "gethostent_r_proto='0'"
$ WC "getlogin_r_proto='0'"
$ WC "getnetbyaddr_r_proto='0'"
$ WC "getnetbyname_r_proto='0'"
$ WC "getnetent_r_proto='0'"
$ WC "getprotobyname_r_proto='0'"
$ WC "getprotobynumber_r_proto='0'"
$ WC "getprotoent_r_proto='0'"
$ WC "getpwent_r_proto='0'"
$ WC "getpwnam_r_proto='0'"
$ WC "getpwuid_r_proto='0'"
$ WC "getservbyname_r_proto='0'"
$ WC "getservbyport_r_proto='0'"
$ WC "getservent_r_proto='0'"
$ WC "getspnam_r_proto='0'"
$ WC "gmtime_r_proto='0'"
$ WC "localtime_r_proto='0'"
$ WC "random_r_proto='0'"
$ WC "readdir_r_proto='REENTRANT_PROTO_I_TSR'"  ! always defined; we roll our own
$ WC "readdir64_r_proto='0'"
$ WC "setgrent_r_proto='0'"
$ WC "sethostent_r_proto='0'"
$ WC "setlocale_r_proto='0'"
$ WC "setnetent_r_proto='0'"
$ WC "setprotoent_r_proto='0'"
$ WC "setpwent_r_proto='0'"
$ WC "setservent_r_proto='0'"
$ WC "srand48_r_proto='0'"
$ WC "srandom_r_proto='0'"
$ WC "strerror_r_proto='0'"
$ WC "tmpnam_r_proto='0'"
$ WC "ttyname_r_proto='" + ttyname_r_proto + "'"
$!
$! ##END WRITE NEW CONSTANTS HERE##
$!
$ CLOSE CONFIG
$!
$! Okay, we've gotten here. Build munchconfig.exe
$ COPY/NOLOG [-.vms]munchconfig.c []
$ COPY/NOLOG [-.vms]'Makefile_SH' []
$ 'Perl_CC' munchconfig.c
$ IF Needs_Opt
$ THEN
$   OPEN/WRITE CONFIG []munchconfig.opt
$   IF ccname .EQS. "GCC"
$   THEN
$     WRITE CONFIG "Gnu_CC:[000000]gcclib.olb/library"
$   ENDIF
$   WRITE CONFIG "Sys$Share:VAXCRTL/Share"
$   CLOSE CONFIG
$   'ld' munchconfig.obj,munchconfig.opt/opt
$   DELETE/NOLOG/NOCONFIRM munchconfig.opt;
$ ELSE
$   'ld' munchconfig.obj
$ ENDIF
$ IF F$SEARCH("munchconfig.obj") .NES. "" THEN DELETE/NOLOG/NOCONFIRM munchconfig.obj;
$ IF F$SEARCH("munchconfig.c") .NES. "" THEN DELETE/NOLOG/NOCONFIRM munchconfig.c;
$ IF ccname .EQS. "CXX"
$ THEN
$   CALL Cxx_demangler_cleanup
$ ENDIF
$!
$ IF alldone .EQS. ""
$ THEN
$   cat4 SYS$INPUT:
$   DECK

If you'd like to make any changes to the config.sh file before I begin
to configure things, answer yes to the following question.

$   EOD
$   bool_dflt="n"
$   rp="Do you wish to edit ''basename_config_sh'? [''bool_dflt'] "
$   GOSUB myread
$   IF ans
$   THEN
$     echo4 ""
$     echo4 "Be sure to type LOGOUT after you have edited the file,"
$     echo4 "then this procedure will resume."
$     echo4 ""
$     default = F$ENVIRONMENT("DEFAULT")
$     DIRECTORY 'config_sh'
$     SET DEFAULT [-]
$     SPAWN/WAIT
$     SET DEFAULT 'default'
$   ENDIF
$ ENDIF
$!
$ echo ""
$ echo4 "Adding ''osname' specific preprocessor commands."
$ !
$ ! we need an fdl file
$ CREATE [-]CONFIG.FDL
$ DECK
RECORD
  FORMAT STREAM_LF
$ EOD
$ CREATE /FDL=[-]CONFIG.FDL [-]CONFIG.LOCAL
$ ! First spit out the header info with the local defines (to get
$ ! around the 255 character command line limit)
$ OPEN/APPEND CONFIG [-]config.local
$ IF use_debugging_perl THEN WC "#define DEBUGGING"
$ IF use_two_pot_malloc THEN WC "#define TWO_POT_OPTIMIZE"
$ IF mymalloc THEN WC "#define EMBEDMYMALLOC"
$ IF use_pack_malloc THEN WC "#define PACK_MALLOC"
$ IF use_debugmalloc THEN WC "#define DEBUGGING_MSTATS"
$ IF ccname .EQS. "GCC" THEN WC "#define GNUC_ATTRIBUTE_CHECK"
$ IF (Has_Dec_C_Sockets)
$ THEN
$    WC "#define VMS_DO_SOCKETS"
$    WC "#define DECCRTL_SOCKETS"
$ ELSE
$    IF Has_Socketshr THEN WC "#define VMS_DO_SOCKETS"
$ ENDIF
$! This is VMS-specific for now
$ WC "#''d_setenv' HAS_SETENV"
$ IF d_secintgenv THEN WC "#define SECURE_INTERNAL_GETENV"
$ IF d_alwdeftype THEN WC "#define ALWAYS_DEFTYPES"
$ IF use64bitint .OR. use64bitint .EQS. "define"
$ THEN
$   WC "#define USE_64_BIT_INT"
$   WC "#define USE_LONG_DOUBLE"
$ ENDIF
$ IF use64bitall .OR. use64bitall .EQS. "define" THEN -
    WC "#define USE_64_BIT_ALL"
$ IF be_case_sensitive THEN WC "#define VMS_WE_ARE_CASE_SENSITIVE"
$ IF d_herrno .EQS. "undef" THEN WC "#define NEED_AN_H_ERRNO"
$ WC "#define HAS_ENVGETENV"
$ WC "#define PERL_EXTERNAL_GLOB"
$ IF archname .EQS. "VMS_VAX" .AND. -
     ccname .EQS. "DEC" .AND. -
     ccversion .LE. 50390006
$ THEN
$! Alas this does not help to build Fcntl
$!   WC "#define PERL_IGNORE_FPUSIG SIGFPE"
$ ENDIF
$ IF kill_by_sigprc .EQS. "define" then WC "#define KILL_BY_SIGPRC"
$ IF usedecterm .OR. usedecterm .EQS. "define" then WC "#define USE_VMS_DECTERM"
$ IF unlink_all_versions .OR. unlink_all_versions .EQS. "define" THEN -
    WC "#define UNLINK_ALL_VERSIONS"
$ CLOSE CONFIG
$!
$ echo4 "Doing variable substitutions on .SH files..."
$ echo4 "Extracting config.h (with variable substitutions)"
$!
$! Now build the normal config.h
$ DEFINE/USER_MODE sys$output [-]config.main
$ mcr []munchconfig 'config_sh' [-]config_h.sh
$ ! Concatenate them together
$ copy [-]config.local,[-]config.main [-]config.h
$! Clean up
$ DELETE/NOLOG/NOCONFIRM [-]CONFIG.MAIN;*
$ DELETE/NOLOG/NOCONFIRM [-]CONFIG.LOCAL;*
$ DELETE/NOLOG/NOCONFIRM [-]CONFIG.FDL;*
$!
$ IF ccname .EQS. "DEC"
$ THEN
$   DECC_REPLACE = "DECC=decc=1"
$ ELSE
$   DECC_REPLACE = "DECC="
$ ENDIF
$ IF ccname .EQS. "CXX"
$ THEN
$   DECCXX_REPLACE = "DECCXX=DECCXX=1"
$ ELSE
$   DECCXX_REPLACE = "DECCXX="
$ ENDIF
$ IF ccname .EQS. "GCC"
$ THEN
$   GNUC_REPLACE = "GNUC=gnuc=1"
$ ELSE
$   GNUC_REPLACE = "GNUC=" 
$ ENDIF
$ IF Has_Dec_C_Sockets
$ THEN
$   SOCKET_REPLACE = "SOCKET=DECC_SOCKETS=1"
$ ELSE
$   IF Has_Socketshr
$   THEN
$     SOCKET_REPLACE = "SOCKET=SOCKETSHR_SOCKETS=1"
$   ELSE
$     SOCKET_REPLACE = "SOCKET="
$   ENDIF
$ ENDIF
$ IF use_threads
$ THEN
$   IF (vms_ver .LES. "6.2")
$   THEN
$     THREAD_REPLACE = "THREAD=OLDTHREADED=1"
$   ELSE
$     THREAD_REPLACE = "THREAD=THREADED=1"
$   ENDIF
$ ELSE
$   THREAD_REPLACE = "THREAD="
$ ENDIF
$ IF mymalloc
$ THEN
$   MALLOC_REPLACE = "MALLOC=MALLOC=1"
$ ELSE
$   MALLOC_REPLACE = "MALLOC="
$ ENDIF
$ IF uselargefiles .OR. uselargefiles .EQS. "define"
$ THEN
$   IF usestdstat .or. usestdstat .eqs. "define"
$   THEN
$      LARGEFILE_REPLACE = "LARGEFILE=LARGEFILE=_USE_STD_STAT=1"
$   ELSE
$      LARGEFILE_REPLACE = "LARGEFILE=LARGEFILE=_LARGEFILE=1"
$   ENDIF
$ ELSE
$   LARGEFILE_REPLACE = "LARGEFILE="
$ ENDIF
$ IF usedecterm .OR. usedecterm .EQS. "define"
$ THEN
$   IF F$SEARCH("SYS$SHARE:DECW$TERMINALSHR12.EXE") .nes. ""
$   THEN
$      DECTERM_REPLACE = "DECTERMLIB=DECTERMLIB=DECW$TERMINALSHR12/SHARE"
$   ELSE
$      DECTERM_REPLACE = "DECTERMLIB=DECTERMLIB=DECW$TERMINALSHR/SHARE"
$   ENDIF
$ ELSE
$   DECTERM_REPLACE = "DECTERMLIB=DECTERMLIB="
$ ENDIF
$!
$! In order not to stress the tiny command buffer on pre-7.3-2 systems,
$! we put the following substitutions in a file and pass the file to
$! munchconfig.
$!
$ open/write CONFIG extra_subs.txt
$ WC := write CONFIG
$ WC "''DECC_REPLACE'"
$ WC "''DECCXX_REPLACE'"
$ WC "''ARCH_TYPE'"
$ WC "''GNUC_REPLACE'"
$ WC "''SOCKET_REPLACE'"
$ WC "''THREAD_REPLACE'"
$ WC "''C_Compiler_Replace'"
$ WC "''MALLOC_REPLACE'"
$ WC "''THREAD_UPCALLS'"
$ WC "''THREAD_KERNEL'"
$ WC "PV=''version'"
$ WC "FLAGS=FLAGS=''extra_flags'"
$ WC "''LARGEFILE_REPLACE'"
$ WC "''DECTERM_REPLACE'"
$ close CONFIG
$!
$ echo4 "Extracting ''defmakefile' (with variable substitutions)"
$ DEFINE/USER_MODE sys$output 'UUmakefile'
$ mcr []munchconfig 'config_sh' 'Makefile_SH' -f extra_subs.txt
$! Clean up after ourselves
$ DELETE/NOLOG/NOCONFIRM []munchconfig.exe;
$ DELETE/NOLOG/NOCONFIRM []extra_subs.txt;
$!
$ echo4 "Extracting make_ext.com (without variable substitutions)"
$ Create Sys$Disk:[-]make_ext.com
$ Deck/Dollar="$EndOfTpl$"
$!++ make_ext.com
$!   NOTE: This file is extracted as part of the VMS configuration process.
$!   Any changes made to it directly will be lost.  If you need to make any
$!   changes, please edit the template in Configure.Com instead.
$    mydefault = F$Environment("Default")
$!   p1 - how to invoke miniperl (passed in from descrip.mms)
$    p1 = F$Edit(p1,"Upcase,Compress,Trim")
$    If F$Locate("MCR ",p1).eq.0 Then p1 = F$Extract(3,255,p1)
$    miniperl = "$" + F$Search(F$Parse(p1,".Exe"))
$!   p2 - how to invoke local make utility (passed in from descrip.mms)
$    makeutil = p2
$    if f$type('p2') .nes. "" then makeutil = 'p2'
$!   p3 - make target (passed in from descrip.mms)
$    targ = F$Edit(p3,"Lowercase")
$    sts = 1
$    extensions = ""
$    open/read CONFIG config.sh
$ find_ext_loop:
$    read/end=end_ext_loop CONFIG line
$    if (f$extract(0,12,line) .NES. "extensions='")
$    then goto find_ext_loop
$    else extensions = f$extract(12,f$length(line),line) - "'"
$    endif
$ end_ext_loop:
$    close CONFIG
$    extensions = f$edit(extensions,"TRIM,COMPRESS")
$    i = 0
$ next_ext:
$    ext = f$element(i," ",extensions)
$    If ext .eqs. " " .or. ext .eqs. "" Then Goto done
$    Define/User_mode Perl_Env_Tables CLISYM_LOCAL
$    miniperl
$    deck
     ($extdir = $ENV{'ext'}) =~ s/::/./g;
     $extdir =~ s#/#.#g;
     if ($extdir =~ /^vms/i) { $extdir =~ s/vms/.vms.ext/i; }
     else                    { $extdir = ".ext.$extdir";   }
     ($ENV{'extdir'} = "[$extdir]");
     ($ENV{'up'} = ('-') x ($extdir =~ tr/././));
$    eod
$    Set Default &extdir
$    redesc = 0
$    If F$Locate("clean",targ) .eqs. F$Length(targ)
$    Then
$      Write Sys$Output ""
$      Write Sys$Output "	Making ''ext' (dynamic)"
$      On Error Then Goto done
$      If F$Search("Descrip.MMS") .eqs. ""
$      Then
$        redesc = 1
$      Else
$        If F$CvTime(F$File("Descrip.MMS","rdt")) .lts. -
            F$CvTime(F$File("Makefile.PL","rdt")) Then redesc = 1
$      EndIf
$    Else
$      Write Sys$Output "''targ'ing ''ext' . . ."
$      On Error Then Continue
$    EndIf
$    If redesc Then -
       miniperl "-I[''up'.lib]" Makefile.PL "INST_LIB=[''up'.lib]" "INST_ARCHLIB=[''up'.lib]"  "PERL_CORE=1"
$    makeutil 'targ'
$    i = i + 1
$    Set Def &mydefault
$    Goto next_ext
$ done:
$    sts = $Status
$    Set Def &def
$    Exit sts
$!-- make_ext.com
$EndOfTpl$
$!
$! Note that the /key qualifier to search, as in:
$! search README.* "=head"/key=(position=1)/window=0/output=extra.pods
$! is not supported on VMS V5.5-2, hence not used in extra_pods.com.
$!
$ echo4 "Extracting extra_pods.com (without variable substitutions)"
$ Create Sys$Disk:[-]extra_pods.com
$ Deck/Dollar="$EOExtra_Pods$"
$!++ extra_pods.com
$!   NOTE: This file is extracted as part of the VMS configuration process.
$!   Any changes made to it directly will be lost.  If you need to make any
$!   changes, please edit the template in Configure.Com instead.
$!   Use FORCE if you've just podified a README.* file on VMS.
$ if f$search("extra.pods") .eqs. "" .or. P1 .eqs. "FORCE" then -
    search README.* "=head"/window=0/output=extra.pods
$ open/read/error=extra_close EXTRA extra.pods
$extra_loop:
$ read/error=extra_close/END_OF_FILE=extra_close EXTRA file
$ file_type = f$edit(f$parse(file,,,"TYPE",),"LOWERCASE") - "."
$ if file_type .nes. "VMS" .and. file_type .nes. "vms"
$ then
$   pod_file = "[.pod]perl''file_type'.pod"
$   file = file - "''f$parse(file,,,"VERSION",)'"
$   if p1 .eqs. "CLEAN"
$   then if f$search(pod_file) .nes. "" then delete/log 'pod_file';*
$   else
$     do_copy := false
$     if f$search(pod_file) .eqs. ""
$     then do_copy := true
$     else
$       file_rdt = f$cvtime(f$file_attributes(file,"RDT"))
$       pod_file_rdt = f$cvtime(f$file_attributes(pod_file,"RDT"))
$       if file_rdt .GTS. pod_file_rdt then do_copy := true
$     endif
$     ! wacky method to preserve case on ODS-5 even when parse style is traditional
$     if do_copy then mcr sys$disk:[]miniperl.exe -e "exit 0+$^E unless File::Copy::rmscopy(q{''file'}, q{''pod_file'});"
$   endif
$ endif
$ goto extra_loop
$extra_close:
$ close EXTRA
$ if p1 .eqs. "CLEAN" .and. f$search("extra.pods;-1") .nes. "" then -
    purge/nolog extra.pods
$!-- extra_pods.com
$EOExtra_Pods$
$!
$!  Warn of dangerous symbols or logical names
$!
$Bad_environment: SUBROUTINE
$   Bad_env = ""
$   IF p2 .eqs. "SYMBOL"
$   THEN
$     IF f$type('p1') .nes. "" THEN  Bad_env := SYMBOL
$   ELSE
$     IF f$trnlnm(p1) .nes. "" THEN Bad_env := LOGICAL
$   ENDIF
$   IF Bad_env .eqs. "SYMBOL" .or. Bad_env .eqs. "LOGICAL"
$   THEN
$     IF f$search("config.msg") .nes. ""
$     THEN
$       OPEN/APPEND CONFIG config.msg
$     ELSE
$       OPEN/WRITE CONFIG config.msg
$     ENDIF
$     IF Bad_env .eqs. "SYMBOL"
$     THEN
$       WRITE CONFIG ""
$       WRITE CONFIG "Symbol name ''p1' found in environment as " + &p1
$       WRITE CONFIG " delete before building ''package' via:"
$       WRITE CONFIG "     $ DELETE/SYMBOL/GLOBAL ''p1'"
$       IF f$locate("""",&p1) .ge. f$length(&p1)
$       THEN
$       WRITE CONFIG " after building, testing, and installing ''package'"
$       WRITE CONFIG " restore the symbol with:"
$       WRITE CONFIG "     $ ''p1' == """ + &p1 + """"
$       ENDIF
$     ENDIF
$     IF Bad_env .eqs. "LOGICAL"
$     THEN
$       WRITE CONFIG ""
$       WRITE CONFIG "Logical name ''p1' found in environment as " + f$trnlnm(p1)
$       WRITE CONFIG " deassign before building ''package'"
$     ENDIF
$     CLOSE CONFIG
$     Bad_env = ""
$   ENDIF
$ EXIT
$ ENDSUBROUTINE ! Bad_environment
$ echo ""
$ echo4 "Checking for dangerous pre-existing global symbols and logical names."
$ CALL Bad_environment "COMP"
$ CALL Bad_environment "EXT"
$ CALL Bad_environment "FOO"
$ CALL Bad_environment "LIB"
$ CALL Bad_environment "LIST"
$ CALL Bad_environment "MIME"
$ CALL Bad_environment "POSIX"
$ CALL Bad_environment "SYS"
$ CALL Bad_environment "T"
$ CALL Bad_environment "THREAD"
$ CALL Bad_environment "THREADS"
$ CALL Bad_environment "TIME"
$ CALL Bad_environment "TMP"
$ CALL Bad_environment "UNICODE"
$ CALL Bad_environment "UTIL"
$ CALL Bad_environment "TEST" "SYMBOL"
$ IF f$search("config.msg") .eqs. "" THEN echo "OK."
$!
$! %Config-I-VMS, write perl_setup.com here
$!
$ IF (.NOT.perl_symbol)
$ THEN
$   file_2_find = "[-]''packageup'.cld"
$   echo ""
$   echo4 "The perl.cld file is now being written..."
$   OPEN/WRITE CONFIG 'file_2_find'
$   ext = ".exe"
$   IF (sharedperl .AND. F$EXTRACT(0,7,archname) .EQS. "VMS_AXP") THEN ext := .AXE
$   IF (sharedperl .AND. F$EXTRACT(0,8,archname) .EQS. "VMS_IA64") THEN ext := .IXE
$   IF (use_vmsdebug_perl)
$   THEN
$     WRITE CONFIG "define verb dbgperl"
$     WRITE CONFIG F$FAO("!_!AS","image ''vms_prefix':[000000]dbgperl''ext'")
$     WRITE CONFIG F$FAO("!_!AS","cliflags (foreign)")
$     WRITE CONFIG ""
$     WRITE CONFIG "define verb perl"
$     WRITE CONFIG F$FAO("!_!AS","image ''vms_prefix':[000000]ndbgPerl''ext'")
$     WRITE CONFIG F$FAO("!_!AS","cliflags (foreign)")
$   ELSE
$     WRITE CONFIG "define verb perl"
$     WRITE CONFIG F$FAO("!_!AS","image ''vms_prefix':[000000]perl''ext'")
$     WRITE CONFIG F$FAO("!_!AS","cliflags (foreign)")
$   ENDIF
$   CLOSE CONFIG
$ ENDIF ! (.NOT.perl_symbol)
$ echo ""
$ echo4 "The perl_setup.com file is now being written..."
$ file_2_find = "[-]perl_setup.com"
$!
$! Folks are likely to want to edit perl_setup.com.
$! STMLF RFM plays nicer with ported editors than does VFC.
$!
$ CREATE [-]CONFIG.FDL
$ DECK
RECORD
  FORMAT STREAM_LF
$ EOD
$ CREATE /FDL=[-]CONFIG.FDL 'file_2_find'
$ OPEN/APPEND CONFIG 'file_2_find'
$ DELETE/NOLOG/NOCONFIRM [-]CONFIG.FDL;
$ WRITE CONFIG "$!"
$ WRITE CONFIG "$! Perl_Setup.com    ''cf_time'"
$ IF cf_email.NES.perladmin
$ THEN
$ WRITE CONFIG "$! perl configured by ''cf_email'"
$ ELSE
$ WRITE CONFIG "$! This perl configured & administered by ''perladmin'"
$ ENDIF
$ WRITE CONFIG "$!"
$! HP hack to make distributing binaries easier
$!----------------------------------------------
$ pcsi_producer = f$trnlnm("PCSI_PRODUCER")
$ if pcsi_producer .eqs. ""
$ then
$   WRITE CONFIG "$ define/translation=concealed ''vms_prefix' ''prefix'"
$ else
$  WRITE CONFIG "$ myproc = f$environment(""PROCEDURE"")"
$  WRITE CONFIG "$ myroot_dev = f$parse(myproc,,,""DEVICE"",""NO_CONCEAL"")"
$  WRITE CONFIG "$ myroot_dir = f$parse(myproc,,,""DIRECTORY"",""NO_CONCEAL"")"
$  WRITE CONFIG "$ myroot_dir = myroot_dir - ""][000000."" - ""><000000."""
$  WRITE CONFIG "$ myroot_dir = myroot_dir - ""][000000]"" - ""><000000>"""
$  WRITE CONFIG "$ myroot_dir = myroot_dir - ""]["" - ""><"""
$  WRITE CONFIG "$ myroot_dir = myroot_dir - "".]"" - "".>"" - ""["" - ""]"" - ""<"" - "">"""
$  WRITE CONFIG "$ if f$trnlnm(""HP_BUILD_PERL_BIN_KIT"",""LNM$PROCESS_TABLE"") .EQS. """""
$  WRITE CONFIG "$ then"
$  WRITE CONFIG "$  define/translation=concealed ''vms_prefix' 'myroot_dev'['myroot_dir'.]"
$  WRITE CONFIG "$ endif"
$ endif
$ WRITE CONFIG "$ ext = "".exe"""
$ IF sharedperl
$ THEN
$ WRITE CONFIG "$ if f$getsyi(""ARCH_TYPE"") .eq. 2 then ext = "".AXE"""
$ WRITE CONFIG "$ if f$getsyi(""ARCH_TYPE"") .eq. 3 then ext = "".IXE"""
$ ENDIF
$ IF (perl_symbol)
$ THEN
$   perl_setup_perl = "'" + "'perl'" ! triple quoted foreign command symbol
$   IF (use_vmsdebug_perl)
$   THEN
$     WRITE CONFIG "$ dbgperl :== $''vms_prefix':[000000]dbgperl'ext'"
$     WRITE CONFIG "$ perl    :== $''vms_prefix':[000000]ndbgperl'ext'"
$     WRITE CONFIG "$ define dbgperlshr ''vms_prefix':[000000]dbgperlshr'ext'"
$   ELSE
$     WRITE CONFIG "$ perl :== $''vms_prefix':[000000]Perl'ext'"
$     WRITE CONFIG "$ define perlshr ''vms_prefix':[000000]perlshr'ext'"
$   ENDIF
$ ELSE ! .NOT.perl_symbol
$   perl_setup_perl = "perl" ! command verb
$   IF (use_vmsdebug_perl)
$   THEN
$     WRITE CONFIG "$ define dbgperlshr ''vms_prefix':[000000]dbgperlshr'ext'"
$   ELSE
$     WRITE CONFIG "$ define perlshr ''vms_prefix':[000000]perlshr'ext'"
$   ENDIF
$   IF perl_verb .EQS. "PROCESS"
$   THEN
$     WRITE CONFIG "$ set command ''vms_prefix':[000000]''packageup'.CLD"
$   ENDIF
$ ENDIF !  perl_symbol
$!
$ IF (tzneedset)
$ THEN
$ WRITE CONFIG "$ define SYS$TIMEZONE_DIFFERENTIAL ''tzd'"
$ ELSE    !leave in but commented out (in case setting was from perl :-)
$ WRITE CONFIG "$! define SYS$TIMEZONE_DIFFERENTIAL ''tzd'"
$ ENDIF
$ WRITE CONFIG "$!"
$ WRITE CONFIG "$! Symbols for commonly used programs:"
$ WRITE CONFIG "$!"
$ WRITE CONFIG "$ c2ph       == """ + perl_setup_perl + " ''vms_prefix':[utils]c2ph.com"""
$ WRITE CONFIG "$ cpan       == """ + perl_setup_perl + " ''vms_prefix':[utils]cpan.com"""
$ IF F$LOCATE("Devel::DProf",extensions) .LT. F$LENGTH(extensions)
$ THEN
$ WRITE CONFIG "$ dprofpp    == """ + perl_setup_perl + " ''vms_prefix':[utils]dprofpp.com"""
$ ENDIF 
$ WRITE CONFIG "$ enc2xs     == """ + perl_setup_perl + " ''vms_prefix':[utils]enc2xs.com"""
$ WRITE CONFIG "$ find2perl  == """ + perl_setup_perl + " ''vms_prefix':[utils]find2perl.com"""
$ WRITE CONFIG "$ h2ph       == """ + perl_setup_perl + " ''vms_prefix':[utils]h2ph.com"""
$ WRITE CONFIG "$ h2xs       == """ + perl_setup_perl + " ''vms_prefix':[utils]h2xs.com"""
$ WRITE CONFIG "$ instmodsh  == """ + perl_setup_perl + " ''vms_prefix':[utils]instmodsh.com"""
$ WRITE CONFIG "$ libnetcfg  == """ + perl_setup_perl + " ''vms_prefix':[utils]libnetcfg.com"""
$ WRITE CONFIG "$ perlbug    == """ + perl_setup_perl + " ''vms_prefix':[utils]perlbug.com"""
$ WRITE CONFIG "$ perldoc    == """ + perl_setup_perl + " ''vms_prefix':[utils]perldoc.com """"-t"""""""
$ WRITE CONFIG "$ perlivp    == """ + perl_setup_perl + " ''vms_prefix':[utils]perlivp.com"""
$ WRITE CONFIG "$ piconv     == """ + perl_setup_perl + " ''vms_prefix':[utils]piconv.com"""
$ WRITE CONFIG "$ pl2pm      == """ + perl_setup_perl + " ''vms_prefix':[utils]pl2pm.com"""
$ WRITE CONFIG "$ pod2html   == """ + perl_setup_perl + " ''vms_prefix':[utils]pod2html.com"""
$ WRITE CONFIG "$ pod2latex  == """ + perl_setup_perl + " ''vms_prefix':[utils]pod2latex.com"""
$ WRITE CONFIG "$ pod2text   == """ + perl_setup_perl + " ''vms_prefix':[utils]pod2text.com"""
$ WRITE CONFIG "$!pod2man    == """ + perl_setup_perl + " ''vms_prefix':[utils]pod2man.com"""
$ WRITE CONFIG "$ pod2usage  == """ + perl_setup_perl + " ''vms_prefix':[utils]pod2usage.com"""
$ WRITE CONFIG "$ podchecker == """ + perl_setup_perl + " ''vms_prefix':[utils]podchecker.com"""
$ WRITE CONFIG "$ podselect  == """ + perl_setup_perl + " ''vms_prefix':[utils]podselect.com"""
$ WRITE CONFIG "$ prove      == """ + perl_setup_perl + " ''vms_prefix':[utils]prove.com"""
$ WRITE CONFIG "$ psed       == """ + perl_setup_perl + " ''vms_prefix':[utils]psed.com"""
$ WRITE CONFIG "$ pstruct    == """ + perl_setup_perl + " ''vms_prefix':[utils]pstruct.com"""
$ WRITE CONFIG "$ s2p        == """ + perl_setup_perl + " ''vms_prefix':[utils]s2p.com"""
$ WRITE CONFIG "$ splain     == """ + perl_setup_perl + " ''vms_prefix':[utils]splain.com"""
$ WRITE CONFIG "$ xsubpp     == """ + perl_setup_perl + " ''vms_prefix':[utils]xsubpp.com"""
$ CLOSE CONFIG
$!
$ echo  ""
$ echo  "The file can be found at:"
$ echo4 "    ''F$SEARCH(file_2_find)'"
$ echo  "Add that file (or an @ call to it) to your [SY]LOGIN.COM"
$ echo  "when you are satisfied with a successful compilation,"
$ echo  "testing, and installation of your perl."
$ echo  ""
$ IF ((.NOT.perl_symbol) .AND. (perl_verb .EQS. "DCLTABLES"))
$ THEN
$   file_2_find = "[-]''packageup'_install.com"
$   OPEN/WRITE CONFIG 'file_2_find'
$   WRITE CONFIG "$ set command perl /table=sys$common:[syslib]dcltables.exe -"
$   WRITE CONFIG "    /output=sys$common:[syslib]dcltables.exe"
$   WRITE CONFIG "$ install replace sys$common:[syslib]dcltables.exe"
$   CLOSE CONFIG
$   echo4 ""
$   echo4 "In order to install the ''packageup' verb into DCLTABLES run:"
$   echo4 "    @ ''F$SEARCH(file_2_find)'"
$   echo4 "after a successful build, test, and install.  Do so with CMKRNL privilege."
$   echo4 ""
$ ENDIF
$!
$!figure out where we "are" by parsing 'vms_default_directory_name' 
$!
$ set_def_command = ""
$ dflt = F$ENVIRONMENT("DEFAULT") - ".UU]" 
$ tmp = vms_default_directory_name - dflt - "]"
$ i = 0
$ IF tmp .EQS. "" THEN GOTO Beyond_set_def_loop
$Set_def_loop:
$ tmp1 = F$ELEMENT(i,".",tmp)
$ IF tmp1 .EQS. "." THEN GOTO Beyond_set_def_loop
$ IF i .EQ. 0 
$ THEN set_def_command = "set default [-"
$ ELSE set_def_command = set_def_command + "-"
$ ENDIF
$ i = i + 1
$ GOTO Set_def_loop
$Beyond_set_def_loop:
$ IF set_def_command.NES.""
$ THEN
$   set_def_command = set_def_command - "-" + "]"
$   echo4 ""
$   echo4 "In order to build ''package' you must now issue the commands:"
$   echo4 ""
$   echo4 " ''set_def_command'"
$ ELSE
$   echo4 ""
$   echo4 "In order to build ''package' you must now issue the command:"
$   echo4 ""
$ ENDIF
$ echo4 " ''make'''makefile'", macros
$ echo4 ""
$!
$ IF ( F$SEARCH("config.msg").NES."" ) 
$ THEN
$   echo4 "Hmm.  I also noted the following information while running:"
$   echo4 ""
$   TYPE/OUTPUT=SYS$ERROR: config.msg
$   SET PROTECTION=(SYSTEM:RWED,OWNER:RWED) config.msg
$   DELETE/NOLOG/NOCONFIRM config.msg;
$ ENDIF
$!
$Clean_up:
$ SET NOON
$ IF (silent)
$ THEN
$   CLOSE/NOLOG STDOUT
$   DEASSIGN SYS$OUTPUT
$ ENDIF
$ CLOSE/NOLOG CONFIG
$ IF F$GETJPI("","FILCNT").GT.vms_filcnt
$ THEN WRITE SYS$ERROR "%Config-W-VMS, WARNING: There is a file still open"
$ ENDIF
$ dflt = F$ENVIRONMENT("DEFAULT")
$ IF F$LOCATE("UU]",dflt).EQS.(F$LENGTH(dflt)-3)
$ THEN
$   IF ( F$SEARCH("[]*.*").NES."" ) THEN DELETE/NOLOG/NOCONFIRM []*.*;*
$   SET DEFAULT [-]
$   SET PROTECTION=(SYSTEM:RWED,OWNER:RWED) UU.DIR
$   DELETE/NOLOG/NOCONFIRM UU.DIR;
$ ENDIF
$ SET DEFAULT 'vms_default_directory_name' !be kind rewind
$ EXIT
$!: End of Configure
