package Devel::BindPP;
use strict;
use warnings;
use 5.008005;
our $VERSION = '0.03_01';
use File::ShareDir ':ALL';
use File::Copy;
use XSLoader;

XSLoader::load(__PACKAGE__, $VERSION);

sub WriteFile {
    my $no_ppport = shift || undef;
    copy(dist_file('Devel-BindPP', 'bindpp.h'), 'bindpp.h');
    unless ($no_ppport) {
        copy(dist_file('Devel-BindPP', 'ppport.h'), 'ppport.h');
    }
}

1;
__END__

=head1 NAME

Devel::BindPP - bind c++ to perl

=head1 SYNOPSIS

    // generate ppport.h & bindpp.h
    perl -e 'use Devel::BindPP; Devel::BindPP::WriteFile()'

    //// and write your c++ module
    #include "bindpp.h"

    XS(xs_new) {
        pl::Ctx c;

        char *self;
        Newx(self, 3, char);
        strcpy(self, "ok");

        pl::Pointer obj((void*)self, "MyOwnExt");
        c.ret(&obj);
    }

    XS(xs_get) {
        pl::Ctx c;

        pl::Pointer * p = c.arg(0)->as_pointer();

        char *self = p->extract<char>();
        pl::Str s(self);
        c.ret(&s);
    }

    XS(xs_destroy) {
        pl::Ctx c;

        pl::Pointer * p = c.arg(0)->as_pointer();
        Safefree(p->extract<char>());
        c.ret(pl::Boolean::yes());
    }

    extern "C" {
        XS(bootstrap_Your__Package) {
            pl::BootstrapCtx bc;

            pl::Package pkg("MyOwnExt");
            pkg.add_method("new", xs_new, __FILE__);
            pkg.add_method("get", xs_get, __FILE__);
            pkg.add_method("DESTROY", xs_destroy, __FILE__);
        }
    };

=head1 CAUTION

THIS MODULE IS ITS IN BETA QUALITY. API MAY CHANGE IN THE FUTURE.

=head1 DESCRIPTION

XS is too difficult for me :p XS is filled by too much C macros.

You can write perl extension by pure C++ with Devel::BindPP.

This module contains only one header file.You can include this file and write C++!

=head1 AUTHOR

Tokuhiro Matsuno E<lt>tokuhirom ah! gmail.comE<gt>

=head1 SEE ALSO

L<Devel::PPPort>, L<perl>

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
