/*
 * Decompiled with CFR 0.152.
 */
package gma.util;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ByteParser {
    private FileInputStream reader;
    private int nextByte = 0;
    private List byteList;
    private ArrayList wordList;
    private ArrayList positionList;
    private ArrayList dictFrom;
    private ArrayList dictTo;

    public ByteParser(List inList) {
        this.byteList = inList;
    }

    public String listToString() {
        StringBuffer outString = new StringBuffer();
        Iterator li = this.byteList.iterator();
        while (li.hasNext()) {
            outString.append((char)((Integer)li.next()).intValue());
        }
        return outString.toString();
    }

    public int getSize() {
        int ls = this.byteList.size();
        return ls;
    }

    public List parseDictionaryLine() {
        int c;
        int i;
        ArrayList<Integer> langList1 = new ArrayList<Integer>();
        ArrayList<Integer> langList2 = new ArrayList<Integer>();
        ArrayList<List> outList = new ArrayList<List>();
        int start = -1;
        int end = -1;
        boolean preSpace = true;
        for (i = 0; i < this.byteList.size(); ++i) {
            int cminus1;
            c = (Integer)this.byteList.get(i);
            if (c != 62 || i <= 1 || (cminus1 = ((Integer)this.byteList.get(i - 1)).intValue()) != 60) continue;
            start = i - 1;
            end = i;
        }
        if (start == -1 || end == -1) {
            System.err.println("The input file is not in the correct translation lexicon format.");
            System.exit(1);
        }
        for (i = 0; i < this.byteList.size(); ++i) {
            if (i < start) {
                c = (Integer)this.byteList.get(i);
                langList1.add(new Integer(c));
                continue;
            }
            if (i <= end) continue;
            c = (Integer)this.byteList.get(i);
            langList2.add(new Integer(c));
        }
        if (langList1.size() != 0) {
            outList.add(this.strip(langList1));
        }
        if (langList2.size() != 0) {
            outList.add(this.strip(langList2));
        }
        return outList;
    }

    public List strip(List inList) {
        ArrayList<Integer> outList = new ArrayList<Integer>();
        int start = 0;
        int end = inList.size();
        while ((Integer)inList.get(start) == 32) {
            if (++start != end) continue;
            System.err.println("The lexicon contains an invalid entry");
            return outList;
        }
        while ((Integer)inList.get(end - 1) == 32) {
            --end;
        }
        for (int i = start; i < end; ++i) {
            outList.add((Integer)inList.get(i));
        }
        return outList;
    }

    public List parseAxisLine() {
        ArrayList<Integer> positionList = new ArrayList<Integer>();
        ArrayList<Integer> wordList = new ArrayList<Integer>();
        ArrayList<List> outList = new ArrayList<List>();
        boolean preSpace = true;
        for (int i = 0; i < this.byteList.size(); ++i) {
            int c = (Integer)this.byteList.get(i);
            if (c == 32 && preSpace) {
                if (positionList.size() == 0) continue;
                preSpace = false;
                continue;
            }
            if (preSpace) {
                positionList.add(new Integer(c));
                continue;
            }
            wordList.add(new Integer(c));
        }
        if (positionList.size() != 0) {
            outList.add(this.strip(positionList));
        }
        if (wordList.size() != 0) {
            outList.add(this.strip(wordList));
        }
        return outList;
    }
}

