/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.LabelSet;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParsingException;
import org.maltparser.parser.guide.OracleGuide;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.action.GuideUserAction;
import org.maltparser.parser.history.container.ActionContainer;

public abstract class Oracle
implements OracleGuide {
    private DependencyParserConfig manager;
    private GuideUserHistory history;
    private String name;
    protected ActionContainer[] actionContainers;
    protected ActionContainer transActionContainer;
    protected ActionContainer[] arcLabelActionContainers;

    public Oracle(DependencyParserConfig manager, GuideUserHistory history) throws MaltChainedException {
        this.manager = manager;
        this.history = history;
        this.initActionContainers();
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }

    public GuideUserHistory getHistory() {
        return this.history;
    }

    public void setHistory(GuideUserHistory history) {
        this.history = history;
    }

    public DependencyParserConfig getConfiguration() {
        return this.manager;
    }

    public String getGuideName() {
        return this.name;
    }

    public void setGuideName(String guideName) {
        this.name = guideName;
    }

    protected GuideUserAction updateActionContainers(int transition, LabelSet arcLabels) throws MaltChainedException {
        int i;
        this.transActionContainer.setAction(transition);
        if (arcLabels == null) {
            for (i = 0; i < this.arcLabelActionContainers.length; ++i) {
                this.arcLabelActionContainers[i].setAction(-1);
            }
        } else {
            for (i = 0; i < this.arcLabelActionContainers.length; ++i) {
                this.arcLabelActionContainers[i].setAction(((Integer)arcLabels.get(this.arcLabelActionContainers[i].getTable())).shortValue());
            }
        }
        GuideUserAction oracleAction = this.history.getEmptyGuideUserAction();
        oracleAction.addAction(this.actionContainers);
        return oracleAction;
    }

    public void initActionContainers() throws MaltChainedException {
        this.actionContainers = this.history.getActionContainerArray();
        if (this.actionContainers.length < 1) {
            throw new ParsingException("Problem when initialize the history (sequence of actions). There are no action containers. ");
        }
        int nLabels = 0;
        for (int i = 0; i < this.actionContainers.length; ++i) {
            if (!this.actionContainers[i].getTableContainerName().startsWith("A.")) continue;
            ++nLabels;
        }
        int j = 0;
        for (int i = 0; i < this.actionContainers.length; ++i) {
            if (this.actionContainers[i].getTableContainerName().equals("T.TRANS")) {
                this.transActionContainer = this.actionContainers[i];
                continue;
            }
            if (!this.actionContainers[i].getTableContainerName().startsWith("A.")) continue;
            if (this.arcLabelActionContainers == null) {
                this.arcLabelActionContainers = new ActionContainer[nLabels];
            }
            this.arcLabelActionContainers[j++] = this.actionContainers[i];
        }
    }
}

