/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.unify;

import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.Iterator;
import java.util.Set;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.CategoryFcn;
import opennlp.common.unify.FeatureStructure;
import opennlp.common.unify.Substitution;
import opennlp.common.unify.Variable;
import opennlp.grok.expression.CategoryFcnAdapter;

public class FSCondenser {
    private TIntObjectHashMap _indicesToFeatStrucs;
    private Set _allFeatStrucs;
    private CategoryFcn fsCollector = new CategoryFcnAdapter(){

        public void forall(Category c) {
            FeatureStructure fs = c.getFeatureStructure();
            if (fs != null) {
                FSCondenser.this._allFeatStrucs.add(fs);
                int index = fs.getIndex();
                if (index > 0) {
                    FSCondenser.this._indicesToFeatStrucs.put(index, (Object)fs);
                }
            }
        }
    };

    public void condense(Substitution sub) {
        this._indicesToFeatStrucs = new TIntObjectHashMap();
        this._allFeatStrucs = new THashSet();
        Iterator subIt = sub.varIterator();
        while (subIt.hasNext()) {
            Object val = sub.getValue((Variable)subIt.next());
            if (!(val instanceof Category)) continue;
            ((Category)val).forall(this.fsCollector);
        }
        Iterator fsIt = this._allFeatStrucs.iterator();
        while (fsIt.hasNext()) {
            FeatureStructure inheritor;
            FeatureStructure fs = (FeatureStructure)fsIt.next();
            int inheritorId = fs.getInheritorIndex();
            if (inheritorId <= 0 || (inheritor = (FeatureStructure)this._indicesToFeatStrucs.get(inheritorId)) == null) continue;
            inheritor.inherit(fs);
            int id = fs.getIndex();
            if (id <= 0) continue;
            this._indicesToFeatStrucs.put(id, (Object)inheritor);
        }
        Iterator fsIt2 = this._allFeatStrucs.iterator();
        while (fsIt2.hasNext()) {
            FeatureStructure inheritor;
            FeatureStructure fs = (FeatureStructure)fsIt2.next();
            int inheritorId = fs.getInheritorIndex();
            if (inheritorId <= 0 || (inheritor = (FeatureStructure)this._indicesToFeatStrucs.get(inheritorId)) == null) continue;
            fs.setInheritorIndex(inheritor.getIndex());
        }
        this._indicesToFeatStrucs.clear();
        this._allFeatStrucs.clear();
    }

    private void printMap() {
        System.out.println("### ");
        int[] keys = this._indicesToFeatStrucs.keys();
        int i = 0;
        while (i < keys.length) {
            System.out.println(keys[i] + " => " + this._indicesToFeatStrucs.get(keys[i]));
            ++i;
        }
    }

    private void printFSs() {
        System.out.println("@@@");
        Iterator i = this._allFeatStrucs.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator fsIt = this._allFeatStrucs.iterator();
        while (fsIt.hasNext()) {
            sb.append(fsIt.next().toString()).append('\n');
        }
        return sb.toString();
    }
}

