#!/usr/bin/env perl
#-*-perl-*-
#
#

## make this a module
package ISO::639::5;

# use 5.006;
use strict;
use warnings;

use utf8;
use open ':locale';
use Pod::Usage;
# use ISO::639::3;

=head1 NAME

ISO::639::5 - Language groups

=head1 VERSION

Version 0.03

=cut

our $VERSION      = '0.03';

use Exporter 'import';
our @EXPORT = qw(
    language_group
    language_parent
    language_group_children
);
our %EXPORT_TAGS = ( all => \@EXPORT );


=head1 SYNOPSIS

    use ISO::639::5 qw/:all/;

=cut

our $LanguageGroup;
our $LanguageParent;

$LanguageGroup = {
  'gmq' => [
    'dan',
    'fao',
    'isl',
    'nno',
    'nob',
    'non',
    'nrn',
    'ovd',
    'rmg',
    'swe'
  ],
  'tup' => [
    'eme',
    'grn',
    'gui',
    'guq',
    'gyr',
    'kay',
    'kgk',
    'kpn',
    'ktn',
    'kyr',
    'mpu',
    'myu',
    'nhd',
    'psm',
    'skf',
    'srq',
    'tpj',
    'tpr',
    'tpw',
    'twt',
    'wyr',
    'yrl'
  ],
  'kar' => [
    'kvq'
  ],
  'ccn' => [
    'abk',
    'abq',
    'ady',
    'agx',
    'akv',
    'ani',
    'aqc',
    'ava',
    'bbl',
    'bdk',
    'bph',
    'che',
    'cji',
    'dar',
    'ddo',
    'gdo',
    'gin',
    'huz',
    'inh',
    'kap',
    'kbd',
    'khv',
    'kjj',
    'kpt',
    'kry',
    'kva',
    'lbe',
    'lez',
    'rut',
    'tab',
    'tin',
    'tkr',
    'uby',
    'udi'
  ],
  'alv' => [
    'aba',
    'abi',
    'abr',
    'abu',
    'ada',
    'adj',
    'agq',
    'ajg',
    'aka',
    'anw',
    'ati',
    'avi',
    'ayb',
    'azo',
    'bad',
    'bai',
    'bax',
    'bba',
    'bce',
    'bci',
    'bda',
    'beh',
    'bfd',
    'bfl',
    'bgj',
    'bim',
    'bin',
    'bju',
    'bkc',
    'bkm',
    'blo',
    'bmq',
    'bnt',
    'bqj',
    'bsc',
    'cae',
    'cou',
    'cwt',
    'dag',
    'dai',
    'dop',
    'dur',
    'dyo',
    'ebr',
    'efi',
    'ewe',
    'fap',
    'fod',
    'fon',
    'ful',
    'gaa',
    'gba',
    'gej',
    'gjn',
    'gkn',
    'goy',
    'gur',
    'gux',
    'ibo',
    'ijo',
    'jab',
    'kbp',
    'kcj',
    'kdh',
    'keu',
    'kia',
    'kma',
    'knf',
    'kqs',
    'kro',
    'krx',
    'kss',
    'kzc',
    'kzr',
    'ldm',
    'lee',
    'lmp',
    'lob',
    'mdd',
    'mfq',
    'mfv',
    'mgo',
    'mlo',
    'mnh',
    'mor',
    'mos',
    'mql',
    'mua',
    'myk',
    'mzm',
    'mzv',
    'mzw',
    'naj',
    'ndv',
    'nfr',
    'nga',
    'ngb',
    'nie',
    'nku',
    'ntm',
    'nza',
    'nzi',
    'ogc',
    'oku',
    'otr',
    'ozm',
    'pbo',
    'pbp',
    'pil',
    'pny',
    'pug',
    'sav',
    'sev',
    'shz',
    'snf',
    'soy',
    'spp',
    'srr',
    'tbz',
    'tem',
    'tfi',
    'tik',
    'tiv',
    'tkq',
    'tnr',
    'tui',
    'tuz',
    'urh',
    'wci',
    'wol',
    'wwa',
    'xsm',
    'xwe',
    'yav',
    'yky',
    'yor'
  ],
  'tut' => [
    'nog',
    'trk',
    'tuw',
    'xgn'
  ],
  'bat' => [
    'lav',
    'lit',
    'ltg',
    'ndf',
    'olt',
    'prg',
    'sgs',
    'svx',
    'sxl',
    'xcu',
    'xgl',
    'xsv',
    'xzm'
  ],
  'ath' => [
    'aht',
    'apa',
    'bcr',
    'bea',
    'caf',
    'chp',
    'clc',
    'crx',
    'den',
    'dgr',
    'gwi',
    'haa',
    'hup',
    'ing',
    'kkz',
    'koy',
    'kuu',
    'srs',
    'tau',
    'tcb',
    'tgx',
    'tht',
    'tol'
  ],
  'sqj' => [
    'aae',
    'aat',
    'aln',
    'als'
  ],
  'ine' => [
    'aln',
    'anp',
    'bat',
    'cel',
    'cms',
    'gem',
    'grk',
    'hit',
    'hlu',
    'hye',
    'iir',
    'imy',
    'itc',
    'plq',
    'scx',
    'sdt',
    'sla',
    'sqi',
    'txb',
    'txh',
    'xcl',
    'xcr',
    'xdc',
    'xlc',
    'xld',
    'xlg',
    'xls',
    'xmk',
    'xpg',
    'xps',
    'xsd',
    'xto',
    'xve'
  ],
  'mixe1284' => [
    'mco',
    'mir',
    'mto',
    'mxp',
    'mxq',
    'mzl',
    'neq',
    'plo',
    'poi',
    'poq',
    'pos',
    'pxm',
    'zoc',
    'zoh',
    'zoq',
    'zor',
    'zos'
  ],
  'map' => [
    'fox',
    'lcl',
    'lnd',
    'poz'
  ],
  'cus' => [
    'aar',
    'arv',
    'bej',
    'bji',
    'byn',
    'dal',
    'irk',
    'orc',
    'orm',
    'sid',
    'som',
    'ssn',
    'ssy'
  ],
  'cba' => [
    'bzd',
    'cbg',
    'chb',
    'kog',
    'mbp',
    'mot',
    'tuf'
  ],
  'pra' => [
    'pli',
    'san'
  ],
  'ypk' => [
    'ems',
    'ess',
    'esu',
    'ynk'
  ],
  'mun' => [
    'hoc',
    'pcj',
    'sat',
    'unr'
  ],
  'trk' => [
    'aib',
    'alt',
    'azb',
    'aze',
    'bak',
    'chg',
    'chv',
    'cjs',
    'clw',
    'crh',
    'dlg',
    'gag',
    'ili',
    'jct',
    'kaa',
    'kaz',
    'kdr',
    'kim',
    'kir',
    'kjh',
    'klj',
    'kmz',
    'krc',
    'kum',
    'ota',
    'otk',
    'qwm',
    'qxq',
    'sah',
    'slr',
    'tat',
    'tuk',
    'tur',
    'tyv',
    'uig',
    'uzb',
    'uzs',
    'xpc',
    'ybe'
  ],
  'phi' => [
    'akl',
    'bik',
    'blf',
    'bno',
    'bnq',
    'ceb',
    'cps',
    'fil',
    'gor',
    'hil',
    'ibg',
    'ibl',
    'ify',
    'ilk',
    'ilo',
    'kak',
    'krj',
    'kyj',
    'kyk',
    'loc',
    'mdh',
    'mno',
    'mog',
    'mrw',
    'msb',
    'pag',
    'pam',
    'rth',
    'sgd',
    'snl',
    'sxn',
    'tbl',
    'tdn',
    'tne',
    'tnt',
    'tnw',
    'tom',
    'txs',
    'war'
  ],
  'aql' => [
    'alg',
    'wiy',
    'yur'
  ],
  'apa' => [
    'apj',
    'apk',
    'apl',
    'apw',
    'nav'
  ],
  'cpp' => [
    'aoa',
    'cri',
    'fab',
    'kea',
    'mzs',
    'pap',
    'pov',
    'pre',
    'srm',
    'xmm'
  ],
  'tuw' => [
    'eve',
    'evn',
    'gld',
    'juc',
    'mnc',
    'neg',
    'oaa',
    'oac',
    'orh',
    'sjo',
    'ude',
    'ulc'
  ],
  'ngf' => [
    'bjz',
    'ekg',
    'uhn'
  ],
  'btk' => [
    'akb',
    'bbc',
    'btd',
    'btm',
    'bts',
    'btx',
    'btz'
  ],
  'tequ1244' => [
    'chd',
    'clo'
  ],
  'grk' => [
    'cpg',
    'ell',
    'gmy',
    'grc',
    'pnt',
    'tsd',
    'yej'
  ],
  'hyx' => [
    'axm',
    'hye',
    'hyw',
    'xcl'
  ],
  'omq' => [
    'cco',
    'coz',
    'czn',
    'ixc',
    'maj',
    'maq',
    'miz',
    'mxb',
    'oto',
    'pbs',
    'pmq',
    'pmz',
    'tpc',
    'tpl',
    'tpx',
    'trs',
    'zap',
    'zaw',
    'ztq',
    'zty'
  ],
  'qwe' => [
    'cqu',
    'inb',
    'inj',
    'qub',
    'qud',
    'quf',
    'qug',
    'quh',
    'quk',
    'qul',
    'qup',
    'qur',
    'qus',
    'quw',
    'qux',
    'quy',
    'quz',
    'qva',
    'qvc',
    'qve',
    'qvh',
    'qvi',
    'qvj',
    'qvl',
    'qvm',
    'qvn',
    'qvo',
    'qvp',
    'qvs',
    'qvw',
    'qvz',
    'qwa',
    'qwc',
    'qwh',
    'qws',
    'qxa',
    'qxc',
    'qxh',
    'qxl',
    'qxn',
    'qxo',
    'qxp',
    'qxr',
    'qxt',
    'qxu',
    'qxw'
  ],
  'cdd' => [
    'ari',
    'cad',
    'kii',
    'paw',
    'wic'
  ],
  'syd' => [
    'mtm',
    'nio',
    'sel',
    'xas',
    'yrk'
  ],
  'ccs' => [
    'kat',
    'lzz',
    'sva',
    'xmf'
  ],
  'aus' => [
    'bck',
    'dbl',
    'ddj',
    'gbu',
    'gni',
    'kdd',
    'kjn',
    'kld',
    'mep',
    'nha',
    'nuy',
    'piu',
    'pkn',
    'vma',
    'vmb',
    'wbp',
    'wmt',
    'xbp',
    'xrg',
    'yii',
    'yij'
  ],
  'pqw' => [
    'abl',
    'abs',
    'abx',
    'ban',
    'bdg',
    'bdl',
    'bdr',
    'beg',
    'bew',
    'bjn',
    'bkz',
    'bsu',
    'btk',
    'buc',
    'bug',
    'cha',
    'cia',
    'cmc',
    'day',
    'dbj',
    'drg',
    'dtr',
    'dun',
    'dup',
    'duq',
    'duw',
    'eno',
    'gay',
    'goq',
    'iba',
    'ind',
    'jav',
    'kaw',
    'kge',
    'kjc',
    'kjk',
    'kqr',
    'ktq',
    'kvr',
    'kxd',
    'kyi',
    'kys',
    'lbw',
    'lbx',
    'lce',
    'lcf',
    'ley',
    'liw',
    'ljp',
    'llk',
    'mad',
    'mak',
    'mdr',
    'mfa',
    'mfb',
    'mhy',
    'min',
    'mkm',
    'mlg',
    'mqn',
    'msa',
    'mtd',
    'mui',
    'mwv',
    'mxr',
    'myl',
    'mzq',
    'nia',
    'nij',
    'nrm',
    'otd',
    'pau',
    'pdo',
    'pel',
    'phi',
    'pku',
    'pse',
    'raz',
    'ree',
    'rej',
    'sas',
    'sda',
    'sjm',
    'skh',
    'slm',
    'sml',
    'smr',
    'smw',
    'snv',
    'ssb',
    'sse',
    'sun',
    'sya',
    'tdi',
    'tdu',
    'tdx',
    'tjg',
    'tkg',
    'tlk',
    'twy',
    'txy',
    'ulu',
    'vkl',
    'vko',
    'wow',
    'wru',
    'xkq',
    'xmv',
    'xmw',
    'xmz',
    'yka',
    'zbc',
    'zbe',
    'zbw'
  ],
  'aqa' => [
    'alc'
  ],
  'mno' => [
    'atd',
    'bgs',
    'bkd',
    'cgc',
    'mba',
    'mbb',
    'mbd',
    'mbi',
    'mbs',
    'mbt',
    'mkx',
    'mqk',
    'msm',
    'mta',
    'obo'
  ],
  'nub' => [
    'fia',
    'onw'
  ],
  'aav' => [
    'irr',
    'kdt',
    'mkh',
    'mun',
    'nyl',
    'sss',
    'tth'
  ],
  'myn' => [
    'acr',
    'agu',
    'caa',
    'cac',
    'cak',
    'ctu',
    'hus',
    'itz',
    'ixl',
    'jac',
    'kek',
    'kjb',
    'knj',
    'mam',
    'mhc',
    'mop',
    'poc',
    'poh',
    'quc',
    'qum',
    'quv',
    'toj',
    'ttc',
    'tzh',
    'tzj',
    'tzo',
    'usp',
    'yua'
  ],
  'dra' => [
    'brh',
    'gon',
    'iru',
    'kan',
    'kfa',
    'kfc',
    'kff',
    'kmj',
    'kru',
    'kxl',
    'kxu',
    'kxv',
    'mal',
    'mjt',
    'mjv',
    'muv',
    'tam',
    'tcx',
    'tcy',
    'tel'
  ],
  'ssa' => [
    'csu',
    'dzg',
    'fvr',
    'gly',
    'guk',
    'ikx',
    'kau',
    'kbl',
    'kie',
    'kmq',
    'lgn',
    'mde',
    'mls',
    'rou',
    'sdv',
    'son',
    'teu',
    'tuq',
    'udu',
    'wti',
    'xmr',
    'xom'
  ],
  'jpx' => [
    'jpn'
  ],
  'mul' => [
    'aav',
    'afa',
    'aqa',
    'aql',
    'art',
    'auf',
    'aus',
    'awd',
    'azc',
    'bih',
    'cai',
    'cau',
    'cba',
    'cdd',
    'dra',
    'egx',
    'esx',
    'euq',
    'hmx',
    'hok',
    'hyx',
    'ine',
    'iro',
    'jpx',
    'khi',
    'map',
    'myn',
    'nic',
    'omq',
    'paa',
    'qwe',
    'sal',
    'sgn',
    'sio',
    'sit',
    'sqj',
    'ssa',
    'tai',
    'tup',
    'tut',
    'urj',
    'wak',
    'xnd'
  ],
  'cai' => [
    'azc',
    'cba',
    'cuy',
    'hok',
    'hue',
    'huv',
    'hve',
    'hvv',
    'len',
    'misu1242',
    'mixe1284',
    'myn',
    'omq',
    'pua',
    'tequ1244',
    'toto1251',
    'tsz',
    'xin'
  ],
  'hmx' => [
    'bje',
    'bpn',
    'buh',
    'bwn',
    'cqd',
    'hmd',
    'hml',
    'hmn',
    'hnj',
    'ium',
    'mji',
    'mmr',
    'mww',
    'pha',
    'pnu',
    'shx'
  ],
  'zle' => [
    'bel',
    'orv',
    'rue',
    'rus',
    'ukr'
  ],
  'ngb' => [
    'sag'
  ],
  'oto' => [
    'otm'
  ],
  'euq' => [
    'eus'
  ],
  'dmn' => [
    'bam',
    'bib',
    'bqc',
    'dnj',
    'dyu',
    'goa',
    'kao',
    'knk',
    'kno',
    'knu',
    'kpe',
    'lom',
    'man',
    'men',
    'mlq',
    'moa',
    'mwk',
    'rkm',
    'snk',
    'sus',
    'vai',
    'xkg',
    'yal'
  ],
  'poz' => [
    'aol',
    'bhp',
    'end',
    'hvn',
    'ivv',
    'kei',
    'kvh',
    'mqy',
    'nxe',
    'ple',
    'plf',
    'pqe',
    'pqw',
    'ski',
    'tao',
    'xbr',
    'xxk'
  ],
  'inc' => [
    'asm',
    'awa',
    'ben',
    'bgc',
    'bhb',
    'bho',
    'bjj',
    'bkk',
    'bns',
    'bpy',
    'bra',
    'ccp',
    'ctg',
    'div',
    'dml',
    'doi',
    'emx',
    'guj',
    'gwc',
    'gwt',
    'hif',
    'hin',
    'hne',
    'kas',
    'khw',
    'kls',
    'kok',
    'lah',
    'mag',
    'mai',
    'mar',
    'mvy',
    'mwr',
    'nep',
    'ori',
    'pan',
    'phl',
    'pra',
    'raj',
    'rml',
    'rmq',
    'rmt',
    'rom',
    'scl',
    'sdg',
    'sin',
    'skr',
    'snd',
    'syl',
    'urd'
  ],
  'azc' => [
    'chl',
    'com',
    'cup',
    'hch',
    'hop',
    'lui',
    'mfy',
    'mnr',
    'nah',
    'ntp',
    'ood',
    'opt',
    'pao',
    'par',
    'pia',
    'ppl',
    'ser',
    'shh',
    'stp',
    'tac',
    'tar',
    'tla',
    'tub',
    'var',
    'xaw',
    'xgf',
    'yaq'
  ],
  'misu1242' => [
    'ccr',
    'miq',
    'mtn',
    'ulw',
    'yan'
  ],
  'nic' => [
    'alv',
    'dmn',
    'eka',
    'kdo',
    'lam',
    'nqo',
    'nyo',
    'tog',
    'znd'
  ],
  'afa' => [
    'ber',
    'bxe',
    'cdc',
    'cop',
    'cus',
    'egy',
    'omv',
    'sem',
    'zwa'
  ],
  'bih' => [
    'anp',
    'bho',
    'hif',
    'hns',
    'kra',
    'kyw',
    'mag',
    'mah',
    'mai',
    'mjz',
    'sck',
    'smm',
    'soi',
    'tdb',
    'the',
    'thl',
    'thq',
    'thr',
    'tkb',
    'tkt'
  ],
  'znd' => [
    'zne'
  ],
  'mkh' => [
    'bbh',
    'bgk',
    'blr',
    'caq',
    'cbn',
    'crv',
    'cwg',
    'huo',
    'jah',
    'jhi',
    'kha',
    'khm',
    'kjg',
    'lbn',
    'mhe',
    'mlf',
    'mml',
    'mnw',
    'mqt',
    'mra',
    'mtq',
    'ncb',
    'oyb',
    'ply',
    'prk',
    'pry',
    'rka',
    'scb',
    'sea',
    'sii',
    'tef',
    'tnz',
    'tpu',
    'tyh',
    'uuu',
    'vie',
    'vwa',
    'wbm',
    'xao',
    'xnh',
    'zng'
  ],
  'wen' => [
    'dsb',
    'hsb'
  ],
  'kdo' => [
    'acz',
    'dec',
    'eli',
    'fuj',
    'hbn',
    'iof',
    'jle',
    'kcp',
    'kcr',
    'kec',
    'kgo',
    'kib',
    'laf',
    'lmd',
    'mor',
    'otr',
    'ras',
    'shw',
    'tag',
    'taz',
    'tbr',
    'tey',
    'tic',
    'tlo',
    'tms',
    'tqr',
    'wrn',
    'xtc'
  ],
  'khi' => [
    'hts',
    'ktz',
    'kwz',
    'naq',
    'nmn',
    'sad'
  ],
  'sio' => [
    'asb',
    'bll',
    'cro',
    'dak',
    'hid',
    'iow',
    'ksk',
    'lkt',
    'mhq',
    'ofo',
    'oma',
    'osa',
    'qua',
    'sto',
    'tta',
    'win',
    'xwc'
  ],
  'ijo' => [
    'iby',
    'ijc',
    'ije',
    'ijn',
    'ijs',
    'nkx',
    'okd',
    'okr',
    'orr'
  ],
  'art' => [
    'afh',
    'avk',
    'bzt',
    'dws',
    'epo',
    'ido',
    'igs',
    'ile',
    'ina',
    'jbo',
    'ldn',
    'lfn',
    'neu',
    'nov',
    'qya',
    'rmv',
    'sjn',
    'tlh',
    'tzl',
    'vol',
    'zbl'
  ],
  'auf' => [
    'aru',
    'cul',
    'dny',
    'pad',
    'swx'
  ],
  'itc' => [
    'lat',
    'osc',
    'roa',
    'spx',
    'xfa',
    'xum'
  ],
  'fox' => [
    'bnn',
    'bzg',
    'ckv',
    'dru',
    'fos',
    'pwn',
    'pyu',
    'ssf',
    'sxr',
    'tay',
    'trv',
    'tsu',
    'uun',
    'xnb',
    'xsy'
  ],
  'awd' => [
    'aca',
    'ame',
    'apu',
    'bae',
    'brg',
    'ccc',
    'cui',
    'gob',
    'guc',
    'guh',
    'guo',
    'ign',
    'inp',
    'kpc',
    'mbn',
    'not',
    'pbg',
    'pib',
    'pio',
    'plu',
    'tae',
    'trn',
    'ycn'
  ],
  'urj' => [
    'fiu',
    'syd'
  ],
  'roa' => [
    'arg',
    'ast',
    'cat',
    'cos',
    'cpf',
    'cpp',
    'dlm',
    'egl',
    'ext',
    'fax',
    'fra',
    'frc',
    'frm',
    'fro',
    'frp',
    'fur',
    'glg',
    'ist',
    'ita',
    'lad',
    'lij',
    'lld',
    'lmo',
    'mwl',
    'mxi',
    'nap',
    'nrf',
    'oci',
    'osp',
    'pcd',
    'pms',
    'por',
    'rgn',
    'roh',
    'ron',
    'ruo',
    'rup',
    'ruq',
    'scn',
    'sdc',
    'sdn',
    'spa',
    'srd',
    'vec',
    'wln'
  ],
  'xnd' => [
    'ath',
    'eya',
    'hoi',
    'tfn',
    'tli'
  ],
  'iro' => [
    'cay',
    'chr',
    'lre',
    'moh',
    'ntw',
    'one',
    'ono',
    'see',
    'sqn',
    'tus',
    'wya'
  ],
  'esx' => [
    'ale',
    'iku',
    'ipk',
    'kal',
    'ypk',
    'ysr'
  ],
  'cau' => [
    'ccn',
    'ccs'
  ],
  'tai' => [
    'lao',
    'tha'
  ],
  'sem' => [
    'aao',
    'acw',
    'acy',
    'aeb',
    'afb',
    'aii',
    'ajt',
    'akk',
    'amh',
    'amw',
    'apc',
    'ara',
    'arc',
    'arq',
    'ary',
    'arz',
    'ayl',
    'gdq',
    'gez',
    'har',
    'heb',
    'jrb',
    'mey',
    'mlt',
    'phn',
    'sam',
    'shu',
    'smp',
    'sqr',
    'syc',
    'tig',
    'tir',
    'tmr',
    'uga',
    'xaa',
    'xeb',
    'xpu'
  ],
  'ber' => [
    'cnu',
    'grr',
    'jbe',
    'jbn',
    'kab',
    'mzb',
    'nxm',
    'oua',
    'rif',
    'sds',
    'shi',
    'shy',
    'siz',
    'taq',
    'thv',
    'tmh',
    'tzm',
    'zen',
    'zgh'
  ],
  'nah' => [
    'nci'
  ],
  'day' => [
    'bth',
    'lra',
    'sdo',
    'sne'
  ],
  'tbq' => [
    'adx',
    'anm',
    'bod',
    'bqh',
    'brx',
    'duu',
    'ers',
    'gqi',
    'gro',
    'jya',
    'lhu',
    'lpo',
    'mxj',
    'njo',
    'nun',
    'trp',
    'twm'
  ],
  'wak' => [
    'dtd',
    'has',
    'hei',
    'kwk',
    'myh',
    'nuk'
  ],
  'sdv' => [
    'ach',
    'alz',
    'anu',
    'bfa',
    'ddd',
    'din',
    'enb',
    'eyo',
    'kdj',
    'keo',
    'kln',
    'kpz',
    'lky',
    'lot',
    'lpx',
    'luo',
    'mas',
    'mqu',
    'muz',
    'niq',
    'nsg',
    'nub',
    'nus',
    'saq',
    'sgc',
    'shk',
    'tec',
    'teo',
    'toq',
    'tuv',
    'tuy'
  ],
  'iir' => [
    'ask',
    'bsh',
    'inc',
    'ira',
    'prn',
    'wbk',
    'xvi'
  ],
  'hok' => [
    'acv',
    'atw',
    'boi',
    'cid',
    'coc',
    'crz',
    'esq',
    'inz',
    'kju',
    'klb',
    'kyh',
    'mov',
    'mrc',
    'obi',
    'peb',
    'pef',
    'pej',
    'peq',
    'pom',
    'poo',
    'ppi',
    'puy',
    'sei',
    'sht',
    'sln',
    'veo',
    'was',
    'ynn',
    'yuf',
    'yum'
  ],
  'zhx' => [
    'cdo',
    'cjy',
    'cpx',
    'czh',
    'czo',
    'gan',
    'hak',
    'hsn',
    'ltc',
    'mnp',
    'nan',
    'och',
    'wuu',
    'wxa',
    'yue',
    'zho'
  ],
  'sla' => [
    'zle',
    'zls',
    'zlw'
  ],
  'sit' => [
    'dzo',
    'ero',
    'grt',
    'hmr',
    'hni',
    'iii',
    'jkr',
    'kac',
    'kar',
    'lbj',
    'lus',
    'mni',
    'mya',
    'new',
    'njh',
    'njm',
    'nmy',
    'nwc',
    'nxq',
    'qvy',
    'sxg',
    'tbq',
    'tsj',
    'txg',
    'xsr',
    'zhx'
  ],
  'cpf' => [
    'acf',
    'cks',
    'crs',
    'gcf',
    'gcr',
    'hat',
    'kmv',
    'lou',
    'mfe',
    'rcf'
  ],
  'plf' => [
    'alo',
    'amv',
    'gal',
    'hbu',
    'kje',
    'lti',
    'mhs',
    'szn',
    'tet',
    'tlv',
    'txn',
    'wha'
  ],
  'pqe' => [
    'agw',
    'ahb',
    'aia',
    'aie',
    'aji',
    'akr',
    'alm',
    'alu',
    'ane',
    'anx',
    'apb',
    'app',
    'apr',
    'asz',
    'aty',
    'aua',
    'aud',
    'aul',
    'auq',
    'aut',
    'baa',
    'bch',
    'bcm',
    'bcu',
    'bgt',
    'bhc',
    'bhw',
    'biq',
    'bjk',
    'blp',
    'blq',
    'bnk',
    'bnr',
    'bpa',
    'brr',
    'btr',
    'buk',
    'bvc',
    'bvd',
    'bwd',
    'bxa',
    'bxf',
    'bzh',
    'bzq',
    'cal',
    'cam',
    'chk',
    'crc',
    'ddi',
    'dgg',
    'dhv',
    'dob',
    'dor',
    'drr',
    'erg',
    'erk',
    'etn',
    'faf',
    'far',
    'fij',
    'frt',
    'fud',
    'fut',
    'fwa',
    'gdd',
    'gei',
    'gfk',
    'gga',
    'ggt',
    'ghn',
    'gil',
    'gli',
    'gmb',
    'goo',
    'gri',
    'grz',
    'gzn',
    'hah',
    'hao',
    'haw',
    'hiw',
    'hla',
    'hoa',
    'hrw',
    'iai',
    'irh',
    'jae',
    'jaj',
    'jaz',
    'kbm',
    'kdk',
    'khl',
    'kij',
    'kji',
    'kkk',
    'klv',
    'koa',
    'kos',
    'kpg',
    'kqw',
    'krf',
    'ksd',
    'ksg',
    'ktm',
    'kvc',
    'kwd',
    'kwf',
    'kxr',
    'kzk',
    'kzu',
    'lbb',
    'lbv',
    'lcm',
    'lek',
    'ler',
    'leu',
    'lga',
    'lgb',
    'lgk',
    'lgl',
    'lgr',
    'lgu',
    'lht',
    'lib',
    'lid',
    'lkn',
    'lle',
    'llf',
    'llp',
    'llu',
    'llx',
    'lmg',
    'lml',
    'lmu',
    'lmv',
    'loj',
    'los',
    'lpa',
    'lrv',
    'lrz',
    'lww',
    'mah',
    'mee',
    'mek',
    'met',
    'meu',
    'mft',
    'mgl',
    'mkj',
    'mkv',
    'mky',
    'mla',
    'mln',
    'mlu',
    'mlv',
    'mme',
    'mmg',
    'mmt',
    'mmw',
    'mmx',
    'mna',
    'mnv',
    'mox',
    'mpr',
    'mpy',
    'mqa',
    'mqm',
    'mrb',
    'mri',
    'mrl',
    'mrm',
    'mrn',
    'mrq',
    'mrv',
    'msq',
    'mte',
    'mtt',
    'mvo',
    'mwc',
    'mwh',
    'mwi',
    'mwo',
    'mxe',
    'nal',
    'nau',
    'ncc',
    'ncf',
    'ncn',
    'nee',
    'nem',
    'nen',
    'nfl',
    'ngr',
    'niu',
    'nke',
    'nkr',
    'nlg',
    'nmb',
    'nmk',
    'nms',
    'nmt',
    'nnd',
    'npn',
    'nsn',
    'nss',
    'nsw',
    'nua',
    'nuw',
    'nwi',
    'olr',
    'omb',
    'onu',
    'ora',
    'pek',
    'pex',
    'pfa',
    'pgk',
    'pif',
    'piv',
    'piz',
    'pkg',
    'pma',
    'pme',
    'pmt',
    'pnh',
    'pon',
    'pop',
    'ppn',
    'pri',
    'pss',
    'psw',
    'ptp',
    'ptv',
    'puw',
    'pwg',
    'rai',
    'rak',
    'rap',
    'rar',
    'ray',
    'roe',
    'rri',
    'rro',
    'rug',
    'sax',
    'sbb',
    'sbc',
    'sbe',
    'sbh',
    'sgz',
    'sij',
    'sjr',
    'sku',
    'slz',
    'smo',
    'sns',
    'sob',
    'sol',
    'sov',
    'sps',
    'ssg',
    'stn',
    'stw',
    'swp',
    'szw',
    'tah',
    'tbc',
    'tbe',
    'tbf',
    'tbj',
    'tgc',
    'tgi',
    'tgp',
    'tgs',
    'tio',
    'tkl',
    'tkp',
    'tkw',
    'tlm',
    'tlr',
    'tlx',
    'tmb',
    'tmi',
    'tmy',
    'tnk',
    'tnl',
    'tnn',
    'tnp',
    'tnx',
    'ton',
    'tox',
    'tpv',
    'tpz',
    'tql',
    'tqp',
    'tsr',
    'ttu',
    'ttv',
    'tuc',
    'tva',
    'tvk',
    'tvl',
    'twp',
    'ubr',
    'uge',
    'uli',
    'upv',
    'urr',
    'urv',
    'utp',
    'uve',
    'uvl',
    'vao',
    'vmg',
    'vnk',
    'vnm',
    'vra',
    'vrs',
    'vrt',
    'wiv',
    'wls',
    'woe',
    'wuv',
    'wwo',
    'wyy',
    'xsi',
    'yap',
    'yly',
    'zgr'
  ],
  'bnt' => [
    'abb',
    'asa',
    'auh',
    'bas',
    'beb',
    'bem',
    'beq',
    'bez',
    'bip',
    'bja',
    'bkh',
    'bkw',
    'bng',
    'bni',
    'bqz',
    'brf',
    'btb',
    'bum',
    'bvb',
    'bwt',
    'bxg',
    'cgg',
    'cjk',
    'cwe',
    'dav',
    'dez',
    'dma',
    'dua',
    'ebu',
    'eko',
    'eto',
    'ewo',
    'fan',
    'fip',
    'guz',
    'haq',
    'heh',
    'her',
    'hke',
    'hoo',
    'jmc',
    'kam',
    'kck',
    'kcv',
    'kde',
    'kik',
    'kin',
    'kkj',
    'kmb',
    'kon',
    'koo',
    'koq',
    'kqn',
    'ksb',
    'ksf',
    'kua',
    'kws',
    'kzo',
    'lag',
    'lch',
    'lik',
    'lin',
    'lol',
    'loz',
    'lua',
    'lub',
    'lue',
    'lug',
    'lun',
    'luy',
    'lyn',
    'mbo',
    'mdw',
    'mer',
    'mgh',
    'mhb',
    'mhw',
    'mye',
    'nba',
    'nbl',
    'ndc',
    'nde',
    'ndo',
    'ngc',
    'ngl',
    'njx',
    'nmg',
    'nnb',
    'nse',
    'nso',
    'nya',
    'nyf',
    'nym',
    'nyn',
    'pic',
    'rng',
    'rof',
    'run',
    'rwk',
    'rwm',
    'sbp',
    'seh',
    'shr',
    'sna',
    'snq',
    'sop',
    'sot',
    'ssw',
    'suk',
    'swa',
    'swb',
    'tll',
    'toi',
    'tsn',
    'tso',
    'tum',
    'umb',
    'ven',
    'vif',
    'vmk',
    'vun',
    'wdd',
    'wlc',
    'wni',
    'xho',
    'xog',
    'yao',
    'zdj',
    'zmw',
    'zul'
  ],
  'smi' => [
    'sia',
    'sjd',
    'sje',
    'sjt',
    'sma',
    'sme',
    'smj',
    'smn',
    'sms'
  ],
  'egx' => [
    'egy'
  ],
  'gmw' => [
    'afr',
    'ang',
    'cim',
    'deu',
    'dum',
    'eng',
    'enm',
    'frk',
    'frr',
    'fry',
    'gct',
    'gmh',
    'gml',
    'goh',
    'gos',
    'gsw',
    'ksh',
    'lim',
    'lng',
    'ltz',
    'mhn',
    'nds',
    'nld',
    'odt',
    'ofs',
    'osx',
    'pdc',
    'pfl',
    'sco',
    'stq',
    'swg',
    'wae',
    'wep',
    'wym',
    'yec',
    'yid',
    'zea'
  ],
  'swa' => [
    'swc'
  ],
  'paa' => [
    'aau',
    'anz',
    'ddg',
    'gak',
    'kax',
    'kmo',
    'lvk',
    'mok',
    'nas',
    'ngf',
    'pgu',
    'saj',
    'tcm',
    'tft',
    'tif',
    'tlb',
    'tqu',
    'waj',
    'wli',
    'yee',
    'zuh'
  ],
  'cmc' => [
    'ace',
    'cje',
    'cjm',
    'hro',
    'huq',
    'jra',
    'rad',
    'rog'
  ],
  'toto1251' => [
    'tcw',
    'tee',
    'tku',
    'tlc',
    'tlp',
    'toc',
    'too',
    'top',
    'tos',
    'tpp',
    'tpt',
    'tqt'
  ],
  'zlw' => [
    'ces',
    'csb',
    'czk',
    'pol',
    'pox',
    'slk',
    'szl',
    'wen'
  ],
  'sal' => [
    'cjh',
    'clm',
    'col',
    'coo',
    'cow',
    'crd',
    'fla',
    'hur',
    'lil',
    'nok',
    'oka',
    'qun',
    'shs',
    'spo',
    'squ',
    'str',
    'thp'
  ],
  'fiu' => [
    'chm',
    'est',
    'fin',
    'fit',
    'fkv',
    'hun',
    'izh',
    'kca',
    'koi',
    'kom',
    'krl',
    'liv',
    'mdf',
    'mns',
    'mrj',
    'myv',
    'olo',
    'smi',
    'udm',
    'vep',
    'vot',
    'vro'
  ],
  'zls' => [
    'bos',
    'bul',
    'chu',
    'hrv',
    'mkd',
    'slv',
    'srp'
  ],
  'bad' => [
    'bbp',
    'bfl',
    'bjo',
    'bpd',
    'bqk',
    'gox',
    'kuw',
    'liy',
    'lna',
    'lnl',
    'mnh',
    'nue',
    'nuu',
    'tor',
    'yaj',
    'zmz'
  ],
  'ira' => [
    'ave',
    'bal',
    'bsg',
    'ckb',
    'fas',
    'glk',
    'hac',
    'haz',
    'isk',
    'jdt',
    'jpr',
    'kho',
    'kur',
    'lrc',
    'lsa',
    'mzn',
    'oru',
    'oss',
    'pal',
    'peo',
    'prc',
    'pus',
    'sgh',
    'sgl',
    'sgy',
    'siy',
    'smy',
    'sog',
    'sqo',
    'srh',
    'tgk',
    'tly',
    'ttt',
    'wbl',
    'xbc',
    'xco',
    'xpr',
    'xsc',
    'yai',
    'zum',
    'zza'
  ],
  'cdc' => [
    'anc',
    'ank',
    'bid',
    'daa',
    'hau',
    'hed',
    'lme',
    'maf',
    'mcn',
    'mmy',
    'mpi',
    'mse',
    'mug',
    'nnc',
    'nnn',
    'pip',
    'sor',
    'tmc',
    'zim',
    'zuy'
  ],
  'sgn' => [
    'csn',
    'fcs',
    'fsl',
    'ils',
    'isg',
    'rsl'
  ],
  'gem' => [
    'gme',
    'gmq',
    'gmw'
  ],
  'xgn' => [
    'bua',
    'dta',
    'kxs',
    'mhj',
    'mjg',
    'mon',
    'mvf',
    'peh',
    'sce',
    'xal',
    'xwo',
    'yuy'
  ],
  'kro' => [
    'ald',
    'bsq',
    'dic',
    'grb',
    'gud',
    'gxx',
    'ney',
    'nwb',
    'wec'
  ],
  'bai' => [
    'bbj',
    'bko',
    'byv',
    'fmp',
    'jgo',
    'nla',
    'nnh',
    'nnz',
    'nwe',
    'xmg',
    'ybb'
  ],
  'csu' => [
    'avu',
    'bdh',
    'bex',
    'bot',
    'kcm',
    'led',
    'mdi',
    'mdj',
    'mhi',
    'mwm',
    'myb',
    'niy',
    'sba'
  ],
  'cel' => [
    'bre',
    'cor',
    'cym',
    'gla',
    'gle',
    'glv',
    'mga',
    'nrc',
    'obt',
    'owl',
    'sga',
    'wlm',
    'xbm',
    'xcb',
    'xce',
    'xga',
    'xpi'
  ],
  'alg' => [
    'alq',
    'arp',
    'atj',
    'ats',
    'bla',
    'chy',
    'ciw',
    'cre',
    'del',
    'kic',
    'mez',
    'mia',
    'mic',
    'mjy',
    'moe',
    'nnt',
    'oji',
    'ojs',
    'ojw',
    'otw',
    'pim',
    'pot',
    'qyp',
    'sac',
    'sjw',
    'unm',
    'wam',
    'xlb',
    'xlo',
    'xnt',
    'xpq'
  ],
  'gme' => [
    'got',
    'xvn'
  ],
  'son' => [
    'ddn',
    'dje',
    'kcy',
    'khq',
    'ses',
    'twq'
  ],
  'omv' => [
    'aiw',
    'bcq',
    'bwo',
    'dim',
    'doz',
    'jnj',
    'mdx',
    'noz',
    'she',
    'wal',
    'zay'
  ]
};
$LanguageParent = {
  'wwa' => 'alv',
  'tut' => 'mul',
  'mixe1284' => 'cai',
  'gaa' => 'alv',
  'kxr' => 'pqe',
  'crh' => 'trk',
  'xlc' => 'ine',
  'ssf' => 'fox',
  'cup' => 'azc',
  'mak' => 'pqw',
  'esq' => 'hok',
  'pon' => 'pqe',
  'pol' => 'zlw',
  'tpx' => 'omq',
  'lgr' => 'pqe',
  'pra' => 'inc',
  'pri' => 'pqe',
  'nnd' => 'pqe',
  'zne' => 'znd',
  'bqc' => 'dmn',
  'aii' => 'sem',
  'stq' => 'gmw',
  'wam' => 'alg',
  'zmz' => 'bad',
  'nsn' => 'pqe',
  'mcn' => 'cdc',
  'mzw' => 'alv',
  'bvc' => 'pqe',
  'atd' => 'mno',
  'kwd' => 'pqe',
  'mns' => 'fiu',
  'hau' => 'cdc',
  'nia' => 'pqw',
  'tqr' => 'kdo',
  'tql' => 'pqe',
  'dje' => 'son',
  'sba' => 'csu',
  'pqw' => 'poz',
  'pbp' => 'alv',
  'ven' => 'bnt',
  'znd' => 'nic',
  'wen' => 'zlw',
  'aud' => 'pqe',
  'chl' => 'azc',
  'toj' => 'myn',
  'ofs' => 'gmw',
  'ssg' => 'pqe',
  'mhe' => 'mkh',
  'pap' => 'cpp',
  'ntm' => 'alv',
  'jkr' => 'sit',
  'ppi' => 'hok',
  'kdd' => 'aus',
  'lbb' => 'pqe',
  'awd' => 'mul',
  'doz' => 'omv',
  'oma' => 'sio',
  'quf' => 'qwe',
  'dzo' => 'sit',
  'fan' => 'bnt',
  'iir' => 'ine',
  'blr' => 'mkh',
  'lim' => 'gmw',
  'irk' => 'cus',
  'bjk' => 'pqe',
  'div' => 'inc',
  'qup' => 'qwe',
  'sgn' => 'mul',
  'ggt' => 'pqe',
  'tso' => 'bnt',
  'alm' => 'pqe',
  'coz' => 'omq',
  'tcb' => 'ath',
  'dgg' => 'pqe',
  'mhc' => 'myn',
  'ndo' => 'bnt',
  'fla' => 'sal',
  'byv' => 'bai',
  'qxt' => 'qwe',
  'str' => 'sal',
  'kno' => 'dmn',
  'bkm' => 'alv',
  'tuz' => 'alv',
  'amv' => 'plf',
  'hrv' => 'zls',
  'qxh' => 'qwe',
  'lch' => 'bnt',
  'slz' => 'pqe',
  'qun' => 'sal',
  'ify' => 'phi',
  'twq' => 'son',
  'hro' => 'cmc',
  'mhw' => 'bnt',
  'drg' => 'pqw',
  'yec' => 'gmw',
  'nym' => 'bnt',
  'nuk' => 'wak',
  'wec' => 'kro',
  'nrm' => 'pqw',
  'nen' => 'pqe',
  'caf' => 'ath',
  'zoc' => 'mixe1284',
  'nrn' => 'gmq',
  'dzg' => 'ssa',
  'yue' => 'zhx',
  'sns' => 'pqe',
  'mog' => 'phi',
  'lfn' => 'art',
  'bja' => 'bnt',
  'pbg' => 'awd',
  'tly' => 'ira',
  'app' => 'pqe',
  'mvy' => 'inc',
  'fry' => 'gmw',
  'dur' => 'alv',
  'quh' => 'qwe',
  'mjz' => 'bih',
  'tlb' => 'paa',
  'akv' => 'ccn',
  'pop' => 'pqe',
  'eli' => 'kdo',
  'afa' => 'mul',
  'mmg' => 'pqe',
  'bgs' => 'mno',
  'sda' => 'pqw',
  'bdg' => 'pqw',
  'huz' => 'ccn',
  'sem' => 'afa',
  'obo' => 'mno',
  'bkz' => 'pqw',
  'czk' => 'zlw',
  'stn' => 'pqe',
  'enm' => 'gmw',
  'ber' => 'afa',
  'tpp' => 'toto1251',
  'end' => 'poz',
  'hve' => 'cai',
  'kpe' => 'dmn',
  'tuf' => 'cba',
  'cul' => 'auf',
  'lmg' => 'pqe',
  'fox' => 'map',
  'frp' => 'roa',
  'prk' => 'mkh',
  'leu' => 'pqe',
  'deu' => 'gmw',
  'ple' => 'poz',
  'qvw' => 'qwe',
  'led' => 'csu',
  'vep' => 'fiu',
  'slm' => 'pqw',
  'lug' => 'bnt',
  'csu' => 'ssa',
  'qub' => 'qwe',
  'tbj' => 'pqe',
  'hns' => 'bih',
  'gei' => 'pqe',
  'bad' => 'alv',
  'bzg' => 'fox',
  'ady' => 'ccn',
  'aau' => 'paa',
  'kap' => 'ccn',
  'sam' => 'sem',
  'ulw' => 'misu1242',
  'qxw' => 'qwe',
  'qvl' => 'qwe',
  'llk' => 'pqw',
  'kmv' => 'cpf',
  'hmr' => 'sit',
  'nsg' => 'sdv',
  'tku' => 'toto1251',
  'ler' => 'pqe',
  'kan' => 'dra',
  'rwk' => 'bnt',
  'cba' => 'cai',
  'mun' => 'aav',
  'kjb' => 'myn',
  'pex' => 'pqe',
  'kpc' => 'awd',
  'ciw' => 'alg',
  'wmt' => 'aus',
  'btd' => 'btk',
  'tdx' => 'pqw',
  'ttv' => 'pqe',
  'wbp' => 'aus',
  'ngf' => 'paa',
  'aka' => 'alv',
  'haw' => 'pqe',
  'tat' => 'trk',
  'lot' => 'sdv',
  'isk' => 'ira',
  'qus' => 'qwe',
  'swb' => 'bnt',
  'uge' => 'pqe',
  'mmr' => 'hmx',
  'liv' => 'fiu',
  'bba' => 'alv',
  'ncc' => 'pqe',
  'ibg' => 'phi',
  'kao' => 'dmn',
  'krc' => 'trk',
  'nzi' => 'alv',
  'kge' => 'pqw',
  'tuv' => 'sdv',
  'oci' => 'roa',
  'brr' => 'pqe',
  'ney' => 'kro',
  'obi' => 'hok',
  'cae' => 'alv',
  'saj' => 'paa',
  'cbn' => 'mkh',
  'zos' => 'mixe1284',
  'cdo' => 'zhx',
  'mok' => 'paa',
  'mjy' => 'alg',
  'uzs' => 'trk',
  'maf' => 'cdc',
  'jhi' => 'mkh',
  'sbh' => 'pqe',
  'mer' => 'bnt',
  'ava' => 'ccn',
  'biq' => 'pqe',
  'krl' => 'fiu',
  'waj' => 'paa',
  'iba' => 'pqw',
  'ngl' => 'bnt',
  'mwr' => 'inc',
  'cak' => 'myn',
  'gud' => 'kro',
  'smj' => 'smi',
  'tll' => 'bnt',
  'bkc' => 'alv',
  'srr' => 'alv',
  'the' => 'bih',
  'kbm' => 'pqe',
  'tmy' => 'pqe',
  'bwd' => 'pqe',
  'blq' => 'pqe',
  'rri' => 'pqe',
  'cji' => 'ccn',
  'som' => 'cus',
  'iai' => 'pqe',
  'lhu' => 'tbq',
  'txb' => 'ine',
  'nnn' => 'cdc',
  'sxg' => 'sit',
  'grn' => 'tup',
  'wha' => 'plf',
  'osa' => 'sio',
  'ems' => 'ypk',
  'gej' => 'alv',
  'pre' => 'cpp',
  'mam' => 'myn',
  'dua' => 'bnt',
  'tsr' => 'pqe',
  'anw' => 'alv',
  'zbc' => 'pqw',
  'kim' => 'trk',
  'klj' => 'trk',
  'myn' => 'cai',
  'hop' => 'azc',
  'lub' => 'bnt',
  'xmf' => 'ccs',
  'beg' => 'pqw',
  'tmh' => 'ber',
  'ccc' => 'awd',
  'ils' => 'sgn',
  'kxd' => 'pqw',
  'kcr' => 'kdo',
  'bez' => 'bnt',
  'bpy' => 'inc',
  'xnd' => 'mul',
  'zwa' => 'afa',
  'tmi' => 'pqe',
  'erk' => 'pqe',
  'mrq' => 'pqe',
  'lra' => 'day',
  'qwm' => 'trk',
  'ajg' => 'alv',
  'tkr' => 'ccn',
  'xbc' => 'ira',
  'ycn' => 'awd',
  'tnw' => 'phi',
  'ldm' => 'alv',
  'ubr' => 'pqe',
  'fit' => 'fiu',
  'yav' => 'alv',
  'xgn' => 'tut',
  'aba' => 'alv',
  'hbu' => 'plf',
  'aia' => 'pqe',
  'omv' => 'afa',
  'xsy' => 'fox',
  'grc' => 'grk',
  'utp' => 'pqe',
  'ira' => 'iir',
  'ign' => 'awd',
  'dob' => 'pqe',
  'ree' => 'pqw',
  'tnz' => 'mkh',
  'spp' => 'alv',
  'rad' => 'cmc',
  'sot' => 'bnt',
  'gzn' => 'pqe',
  'bts' => 'btk',
  'zmw' => 'bnt',
  'rar' => 'pqe',
  'qum' => 'myn',
  'ist' => 'roa',
  'guz' => 'bnt',
  'dyu' => 'dmn',
  'vra' => 'pqe',
  'gmb' => 'pqe',
  'phl' => 'inc',
  'sxn' => 'phi',
  'crx' => 'ath',
  'dai' => 'alv',
  'tef' => 'mkh',
  'eto' => 'bnt',
  'chr' => 'iro',
  'agx' => 'ccn',
  'btk' => 'pqw',
  'xnh' => 'mkh',
  'lmo' => 'roa',
  'tequ1244' => 'cai',
  'tfi' => 'alv',
  'taz' => 'kdo',
  'snv' => 'pqw',
  'tyv' => 'trk',
  'ani' => 'ccn',
  'kjc' => 'pqw',
  'pan' => 'inc',
  'roe' => 'pqe',
  'nob' => 'gmq',
  'tkb' => 'bih',
  'bko' => 'bai',
  'one' => 'iro',
  'tel' => 'dra',
  'gle' => 'cel',
  'bea' => 'ath',
  'bqh' => 'tbq',
  'mdw' => 'bnt',
  'iro' => 'mul',
  'nqo' => 'nic',
  'fao' => 'gmq',
  'uhn' => 'ngf',
  'irh' => 'pqe',
  'bik' => 'phi',
  'jpn' => 'jpx',
  'mic' => 'alg',
  'ori' => 'inc',
  'egy' => 'egx',
  'peq' => 'hok',
  'tzh' => 'myn',
  'oru' => 'ira',
  'mfe' => 'cpf',
  'mbp' => 'cba',
  'sah' => 'trk',
  'sgy' => 'ira',
  'inh' => 'ccn',
  'orv' => 'zle',
  'keo' => 'sdv',
  'daa' => 'cdc',
  'koa' => 'pqe',
  'cnu' => 'ber',
  'urv' => 'pqe',
  'nld' => 'gmw',
  'sdo' => 'day',
  'yee' => 'paa',
  'jra' => 'cmc',
  'cus' => 'afa',
  'map' => 'mul',
  'nwi' => 'pqe',
  'kdk' => 'pqe',
  'tpl' => 'omq',
  'hin' => 'inc',
  'upv' => 'pqe',
  'txn' => 'plf',
  'kje' => 'plf',
  'myv' => 'fiu',
  'hmn' => 'hmx',
  'ach' => 'sdv',
  'nmb' => 'pqe',
  'kzk' => 'pqe',
  'mlv' => 'pqe',
  'gal' => 'plf',
  'lgn' => 'ssa',
  'olt' => 'bat',
  'buc' => 'pqw',
  'coo' => 'sal',
  'bgk' => 'mkh',
  'khm' => 'mkh',
  'dra' => 'mul',
  'mai' => 'bih',
  'mzb' => 'ber',
  'pua' => 'cai',
  'dal' => 'cus',
  'aqa' => 'mul',
  'mwh' => 'pqe',
  'cha' => 'pqw',
  'bdl' => 'pqw',
  'tbc' => 'pqe',
  'tic' => 'kdo',
  'eus' => 'euq',
  'ley' => 'pqw',
  'pot' => 'alg',
  'bbl' => 'ccn',
  'bpa' => 'pqe',
  'udm' => 'fiu',
  'sgl' => 'ira',
  'kdj' => 'sdv',
  'smy' => 'ira',
  'ikx' => 'ssa',
  'nmg' => 'bnt',
  'nnz' => 'bai',
  'lcm' => 'pqe',
  'pau' => 'pqw',
  'uli' => 'pqe',
  'pnt' => 'grk',
  'ace' => 'cmc',
  'otm' => 'oto',
  'kro' => 'alv',
  'gmh' => 'gmw',
  'ayb' => 'alv',
  'har' => 'sem',
  'eng' => 'gmw',
  'lbj' => 'sit',
  'blo' => 'alv',
  'xmr' => 'ssa',
  'nfl' => 'pqe',
  'kji' => 'pqe',
  'vwa' => 'mkh',
  'bod' => 'tbq',
  'sva' => 'ccs',
  'ine' => 'mul',
  'mui' => 'pqw',
  'gag' => 'trk',
  'tzm' => 'ber',
  'bjj' => 'inc',
  'gui' => 'tup',
  'xnt' => 'alg',
  'wru' => 'pqw',
  'skf' => 'tup',
  'maq' => 'omq',
  'dec' => 'kdo',
  'lit' => 'bat',
  'ido' => 'art',
  'gld' => 'tuw',
  'mqm' => 'pqe',
  'dan' => 'gmq',
  'xpr' => 'ira',
  'rmv' => 'art',
  'bsc' => 'alv',
  'acw' => 'sem',
  'kgo' => 'kdo',
  'xho' => 'bnt',
  'ccs' => 'cau',
  'bsq' => 'kro',
  'tkw' => 'pqe',
  'btm' => 'btk',
  'hoo' => 'bnt',
  'ntw' => 'iro',
  'wlc' => 'bnt',
  'mir' => 'mixe1284',
  'oto' => 'omq',
  'nau' => 'pqe',
  'kry' => 'ccn',
  'dbj' => 'pqw',
  'aae' => 'sqj',
  'bum' => 'bnt',
  'shw' => 'kdo',
  'ysr' => 'esx',
  'knf' => 'alv',
  'hnj' => 'hmx',
  'nun' => 'tbq',
  'cje' => 'cmc',
  'pfl' => 'gmw',
  'gro' => 'tbq',
  'bch' => 'pqe',
  'mrl' => 'pqe',
  'qxu' => 'qwe',
  'nse' => 'bnt',
  'ijs' => 'ijo',
  'scl' => 'inc',
  'tgc' => 'pqe',
  'tne' => 'phi',
  'lvk' => 'paa',
  'fod' => 'alv',
  'mxj' => 'tbq',
  'hao' => 'pqe',
  'zng' => 'mkh',
  'cwe' => 'bnt',
  'kmb' => 'bnt',
  'krx' => 'alv',
  'pmt' => 'pqe',
  'frc' => 'roa',
  'kde' => 'bnt',
  'cjk' => 'bnt',
  'plu' => 'awd',
  'poo' => 'hok',
  'mtd' => 'pqw',
  'ell' => 'grk',
  'ood' => 'azc',
  'lme' => 'cdc',
  'trs' => 'omq',
  'bph' => 'ccn',
  'xlb' => 'alg',
  'qxn' => 'qwe',
  'anu' => 'sdv',
  'tam' => 'dra',
  'tey' => 'kdo',
  'tos' => 'toto1251',
  'tlx' => 'pqe',
  'ghn' => 'pqe',
  'kjj' => 'ccn',
  'khq' => 'son',
  'nms' => 'pqe',
  'mtt' => 'pqe',
  'lcl' => 'map',
  'nnh' => 'bai',
  'pse' => 'pqw',
  'gml' => 'gmw',
  'hye' => 'hyx',
  'ewe' => 'alv',
  'zbe' => 'pqw',
  'nss' => 'pqe',
  'oss' => 'ira',
  'cjh' => 'sal',
  'wal' => 'omv',
  'kxs' => 'xgn',
  'opt' => 'azc',
  'hup' => 'ath',
  'teu' => 'ssa',
  'tth' => 'aav',
  'wyy' => 'pqe',
  'nrc' => 'cel',
  'tnn' => 'pqe',
  'lky' => 'sdv',
  'npn' => 'pqe',
  'svx' => 'bat',
  'cpx' => 'zhx',
  'oku' => 'alv',
  'njh' => 'sit',
  'amh' => 'sem',
  'guq' => 'tup',
  'rou' => 'ssa',
  'cim' => 'gmw',
  'bhp' => 'poz',
  'ctg' => 'inc',
  'qwc' => 'qwe',
  'scb' => 'mkh',
  'haz' => 'ira',
  'mgo' => 'alv',
  'unr' => 'mun',
  'bce' => 'alv',
  'abb' => 'bnt',
  'ale' => 'esx',
  'lga' => 'pqe',
  'nio' => 'syd',
  'kar' => 'sit',
  'urd' => 'inc',
  'urh' => 'alv',
  'prc' => 'ira',
  'abq' => 'ccn',
  'lib' => 'pqe',
  'duu' => 'tbq',
  'mse' => 'cdc',
  'ceb' => 'phi',
  'ixc' => 'omq',
  'zor' => 'mixe1284',
  'gux' => 'alv',
  'dop' => 'alv',
  'grr' => 'ber',
  'bot' => 'csu',
  'tnr' => 'alv',
  'kju' => 'hok',
  'phn' => 'sem',
  'smp' => 'sem',
  'ang' => 'gmw',
  'mdx' => 'omv',
  'ind' => 'pqw',
  'quv' => 'myn',
  'mnv' => 'pqe',
  'tog' => 'nic',
  'mzl' => 'mixe1284',
  'faf' => 'pqe',
  'lyn' => 'bnt',
  'iru' => 'dra',
  'tsu' => 'fox',
  'xwc' => 'sio',
  'tbe' => 'pqe',
  'cdd' => 'mul',
  'kyk' => 'phi',
  'ebu' => 'bnt',
  'lpx' => 'sdv',
  'cai' => 'mul',
  'mpu' => 'tup',
  'not' => 'awd',
  'pfa' => 'pqe',
  'kic' => 'alg',
  'alz' => 'sdv',
  'ari' => 'cdd',
  'dar' => 'ccn',
  'xbp' => 'aus',
  'bqz' => 'bnt',
  'her' => 'bnt',
  'cuy' => 'cai',
  'hit' => 'ine',
  'ask' => 'iir',
  'bzt' => 'art',
  'frr' => 'gmw',
  'ron' => 'roa',
  'beb' => 'bnt',
  'bvd' => 'pqe',
  'arc' => 'sem',
  'mnh' => 'bad',
  'stp' => 'azc',
  'qve' => 'qwe',
  'afr' => 'gmw',
  'lre' => 'iro',
  'bnk' => 'pqe',
  'ixl' => 'myn',
  'tkq' => 'alv',
  'ebr' => 'alv',
  'far' => 'pqe',
  'kbl' => 'ssa',
  'sov' => 'pqe',
  'dez' => 'bnt',
  'kkk' => 'pqe',
  'czn' => 'omq',
  'pdc' => 'gmw',
  'yrk' => 'syd',
  'haq' => 'bnt',
  'igs' => 'art',
  'mep' => 'aus',
  'ibl' => 'phi',
  'okr' => 'ijo',
  'mtm' => 'syd',
  'mra' => 'mkh',
  'kxv' => 'dra',
  'ckb' => 'ira',
  'ruo' => 'roa',
  'ojs' => 'alg',
  'otw' => 'alg',
  'lrz' => 'pqe',
  'abk' => 'ccn',
  'moh' => 'iro',
  'swg' => 'gmw',
  'xfa' => 'itc',
  'tkg' => 'pqw',
  'aty' => 'pqe',
  'ddi' => 'pqe',
  'tuw' => 'tut',
  'ltg' => 'bat',
  'mde' => 'ssa',
  'mbi' => 'mno',
  'kyw' => 'bih',
  'mkj' => 'pqe',
  'xvi' => 'iir',
  'ave' => 'ira',
  'xsi' => 'pqe',
  'xpq' => 'alg',
  'yrl' => 'tup',
  'bul' => 'zls',
  'ktm' => 'pqe',
  'mye' => 'bnt',
  'kia' => 'alv',
  'gsw' => 'gmw',
  'lpa' => 'pqe',
  'mxp' => 'mixe1284',
  'ude' => 'tuw',
  'vmk' => 'bnt',
  'tao' => 'poz',
  'slv' => 'zls',
  'mrm' => 'pqe',
  'mri' => 'pqe',
  'cre' => 'alg',
  'xve' => 'ine',
  'bbp' => 'bad',
  'vif' => 'bnt',
  'gem' => 'ine',
  'tht' => 'ath',
  'apu' => 'awd',
  'suk' => 'bnt',
  'yua' => 'myn',
  'bwt' => 'bnt',
  'smm' => 'bih',
  'tpw' => 'tup',
  'toto1251' => 'cai',
  'ctu' => 'myn',
  'sid' => 'cus',
  'chy' => 'alg',
  'sia' => 'smi',
  'ben' => 'inc',
  'smr' => 'pqw',
  'ccp' => 'inc',
  'efi' => 'alv',
  'xpc' => 'trk',
  'tup' => 'mul',
  'ses' => 'son',
  'puy' => 'hok',
  'tmc' => 'cdc',
  'ary' => 'sem',
  'buh' => 'hmx',
  'kib' => 'kdo',
  'kal' => 'esx',
  'ces' => 'zlw',
  'mky' => 'pqe',
  'syr' => 'sem',
  'fap' => 'alv',
  'xlo' => 'alg',
  'bin' => 'alv',
  'mlo' => 'alv',
  'wls' => 'pqe',
  'spa' => 'roa',
  'ium' => 'hmx',
  'sbb' => 'pqe',
  'byn' => 'cus',
  'abi' => 'alv',
  'koo' => 'bnt',
  'ful' => 'alv',
  'gqi' => 'tbq',
  'sax' => 'pqe',
  'smo' => 'pqe',
  'acf' => 'cpf',
  'tif' => 'paa',
  'llx' => 'pqe',
  'pif' => 'pqe',
  'peh' => 'xgn',
  'srd' => 'roa',
  'cow' => 'sal',
  'yly' => 'pqe',
  'nfr' => 'alv',
  'pej' => 'hok',
  'tah' => 'pqe',
  'rmg' => 'gmq',
  'zty' => 'omq',
  'tar' => 'azc',
  'aib' => 'trk',
  'niy' => 'csu',
  'saq' => 'sdv',
  'sjo' => 'tuw',
  'soy' => 'alv',
  'mql' => 'alv',
  'ijo' => 'alv',
  'vrt' => 'pqe',
  'kec' => 'kdo',
  'loj' => 'pqe',
  'xwe' => 'alv',
  'bvb' => 'bnt',
  'qxr' => 'qwe',
  'tgs' => 'pqe',
  'wni' => 'bnt',
  'rml' => 'inc',
  'gil' => 'pqe',
  'rej' => 'pqw',
  'ess' => 'ypk',
  'chg' => 'trk',
  'drr' => 'pqe',
  'kmz' => 'trk',
  'wlm' => 'cel',
  'gla' => 'cel',
  'kok' => 'inc',
  'jmc' => 'bnt',
  'nya' => 'bnt',
  'cbg' => 'cba',
  'blf' => 'phi',
  'gcr' => 'cpf',
  'bkh' => 'bnt',
  'frm' => 'roa',
  'mlt' => 'sem',
  'hiw' => 'pqe',
  'sat' => 'mun',
  'pib' => 'awd',
  'cpg' => 'grk',
  'tmb' => 'pqe',
  'neq' => 'mixe1284',
  'bck' => 'aus',
  'czh' => 'zhx',
  'trk' => 'tut',
  'goa' => 'dmn',
  'roh' => 'roa',
  'tlm' => 'pqe',
  'wti' => 'ssa',
  'slr' => 'trk',
  'xeb' => 'sem',
  'qws' => 'qwe',
  'sml' => 'pqw',
  'bjz' => 'ngf',
  'ptp' => 'pqe',
  'aht' => 'ath',
  'tem' => 'alv',
  'itz' => 'myn',
  'ban' => 'pqw',
  'etn' => 'pqe',
  'kyj' => 'phi',
  'bnq' => 'phi',
  'frt' => 'pqe',
  'dum' => 'gmw',
  'ksg' => 'pqe',
  'mmt' => 'pqe',
  'nij' => 'pqw',
  'cor' => 'cel',
  'aoa' => 'cpp',
  'isl' => 'gmq',
  'bib' => 'dmn',
  'shy' => 'ber',
  'kir' => 'trk',
  'bmq' => 'alv',
  'met' => 'pqe',
  'pom' => 'hok',
  'rgn' => 'roa',
  'kln' => 'sdv',
  'syc' => 'sem',
  'lob' => 'alv',
  'piv' => 'pqe',
  'var' => 'azc',
  'tcw' => 'toto1251',
  'lmv' => 'pqe',
  'sco' => 'gmw',
  'xps' => 'ine',
  'nso' => 'bnt',
  'tlr' => 'pqe',
  'zgh' => 'ber',
  'tkt' => 'bih',
  'khl' => 'pqe',
  'tqp' => 'pqe',
  'apb' => 'pqe',
  'thq' => 'bih',
  'quy' => 'qwe',
  'lui' => 'azc',
  'sqj' => 'mul',
  'vot' => 'fiu',
  'mfv' => 'alv',
  'pos' => 'mixe1284',
  'oji' => 'alg',
  'ynn' => 'hok',
  'sqn' => 'iro',
  'piz' => 'pqe',
  'myk' => 'alv',
  'kkz' => 'ath',
  'xaw' => 'azc',
  'cid' => 'hok',
  'huq' => 'cmc',
  'imy' => 'ine',
  'tgk' => 'ira',
  'kdh' => 'alv',
  'btb' => 'bnt',
  'quc' => 'myn',
  'rkm' => 'dmn',
  'xxk' => 'poz',
  'pia' => 'azc',
  'vec' => 'roa',
  'muv' => 'dra',
  'bam' => 'dmn',
  'sps' => 'pqe',
  'agq' => 'alv',
  'bbh' => 'mkh',
  'smn' => 'smi',
  'acy' => 'sem',
  'bjo' => 'bad',
  'yid' => 'gmw',
  'kzo' => 'bnt',
  'kqr' => 'pqw',
  'smw' => 'pqw',
  'nde' => 'bnt',
  'awa' => 'inc',
  'aln' => 'sqj',
  'osp' => 'roa',
  'nal' => 'pqe',
  'qvc' => 'qwe',
  'agw' => 'pqe',
  'sma' => 'smi',
  'mte' => 'pqe',
  'guo' => 'awd',
  'mdd' => 'alv',
  'swe' => 'gmq',
  'lao' => 'tai',
  'mey' => 'sem',
  'dak' => 'sio',
  'onw' => 'nub',
  'kur' => 'ira',
  'gbu' => 'aus',
  'dml' => 'inc',
  'inj' => 'qwe',
  'llp' => 'pqe',
  'aiw' => 'omv',
  'sjd' => 'smi',
  'peo' => 'ira',
  'qug' => 'qwe',
  'kxl' => 'dra',
  'bcr' => 'ath',
  'xsm' => 'alv',
  'urj' => 'mul',
  'pwg' => 'pqe',
  'pek' => 'pqe',
  'aol' => 'poz',
  'usp' => 'myn',
  'pha' => 'hmx',
  'xdc' => 'ine',
  'chm' => 'fiu',
  'ttu' => 'pqe',
  'tay' => 'fox',
  'mww' => 'hmx',
  'kwz' => 'khi',
  'tkp' => 'pqe',
  'beq' => 'bnt',
  'btx' => 'btk',
  'abr' => 'alv',
  'wiy' => 'aql',
  'erg' => 'pqe',
  'cjy' => 'zhx',
  'akk' => 'sem',
  'abs' => 'pqw',
  'syl' => 'inc',
  'zoq' => 'mixe1284',
  'uuu' => 'mkh',
  'gly' => 'ssa',
  'mmx' => 'pqe',
  'pma' => 'pqe',
  'kgk' => 'tup',
  'pnh' => 'pqe',
  'yij' => 'aus',
  'arq' => 'sem',
  'mlq' => 'dmn',
  'snl' => 'phi',
  'rof' => 'bnt',
  'kpt' => 'ccn',
  'alv' => 'nic',
  'txg' => 'sit',
  'ccn' => 'cau',
  'olr' => 'pqe',
  'jah' => 'mkh',
  'lgu' => 'pqe',
  'ext' => 'roa',
  'nnt' => 'alg',
  'hoi' => 'xnd',
  'gfk' => 'pqe',
  'mrc' => 'hok',
  'mba' => 'mno',
  'lww' => 'pqe',
  'adx' => 'tbq',
  'mfa' => 'pqw',
  'dlm' => 'roa',
  'koy' => 'ath',
  'nkr' => 'pqe',
  'mmy' => 'cdc',
  'mlg' => 'pqw',
  'xga' => 'cel',
  'lou' => 'cpf',
  'prg' => 'bat',
  'chu' => 'zls',
  'tzj' => 'myn',
  'kss' => 'alv',
  'tpj' => 'tup',
  'lat' => 'itc',
  'oaa' => 'tuw',
  'tab' => 'ccn',
  'sdn' => 'roa',
  'sln' => 'hok',
  'ijc' => 'ijo',
  'mqn' => 'pqw',
  'lgk' => 'pqe',
  'srq' => 'tup',
  'bos' => 'zls',
  'mrv' => 'pqe',
  'bll' => 'sio',
  'nep' => 'inc',
  'kay' => 'tup',
  'shz' => 'alv',
  'dny' => 'auf',
  'mot' => 'cba',
  'arv' => 'cus',
  'mfb' => 'pqw',
  'huo' => 'mkh',
  'mqa' => 'pqe',
  'mwl' => 'roa',
  'tnl' => 'pqe',
  'koi' => 'fiu',
  'plf' => 'poz',
  'bel' => 'zle',
  'hbs' => 'zls',
  'glg' => 'roa',
  'pao' => 'azc',
  'owl' => 'cel',
  'nwe' => 'bai',
  'sla' => 'ine',
  'wep' => 'gmw',
  'ddj' => 'aus',
  'pip' => 'cdc',
  'mez' => 'alg',
  'ser' => 'azc',
  'mah' => 'bih',
  'eve' => 'tuw',
  'juc' => 'tuw',
  'qvo' => 'qwe',
  'mgl' => 'pqe',
  'bcq' => 'omv',
  'kjg' => 'mkh',
  'czo' => 'zhx',
  'pdo' => 'pqw',
  'anm' => 'tbq',
  'ldn' => 'art',
  'omb' => 'pqe',
  'qvh' => 'qwe',
  'nas' => 'paa',
  'dma' => 'bnt',
  'kuw' => 'bad',
  'aql' => 'mul',
  'ane' => 'pqe',
  'bfd' => 'alv',
  'rut' => 'ccn',
  'mji' => 'hmx',
  'njo' => 'tbq',
  'ovd' => 'gmq',
  'fsl' => 'sgn',
  'sog' => 'ira',
  'msa' => 'pqw',
  'asb' => 'sio',
  'wuv' => 'pqe',
  'dor' => 'pqe',
  'tuc' => 'pqe',
  'otk' => 'trk',
  'nku' => 'alv',
  'ada' => 'alv',
  'grk' => 'ine',
  'tsn' => 'bnt',
  'pov' => 'cpp',
  'ono' => 'iro',
  'ulu' => 'pqw',
  'mpy' => 'pqe',
  'mkh' => 'aav',
  'hmx' => 'mul',
  'ktq' => 'pqw',
  'kat' => 'ccs',
  'goy' => 'alv',
  'coc' => 'hok',
  'din' => 'sdv',
  'crs' => 'cpf',
  'loc' => 'phi',
  'gin' => 'ccn',
  'lce' => 'pqw',
  'pmq' => 'omq',
  'naj' => 'alv',
  'see' => 'iro',
  'xld' => 'ine',
  'ili' => 'trk',
  'gmw' => 'gem',
  'myh' => 'wak',
  'sdv' => 'ssa',
  'avi' => 'alv',
  'tms' => 'kdo',
  'bnn' => 'fox',
  'acz' => 'kdo',
  'mta' => 'mno',
  'tgp' => 'pqe',
  'odt' => 'gmw',
  'son' => 'ssa',
  'alg' => 'aql',
  'tcm' => 'paa',
  'ssn' => 'cus',
  'tft' => 'paa',
  'xum' => 'itc',
  'oac' => 'tuw',
  'vao' => 'pqe',
  'wli' => 'paa',
  'wic' => 'cdd',
  'bci' => 'alv',
  'bat' => 'ine',
  'qvj' => 'qwe',
  'wym' => 'gmw',
  'qxl' => 'qwe',
  'dag' => 'alv',
  'thl' => 'bih',
  'hbn' => 'kdo',
  'xcr' => 'ine',
  'nkx' => 'ijo',
  'ero' => 'sit',
  'alo' => 'plf',
  'bxe' => 'afa',
  'tgx' => 'ath',
  'mbs' => 'mno',
  'kuu' => 'ath',
  'bns' => 'inc',
  'sjn' => 'art',
  'llu' => 'pqe',
  'bgt' => 'pqe',
  'srs' => 'ath',
  'teo' => 'sdv',
  'fro' => 'roa',
  'rak' => 'pqe',
  'tbf' => 'pqe',
  'ekg' => 'ngf',
  'tpr' => 'tup',
  'qxc' => 'qwe',
  'kac' => 'sit',
  'tvl' => 'pqe',
  'hni' => 'sit',
  'bsg' => 'ira',
  'srh' => 'ira',
  'ahb' => 'pqe',
  'xce' => 'cel',
  'pal' => 'ira',
  'quw' => 'qwe',
  'khi' => 'mul',
  'kzr' => 'alv',
  'tus' => 'iro',
  'zgr' => 'pqe',
  'raz' => 'pqw',
  'mar' => 'inc',
  'arp' => 'alg',
  'cqu' => 'qwe',
  'mdf' => 'fiu',
  'zle' => 'sla',
  'xcu' => 'bat',
  'psw' => 'pqe',
  'gez' => 'sem',
  'oka' => 'sal',
  'abl' => 'pqw',
  'kzu' => 'pqe',
  'poh' => 'myn',
  'anz' => 'paa',
  'sdc' => 'roa',
  'quk' => 'qwe',
  'fab' => 'cpp',
  'rog' => 'cmc',
  'soi' => 'bih',
  'smi' => 'fiu',
  'zen' => 'ber',
  'inb' => 'qwe',
  'bnr' => 'pqe',
  'lrv' => 'pqe',
  'yky' => 'alv',
  'msb' => 'phi',
  'kbp' => 'alv',
  'ckv' => 'fox',
  'jrb' => 'sem',
  'asz' => 'pqe',
  'mwi' => 'pqe',
  'kon' => 'bnt',
  'ssy' => 'cus',
  'sus' => 'dmn',
  'mwv' => 'pqw',
  'ara' => 'sem',
  'sol' => 'pqe',
  'tsd' => 'grk',
  'kcy' => 'son',
  'sxl' => 'bat',
  'mkd' => 'zls',
  'alt' => 'trk',
  'yaj' => 'bad',
  'ksh' => 'gmw',
  'mjv' => 'dra',
  'hil' => 'phi',
  'orc' => 'cus',
  'rug' => 'pqe',
  'mtq' => 'mkh',
  'bwo' => 'omv',
  'tnp' => 'pqe',
  'zum' => 'ira',
  'oua' => 'ber',
  'haa' => 'ath',
  'kvr' => 'pqw',
  'mlf' => 'mkh',
  'shs' => 'sal',
  'brh' => 'dra',
  'mrb' => 'pqe',
  'cym' => 'cel',
  'lnd' => 'map',
  'nuu' => 'bad',
  'jbe' => 'ber',
  'ljp' => 'pqw',
  'nci' => 'nah',
  'mlu' => 'pqe',
  'kas' => 'inc',
  'ilk' => 'phi',
  'hei' => 'wak',
  'ita' => 'roa',
  'sun' => 'pqw',
  'heh' => 'bnt',
  'goo' => 'pqe',
  'nub' => 'sdv',
  'mls' => 'ssa',
  'squ' => 'sal',
  'uzb' => 'trk',
  'yuf' => 'hok',
  'tom' => 'phi',
  'kaw' => 'pqw',
  'tox' => 'pqe',
  'khw' => 'inc',
  'nga' => 'alv',
  'mna' => 'pqe',
  'zza' => 'ira',
  'sjw' => 'alg',
  'cac' => 'myn',
  'bgj' => 'alv',
  'aua' => 'pqe',
  'ijn' => 'ijo',
  'roa' => 'itc',
  'lij' => 'roa',
  'bej' => 'cus',
  'pnu' => 'hmx',
  'mkm' => 'pqw',
  'non' => 'gmq',
  'mwm' => 'csu',
  'bju' => 'alv',
  'cou' => 'alv',
  'iof' => 'kdo',
  'apw' => 'apa',
  'tuq' => 'ssa',
  'ivv' => 'poz',
  'hyw' => 'hyx',
  'fuj' => 'kdo',
  'yao' => 'bnt',
  'dhv' => 'pqe',
  'stw' => 'pqe',
  'mee' => 'pqe',
  'ksk' => 'sio',
  'wbl' => 'ira',
  'mwc' => 'pqe',
  'liw' => 'pqw',
  'vmb' => 'aus',
  'mnc' => 'tuw',
  'mwk' => 'dmn',
  'tkl' => 'pqe',
  'kys' => 'pqw',
  'sop' => 'bnt',
  'zbl' => 'art',
  'kbd' => 'ccn',
  'cri' => 'cpp',
  'xto' => 'ine',
  'lua' => 'bnt',
  'vro' => 'fiu',
  'lag' => 'bnt',
  'nyo' => 'nic',
  'sin' => 'inc',
  'sel' => 'syd',
  'bpd' => 'bad',
  'jac' => 'myn',
  'rai' => 'pqe',
  'yii' => 'aus',
  'mqk' => 'mno',
  'inp' => 'awd',
  'cco' => 'omq',
  'neu' => 'art',
  'sbc' => 'pqe',
  'poz' => 'map',
  'pms' => 'roa',
  'jgo' => 'bai',
  'sje' => 'smi',
  'pio' => 'awd',
  'atw' => 'hok',
  'tha' => 'tai',
  'yum' => 'hok',
  'nah' => 'azc',
  'kvc' => 'pqe',
  'gdo' => 'ccn',
  'twt' => 'tup',
  'sck' => 'bih',
  'lav' => 'bat',
  'tva' => 'pqe',
  'nha' => 'aus',
  'xkq' => 'pqw',
  'meu' => 'pqe',
  'tpz' => 'pqe',
  'alc' => 'aqa',
  'hat' => 'cpf',
  'moa' => 'dmn',
  'was' => 'hok',
  'asm' => 'inc',
  'tac' => 'azc',
  'ppl' => 'azc',
  'auh' => 'bnt',
  'btz' => 'btk',
  'kaa' => 'trk',
  'ton' => 'pqe',
  'gmq' => 'gem',
  'mzs' => 'cpp',
  'lek' => 'pqe',
  'cgg' => 'bnt',
  'shx' => 'hmx',
  'lkn' => 'pqe',
  'rth' => 'phi',
  'sto' => 'sio',
  'kff' => 'dra',
  'gdd' => 'pqe',
  'uun' => 'fox',
  'lnl' => 'bad',
  'nwc' => 'sit',
  'gri' => 'pqe',
  'ota' => 'trk',
  'afb' => 'sem',
  'mug' => 'cdc',
  'tec' => 'sdv',
  'crz' => 'hok',
  'man' => 'dmn',
  'bzh' => 'pqe',
  'mag' => 'bih',
  'shu' => 'sem',
  'kyi' => 'pqw',
  'too' => 'toto1251',
  'nxq' => 'sit',
  'hoa' => 'pqe',
  'cqd' => 'hmx',
  'yai' => 'ira',
  'nav' => 'apa',
  'sij' => 'pqe',
  'jaz' => 'pqe',
  'qua' => 'sio',
  'pry' => 'mkh',
  'tet' => 'plf',
  'fmp' => 'bai',
  'brf' => 'bnt',
  'huv' => 'cai',
  'kfc' => 'dra',
  'qvy' => 'sit',
  'eya' => 'xnd',
  'agu' => 'myn',
  'bak' => 'trk',
  'bqk' => 'bad',
  'mrw' => 'phi',
  'sjt' => 'smi',
  'kws' => 'bnt',
  'hus' => 'myn',
  'mor' => 'kdo',
  'dup' => 'pqw',
  'mxe' => 'pqe',
  'kqs' => 'alv',
  'egl' => 'roa',
  'nwb' => 'kro',
  'wbk' => 'iir',
  'nno' => 'gmq',
  'lzz' => 'ccs',
  'hla' => 'pqe',
  'eno' => 'pqw',
  'gcf' => 'cpf',
  'sad' => 'khi',
  'cdc' => 'afa',
  'pbs' => 'omq',
  'mtn' => 'misu1242',
  'klb' => 'hok',
  'bzd' => 'cba',
  'nnb' => 'bnt',
  'koq' => 'bnt',
  'knj' => 'myn',
  'fon' => 'alv',
  'dtd' => 'wak',
  'sbe' => 'pqe',
  'ddn' => 'son',
  'mia' => 'alg',
  'akr' => 'pqe',
  'den' => 'ath',
  'pam' => 'phi',
  'mal' => 'dra',
  'enb' => 'sdv',
  'dun' => 'pqw',
  'hyx' => 'mul',
  'ksd' => 'pqe',
  'nnc' => 'cdc',
  'pyu' => 'fox',
  'uvl' => 'pqe',
  'aie' => 'pqe',
  'wxa' => 'zhx',
  'heb' => 'sem',
  'nke' => 'pqe',
  'she' => 'omv',
  'myb' => 'csu',
  'trv' => 'fox',
  'bfa' => 'sdv',
  'rap' => 'pqe',
  'kcv' => 'bnt',
  'swc' => 'swa',
  'acv' => 'hok',
  'mwo' => 'pqe',
  'dru' => 'fox',
  'gni' => 'aus',
  'sgz' => 'pqe',
  'epo' => 'art',
  'dmn' => 'nic',
  'aru' => 'auf',
  'osc' => 'itc',
  'nua' => 'pqe',
  'urr' => 'pqe',
  'mox' => 'pqe',
  'seh' => 'bnt',
  'hvv' => 'cai',
  'mhb' => 'bnt',
  'amw' => 'sem',
  'maj' => 'omq',
  'xbr' => 'poz',
  'mhi' => 'csu',
  'tdu' => 'pqw',
  'lil' => 'sal',
  'nuy' => 'aus',
  'mhn' => 'gmw',
  'cgc' => 'mno',
  'ski' => 'poz',
  'kcp' => 'kdo',
  'qxo' => 'qwe',
  'qud' => 'qwe',
  'zhx' => 'sit',
  'hah' => 'pqe',
  'kjh' => 'trk',
  'wwo' => 'pqe',
  'qwa' => 'qwe',
  'nie' => 'alv',
  'fiu' => 'urj',
  'tpt' => 'toto1251',
  'fkv' => 'fiu',
  'kaz' => 'trk',
  'ank' => 'cdc',
  'bhc' => 'pqe',
  'caq' => 'mkh',
  'tlc' => 'toto1251',
  'akb' => 'btk',
  'psm' => 'tup',
  'njx' => 'bnt',
  'mya' => 'sit',
  'ulc' => 'tuw',
  'qvs' => 'qwe',
  'kmq' => 'ssa',
  'pug' => 'alv',
  'cui' => 'awd',
  'kjn' => 'aus',
  'tau' => 'ath',
  'xcl' => 'hyx',
  'kho' => 'ira',
  'isg' => 'sgn',
  'tlp' => 'toto1251',
  'kvh' => 'poz',
  'ndv' => 'alv',
  'anc' => 'cdc',
  'bid' => 'cdc',
  'twy' => 'pqw',
  'ina' => 'art',
  'peb' => 'hok',
  'kca' => 'fiu',
  'niu' => 'pqe',
  'kpn' => 'tup',
  'cps' => 'phi',
  'hml' => 'hmx',
  'tzo' => 'myn',
  'orm' => 'cus',
  'lmu' => 'pqe',
  'sxr' => 'fox',
  'rup' => 'roa',
  'akl' => 'phi',
  'taq' => 'ber',
  'aus' => 'mul',
  'goh' => 'gmw',
  'inc' => 'iir',
  'ddo' => 'ccn',
  'kek' => 'myn',
  'anx' => 'pqe',
  'hvn' => 'poz',
  'guh' => 'awd',
  'jbn' => 'ber',
  'plq' => 'ine',
  'fax' => 'roa',
  'jbo' => 'art',
  'lom' => 'dmn',
  'kdr' => 'trk',
  'kdt' => 'aav',
  'lmd' => 'kdo',
  'nds' => 'gmw',
  'lcf' => 'pqw',
  'mqu' => 'sdv',
  'hsn' => 'zhx',
  'xsv' => 'bat',
  'kea' => 'cpp',
  'tiv' => 'alv',
  'ray' => 'pqe',
  'lng' => 'gmw',
  'tur' => 'trk',
  'vie' => 'mkh',
  'abx' => 'pqw',
  'bai' => 'alv',
  'gay' => 'pqw',
  'tbz' => 'alv',
  'lin' => 'bnt',
  'xrg' => 'aus',
  'fil' => 'phi',
  'lez' => 'ccn',
  'paa' => 'mul',
  'miz' => 'omq',
  'dnj' => 'dmn',
  'mto' => 'mixe1284',
  'doi' => 'inc',
  'wdd' => 'bnt',
  'apk' => 'apa',
  'skr' => 'inc',
  'ttc' => 'myn',
  'lgb' => 'pqe',
  'vol' => 'art',
  'guc' => 'awd',
  'lun' => 'bnt',
  'hch' => 'azc',
  'xmz' => 'pqw',
  'xwo' => 'xgn',
  'vai' => 'dmn',
  'hlu' => 'ine',
  'jae' => 'pqe',
  'txs' => 'phi',
  'xlg' => 'ine',
  'txy' => 'pqw',
  'nor' => 'gmq',
  'tqu' => 'paa',
  'sdt' => 'ine',
  'lrc' => 'ira',
  'rmt' => 'inc',
  'vko' => 'pqw',
  'nla' => 'bai',
  'nem' => 'pqe',
  'rro' => 'pqe',
  'tag' => 'kdo',
  'xzm' => 'bat',
  'poi' => 'mixe1284',
  'hid' => 'sio',
  'tjg' => 'pqw',
  'ksb' => 'bnt',
  'lad' => 'roa',
  'lgl' => 'pqe',
  'hmd' => 'hmx',
  'nlg' => 'pqe',
  'xao' => 'mkh',
  'qvz' => 'qwe',
  'xmk' => 'ine',
  'pad' => 'auf',
  'tla' => 'azc',
  'bgc' => 'inc',
  'trp' => 'tbq',
  'lbe' => 'ccn',
  'mme' => 'pqe',
  'nus' => 'sdv',
  'chk' => 'pqe',
  'jpx' => 'mul',
  'bcu' => 'pqe',
  'kik' => 'bnt',
  'tir' => 'sem',
  'mbo' => 'bnt',
  'cau' => 'mul',
  'udi' => 'ccn',
  'olo' => 'fiu',
  'cad' => 'cdd',
  'bim' => 'alv',
  'xnb' => 'fox',
  'bdh' => 'csu',
  'scn' => 'roa',
  'poq' => 'mixe1284',
  'rmq' => 'inc',
  'brx' => 'tbq',
  'lsa' => 'ira',
  'auf' => 'mul',
  'gkn' => 'alv',
  'kam' => 'bnt',
  'fia' => 'nub',
  'jle' => 'kdo',
  'qur' => 'qwe',
  'kck' => 'bnt',
  'zap' => 'omq',
  'grb' => 'kro',
  'duq' => 'pqw',
  'sor' => 'cdc',
  'ers' => 'tbq',
  'qxq' => 'trk',
  'kua' => 'bnt',
  'mqy' => 'poz',
  'bno' => 'phi',
  'ktn' => 'tup',
  'ath' => 'xnd',
  'grz' => 'pqe',
  'ald' => 'kro',
  'mxr' => 'pqw',
  'lam' => 'nic',
  'zaw' => 'omq',
  'pxm' => 'mixe1284',
  'cia' => 'pqw',
  'dws' => 'art',
  'moe' => 'alg',
  'dim' => 'omv',
  'csn' => 'sgn',
  'bxa' => 'pqe',
  'jct' => 'trk',
  'hrw' => 'pqe',
  'mdh' => 'phi',
  'nuw' => 'pqe',
  'tgi' => 'pqe',
  'omq' => 'cai',
  'bbc' => 'btk',
  'azo' => 'alv',
  'snq' => 'bnt',
  'knk' => 'dmn',
  'toc' => 'toto1251',
  'mln' => 'pqe',
  'als' => 'sqj',
  'tnt' => 'phi',
  'pcj' => 'mun',
  'tbr' => 'kdo',
  'kau' => 'ssa',
  'bzq' => 'pqe',
  'pku' => 'pqw',
  'ayl' => 'sem',
  'aze' => 'trk',
  'gwc' => 'inc',
  'san' => 'pra',
  'lna' => 'bad',
  'pim' => 'alg',
  'mhy' => 'pqw',
  'tdn' => 'phi',
  'itc' => 'ine',
  'wbm' => 'mkh',
  'pli' => 'pra',
  'xmg' => 'bai',
  'naq' => 'khi',
  'zbw' => 'pqw',
  'swa' => 'swa',
  'jaj' => 'pqe',
  'chv' => 'trk',
  'fos' => 'fox',
  'bem' => 'bnt',
  'tsj' => 'sit',
  'ajt' => 'sem',
  'apl' => 'apa',
  'luy' => 'bnt',
  'nmn' => 'khi',
  'min' => 'pqw',
  'mpi' => 'cdc',
  'ipk' => 'esx',
  'atj' => 'alg',
  'qux' => 'qwe',
  'zlw' => 'sla',
  'llf' => 'pqe',
  'sgd' => 'phi',
  'obt' => 'cel',
  'xsd' => 'ine',
  'par' => 'azc',
  'qxp' => 'qwe',
  'zul' => 'bnt',
  'phi' => 'pqw',
  'inz' => 'hok',
  'win' => 'sio',
  'tfn' => 'xnd',
  'pkg' => 'pqe',
  'nxe' => 'poz',
  'mbd' => 'mno',
  'fra' => 'roa',
  'kha' => 'mkh',
  'bje' => 'hmx',
  'kfa' => 'dra',
  'crd' => 'sal',
  'kkj' => 'bnt',
  'mni' => 'sit',
  'bew' => 'pqw',
  'lbw' => 'pqw',
  'pus' => 'ira',
  'eme' => 'tup',
  'cpp' => 'roa',
  'ndf' => 'bat',
  'ddd' => 'sdv',
  'kzc' => 'alv',
  'lid' => 'pqe',
  'mga' => 'cel',
  'aav' => 'mul',
  'irr' => 'aav',
  'cwt' => 'alv',
  'lol' => 'bnt',
  'ybe' => 'trk',
  'thp' => 'sal',
  'dav' => 'bnt',
  'lbx' => 'pqw',
  'eko' => 'bnt',
  'abu' => 'alv',
  'iby' => 'ijo',
  'ssw' => 'bnt',
  'xsc' => 'ira',
  'xtc' => 'kdo',
  'btr' => 'pqe',
  'ame' => 'awd',
  'tae' => 'awd',
  'tbq' => 'sit',
  'gon' => 'dra',
  'com' => 'azc',
  'sga' => 'cel',
  'art' => 'mul',
  'xal' => 'xgn',
  'vma' => 'aus',
  'szl' => 'zlw',
  'tmr' => 'sem',
  'fud' => 'pqe',
  'nhd' => 'tup',
  'ddg' => 'paa',
  'ukr' => 'zle',
  'mos' => 'alv',
  'yap' => 'pqe',
  'axm' => 'hyx',
  'sal' => 'mul',
  'kld' => 'aus',
  'szw' => 'pqe',
  'wln' => 'roa',
  'aao' => 'sem',
  'tyh' => 'mkh',
  'clo' => 'tequ1244',
  'hne' => 'inc',
  'kpz' => 'sdv',
  'kwf' => 'pqe',
  'fas' => 'ira',
  'shh' => 'azc',
  'xgl' => 'bat',
  'kxu' => 'dra',
  'bra' => 'inc',
  'ilo' => 'phi',
  'shk' => 'sdv',
  'tum' => 'bnt',
  'apa' => 'ath',
  'lee' => 'alv',
  'srp' => 'zls',
  'xmv' => 'pqw',
  'grt' => 'sit',
  'nue' => 'bad',
  'keu' => 'alv',
  'bug' => 'pqw',
  'wiv' => 'pqe',
  'sqi' => 'sqj',
  'tqt' => 'toto1251',
  'tuy' => 'sdv',
  'tub' => 'azc',
  'buk' => 'pqe',
  'cjm' => 'cmc',
  'rue' => 'zle',
  'gjn' => 'alv',
  'zay' => 'omv',
  'poc' => 'myn',
  'tnx' => 'pqe',
  'fwa' => 'pqe',
  'swx' => 'auf',
  'clm' => 'sal',
  'nap' => 'roa',
  'emx' => 'inc',
  'kii' => 'cdd',
  'kog' => 'cba',
  'mhs' => 'plf',
  'mla' => 'pqe',
  'puw' => 'pqe',
  'esx' => 'mul',
  'day' => 'pqw',
  'rwm' => 'bnt',
  'cam' => 'pqe',
  'yor' => 'alv',
  'noz' => 'omv',
  'sku' => 'pqe',
  'mft' => 'pqe',
  'gmy' => 'grk',
  'rif' => 'ber',
  'zho' => 'zhx',
  'kin' => 'bnt',
  'lus' => 'sit',
  'xkg' => 'dmn',
  'ssb' => 'pqw',
  'rom' => 'inc',
  'klv' => 'pqe',
  'tig' => 'sem',
  'alq' => 'alg',
  'tsz' => 'cai',
  'myl' => 'pqw',
  'uby' => 'ccn',
  'che' => 'ccn',
  'kqw' => 'pqe',
  'lbn' => 'mkh',
  'ncf' => 'pqe',
  'snk' => 'dmn',
  'aut' => 'pqe',
  'vrs' => 'pqe',
  'trn' => 'awd',
  'tlk' => 'pqw',
  'blp' => 'pqe',
  'sdg' => 'inc',
  'ing' => 'ath',
  'yuy' => 'xgn',
  'yaq' => 'azc',
  'xgf' => 'azc',
  'tee' => 'toto1251',
  'bdk' => 'ccn',
  'gan' => 'zhx',
  'xas' => 'syd',
  'bni' => 'bnt',
  'tpv' => 'pqe',
  'sss' => 'aav',
  'hif' => 'bih',
  'pag' => 'phi',
  'goq' => 'pqw',
  'bla' => 'alg',
  'mzm' => 'alv',
  'nba' => 'bnt',
  'ccr' => 'misu1242',
  'pme' => 'pqe',
  'sgs' => 'bat',
  'mad' => 'pqw',
  'okd' => 'ijo',
  'tol' => 'ath',
  'cms' => 'ine',
  'bas' => 'bnt',
  'brg' => 'awd',
  'pcd' => 'roa',
  'ply' => 'mkh',
  'plo' => 'mixe1284',
  'kva' => 'ccn',
  'qya' => 'art',
  'lkt' => 'sio',
  'nan' => 'zhx',
  'qwh' => 'qwe',
  'tli' => 'xnd',
  'pef' => 'hok',
  'wuu' => 'zhx',
  'otd' => 'pqw',
  'aca' => 'awd',
  'bua' => 'xgn',
  'ile' => 'art',
  'mco' => 'mixe1284',
  'sqr' => 'sem',
  'fcs' => 'sgn',
  'mjt' => 'dra',
  'knu' => 'dmn',
  'cal' => 'pqe',
  'zoh' => 'mixe1284',
  'ewo' => 'bnt',
  'mfq' => 'alv',
  'wyr' => 'tup',
  'asa' => 'bnt',
  'kvq' => 'kar',
  'yan' => 'misu1242',
  'sbp' => 'bnt',
  'mdr' => 'pqw',
  'gga' => 'pqe',
  'khv' => 'ccn',
  'sit' => 'mul',
  'kcj' => 'alv',
  'gdq' => 'sem',
  'txh' => 'ine',
  'guk' => 'ssa',
  'ati' => 'alv',
  'kqn' => 'bnt',
  'bcm' => 'pqe',
  'ozm' => 'alv',
  'mzq' => 'pqw',
  'bth' => 'day',
  'alu' => 'pqe',
  'xaa' => 'sem',
  'yej' => 'grk',
  'sei' => 'hok',
  'lmp' => 'alv',
  'thv' => 'ber',
  'mxi' => 'roa',
  'xog' => 'bnt',
  'csb' => 'zlw',
  'got' => 'gme',
  'kru' => 'dra',
  'hts' => 'khi',
  'sht' => 'hok',
  'pss' => 'pqe',
  'srm' => 'cpp',
  'nok' => 'sal',
  'ypk' => 'esx',
  'gxx' => 'kro',
  'pwn' => 'fox',
  'rka' => 'mkh',
  'wol' => 'alv',
  'sya' => 'pqw',
  'kmj' => 'dra',
  'apr' => 'pqe',
  'lti' => 'plf',
  'acr' => 'myn',
  'esu' => 'ypk',
  'rus' => 'zle',
  'crc' => 'pqe',
  'krf' => 'pqe',
  'hur' => 'sal',
  'umb' => 'bnt',
  'mnp' => 'zhx',
  'kyh' => 'hok',
  'nyn' => 'bnt',
  'tio' => 'pqe',
  'misu1242' => 'cai',
  'sqo' => 'ira',
  'jpr' => 'ira',
  'azb' => 'trk',
  'lue' => 'bnt',
  'mhj' => 'xgn',
  'msq' => 'pqe',
  'pgu' => 'paa',
  'qvm' => 'qwe',
  'ntp' => 'azc',
  'que' => 'qwe',
  'kcm' => 'csu',
  'zuh' => 'paa',
  'nbl' => 'bnt',
  'sme' => 'smi',
  'iku' => 'esx',
  'mpr' => 'pqe',
  'dic' => 'kro',
  'mbt' => 'mno',
  'hun' => 'fiu',
  'otr' => 'kdo',
  'sds' => 'ber',
  'qvn' => 'qwe',
  'dlg' => 'trk',
  'fij' => 'pqe',
  'chp' => 'ath',
  'men' => 'dmn',
  'sob' => 'pqe',
  'luo' => 'sdv',
  'gor' => 'phi',
  'tnk' => 'pqe',
  'niq' => 'sdv',
  'nxm' => 'ber',
  'xom' => 'ssa',
  'hoc' => 'mun',
  'ojw' => 'alg',
  'glk' => 'ira',
  'xmm' => 'cpp',
  'jya' => 'tbq',
  'vnk' => 'pqe',
  'aji' => 'pqe',
  'nmt' => 'pqe',
  'hak' => 'zhx',
  'sea' => 'mkh',
  'yal' => 'dmn',
  'tin' => 'ccn',
  'ibo' => 'alv',
  'tta' => 'sio',
  'liy' => 'bad',
  'bae' => 'awd',
  'tcy' => 'dra',
  'gwi' => 'ath',
  'mrj' => 'fiu',
  'ltc' => 'zhx',
  'baa' => 'pqe',
  'ltz' => 'gmw',
  'bbj' => 'bai',
  'ppn' => 'pqe',
  'mxq' => 'mixe1284',
  'ssa' => 'mul',
  'kak' => 'phi',
  'syd' => 'urj',
  'qwe' => 'mul',
  'woe' => 'pqe',
  'nmy' => 'sit',
  'mno' => 'phi',
  'xbm' => 'cel',
  'tvk' => 'pqe',
  'ncn' => 'pqe',
  'qul' => 'qwe',
  'bih' => 'mul',
  'bho' => 'bih',
  'shr' => 'bnt',
  'kra' => 'bih',
  'xpu' => 'sem',
  'eka' => 'nic',
  'bqj' => 'alv',
  'vkl' => 'pqw',
  'xls' => 'ine',
  'toq' => 'sdv',
  'ybb' => 'bai',
  'toi' => 'bnt',
  'zdj' => 'bnt',
  'vnm' => 'pqe',
  'yka' => 'pqw',
  'pel' => 'pqw',
  'pqe' => 'poz',
  'kwk' => 'wak',
  'ndc' => 'bnt',
  'ruq' => 'roa',
  'mdi' => 'csu',
  'jab' => 'alv',
  'sse' => 'pqw',
  'sas' => 'pqw',
  'neg' => 'tuw',
  'wak' => 'mul',
  'kmo' => 'paa',
  'caa' => 'myn',
  'dsb' => 'wen',
  'bfl' => 'bad',
  'pkn' => 'aus',
  'nyf' => 'bnt',
  'cat' => 'roa',
  'sce' => 'xgn',
  'nsw' => 'pqe',
  'wci' => 'alv',
  'afh' => 'art',
  'jav' => 'pqw',
  'tor' => 'bad',
  'mbb' => 'mno',
  'prn' => 'iir',
  'tlo' => 'kdo',
  'kos' => 'pqe',
  'udu' => 'ssa',
  'njm' => 'sit',
  'auq' => 'pqe',
  'zuy' => 'cdc',
  'sag' => 'ngb',
  'veo' => 'hok',
  'apj' => 'apa',
  'bjn' => 'pqw',
  'kyr' => 'tup',
  'mon' => 'xgn',
  'cjs' => 'trk',
  'chb' => 'cba',
  'siz' => 'ber',
  'muz' => 'sdv',
  'msm' => 'mno',
  'bxg' => 'bnt',
  'bax' => 'alv',
  'mfy' => 'azc',
  'apc' => 'sem',
  'cwg' => 'mkh',
  'qvp' => 'qwe',
  'ktz' => 'khi',
  'nic' => 'mul',
  'kum' => 'trk',
  'ttt' => 'ira',
  'len' => 'cai',
  'myu' => 'tup',
  'ksf' => 'bnt',
  'mkx' => 'mno',
  'ngb' => 'alv',
  'del' => 'alg',
  'mdj' => 'csu',
  'ncb' => 'mkh',
  'siy' => 'ira',
  'xvn' => 'gme',
  'pny' => 'alv',
  'crv' => 'mkh',
  'guj' => 'inc',
  'fip' => 'bnt',
  'snf' => 'alv',
  'iii' => 'sit',
  'lht' => 'pqe',
  'tbl' => 'phi',
  'aqc' => 'ccn',
  'vun' => 'bnt',
  'tdb' => 'bih',
  'tuk' => 'trk',
  'och' => 'zhx',
  'sav' => 'alv',
  'mas' => 'sdv',
  'izh' => 'fiu',
  'hok' => 'cai',
  'tcx' => 'dra',
  'hac' => 'ira',
  'gox' => 'bad',
  'kls' => 'inc',
  'paw' => 'cdd',
  'glv' => 'cel',
  'xco' => 'ira',
  'skh' => 'pqw',
  'arz' => 'sem',
  'tik' => 'alv',
  'tui' => 'alv',
  'bpn' => 'hmx',
  'cks' => 'cpf',
  'slk' => 'zlw',
  'szn' => 'plf',
  'uga' => 'sem',
  'twp' => 'pqe',
  'bng' => 'bnt',
  'frk' => 'gmw',
  'nov' => 'art',
  'xin' => 'cai',
  'spo' => 'sal',
  'mqt' => 'mkh',
  'bji' => 'cus',
  'lml' => 'pqe',
  'gct' => 'gmw',
  'kax' => 'paa',
  'mvf' => 'xgn',
  'mkv' => 'pqe',
  'qyp' => 'alg',
  'gba' => 'alv',
  'run' => 'bnt',
  'fin' => 'fiu',
  'mxb' => 'omq',
  'tlh' => 'art',
  'aul' => 'pqe',
  'sjm' => 'pqw',
  'col' => 'sal',
  'ofo' => 'sio',
  'fur' => 'roa',
  'sna' => 'bnt',
  'bhb' => 'inc',
  'bkw' => 'bnt',
  'sjr' => 'pqe',
  'kdo' => 'nic',
  'por' => 'roa',
  'nmk' => 'pqe',
  'tai' => 'mul',
  'onu' => 'pqe',
  'cay' => 'iro',
  'jdt' => 'ira',
  'sms' => 'smi',
  'jnj' => 'omv',
  'avk' => 'art',
  'ast' => 'roa',
  'ztq' => 'omq',
  'pil' => 'alv',
  'ngc' => 'bnt',
  'bdr' => 'pqw',
  'mrn' => 'pqe',
  'xcb' => 'cel',
  'yur' => 'aql',
  'bkk' => 'inc',
  'kom' => 'fiu',
  'lbv' => 'pqe',
  'quz' => 'qwe',
  'gyr' => 'tup',
  'bkd' => 'mno',
  'iow' => 'sio',
  'orh' => 'tuw',
  'mzn' => 'ira',
  'dyo' => 'alv',
  'est' => 'fiu',
  'raj' => 'inc',
  'mzv' => 'alv',
  'los' => 'pqe',
  'mgh' => 'bnt',
  'gos' => 'gmw',
  'tdi' => 'pqw',
  'zim' => 'cdc',
  'uig' => 'trk',
  'kma' => 'alv',
  'mua' => 'alv',
  'rng' => 'bnt',
  'anp' => 'bih',
  'lik' => 'bnt',
  'qva' => 'qwe',
  'kpg' => 'pqe',
  'mjg' => 'xgn',
  'wya' => 'iro',
  'xmw' => 'pqw',
  'gwt' => 'inc',
  'bwn' => 'hmx',
  'lpo' => 'tbq',
  'pbo' => 'alv',
  'scx' => 'ine',
  'dtr' => 'pqw',
  'wae' => 'gmw',
  'mhq' => 'sio',
  'nyl' => 'aav',
  'lld' => 'roa',
  'tlv' => 'plf',
  'bip' => 'bnt',
  'aat' => 'sqj',
  'twm' => 'tbq',
  'sev' => 'alv',
  'nza' => 'alv',
  'mop' => 'myn',
  'mnw' => 'mkh',
  'mbn' => 'awd',
  'eyo' => 'sdv',
  'war' => 'phi',
  'pox' => 'zlw',
  'rcf' => 'cpf',
  'sne' => 'day',
  'kie' => 'ssa',
  'bre' => 'cel',
  'nog' => 'tut',
  'ngr' => 'pqe',
  'kij' => 'pqe',
  'aar' => 'cus',
  'ynk' => 'ypk',
  'tzl' => 'art',
  'fvr' => 'ssa',
  'bsh' => 'iir',
  'clw' => 'trk',
  'vmg' => 'pqe',
  'duw' => 'pqw',
  'mnr' => 'azc',
  'mek' => 'pqe',
  'cpf' => 'roa',
  'cel' => 'ine',
  'wow' => 'pqw',
  'adj' => 'alv',
  'mml' => 'mkh',
  'cro' => 'sio',
  'krj' => 'phi',
  'ora' => 'pqe',
  'qvi' => 'qwe',
  'hsb' => 'wen',
  'thr' => 'bih',
  'nee' => 'pqe',
  'zls' => 'sla',
  'kei' => 'poz',
  'mvo' => 'pqe',
  'pic' => 'bnt',
  'swp' => 'pqe',
  'sgc' => 'sdv',
  'gob' => 'awd',
  'snd' => 'inc',
  'bhw' => 'pqe',
  'cop' => 'afa',
  'boi' => 'hok',
  'dta' => 'xgn',
  'pmz' => 'omq',
  'xsr' => 'sit',
  'fut' => 'pqe',
  'gur' => 'alv',
  'top' => 'toto1251',
  'has' => 'wak',
  'oyb' => 'mkh',
  'ptv' => 'pqe',
  'kjk' => 'pqw',
  'lah' => 'inc',
  'laf' => 'kdo',
  'piu' => 'aus',
  'aeb' => 'sem',
  'orr' => 'ijo',
  'unm' => 'alg',
  'lle' => 'pqe',
  'cos' => 'roa',
  'ogc' => 'alv',
  'osx' => 'gmw',
  'mov' => 'hok',
  'chd' => 'tequ1244',
  'spx' => 'itc',
  'shi' => 'ber',
  'gli' => 'pqe',
  'clc' => 'ath',
  'mmw' => 'pqe',
  'qxa' => 'qwe',
  'gak' => 'paa',
  'hed' => 'cdc',
  'azc' => 'cai',
  'bal' => 'ira',
  'miq' => 'misu1242',
  'hue' => 'cai',
  'euq' => 'mul',
  'sio' => 'mul',
  'zea' => 'gmw',
  'xpi' => 'cel',
  'sgh' => 'ira',
  'sac' => 'alg',
  'ras' => 'kdo',
  'wrn' => 'kdo',
  'uve' => 'pqe',
  'ats' => 'alg',
  'tpu' => 'mkh',
  'dgr' => 'ath',
  'pgk' => 'pqe',
  'hke' => 'bnt',
  'dbl' => 'aus',
  'bex' => 'csu',
  'tpc' => 'omq',
  'new' => 'sit',
  'egx' => 'mul',
  'rsl' => 'sgn',
  'bnt' => 'alv',
  'evn' => 'tuw',
  'bxf' => 'pqe',
  'arg' => 'roa',
  'sii' => 'mkh',
  'bda' => 'alv',
  'kab' => 'ber',
  'gme' => 'gem',
  'avu' => 'csu',
  'nrf' => 'roa',
  'loz' => 'bnt',
  'xpg' => 'ine',
  'beh' => 'alv',
  'cmc' => 'pqw',
  'bsu' => 'pqw',
  'ije' => 'ijo'
};
#-*-perl-*-

=head1 SUBROUTINES

=head2 @langcodes = language_group( $groupcode )

Returns a list of language codes within the given language group.

=cut


sub language_group{
    my %children = ();
    if (exists $$LanguageGroup{$_[0]}){
	foreach my $l (@{$$LanguageGroup{$_[0]}}){
	    if (exists $$LanguageGroup{$l}){
		foreach (&language_group($l)){
		    $children{$_}++;
		}
	    }
	    else{
		$children{$l}++;
	    }
	}
    }
    else{
	return ($_[0]);
    }
    return sort keys %children;
}


=head2 @langcodes = language_group_children( $groupcode )

Returns a list of language codes that are immediate children of the given language group.

=cut

sub language_group_children{
    if (exists $$LanguageGroup{$_[0]}){
	return @{$$LanguageGroup{$_[0]}};
    }
    print STDERR "unknown language group $_[0]\n";
    return ();
}


=head2 @parentcode = language_group( $langcode )

Returns the parent language code for the given language.

=cut


sub language_parent{
    if (exists $$LanguageParent{$_[0]}){
	return $$LanguageParent{$_[0]};
    }
    print STDERR "no parent found for '$_[0]'\n";
    return undef;
}


## don't need the functions below, just use ISO::639::3
##

# =head2 $name = language_group_name( $groupcode )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_language_name($_[0]);
# }


# =head2 $code = language_group_code( $groupname )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_iso639_3($_[0]);
# }



1;

