use Test::More tests => 39;

BEGIN { use_ok( 'IPC::Semaphore::Set' ) }

my $semset_with_key = IPC::Semaphore::Set->new(
	key => 1337,
);
is($semset_with_key->key, 1337, 'key was as 1337 as expected');
is($semset_with_key->remove, 1, 'successfully removed semaphore set');

my $semset = IPC::Semaphore::Set->new(
	key_name  => 'IPC::Semaphore::Set Tests Basics',
	resources => 3,
	value     => 2,
);
isa_ok($semset, 'IPC::Semaphore::Set');

my @resources = $semset->resources;
is(scalar(@resources), 3, 'got [3] resources');

foreach my $resource (@resources) {
	isa_ok($resource, 'IPC::Semaphore::Set::Resource');
	is($resource->value, 2, 'resource had [2] value');
}

my $resource0 = $semset->resource;
is($resource0->number, 0, 'got the default first [0] resource');

my $resource1 = $semset->resource(number => 2);
is($resource1->number, 2, 'got a proper resource by number');

my $resource2 = $semset->resource;
is($resource2->number, 0, 'got the expected stored resource');
is($semset->remove, 1, 'successfully removed semaphore set');

{
	{
		my $semset = IPC::Semaphore::Set->new(
			key_name  => 'IPC::Semaphore::Set Tests',
			resources => 10,
			value     => 3,
		);
		isa_ok($semset, 'IPC::Semaphore::Set');
		is($semset->resource->lock,  1, 'able to get a lock');
		is($semset->resource->value, 2, 'reduced value by 1');

		is($semset->resource(number => 9)->lock,  1, 'able to get a lock on resource 9');
		is($semset->resource(number => 9)->value, 2, 'reduced value by 1 on resource 9');
	}

	my $semset = IPC::Semaphore::Set->new(key_name => 'IPC::Semaphore::Set Tests');
	is($semset->resource->value, 3, 'destructor properly cleaned up after changes');
	is($semset->resource(number => 9)->value, 3, 'destructor properly cleaned up changes for resource 9');

	is($semset->remove, 1, 'removed semaphore set');
}

{
	my $semset = IPC::Semaphore::Set->new(
		key_name  => 'IPC::Semaphore::Set Tests',
		resources => 10,
		value     => 3,
	);
	isa_ok($semset, 'IPC::Semaphore::Set');

	my $lockOrDie = eval{$semset->resource->lockOrDie};
	is($lockOrDie, 1, 'able to lock once');

	my $lockWait;
	eval {
		local $SIG{ALRM} = sub { die "alarm\n" };
		alarm 3;
		$lockWait = $semset->resource->lockWait;
		alarm 0;
	};
	is($lockWait, 1, 'able to lock a second time');

	is($semset->resource->lock, 1, 'able to lock a third time');
	is($semset->resource->lock, 0, 'unable to lock a fourth time');

	my $lockWait;
	eval {
		local $SIG{ALRM} = sub { die "alarm\n" };
		alarm 1;
		$lockWait = $semset->resource->lockWait;
		alarm 0;
	};
	my $alarm = ($@ eq "alarm\n");
	is($alarm, 1, 'alarm reached properly after one second');
	is($lockWait, undef, 'received no response from lock');

	eval{$semset->resource->lockOrDie};
	my $error = ($@ =~ m/could not lock on semaphore/);
	is($error, 1, 'died trying to get an unavailable resource');

	eval{$semset->resource->lockWaitTimeoutDie(1)};
	my $error = ($@ =~ m/could not establish lock after 1 seconds/);
	is($error, 1, 'died waiting for lock');

	is($semset->resource->addValue, 1, 'able to add value');
	is($semset->resource->lockWaitTimeout, 1, 'able to lock with wait');

	is($semset->resource->addValue, 1, 'able to add value');
	is($semset->resource->addValue, 1, 'able to add value twice');
	is($semset->resource->addValue, 1, 'able to add value a third time');
	is($semset->resource->value, 3, 'correct availability found in semaphore resource');

	is($semset->remove, 1, 'successfully removed semaphore set');
}

