use Test::More tests => 14;

BEGIN { use_ok( 'IPC::Semaphore::Set' ) }

my $semset = IPC::Semaphore::Set->new(
	key_name  => 'IPC::Semaphore::Set Tests',
	resources => 10,
	available => 3,
);
isa_ok($semset, 'IPC::Semaphore::Set');

my $lockOrDie = eval{$semset->resource->lockOrDie};
is($lockOrDie, 1, 'able to lock once');

my $lockWait;
eval {
	local $SIG{ALRM} = sub { die "alarm\n" };
	alarm 3;
	$lockWait = $semset->resource->lockWait;
	alarm 0;
};
is($lockWait, 1, 'able to lock a second time');

is($semset->resource->lock, 1, 'able to lock a third time');
is($semset->resource->lock, 0, 'unable to lock a fourth time');

my $lockWait;
eval {
	local $SIG{ALRM} = sub { die "alarm\n" };
	alarm 1;
	$lockWait = $semset->resource->lockWait;
	alarm 0;
};
my $alarm = ($@ eq "alarm\n");
is($alarm, 1, 'alarm reached properly after one second');
is($lockWait, undef, 'received no response from lock');

eval{$semset->resource->lockOrDie};
my $error = ($@ =~ m/could not lock on semaphore/);
is($error, 1, 'died trying to get an unavailable resource');

is($semset->resource->addValue, 1, 'able to unlock once');
is($semset->resource->addValue, 1, 'able to unlock a second time');
is($semset->resource->addValue, 1, 'able to unlock a third time');
is($semset->resource->value, 3, 'correct availability found in semaphore resource');

is($semset->remove, 1, 'successfully removed semaphore set');

