package Google::Ads::AdWords::v201710::NegativeCampaignCriterion;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201710' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201710::CampaignCriterion);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %campaignId_of :ATTR(:get<campaignId>);
my %isNegative_of :ATTR(:get<isNegative>);
my %criterion_of :ATTR(:get<criterion>);
my %bidModifier_of :ATTR(:get<bidModifier>);
my %campaignCriterionStatus_of :ATTR(:get<campaignCriterionStatus>);
my %baseCampaignId_of :ATTR(:get<baseCampaignId>);
my %forwardCompatibilityMap_of :ATTR(:get<forwardCompatibilityMap>);
my %CampaignCriterion__Type_of :ATTR(:get<CampaignCriterion__Type>);

__PACKAGE__->_factory(
    [ qw(        campaignId
        isNegative
        criterion
        bidModifier
        campaignCriterionStatus
        baseCampaignId
        forwardCompatibilityMap
        CampaignCriterion__Type

    ) ],
    {
        'campaignId' => \%campaignId_of,
        'isNegative' => \%isNegative_of,
        'criterion' => \%criterion_of,
        'bidModifier' => \%bidModifier_of,
        'campaignCriterionStatus' => \%campaignCriterionStatus_of,
        'baseCampaignId' => \%baseCampaignId_of,
        'forwardCompatibilityMap' => \%forwardCompatibilityMap_of,
        'CampaignCriterion__Type' => \%CampaignCriterion__Type_of,
    },
    {
        'campaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'isNegative' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'criterion' => 'Google::Ads::AdWords::v201710::Criterion',
        'bidModifier' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'campaignCriterionStatus' => 'Google::Ads::AdWords::v201710::CampaignCriterion::CampaignCriterionStatus',
        'baseCampaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'forwardCompatibilityMap' => 'Google::Ads::AdWords::v201710::String_StringMapEntry',
        'CampaignCriterion__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'campaignId' => 'campaignId',
        'isNegative' => 'isNegative',
        'criterion' => 'criterion',
        'bidModifier' => 'bidModifier',
        'campaignCriterionStatus' => 'campaignCriterionStatus',
        'baseCampaignId' => 'baseCampaignId',
        'forwardCompatibilityMap' => 'forwardCompatibilityMap',
        'CampaignCriterion__Type' => 'CampaignCriterion.Type',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201710::NegativeCampaignCriterion

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NegativeCampaignCriterion from the namespace https://adwords.google.com/api/adwords/cm/v201710.

A negative campaign criterion. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

