package Google::Ads::AdWords::v201708::PolicyTopicConstraint;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201708' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %constraintType_of :ATTR(:get<constraintType>);
my %PolicyTopicConstraint__Type_of :ATTR(:get<PolicyTopicConstraint__Type>);

__PACKAGE__->_factory(
    [ qw(        constraintType
        PolicyTopicConstraint__Type

    ) ],
    {
        'constraintType' => \%constraintType_of,
        'PolicyTopicConstraint__Type' => \%PolicyTopicConstraint__Type_of,
    },
    {
        'constraintType' => 'Google::Ads::AdWords::v201708::PolicyTopicConstraint::PolicyTopicConstraintType',
        'PolicyTopicConstraint__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'constraintType' => 'constraintType',
        'PolicyTopicConstraint__Type' => 'PolicyTopicConstraint.Type',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201708::PolicyTopicConstraint

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PolicyTopicConstraint from the namespace https://adwords.google.com/api/adwords/cm/v201708.

A target which caused a policy finding. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * constraintType


=item * PolicyTopicConstraint__Type

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 PolicyTopicConstraint.Type




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

