// This file is part of MorphoDiTa.
//
// Copyright 2013 by Institute of Formal and Applied Linguistics, Faculty of
// Mathematics and Physics, Charles University in Prague, Czech Republic.
//
// MorphoDiTa is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of
// the License, or (at your option) any later version.
//
// MorphoDiTa is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with MorphoDiTa.  If not, see <http://www.gnu.org/licenses/>.

#include <cstring>
#include <unordered_set>

#include "czech_tokenizer.h"
#include "../utils/utf8.h"

namespace ufal {
namespace morphodita {


static const char _czech_tokenizer_cond_offsets[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2
};

static const char _czech_tokenizer_cond_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0
};

static const short _czech_tokenizer_cond_keys[] = {
	43u, 43u, 45u, 45u, 0
};

static const char _czech_tokenizer_cond_spaces[] = {
	1, 0, 0
};

static const short _czech_tokenizer_key_offsets[] = {
	0, 0, 1, 2, 3, 5, 8, 9, 
	10, 45, 76, 77, 81, 113, 144, 175, 
	206, 236, 243, 246, 256, 277, 279, 295, 
	323, 355, 377, 379, 380, 382, 392, 394, 
	398, 399, 431, 459, 467, 475, 483, 491, 
	507, 513, 515, 516, 534, 535, 536, 539, 
	546, 552, 563, 566, 568, 580, 601, 611, 
	612, 622, 627, 650, 662, 676, 704, 718, 
	723, 724, 731, 737, 741, 744, 746, 747, 
	749, 765, 769, 773, 785, 787, 799, 806, 
	810, 812, 816, 820, 824, 827, 829, 831, 
	833, 834, 836, 846, 848, 864, 873, 876, 
	877, 888, 902, 914, 927, 936, 944, 951, 
	959, 965, 973, 990, 992, 1000, 1009, 1017, 
	1026, 1034, 1043, 1051, 1059, 1070, 1080, 1088, 
	1096, 1107, 1117, 1125, 1133, 1144, 1154, 1170, 
	1172, 1173, 1175, 1176, 1178, 1187, 1193, 1196, 
	1197, 1200, 1207, 1213, 1224, 1227, 1237, 1238, 
	1250, 1255, 1256, 1262, 1269, 1271, 1274, 1305, 
	1327, 1351, 1373, 1375, 1377, 1379, 1391, 1393, 
	1395, 1405, 1407, 1411, 1417, 1418, 1421, 1422, 
	1427, 1429, 1430, 1432, 1434, 1446, 1456, 1458, 
	1460, 1472, 1474, 1476, 1486, 1488, 1492, 1498, 
	1499, 1502, 1503, 1508, 1510, 1511, 1513, 1528, 
	1544, 1558, 1574, 1589, 1603, 1619, 1631, 1647, 
	1663, 1680, 1696, 1713, 1738, 1755, 1771, 1788, 
	1805, 1822, 1839, 1859, 1878, 1894, 1910, 1929, 
	1947, 1972, 1995, 2017, 2042, 2065, 2067, 2077, 
	2079, 2081, 2093, 2095, 2097, 2107, 2109, 2113, 
	2119, 2120, 2123, 2124, 2129, 2131, 2132, 2134, 
	2145, 2146, 2161, 2177, 2194, 2210, 2227, 2243, 
	2260, 2276, 2292, 2311, 2329, 2345, 2361, 2380, 
	2398, 2414, 2430, 2449, 2467, 2470, 2476, 2478, 
	2486, 2492, 2500, 2504, 2508, 2512, 2517, 2522, 
	2531, 2535, 2539, 2550, 2552, 2556, 2558, 2561, 
	2593, 2595, 2597, 2600, 2602, 2608, 2623, 2636, 
	2655, 2667, 2683, 2692, 2708, 2721, 2742, 2750, 
	2764, 2776, 2790, 2803, 2813, 2824, 2833, 2843, 
	2845, 2847, 2868, 2875, 2883, 2889, 2895, 2896, 
	2940, 2946, 2954, 2965, 2975, 2982, 2988, 2992, 
	2996, 2998, 3000, 3004, 3008, 3010, 3016, 3024, 
	3029, 3033, 3035, 3039, 3041, 3047, 3051, 3055, 
	3057, 3061, 3066, 3067, 3071, 3075, 3077, 3081, 
	3085, 3089, 3095, 3106, 3111, 3125, 3140, 3142, 
	3144, 3146, 3162, 3165, 3167, 3171, 3175, 3179, 
	3185, 3189, 3199, 3209, 3210, 3220, 3228, 3236, 
	3240, 3244, 3248, 3250, 3255, 3257, 3260, 3262, 
	3286, 3288, 3294, 3299, 3303, 3307, 3311, 3319, 
	3321, 3323, 3328, 3332, 3336, 3338, 3340, 3346, 
	3354, 3364, 3368, 3372, 3376, 3380, 3399, 3403, 
	3405, 3416, 3422, 3424, 3426, 3430, 3434, 3438, 
	3442, 3444, 3446, 3450, 3452, 3460, 3473, 3497, 
	3506, 3510, 3512, 3513, 3517, 3519, 3523, 3526, 
	3530, 3534, 3536, 3545, 3547, 3551, 3555, 3568, 
	3570, 3574, 3576, 3584, 3586, 3588, 3590, 3593, 
	3595, 3598, 3604, 3606, 3610, 3612, 3613, 3615, 
	3631, 3637, 3643, 3645, 3649, 3663, 3667, 3679, 
	3686, 3690, 3697, 3703, 3709, 3715, 3719, 3722, 
	3736, 3762, 3772, 3775, 3777, 3781, 3784, 3785, 
	3788, 3790, 3806, 3824, 3841, 3858, 3859, 3860, 
	3861, 3878, 3896, 3914, 3932, 3949, 3951, 3953, 
	3955, 3957, 3973, 3990, 4007, 4023, 4025, 4027, 
	4029, 4048, 4066, 4084, 4102, 4120, 4138, 4155, 
	4173, 4191, 4208, 4226, 4244, 4262, 4281, 4299, 
	4317, 4335, 4353, 4371, 4389, 4407, 4425, 4443, 
	4460, 4478, 4496, 4514, 4531, 4549, 4567, 4585, 
	4593, 4594, 4595, 4596, 4597, 4598, 4599, 4600, 
	4601, 4604, 4605, 4606, 4607, 4608, 4609, 4610, 
	4611, 4612, 4613, 4614, 4615, 4616, 4617, 4618, 
	4619, 4620, 4621, 4622, 4623, 4624, 4625, 4626, 
	4642, 4659, 4676, 4693, 4710, 4727, 4744, 4761, 
	4778, 4794, 4811, 4828, 4845, 4862, 4879, 4896, 
	4913, 4930, 4931, 4932, 4933, 4949, 4966, 4983, 
	5000, 5017, 5034, 5051, 5068, 5085, 5086, 5102, 
	5119, 5136, 5153, 5170, 5187, 5204, 5221, 5238, 
	5239, 5240, 5256, 5273, 5290, 5307, 5324, 5341, 
	5358, 5375, 5392, 5393, 5409, 5426, 5443, 5460, 
	5477, 5494, 5511, 5528, 5544, 5561, 5578, 5595, 
	5612, 5629, 5648, 5666, 5684, 5702, 5720, 5737, 
	5754, 5772, 5790, 5808, 5824, 5825, 5826, 5827, 
	5844, 5862, 5879, 5897, 5915, 5932, 5948, 5965, 
	5983, 6001, 6019, 6037, 6054, 6071, 6089, 6106, 
	6124, 6141, 6159, 6177, 6195, 6213, 6231, 6249, 
	6267, 6284, 6302, 6320, 6338, 6356, 6374, 6392, 
	6410, 6428, 6444, 6461, 6478, 6495, 6512, 6530, 
	6546, 6563, 6580, 6597, 6614, 6632, 6650, 6667, 
	6685, 6703, 6720, 6738, 6756, 6774, 6791, 6809, 
	6827, 6844, 6862, 6880, 6898, 6916, 6933, 6951, 
	6969, 6987, 7003, 7020, 7037, 7054, 7071, 7088, 
	7108, 7125, 7141, 7159, 7177, 7195, 7212, 7214, 
	7216, 7232, 7249, 7266, 7283, 7300, 7316, 7333, 
	7350, 7367, 7385, 7403, 7421, 7439, 7456, 7472, 
	7490, 7508, 7525, 7542, 7560, 7578, 7594, 7611, 
	7628, 7729, 7737, 7744, 7750, 7757, 7765, 7766, 
	7774, 7775, 7783, 7814, 7824, 7841, 7844, 7854, 
	7864, 7874, 7884, 7897, 7909, 7923, 7950, 7974, 
	7996, 8006, 8018, 8035, 8049, 8066, 8092, 8118, 
	8142, 8168, 8194, 8223, 8251, 8278, 8302, 8316, 
	8343, 8370, 8400, 8429, 8445, 8496, 8545, 8594, 
	8611, 8628, 8645, 8665, 8684, 8721, 8770, 8819, 
	8870, 8921, 8972, 9021, 9075, 9124, 9177, 9228, 
	9279, 9328, 9379, 9430, 9481, 9530, 9581, 9632, 
	9681, 9732, 9783, 9834, 9883, 9932, 9987, 10038, 
	10089, 10138, 10189, 10240, 10291, 10340, 10389, 10428, 
	10469, 10510, 10549, 10588, 10626, 10664, 10705, 10744, 
	10782, 10820, 10871, 10922, 10973, 11030, 11079, 11130, 
	11179, 11230, 11281, 11330, 11379, 11434, 11487, 11538, 
	11589, 11640, 11691, 11742, 11791, 11842, 11893, 11944, 
	11995, 12046, 12095, 12146, 12197, 12246, 12296, 12345, 
	12394, 12452, 12502, 12551, 12600, 12651, 12702, 12751, 
	12802, 12851, 12906, 12957, 13008, 13057, 13108, 13157, 
	13206, 13261, 13314, 13365, 13414, 13465, 13516, 13567, 
	13618, 13669, 13720, 13769, 13820, 13871, 13922, 13973, 
	14024, 14075, 14124, 14175, 14226, 14277, 14326, 14377, 
	14428, 14479, 14530, 14579, 14632, 14681, 14732, 14783, 
	14834, 14885, 14934, 14991, 15042, 15093, 15142, 15193, 
	15244, 15293, 15344, 15393, 15444, 15495, 15546, 15597, 
	15646, 15700, 15751, 15802, 15853, 15904, 15955, 16006, 
	16055, 16104, 16155, 16206, 16257, 16306, 16361, 16412, 
	16461, 16514, 16565, 16616, 16665, 16714, 16765, 16816, 
	16865, 16916, 16967, 17018, 17069, 17118, 17168, 17217, 
	17268, 17321, 17374, 17425, 17478, 17529, 17580, 17631, 
	17686, 17737, 17739, 17745, 17755, 17794, 17798, 17800, 
	17814, 17825, 17833, 17836, 17842, 17848, 17855, 17859, 
	17869, 17873, 17884, 17900, 17918, 17925, 17929, 17934, 
	17945, 17977, 17984, 17988, 17995, 18002, 18015, 18036, 
	18050, 18068, 18083, 18095, 18106, 18124, 18136, 18166, 
	18173, 18184, 18198, 18212, 18221, 18234, 18246, 18250, 
	18256, 18264, 18291, 18304, 18311, 18316, 18322, 18368, 
	18373, 18396, 18407, 18416, 18429, 18442, 18450, 18457, 
	18461, 18467, 18471, 18474, 18480, 18487, 18491, 18500, 
	18509, 18513, 18521, 18529, 18533, 18540, 18544, 18548, 
	18560, 18564, 18573, 18579, 18583, 18592, 18598, 18608, 
	18620, 18624, 18628, 18640, 18651, 18661, 18677, 18682, 
	18706, 18723, 18729, 18747, 18752, 18758, 18781, 18788, 
	18794, 18797, 18800, 18812, 18820, 18825, 18835, 18842, 
	18845, 18857, 18872, 18879, 18882, 18890, 18898, 18902, 
	18906, 18908, 18911, 18915, 18944, 18950, 18962, 18967, 
	18973, 18981, 18994, 18998, 19005, 19011, 19022, 19030, 
	19038, 19044, 19051, 19055, 19069, 19082, 19099, 19117, 
	19125, 19131, 19137, 19145, 19166, 19172, 19176, 19191, 
	19195, 19199, 19203, 19207, 19211, 19217, 19225, 19230, 
	19234, 19244, 19251, 19254, 19272, 19289, 19316, 19322, 
	19330, 19334, 19340, 19344, 19350, 19355, 19361, 19369, 
	19377, 19389, 19393, 19401, 19407, 19416, 19422, 19430, 
	19434, 19445, 19451, 19457, 19463, 19473, 19481, 19487, 
	19496, 19500, 19505, 19509, 19514, 19524, 19528, 19533, 
	19539, 19542, 19546, 19563, 19566, 19581, 19584, 19595, 
	19603, 19609, 19614, 19618, 19622, 19626, 19633, 19638, 
	19653, 19682, 19693, 19696, 19700, 19706, 19710, 19717, 
	19739
};

static const short _czech_tokenizer_trans_keys[] = {
	160u, 154u, 128u, 128u, 129u, 175u, 128u, 138u, 
	159u, 128u, 13u, 32u, 34u, 40u, 91u, 96u, 
	123u, 194u, 195u, 196u, 197u, 198u, 199u, 200u, 
	201u, 205u, 206u, 207u, 208u, 209u, 210u, 211u, 
	212u, 213u, 224u, 225u, 226u, 227u, 234u, 239u, 
	240u, 9u, 10u, 65u, 90u, 34u, 40u, 91u, 
	96u, 123u, 194u, 195u, 196u, 197u, 198u, 199u, 
	200u, 201u, 205u, 206u, 207u, 208u, 209u, 210u, 
	211u, 212u, 213u, 224u, 225u, 226u, 227u, 234u, 
	239u, 240u, 65u, 90u, 171u, 128u, 150u, 152u, 
	158u, 128u, 130u, 132u, 134u, 136u, 138u, 140u, 
	142u, 144u, 146u, 148u, 150u, 152u, 154u, 156u, 
	158u, 160u, 162u, 164u, 166u, 168u, 170u, 172u, 
	174u, 176u, 178u, 180u, 182u, 185u, 187u, 189u, 
	191u, 129u, 131u, 133u, 135u, 138u, 140u, 142u, 
	144u, 146u, 148u, 150u, 152u, 154u, 156u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 187u, 189u, 184u, 185u, 
	132u, 162u, 164u, 169u, 172u, 181u, 188u, 129u, 
	130u, 134u, 135u, 137u, 139u, 142u, 145u, 147u, 
	148u, 150u, 152u, 156u, 157u, 159u, 160u, 166u, 
	167u, 174u, 175u, 177u, 179u, 183u, 184u, 141u, 
	143u, 145u, 147u, 149u, 151u, 153u, 155u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	180u, 186u, 188u, 190u, 132u, 133u, 135u, 136u, 
	138u, 139u, 177u, 178u, 182u, 184u, 128u, 130u, 
	132u, 134u, 136u, 138u, 140u, 142u, 144u, 146u, 
	148u, 150u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 176u, 178u, 
	186u, 187u, 189u, 190u, 129u, 136u, 138u, 140u, 
	142u, 131u, 134u, 176u, 178u, 182u, 134u, 140u, 
	136u, 138u, 142u, 143u, 145u, 161u, 163u, 171u, 
	143u, 152u, 154u, 156u, 158u, 160u, 162u, 164u, 
	166u, 168u, 170u, 172u, 174u, 180u, 183u, 146u, 
	148u, 185u, 186u, 189u, 191u, 128u, 175u, 160u, 
	162u, 164u, 166u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 182u, 184u, 186u, 188u, 190u, 128u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 174u, 176u, 178u, 180u, 182u, 184u, 
	186u, 188u, 190u, 131u, 133u, 135u, 137u, 139u, 
	141u, 144u, 146u, 148u, 150u, 152u, 154u, 156u, 
	158u, 160u, 162u, 164u, 166u, 168u, 170u, 172u, 
	174u, 176u, 178u, 180u, 182u, 184u, 186u, 188u, 
	190u, 128u, 129u, 128u, 130u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 177u, 
	191u, 128u, 150u, 188u, 186u, 188u, 130u, 131u, 
	154u, 186u, 188u, 189u, 190u, 191u, 184u, 187u, 
	160u, 191u, 135u, 141u, 128u, 133u, 155u, 128u, 
	130u, 132u, 134u, 136u, 138u, 140u, 142u, 144u, 
	146u, 148u, 150u, 152u, 154u, 156u, 158u, 160u, 
	162u, 164u, 166u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 182u, 184u, 186u, 188u, 190u, 128u, 
	130u, 132u, 134u, 136u, 138u, 140u, 142u, 144u, 
	146u, 148u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 174u, 176u, 178u, 180u, 182u, 184u, 
	186u, 188u, 190u, 136u, 143u, 152u, 157u, 168u, 
	175u, 184u, 191u, 153u, 155u, 157u, 159u, 136u, 
	141u, 168u, 175u, 136u, 143u, 152u, 159u, 168u, 
	175u, 184u, 188u, 136u, 140u, 152u, 155u, 168u, 
	172u, 184u, 188u, 128u, 129u, 130u, 132u, 133u, 
	134u, 140u, 157u, 159u, 166u, 167u, 176u, 177u, 
	178u, 179u, 184u, 152u, 185u, 154u, 156u, 158u, 
	159u, 133u, 189u, 141u, 130u, 135u, 149u, 164u, 
	166u, 168u, 139u, 141u, 144u, 146u, 153u, 157u, 
	170u, 173u, 176u, 179u, 190u, 191u, 133u, 131u, 
	136u, 138u, 169u, 168u, 170u, 172u, 174u, 176u, 
	178u, 180u, 133u, 166u, 168u, 170u, 172u, 174u, 
	131u, 133u, 135u, 137u, 139u, 141u, 143u, 145u, 
	147u, 149u, 151u, 152u, 154u, 188u, 128u, 174u, 
	160u, 167u, 169u, 171u, 178u, 181u, 162u, 164u, 
	173u, 176u, 190u, 191u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 171u, 173u, 
	178u, 130u, 132u, 137u, 140u, 156u, 160u, 162u, 
	164u, 166u, 168u, 128u, 136u, 138u, 140u, 142u, 
	144u, 148u, 150u, 152u, 154u, 157u, 153u, 154u, 
	156u, 157u, 158u, 128u, 130u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	154u, 156u, 158u, 160u, 162u, 164u, 166u, 168u, 
	170u, 172u, 128u, 130u, 132u, 134u, 136u, 138u, 
	140u, 142u, 144u, 146u, 148u, 150u, 162u, 164u, 
	166u, 168u, 170u, 172u, 174u, 178u, 180u, 182u, 
	184u, 186u, 188u, 190u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 185u, 187u, 189u, 190u, 
	128u, 130u, 132u, 134u, 139u, 141u, 144u, 146u, 
	160u, 162u, 164u, 166u, 168u, 170u, 180u, 184u, 
	185u, 188u, 189u, 190u, 151u, 181u, 183u, 185u, 
	187u, 189u, 191u, 129u, 131u, 135u, 153u, 155u, 
	157u, 136u, 187u, 161u, 186u, 155u, 159u, 162u, 
	144u, 157u, 144u, 128u, 167u, 144u, 145u, 146u, 
	147u, 148u, 149u, 150u, 151u, 152u, 153u, 154u, 
	155u, 156u, 157u, 158u, 159u, 128u, 153u, 180u, 
	191u, 128u, 141u, 168u, 191u, 156u, 162u, 128u, 
	129u, 158u, 159u, 165u, 166u, 169u, 172u, 174u, 
	181u, 144u, 169u, 132u, 133u, 135u, 138u, 141u, 
	148u, 150u, 156u, 184u, 185u, 187u, 190u, 134u, 
	128u, 132u, 138u, 144u, 172u, 191u, 128u, 133u, 
	160u, 185u, 148u, 173u, 136u, 161u, 188u, 191u, 
	128u, 149u, 176u, 191u, 128u, 137u, 168u, 191u, 
	128u, 162u, 186u, 156u, 180u, 150u, 174u, 144u, 
	168u, 138u, 160u, 171u, 130u, 131u, 154u, 186u, 
	188u, 189u, 190u, 191u, 184u, 187u, 128u, 155u, 
	128u, 129u, 130u, 132u, 133u, 134u, 140u, 157u, 
	159u, 166u, 167u, 176u, 177u, 178u, 179u, 184u, 
	152u, 175u, 185u, 128u, 138u, 154u, 156u, 158u, 
	159u, 133u, 159u, 189u, 128u, 128u, 136u, 138u, 
	140u, 142u, 144u, 148u, 150u, 152u, 154u, 157u, 
	33u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 64u, 95u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	49u, 50u, 51u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 39u, 41u, 
	61u, 95u, 36u, 47u, 48u, 57u, 58u, 59u, 
	63u, 64u, 65u, 90u, 97u, 122u, 48u, 57u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	48u, 49u, 50u, 51u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 48u, 49u, 50u, 51u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 48u, 49u, 50u, 51u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 53u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 53u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 53u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 13u, 32u, 34u, 39u, 41u, 59u, 
	93u, 125u, 194u, 224u, 225u, 226u, 227u, 239u, 
	9u, 10u, 160u, 187u, 188u, 187u, 189u, 154u, 
	128u, 156u, 128u, 129u, 130u, 140u, 157u, 159u, 
	166u, 167u, 184u, 153u, 157u, 175u, 186u, 128u, 
	138u, 134u, 159u, 190u, 142u, 137u, 139u, 170u, 
	169u, 171u, 173u, 175u, 177u, 179u, 181u, 134u, 
	167u, 169u, 171u, 173u, 175u, 132u, 134u, 136u, 
	138u, 140u, 142u, 144u, 146u, 148u, 150u, 152u, 
	153u, 155u, 189u, 131u, 133u, 138u, 141u, 157u, 
	161u, 163u, 165u, 167u, 169u, 128u, 128u, 137u, 
	139u, 141u, 143u, 145u, 149u, 151u, 153u, 155u, 
	158u, 159u, 180u, 184u, 185u, 188u, 189u, 191u, 
	152u, 182u, 184u, 186u, 188u, 190u, 128u, 130u, 
	132u, 136u, 154u, 156u, 158u, 137u, 189u, 157u, 
	160u, 163u, 13u, 32u, 33u, 34u, 40u, 58u, 
	59u, 64u, 93u, 95u, 125u, 194u, 224u, 225u, 
	226u, 227u, 239u, 9u, 10u, 36u, 37u, 39u, 
	41u, 42u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	43u, 45u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	58u, 64u, 95u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 160u, 169u, 176u, 
	185u, 128u, 137u, 165u, 167u, 169u, 171u, 173u, 
	175u, 177u, 179u, 181u, 185u, 187u, 188u, 166u, 
	175u, 144u, 153u, 129u, 130u, 159u, 160u, 165u, 
	167u, 170u, 173u, 174u, 177u, 134u, 143u, 128u, 
	137u, 144u, 153u, 152u, 163u, 164u, 167u, 169u, 
	175u, 188u, 144u, 145u, 157u, 146u, 129u, 131u, 
	132u, 135u, 155u, 182u, 191u, 159u, 142u, 191u, 
	160u, 169u, 43u, 45u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 48u, 57u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 48u, 57u, 
	176u, 185u, 128u, 137u, 165u, 167u, 169u, 171u, 
	173u, 175u, 177u, 179u, 181u, 185u, 187u, 188u, 
	166u, 175u, 144u, 153u, 129u, 130u, 159u, 160u, 
	165u, 167u, 170u, 173u, 174u, 177u, 134u, 143u, 
	128u, 137u, 144u, 153u, 152u, 163u, 164u, 167u, 
	169u, 175u, 188u, 144u, 145u, 157u, 146u, 129u, 
	131u, 132u, 135u, 155u, 182u, 191u, 159u, 142u, 
	191u, 33u, 45u, 58u, 64u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	58u, 64u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 95u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 47u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 48u, 49u, 50u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 46u, 51u, 57u, 65u, 90u, 
	97u, 122u, 33u, 48u, 49u, 50u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 51u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 48u, 49u, 50u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 51u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 53u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 53u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 43u, 45u, 46u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	95u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 58u, 64u, 95u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 43u, 45u, 46u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 95u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 160u, 169u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 48u, 57u, 176u, 185u, 128u, 
	137u, 165u, 167u, 169u, 171u, 173u, 175u, 177u, 
	179u, 181u, 185u, 187u, 188u, 166u, 175u, 144u, 
	153u, 129u, 130u, 159u, 160u, 165u, 167u, 170u, 
	173u, 174u, 177u, 134u, 143u, 128u, 137u, 144u, 
	153u, 152u, 163u, 164u, 167u, 169u, 175u, 188u, 
	144u, 145u, 157u, 146u, 129u, 131u, 132u, 135u, 
	155u, 182u, 191u, 159u, 142u, 191u, 33u, 47u, 
	95u, 36u, 37u, 39u, 57u, 65u, 90u, 97u, 
	122u, 47u, 33u, 48u, 49u, 50u, 95u, 36u, 
	37u, 39u, 46u, 51u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 48u, 49u, 50u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 51u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 48u, 49u, 50u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 51u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 48u, 49u, 50u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 51u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 53u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 53u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 53u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 52u, 54u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 53u, 54u, 57u, 65u, 
	90u, 97u, 122u, 170u, 181u, 186u, 128u, 150u, 
	152u, 182u, 184u, 191u, 128u, 191u, 172u, 174u, 
	128u, 129u, 134u, 145u, 160u, 164u, 128u, 180u, 
	182u, 183u, 186u, 189u, 134u, 140u, 136u, 138u, 
	142u, 161u, 163u, 191u, 128u, 181u, 183u, 191u, 
	128u, 129u, 131u, 191u, 128u, 167u, 177u, 191u, 
	153u, 128u, 150u, 161u, 191u, 191u, 128u, 135u, 
	145u, 189u, 135u, 129u, 130u, 132u, 133u, 144u, 
	170u, 176u, 178u, 144u, 154u, 160u, 191u, 128u, 
	159u, 174u, 191u, 191u, 128u, 147u, 149u, 156u, 
	159u, 168u, 170u, 175u, 186u, 188u, 144u, 191u, 
	128u, 138u, 141u, 191u, 128u, 177u, 186u, 138u, 
	181u, 160u, 161u, 162u, 163u, 164u, 165u, 166u, 
	167u, 168u, 169u, 170u, 171u, 172u, 173u, 174u, 
	175u, 176u, 177u, 178u, 179u, 180u, 181u, 182u, 
	183u, 184u, 185u, 186u, 187u, 188u, 189u, 190u, 
	191u, 128u, 173u, 128u, 155u, 160u, 162u, 172u, 
	164u, 190u, 128u, 163u, 177u, 183u, 185u, 191u, 
	178u, 129u, 131u, 133u, 140u, 143u, 144u, 147u, 
	168u, 170u, 176u, 182u, 185u, 188u, 191u, 151u, 
	128u, 132u, 135u, 136u, 139u, 142u, 156u, 157u, 
	159u, 163u, 176u, 177u, 188u, 129u, 131u, 133u, 
	138u, 143u, 144u, 147u, 168u, 170u, 176u, 178u, 
	179u, 181u, 182u, 184u, 185u, 190u, 191u, 145u, 
	158u, 128u, 130u, 135u, 136u, 139u, 141u, 153u, 
	156u, 176u, 181u, 129u, 131u, 133u, 141u, 143u, 
	145u, 147u, 168u, 170u, 176u, 178u, 179u, 181u, 
	185u, 188u, 191u, 144u, 128u, 133u, 135u, 137u, 
	139u, 141u, 160u, 163u, 129u, 131u, 133u, 140u, 
	143u, 144u, 147u, 168u, 170u, 176u, 178u, 179u, 
	181u, 185u, 188u, 191u, 177u, 128u, 132u, 135u, 
	136u, 139u, 141u, 150u, 151u, 156u, 157u, 159u, 
	163u, 156u, 130u, 131u, 133u, 138u, 142u, 144u, 
	146u, 149u, 153u, 154u, 158u, 159u, 163u, 164u, 
	168u, 170u, 174u, 185u, 190u, 191u, 144u, 151u, 
	128u, 130u, 134u, 136u, 138u, 141u, 129u, 131u, 
	133u, 140u, 142u, 144u, 146u, 168u, 170u, 179u, 
	181u, 185u, 189u, 191u, 128u, 132u, 134u, 136u, 
	138u, 141u, 149u, 150u, 152u, 153u, 160u, 163u, 
	130u, 131u, 133u, 140u, 142u, 144u, 146u, 168u, 
	170u, 179u, 181u, 185u, 188u, 191u, 158u, 128u, 
	132u, 134u, 136u, 138u, 141u, 149u, 150u, 160u, 
	163u, 177u, 178u, 130u, 131u, 133u, 140u, 142u, 
	144u, 146u, 186u, 189u, 191u, 151u, 128u, 132u, 
	134u, 136u, 138u, 142u, 160u, 163u, 186u, 191u, 
	189u, 130u, 131u, 133u, 150u, 154u, 177u, 179u, 
	187u, 138u, 150u, 128u, 134u, 143u, 148u, 152u, 
	159u, 178u, 179u, 129u, 186u, 128u, 142u, 132u, 
	138u, 141u, 165u, 167u, 129u, 130u, 135u, 136u, 
	148u, 151u, 153u, 159u, 161u, 163u, 170u, 171u, 
	173u, 185u, 187u, 189u, 134u, 128u, 132u, 136u, 
	141u, 156u, 159u, 128u, 181u, 183u, 185u, 152u, 
	153u, 190u, 191u, 128u, 135u, 137u, 172u, 177u, 
	191u, 128u, 132u, 134u, 151u, 153u, 188u, 134u, 
	129u, 130u, 131u, 137u, 138u, 139u, 140u, 141u, 
	142u, 143u, 144u, 153u, 154u, 155u, 156u, 157u, 
	159u, 160u, 161u, 162u, 163u, 164u, 165u, 166u, 
	167u, 168u, 169u, 170u, 172u, 173u, 174u, 175u, 
	176u, 177u, 179u, 183u, 188u, 189u, 190u, 191u, 
	128u, 158u, 180u, 187u, 128u, 143u, 154u, 157u, 
	160u, 191u, 135u, 141u, 128u, 133u, 144u, 186u, 
	188u, 191u, 152u, 128u, 136u, 138u, 141u, 144u, 
	150u, 154u, 157u, 160u, 191u, 128u, 136u, 138u, 
	141u, 144u, 176u, 178u, 181u, 184u, 190u, 128u, 
	130u, 133u, 136u, 150u, 152u, 191u, 128u, 144u, 
	146u, 149u, 152u, 191u, 128u, 154u, 157u, 159u, 
	128u, 143u, 160u, 191u, 128u, 180u, 129u, 191u, 
	128u, 172u, 175u, 191u, 129u, 154u, 160u, 191u, 
	128u, 170u, 128u, 140u, 142u, 148u, 160u, 180u, 
	128u, 147u, 160u, 172u, 174u, 176u, 178u, 179u, 
	151u, 128u, 147u, 156u, 157u, 139u, 141u, 160u, 
	191u, 128u, 183u, 128u, 170u, 176u, 191u, 128u, 
	181u, 128u, 156u, 160u, 171u, 176u, 187u, 144u, 
	173u, 176u, 180u, 128u, 171u, 176u, 191u, 128u, 
	137u, 128u, 155u, 160u, 191u, 191u, 128u, 158u, 
	160u, 188u, 167u, 128u, 139u, 171u, 179u, 128u, 
	175u, 186u, 191u, 128u, 179u, 141u, 143u, 154u, 
	189u, 144u, 146u, 148u, 182u, 128u, 166u, 188u, 
	191u, 128u, 149u, 152u, 157u, 160u, 191u, 153u, 
	155u, 157u, 128u, 133u, 136u, 141u, 144u, 151u, 
	159u, 189u, 190u, 128u, 180u, 182u, 188u, 130u, 
	132u, 134u, 140u, 144u, 147u, 150u, 155u, 160u, 
	172u, 178u, 180u, 182u, 188u, 129u, 130u, 131u, 
	132u, 133u, 134u, 176u, 177u, 178u, 179u, 180u, 
	181u, 182u, 183u, 184u, 177u, 191u, 144u, 156u, 
	144u, 176u, 130u, 135u, 149u, 164u, 166u, 168u, 
	138u, 147u, 153u, 157u, 170u, 173u, 175u, 185u, 
	188u, 191u, 142u, 133u, 137u, 131u, 132u, 128u, 
	174u, 176u, 191u, 128u, 158u, 160u, 191u, 128u, 
	164u, 171u, 179u, 167u, 173u, 128u, 165u, 176u, 
	191u, 175u, 191u, 128u, 167u, 128u, 150u, 160u, 
	166u, 168u, 174u, 176u, 182u, 184u, 190u, 128u, 
	134u, 136u, 142u, 144u, 150u, 152u, 158u, 160u, 
	191u, 175u, 128u, 129u, 130u, 131u, 132u, 133u, 
	134u, 135u, 144u, 191u, 133u, 134u, 170u, 175u, 
	177u, 181u, 187u, 188u, 128u, 150u, 153u, 154u, 
	157u, 159u, 161u, 191u, 128u, 186u, 188u, 191u, 
	133u, 173u, 177u, 191u, 128u, 142u, 160u, 186u, 
	176u, 191u, 182u, 128u, 181u, 184u, 191u, 128u, 
	191u, 191u, 128u, 190u, 128u, 140u, 146u, 147u, 
	152u, 153u, 154u, 155u, 156u, 158u, 159u, 160u, 
	161u, 163u, 164u, 165u, 167u, 168u, 169u, 171u, 
	172u, 175u, 128u, 170u, 176u, 191u, 144u, 189u, 
	128u, 140u, 144u, 159u, 170u, 171u, 191u, 128u, 
	178u, 180u, 189u, 128u, 151u, 159u, 191u, 128u, 
	165u, 176u, 177u, 151u, 159u, 162u, 191u, 128u, 
	136u, 139u, 142u, 144u, 147u, 160u, 170u, 184u, 
	191u, 128u, 167u, 187u, 128u, 132u, 160u, 183u, 
	138u, 173u, 176u, 191u, 128u, 147u, 160u, 188u, 
	128u, 143u, 128u, 182u, 128u, 141u, 160u, 182u, 
	186u, 187u, 128u, 130u, 155u, 157u, 160u, 175u, 
	178u, 182u, 129u, 134u, 137u, 142u, 145u, 150u, 
	160u, 166u, 168u, 174u, 128u, 170u, 172u, 173u, 
	158u, 159u, 128u, 157u, 128u, 163u, 176u, 191u, 
	128u, 134u, 139u, 187u, 169u, 171u, 172u, 173u, 
	174u, 175u, 180u, 181u, 182u, 183u, 184u, 185u, 
	187u, 188u, 189u, 190u, 191u, 164u, 186u, 128u, 
	173u, 176u, 191u, 128u, 153u, 190u, 128u, 134u, 
	147u, 151u, 157u, 168u, 170u, 182u, 184u, 188u, 
	128u, 129u, 131u, 132u, 134u, 191u, 147u, 191u, 
	128u, 189u, 128u, 143u, 146u, 191u, 128u, 135u, 
	176u, 187u, 128u, 143u, 160u, 166u, 176u, 180u, 
	182u, 191u, 128u, 188u, 161u, 186u, 129u, 154u, 
	166u, 191u, 128u, 190u, 130u, 135u, 138u, 143u, 
	146u, 151u, 154u, 156u, 144u, 145u, 146u, 147u, 
	150u, 155u, 157u, 158u, 170u, 171u, 175u, 160u, 
	169u, 128u, 129u, 130u, 131u, 135u, 138u, 139u, 
	140u, 141u, 142u, 143u, 146u, 160u, 161u, 164u, 
	166u, 168u, 169u, 172u, 173u, 176u, 177u, 144u, 
	145u, 191u, 128u, 139u, 141u, 166u, 168u, 186u, 
	188u, 189u, 128u, 141u, 144u, 157u, 128u, 186u, 
	189u, 128u, 156u, 160u, 191u, 128u, 144u, 128u, 
	158u, 176u, 191u, 128u, 130u, 137u, 128u, 157u, 
	160u, 191u, 128u, 131u, 136u, 143u, 128u, 157u, 
	136u, 188u, 191u, 128u, 133u, 138u, 181u, 183u, 
	184u, 128u, 149u, 128u, 149u, 160u, 185u, 128u, 
	183u, 190u, 191u, 191u, 128u, 131u, 133u, 134u, 
	140u, 147u, 149u, 151u, 153u, 179u, 184u, 186u, 
	160u, 188u, 128u, 149u, 160u, 178u, 128u, 136u, 
	128u, 129u, 130u, 131u, 132u, 134u, 135u, 154u, 
	128u, 134u, 144u, 168u, 128u, 132u, 141u, 128u, 
	140u, 128u, 174u, 144u, 128u, 143u, 168u, 188u, 
	189u, 190u, 160u, 167u, 128u, 184u, 128u, 132u, 
	144u, 190u, 143u, 159u, 128u, 128u, 129u, 133u, 
	134u, 137u, 145u, 146u, 147u, 148u, 149u, 154u, 
	155u, 156u, 157u, 158u, 159u, 144u, 153u, 165u, 
	169u, 173u, 178u, 187u, 191u, 128u, 130u, 133u, 
	139u, 170u, 173u, 130u, 132u, 128u, 148u, 150u, 
	191u, 162u, 187u, 128u, 156u, 158u, 159u, 165u, 
	166u, 169u, 172u, 174u, 185u, 189u, 191u, 128u, 
	131u, 133u, 191u, 128u, 133u, 135u, 138u, 141u, 
	148u, 150u, 156u, 158u, 185u, 187u, 190u, 134u, 
	128u, 132u, 138u, 144u, 146u, 191u, 128u, 165u, 
	168u, 191u, 128u, 130u, 154u, 156u, 186u, 188u, 
	191u, 128u, 148u, 150u, 180u, 182u, 191u, 128u, 
	142u, 144u, 174u, 176u, 191u, 128u, 136u, 138u, 
	168u, 170u, 191u, 128u, 130u, 132u, 139u, 184u, 
	185u, 186u, 164u, 167u, 185u, 187u, 128u, 131u, 
	133u, 159u, 161u, 162u, 169u, 178u, 180u, 183u, 
	130u, 135u, 137u, 139u, 148u, 151u, 153u, 155u, 
	157u, 159u, 164u, 190u, 141u, 143u, 145u, 146u, 
	161u, 162u, 167u, 170u, 172u, 178u, 180u, 183u, 
	185u, 188u, 128u, 137u, 139u, 155u, 161u, 163u, 
	165u, 169u, 171u, 187u, 155u, 128u, 191u, 128u, 
	150u, 156u, 160u, 128u, 159u, 168u, 160u, 167u, 
	160u, 135u, 132u, 134u, 128u, 175u, 33u, 45u, 
	58u, 64u, 75u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 97u, 195u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 98u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 106u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 100u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 161u, 105u, 100u, 33u, 45u, 58u, 
	64u, 66u, 95u, 98u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 76u, 95u, 108u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 79u, 95u, 111u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 75u, 
	95u, 107u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 195u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 129u, 161u, 84u, 
	116u, 79u, 111u, 82u, 114u, 33u, 45u, 58u, 
	64u, 82u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 79u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 77u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 58u, 64u, 95u, 196u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 140u, 
	141u, 79u, 111u, 85u, 117u, 33u, 45u, 58u, 
	64u, 77u, 80u, 95u, 109u, 112u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 73u, 95u, 105u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 78u, 
	95u, 110u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 67u, 95u, 99u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 72u, 95u, 104u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 85u, 95u, 117u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 67u, 95u, 
	99u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	79u, 95u, 111u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 76u, 95u, 108u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 58u, 64u, 70u, 95u, 102u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 82u, 95u, 114u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	58u, 64u, 66u, 77u, 95u, 98u, 109u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 85u, 95u, 
	117u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	83u, 95u, 115u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 73u, 95u, 105u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 78u, 95u, 110u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	83u, 95u, 115u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 83u, 95u, 115u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 65u, 95u, 97u, 36u, 
	37u, 39u, 44u, 48u, 57u, 66u, 90u, 98u, 
	122u, 33u, 45u, 46u, 58u, 64u, 73u, 95u, 
	105u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 58u, 64u, 80u, 
	95u, 112u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 76u, 95u, 108u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 65u, 95u, 97u, 36u, 37u, 
	39u, 44u, 48u, 57u, 66u, 90u, 98u, 122u, 
	33u, 45u, 46u, 58u, 64u, 89u, 95u, 121u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 70u, 95u, 
	102u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	73u, 95u, 105u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 70u, 95u, 102u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 84u, 95u, 116u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 157u, 189u, 128u, 150u, 152u, 182u, 184u, 
	191u, 77u, 195u, 173u, 115u, 116u, 101u, 99u, 
	107u, 97u, 111u, 117u, 77u, 195u, 173u, 115u, 
	116u, 101u, 107u, 77u, 195u, 173u, 115u, 116u, 
	107u, 101u, 109u, 77u, 195u, 173u, 115u, 116u, 
	107u, 117u, 33u, 45u, 58u, 64u, 74u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	97u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 98u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 114u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 107u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 111u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 118u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 115u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 107u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 195u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 74u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	97u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 98u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 114u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 107u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 111u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 118u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 115u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 107u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 195u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 169u, 104u, 111u, 33u, 45u, 58u, 
	64u, 74u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 97u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 98u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 114u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 107u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 111u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 118u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	115u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 107u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 195u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 189u, 33u, 45u, 
	58u, 64u, 74u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 97u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 98u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 114u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 107u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 111u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	118u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 115u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 107u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 195u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 169u, 109u, 
	33u, 45u, 58u, 64u, 74u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 97u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 98u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 114u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	107u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 111u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 118u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 115u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 107u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 195u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	169u, 33u, 45u, 58u, 64u, 68u, 95u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 97u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	98u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	118u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 105u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 100u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 115u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 111u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 110u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 58u, 64u, 80u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 97u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 98u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 99u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	107u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 97u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 98u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 114u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 58u, 
	64u, 70u, 84u, 95u, 102u, 116u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 73u, 95u, 105u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 67u, 95u, 99u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 72u, 95u, 104u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 58u, 64u, 84u, 95u, 116u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 58u, 64u, 65u, 95u, 97u, 
	36u, 37u, 39u, 46u, 48u, 57u, 66u, 90u, 
	98u, 122u, 33u, 45u, 46u, 58u, 64u, 68u, 
	95u, 100u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 82u, 95u, 114u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 58u, 64u, 95u, 196u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	140u, 83u, 76u, 33u, 45u, 58u, 64u, 77u, 
	95u, 109u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 85u, 95u, 117u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	58u, 64u, 72u, 95u, 104u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 79u, 95u, 111u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 87u, 95u, 
	119u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 58u, 64u, 73u, 
	95u, 105u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	78u, 95u, 110u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 79u, 95u, 111u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 79u, 95u, 111u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 82u, 95u, 
	114u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 58u, 64u, 84u, 
	95u, 116u, 196u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 58u, 
	64u, 70u, 95u, 102u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	58u, 64u, 70u, 95u, 102u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 69u, 95u, 101u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 58u, 64u, 85u, 95u, 117u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 80u, 
	95u, 112u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	76u, 95u, 108u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 69u, 95u, 101u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 78u, 95u, 110u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 73u, 95u, 
	105u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	78u, 95u, 110u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 73u, 95u, 105u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 83u, 95u, 115u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 77u, 95u, 
	109u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 58u, 64u, 76u, 
	95u, 108u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 78u, 95u, 110u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 73u, 95u, 105u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 78u, 
	95u, 110u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 73u, 95u, 105u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 83u, 95u, 115u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 77u, 95u, 109u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 85u, 
	95u, 117u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	66u, 95u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 101u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 110u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 122u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 121u, 33u, 
	45u, 58u, 64u, 66u, 95u, 98u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 65u, 95u, 97u, 
	36u, 37u, 39u, 44u, 48u, 57u, 66u, 90u, 
	98u, 122u, 33u, 45u, 58u, 64u, 68u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	97u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 98u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 109u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 101u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 58u, 
	64u, 76u, 95u, 108u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 73u, 95u, 105u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 78u, 95u, 110u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 69u, 95u, 
	101u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	88u, 95u, 120u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 80u, 95u, 112u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 58u, 64u, 80u, 95u, 112u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 79u, 95u, 111u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 78u, 
	95u, 110u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 71u, 95u, 103u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	58u, 64u, 79u, 95u, 111u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 70u, 95u, 102u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 70u, 95u, 
	102u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 58u, 64u, 77u, 
	95u, 109u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 85u, 95u, 117u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 83u, 95u, 115u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 73u, 95u, 105u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 67u, 
	95u, 99u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	66u, 95u, 98u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 85u, 95u, 117u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 84u, 95u, 116u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 65u, 95u, 
	97u, 36u, 37u, 39u, 44u, 48u, 57u, 66u, 
	90u, 98u, 122u, 33u, 45u, 58u, 64u, 85u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 104u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 101u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 114u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 115u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 107u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 97u, 101u, 
	111u, 117u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 98u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 109u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 58u, 
	64u, 83u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 89u, 95u, 121u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 83u, 95u, 115u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 84u, 95u, 
	116u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 195u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 137u, 169u, 77u, 109u, 
	33u, 45u, 58u, 64u, 82u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 111u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 121u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	99u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 58u, 64u, 70u, 
	95u, 102u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	87u, 95u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 97u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 98u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 116u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	58u, 64u, 65u, 95u, 97u, 36u, 37u, 39u, 
	46u, 48u, 57u, 66u, 90u, 98u, 122u, 33u, 
	45u, 46u, 58u, 64u, 80u, 95u, 112u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 80u, 95u, 
	112u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	69u, 95u, 101u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 65u, 95u, 97u, 36u, 37u, 39u, 
	44u, 48u, 57u, 66u, 90u, 98u, 122u, 33u, 
	45u, 58u, 64u, 66u, 95u, 98u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 58u, 64u, 77u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 79u, 95u, 111u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 66u, 
	95u, 98u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	87u, 95u, 119u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 58u, 
	64u, 82u, 95u, 114u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 65u, 95u, 97u, 36u, 37u, 
	39u, 44u, 48u, 57u, 66u, 90u, 98u, 122u, 
	33u, 45u, 46u, 58u, 64u, 77u, 95u, 109u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 68u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	85u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 9u, 10u, 13u, 32u, 
	33u, 38u, 44u, 46u, 47u, 48u, 49u, 50u, 
	63u, 65u, 66u, 67u, 68u, 69u, 70u, 71u, 
	72u, 73u, 75u, 77u, 78u, 79u, 80u, 82u, 
	83u, 84u, 85u, 95u, 97u, 98u, 99u, 100u, 
	101u, 102u, 104u, 107u, 109u, 111u, 112u, 115u, 
	194u, 195u, 203u, 204u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 301u, 557u, 811u, 
	1067u, 0u, 35u, 36u, 42u, 51u, 57u, 58u, 
	64u, 74u, 90u, 91u, 96u, 103u, 122u, 123u, 
	127u, 128u, 193u, 196u, 218u, 229u, 236u, 238u, 
	255u, 9u, 10u, 13u, 32u, 194u, 225u, 226u, 
	227u, 9u, 13u, 32u, 194u, 225u, 226u, 227u, 
	9u, 32u, 194u, 225u, 226u, 227u, 9u, 10u, 
	32u, 194u, 225u, 226u, 227u, 9u, 10u, 13u, 
	32u, 194u, 225u, 226u, 227u, 13u, 9u, 10u, 
	13u, 32u, 194u, 225u, 226u, 227u, 10u, 9u, 
	10u, 13u, 32u, 194u, 225u, 226u, 227u, 13u, 
	32u, 33u, 34u, 40u, 58u, 59u, 64u, 93u, 
	95u, 125u, 194u, 224u, 225u, 226u, 227u, 239u, 
	9u, 10u, 36u, 37u, 39u, 41u, 42u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	47u, 58u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 39u, 41u, 61u, 95u, 36u, 47u, 48u, 
	57u, 58u, 59u, 63u, 64u, 65u, 90u, 97u, 
	122u, 47u, 48u, 57u, 45u, 46u, 47u, 58u, 
	48u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	47u, 58u, 48u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 47u, 58u, 48u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 47u, 58u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 47u, 53u, 
	58u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 47u, 58u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 44u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 43u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 48u, 57u, 69u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	48u, 57u, 33u, 45u, 46u, 47u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 47u, 64u, 95u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 47u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 69u, 95u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 53u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 44u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 69u, 95u, 101u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 44u, 48u, 53u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 44u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 43u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 44u, 46u, 
	69u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 48u, 57u, 33u, 44u, 45u, 46u, 
	58u, 64u, 69u, 95u, 101u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	43u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	44u, 45u, 46u, 58u, 64u, 69u, 95u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 43u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 44u, 45u, 46u, 53u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 43u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 44u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 43u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 13u, 32u, 34u, 
	39u, 41u, 59u, 93u, 125u, 194u, 224u, 225u, 
	226u, 227u, 239u, 9u, 10u, 33u, 45u, 46u, 
	58u, 64u, 76u, 95u, 108u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 95u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 47u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 47u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 53u, 54u, 57u, 
	65u, 90u, 97u, 122u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 95u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 95u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	69u, 95u, 101u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 84u, 95u, 116u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 65u, 95u, 
	97u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 66u, 90u, 98u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 95u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 68u, 72u, 79u, 95u, 104u, 111u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	95u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 65u, 85u, 95u, 97u, 117u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 66u, 90u, 98u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 78u, 95u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 71u, 95u, 103u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 95u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 65u, 95u, 97u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 66u, 90u, 98u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	78u, 95u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 71u, 95u, 103u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 95u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 67u, 
	95u, 99u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 65u, 95u, 97u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	66u, 90u, 98u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 85u, 95u, 
	117u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 84u, 95u, 116u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 89u, 95u, 121u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 95u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	95u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 65u, 73u, 82u, 95u, 97u, 105u, 114u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 66u, 90u, 98u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	73u, 95u, 105u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 82u, 95u, 114u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 95u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 70u, 
	95u, 102u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 84u, 95u, 116u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 89u, 95u, 121u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	95u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 95u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 68u, 100u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 69u, 75u, 101u, 107u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 67u, 75u, 99u, 
	107u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 75u, 107u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 79u, 111u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 45u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 45u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	69u, 85u, 101u, 117u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 77u, 109u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	45u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 45u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 85u, 95u, 117u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 84u, 95u, 116u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 72u, 
	95u, 104u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 65u, 69u, 79u, 85u, 95u, 97u, 
	101u, 111u, 117u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 66u, 90u, 
	98u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 77u, 95u, 109u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 95u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	86u, 95u, 118u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 73u, 95u, 105u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 95u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 95u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	65u, 69u, 73u, 95u, 97u, 101u, 105u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 66u, 90u, 98u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 78u, 
	82u, 95u, 110u, 114u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 68u, 95u, 100u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 83u, 
	95u, 115u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 76u, 95u, 108u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 69u, 95u, 101u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	89u, 95u, 121u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 87u, 95u, 119u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 76u, 
	95u, 108u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 69u, 95u, 101u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 84u, 95u, 116u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	84u, 95u, 116u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 71u, 95u, 103u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 72u, 
	95u, 104u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 80u, 95u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 95u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 68u, 
	73u, 78u, 79u, 85u, 95u, 105u, 110u, 111u, 
	117u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 85u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 95u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 79u, 95u, 111u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	87u, 95u, 119u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 72u, 95u, 104u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 95u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	65u, 78u, 79u, 95u, 97u, 110u, 111u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 66u, 90u, 98u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 78u, 
	95u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 71u, 95u, 103u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 71u, 95u, 
	103u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 95u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 65u, 69u, 74u, 95u, 97u, 
	101u, 106u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 66u, 90u, 98u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 75u, 82u, 95u, 107u, 114u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 88u, 95u, 120u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 73u, 95u, 
	105u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 83u, 95u, 115u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 77u, 95u, 109u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 85u, 
	95u, 117u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 83u, 95u, 115u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 82u, 95u, 
	114u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 67u, 95u, 99u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 69u, 95u, 101u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 68u, 
	95u, 100u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 69u, 95u, 101u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 83u, 95u, 115u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	95u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 79u, 95u, 111u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 78u, 95u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 71u, 
	95u, 103u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 79u, 95u, 111u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 84u, 95u, 
	116u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 82u, 95u, 114u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 69u, 95u, 101u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 95u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	78u, 82u, 95u, 110u, 114u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 73u, 95u, 
	105u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 78u, 95u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 84u, 
	95u, 116u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 73u, 76u, 79u, 82u, 95u, 
	105u, 108u, 111u, 114u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 78u, 95u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 71u, 
	95u, 103u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 65u, 95u, 97u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 66u, 90u, 98u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 89u, 95u, 
	121u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 95u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 80u, 95u, 112u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 79u, 95u, 
	111u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 80u, 95u, 112u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 65u, 95u, 97u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 66u, 90u, 98u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 78u, 
	95u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 65u, 77u, 79u, 95u, 97u, 
	111u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 66u, 90u, 98u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 75u, 95u, 107u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 79u, 95u, 111u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 85u, 
	95u, 117u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 83u, 95u, 115u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 75u, 95u, 107u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	79u, 95u, 111u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 95u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 76u, 95u, 108u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 58u, 64u, 
	76u, 95u, 108u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 83u, 95u, 115u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 95u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 67u, 
	69u, 72u, 95u, 99u, 101u, 104u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 73u, 95u, 
	105u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 95u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 84u, 88u, 95u, 116u, 120u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 79u, 
	95u, 111u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 78u, 95u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 95u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 79u, 
	95u, 111u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 87u, 95u, 119u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 67u, 95u, 
	99u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 72u, 95u, 104u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 65u, 95u, 97u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 39u, 44u, 
	48u, 57u, 66u, 90u, 98u, 122u, 196u, 218u, 
	229u, 236u, 33u, 45u, 46u, 58u, 64u, 74u, 
	95u, 106u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 83u, 95u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 58u, 64u, 95u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 79u, 95u, 
	111u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 65u, 73u, 95u, 97u, 105u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 66u, 90u, 98u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 65u, 73u, 
	95u, 97u, 105u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 66u, 90u, 
	98u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 78u, 95u, 110u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 78u, 85u, 
	95u, 110u, 117u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 78u, 95u, 110u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 45u, 46u, 58u, 64u, 65u, 95u, 
	97u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	39u, 44u, 48u, 57u, 66u, 90u, 98u, 122u, 
	196u, 218u, 229u, 236u, 33u, 45u, 46u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 67u, 69u, 72u, 95u, 
	99u, 101u, 104u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 88u, 95u, 120u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 128u, 191u, 160u, 170u, 181u, 186u, 128u, 
	191u, 9u, 10u, 13u, 32u, 194u, 225u, 226u, 
	227u, 128u, 191u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	65u, 90u, 97u, 122u, 128u, 191u, 196u, 218u, 
	229u, 236u, 151u, 183u, 128u, 191u, 128u, 191u, 
	172u, 174u, 128u, 129u, 130u, 133u, 134u, 145u, 
	146u, 159u, 160u, 164u, 165u, 191u, 181u, 128u, 
	175u, 176u, 183u, 184u, 185u, 186u, 189u, 190u, 
	191u, 134u, 139u, 141u, 162u, 128u, 135u, 136u, 
	191u, 182u, 128u, 191u, 128u, 129u, 130u, 137u, 
	138u, 191u, 128u, 167u, 168u, 176u, 177u, 191u, 
	153u, 128u, 150u, 151u, 160u, 161u, 191u, 128u, 
	135u, 136u, 191u, 128u, 143u, 144u, 170u, 171u, 
	175u, 176u, 178u, 179u, 191u, 128u, 159u, 160u, 
	191u, 176u, 128u, 138u, 139u, 159u, 160u, 169u, 
	170u, 173u, 174u, 191u, 44u, 46u, 69u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	48u, 57u, 128u, 191u, 148u, 191u, 128u, 149u, 
	150u, 164u, 165u, 166u, 167u, 173u, 174u, 175u, 
	176u, 185u, 186u, 188u, 189u, 190u, 144u, 128u, 
	145u, 146u, 175u, 176u, 191u, 128u, 140u, 141u, 
	191u, 177u, 128u, 165u, 166u, 191u, 186u, 128u, 
	137u, 138u, 170u, 171u, 179u, 180u, 181u, 182u, 
	191u, 160u, 161u, 162u, 164u, 165u, 166u, 167u, 
	168u, 169u, 170u, 171u, 172u, 173u, 174u, 175u, 
	176u, 177u, 178u, 179u, 180u, 181u, 182u, 183u, 
	184u, 185u, 186u, 187u, 188u, 189u, 190u, 128u, 
	191u, 154u, 164u, 168u, 128u, 149u, 150u, 191u, 
	128u, 152u, 153u, 191u, 160u, 128u, 161u, 162u, 
	172u, 173u, 191u, 189u, 128u, 131u, 132u, 185u, 
	186u, 191u, 144u, 176u, 184u, 128u, 151u, 152u, 
	161u, 162u, 165u, 166u, 175u, 177u, 191u, 169u, 
	177u, 189u, 128u, 132u, 133u, 140u, 141u, 142u, 
	143u, 144u, 145u, 146u, 147u, 178u, 179u, 181u, 
	182u, 185u, 186u, 191u, 142u, 158u, 128u, 155u, 
	156u, 161u, 162u, 165u, 166u, 175u, 176u, 177u, 
	178u, 191u, 169u, 177u, 180u, 183u, 128u, 132u, 
	133u, 138u, 139u, 142u, 143u, 144u, 145u, 146u, 
	147u, 185u, 186u, 191u, 157u, 128u, 152u, 153u, 
	158u, 159u, 165u, 166u, 175u, 176u, 177u, 178u, 
	180u, 181u, 191u, 142u, 146u, 169u, 177u, 180u, 
	189u, 128u, 132u, 133u, 185u, 186u, 191u, 144u, 
	128u, 159u, 160u, 161u, 162u, 165u, 166u, 175u, 
	176u, 191u, 169u, 177u, 180u, 189u, 128u, 132u, 
	133u, 140u, 141u, 142u, 143u, 144u, 145u, 146u, 
	147u, 185u, 186u, 191u, 158u, 177u, 128u, 155u, 
	156u, 161u, 162u, 165u, 166u, 175u, 176u, 191u, 
	131u, 145u, 155u, 157u, 128u, 132u, 133u, 138u, 
	139u, 141u, 142u, 149u, 150u, 152u, 153u, 159u, 
	160u, 162u, 163u, 164u, 165u, 167u, 168u, 170u, 
	171u, 173u, 174u, 185u, 186u, 191u, 144u, 128u, 
	165u, 166u, 175u, 176u, 191u, 141u, 145u, 169u, 
	180u, 189u, 128u, 132u, 133u, 185u, 186u, 191u, 
	128u, 151u, 152u, 153u, 154u, 159u, 160u, 161u, 
	162u, 165u, 166u, 175u, 176u, 191u, 158u, 176u, 
	128u, 159u, 160u, 161u, 162u, 165u, 166u, 175u, 
	177u, 178u, 179u, 191u, 141u, 145u, 189u, 128u, 
	132u, 133u, 186u, 187u, 191u, 142u, 128u, 159u, 
	160u, 161u, 162u, 165u, 166u, 175u, 176u, 185u, 
	186u, 191u, 178u, 188u, 128u, 132u, 133u, 150u, 
	151u, 153u, 154u, 189u, 190u, 191u, 128u, 134u, 
	135u, 191u, 128u, 177u, 129u, 179u, 180u, 191u, 
	128u, 134u, 135u, 143u, 144u, 153u, 154u, 191u, 
	128u, 131u, 137u, 141u, 152u, 160u, 164u, 166u, 
	172u, 177u, 189u, 129u, 132u, 133u, 134u, 135u, 
	138u, 139u, 147u, 148u, 167u, 168u, 169u, 170u, 
	179u, 180u, 191u, 133u, 128u, 134u, 135u, 143u, 
	144u, 153u, 154u, 155u, 156u, 159u, 160u, 191u, 
	128u, 129u, 159u, 160u, 169u, 170u, 191u, 136u, 
	128u, 172u, 173u, 191u, 128u, 135u, 136u, 140u, 
	141u, 191u, 128u, 129u, 130u, 131u, 137u, 138u, 
	139u, 140u, 141u, 142u, 143u, 144u, 153u, 154u, 
	155u, 156u, 157u, 158u, 159u, 160u, 161u, 162u, 
	163u, 164u, 165u, 166u, 167u, 168u, 169u, 170u, 
	171u, 172u, 173u, 174u, 175u, 176u, 177u, 178u, 
	179u, 183u, 188u, 189u, 190u, 191u, 132u, 187u, 
	191u, 128u, 170u, 171u, 190u, 161u, 128u, 137u, 
	138u, 143u, 144u, 149u, 150u, 153u, 154u, 157u, 
	158u, 164u, 165u, 166u, 167u, 173u, 174u, 176u, 
	177u, 180u, 181u, 191u, 142u, 128u, 129u, 130u, 
	143u, 144u, 153u, 154u, 159u, 160u, 191u, 134u, 
	141u, 187u, 128u, 135u, 136u, 143u, 144u, 191u, 
	137u, 151u, 153u, 128u, 141u, 142u, 143u, 144u, 
	157u, 158u, 159u, 160u, 191u, 137u, 177u, 191u, 
	128u, 141u, 142u, 143u, 144u, 181u, 182u, 183u, 
	184u, 190u, 129u, 151u, 128u, 133u, 134u, 135u, 
	136u, 191u, 145u, 128u, 149u, 150u, 151u, 152u, 
	191u, 128u, 154u, 155u, 191u, 128u, 143u, 144u, 
	159u, 160u, 191u, 128u, 180u, 181u, 191u, 128u, 
	129u, 191u, 128u, 172u, 173u, 174u, 175u, 191u, 
	128u, 129u, 154u, 155u, 159u, 160u, 191u, 128u, 
	170u, 171u, 191u, 141u, 128u, 145u, 146u, 159u, 
	160u, 177u, 178u, 191u, 173u, 128u, 145u, 146u, 
	159u, 160u, 176u, 177u, 191u, 128u, 179u, 180u, 
	191u, 151u, 156u, 128u, 159u, 160u, 169u, 170u, 
	191u, 128u, 143u, 144u, 153u, 154u, 159u, 160u, 
	191u, 128u, 183u, 184u, 191u, 169u, 128u, 170u, 
	171u, 175u, 176u, 191u, 128u, 181u, 182u, 191u, 
	128u, 156u, 157u, 191u, 128u, 133u, 134u, 143u, 
	144u, 173u, 174u, 175u, 176u, 180u, 181u, 191u, 
	128u, 171u, 172u, 191u, 128u, 129u, 135u, 136u, 
	143u, 144u, 153u, 154u, 191u, 128u, 150u, 151u, 
	159u, 160u, 191u, 128u, 148u, 149u, 191u, 167u, 
	128u, 137u, 138u, 143u, 144u, 153u, 154u, 191u, 
	128u, 132u, 133u, 179u, 180u, 191u, 128u, 132u, 
	133u, 139u, 140u, 143u, 144u, 153u, 154u, 191u, 
	128u, 130u, 131u, 160u, 161u, 173u, 174u, 175u, 
	176u, 185u, 186u, 191u, 128u, 165u, 166u, 191u, 
	128u, 163u, 164u, 191u, 128u, 137u, 138u, 140u, 
	141u, 143u, 144u, 153u, 154u, 189u, 190u, 191u, 
	173u, 128u, 168u, 169u, 177u, 178u, 180u, 181u, 
	182u, 183u, 191u, 128u, 149u, 150u, 151u, 152u, 
	157u, 158u, 159u, 160u, 191u, 152u, 154u, 156u, 
	158u, 128u, 133u, 134u, 135u, 136u, 141u, 142u, 
	143u, 144u, 189u, 190u, 191u, 181u, 189u, 191u, 
	128u, 190u, 133u, 181u, 128u, 129u, 130u, 140u, 
	141u, 143u, 144u, 147u, 148u, 149u, 150u, 155u, 
	156u, 159u, 160u, 172u, 173u, 177u, 178u, 188u, 
	189u, 191u, 128u, 129u, 130u, 132u, 133u, 134u, 
	176u, 177u, 178u, 179u, 180u, 181u, 182u, 183u, 
	184u, 131u, 191u, 166u, 175u, 128u, 138u, 139u, 
	191u, 13u, 32u, 34u, 39u, 41u, 59u, 93u, 
	125u, 194u, 224u, 225u, 226u, 227u, 239u, 9u, 
	10u, 128u, 191u, 159u, 177u, 191u, 128u, 190u, 
	128u, 143u, 144u, 156u, 157u, 191u, 130u, 135u, 
	148u, 164u, 166u, 168u, 174u, 128u, 137u, 138u, 
	149u, 150u, 152u, 153u, 157u, 158u, 169u, 170u, 
	185u, 186u, 187u, 188u, 191u, 142u, 128u, 132u, 
	133u, 137u, 138u, 191u, 128u, 130u, 131u, 132u, 
	133u, 191u, 175u, 128u, 191u, 159u, 128u, 191u, 
	128u, 164u, 165u, 170u, 171u, 174u, 175u, 177u, 
	178u, 179u, 180u, 191u, 166u, 173u, 128u, 167u, 
	168u, 175u, 176u, 191u, 175u, 128u, 167u, 168u, 
	191u, 167u, 175u, 183u, 191u, 128u, 150u, 151u, 
	159u, 160u, 190u, 135u, 143u, 151u, 128u, 158u, 
	159u, 191u, 175u, 128u, 191u, 128u, 129u, 130u, 
	131u, 132u, 133u, 134u, 135u, 136u, 143u, 144u, 
	191u, 128u, 129u, 132u, 133u, 134u, 135u, 176u, 
	177u, 181u, 182u, 186u, 187u, 188u, 189u, 191u, 
	160u, 128u, 150u, 151u, 156u, 157u, 191u, 187u, 
	128u, 191u, 128u, 132u, 133u, 173u, 174u, 176u, 
	177u, 191u, 128u, 142u, 143u, 159u, 160u, 186u, 
	187u, 191u, 128u, 175u, 176u, 191u, 182u, 183u, 
	128u, 191u, 128u, 191u, 191u, 128u, 190u, 128u, 
	140u, 141u, 191u, 146u, 147u, 152u, 153u, 154u, 
	155u, 156u, 158u, 159u, 160u, 161u, 162u, 163u, 
	164u, 165u, 166u, 167u, 168u, 169u, 170u, 171u, 
	172u, 175u, 128u, 157u, 173u, 174u, 176u, 191u, 
	128u, 143u, 144u, 189u, 190u, 191u, 128u, 140u, 
	141u, 143u, 144u, 159u, 160u, 169u, 170u, 171u, 
	172u, 191u, 191u, 128u, 174u, 175u, 190u, 128u, 
	151u, 152u, 159u, 160u, 191u, 128u, 150u, 151u, 
	159u, 160u, 161u, 162u, 191u, 143u, 128u, 136u, 
	137u, 138u, 139u, 147u, 148u, 159u, 160u, 170u, 
	171u, 191u, 128u, 183u, 184u, 191u, 130u, 134u, 
	139u, 128u, 162u, 163u, 191u, 128u, 129u, 130u, 
	179u, 180u, 191u, 187u, 128u, 143u, 144u, 153u, 
	154u, 177u, 178u, 183u, 184u, 191u, 128u, 137u, 
	138u, 165u, 166u, 175u, 176u, 191u, 128u, 134u, 
	135u, 159u, 160u, 188u, 189u, 191u, 128u, 131u, 
	132u, 178u, 179u, 191u, 143u, 128u, 142u, 144u, 
	153u, 154u, 191u, 128u, 168u, 169u, 191u, 131u, 
	186u, 128u, 139u, 140u, 143u, 144u, 153u, 154u, 
	159u, 160u, 182u, 183u, 191u, 176u, 128u, 177u, 
	178u, 180u, 181u, 182u, 183u, 184u, 185u, 189u, 
	190u, 191u, 129u, 128u, 130u, 131u, 154u, 155u, 
	157u, 158u, 159u, 160u, 170u, 171u, 177u, 178u, 
	180u, 181u, 191u, 128u, 167u, 129u, 134u, 135u, 
	136u, 137u, 142u, 143u, 144u, 145u, 150u, 151u, 
	159u, 160u, 174u, 175u, 191u, 128u, 162u, 163u, 
	175u, 176u, 185u, 186u, 191u, 158u, 159u, 128u, 
	157u, 160u, 191u, 128u, 163u, 164u, 175u, 176u, 
	191u, 128u, 134u, 135u, 138u, 139u, 187u, 188u, 
	191u, 169u, 171u, 172u, 173u, 174u, 175u, 180u, 
	181u, 182u, 183u, 184u, 185u, 187u, 188u, 189u, 
	190u, 191u, 128u, 163u, 164u, 186u, 128u, 173u, 
	174u, 175u, 176u, 191u, 128u, 153u, 154u, 191u, 
	157u, 169u, 183u, 189u, 191u, 128u, 134u, 135u, 
	146u, 147u, 151u, 152u, 158u, 159u, 190u, 130u, 
	133u, 128u, 191u, 128u, 177u, 178u, 191u, 128u, 
	146u, 147u, 191u, 128u, 189u, 190u, 191u, 128u, 
	143u, 144u, 191u, 128u, 143u, 144u, 145u, 146u, 
	191u, 128u, 135u, 136u, 175u, 176u, 187u, 188u, 
	191u, 181u, 128u, 175u, 176u, 191u, 128u, 188u, 
	189u, 191u, 128u, 143u, 144u, 153u, 154u, 160u, 
	161u, 186u, 187u, 191u, 128u, 129u, 154u, 155u, 
	165u, 166u, 191u, 191u, 128u, 190u, 128u, 129u, 
	130u, 135u, 136u, 137u, 138u, 143u, 144u, 145u, 
	146u, 151u, 152u, 153u, 154u, 156u, 157u, 191u, 
	144u, 145u, 146u, 147u, 150u, 155u, 157u, 158u, 
	170u, 171u, 175u, 128u, 159u, 160u, 169u, 172u, 
	191u, 128u, 129u, 130u, 131u, 138u, 139u, 140u, 
	141u, 142u, 143u, 146u, 160u, 161u, 164u, 166u, 
	168u, 169u, 172u, 173u, 176u, 177u, 132u, 137u, 
	144u, 145u, 147u, 191u, 140u, 167u, 187u, 190u, 
	128u, 191u, 128u, 141u, 142u, 143u, 144u, 157u, 
	158u, 191u, 128u, 186u, 187u, 191u, 128u, 156u, 
	157u, 159u, 160u, 191u, 128u, 144u, 145u, 191u, 
	128u, 158u, 159u, 175u, 176u, 191u, 129u, 128u, 
	137u, 138u, 191u, 128u, 157u, 158u, 159u, 160u, 
	191u, 128u, 131u, 132u, 135u, 136u, 143u, 144u, 
	191u, 128u, 157u, 158u, 159u, 160u, 169u, 170u, 
	191u, 136u, 182u, 188u, 191u, 128u, 133u, 134u, 
	137u, 138u, 184u, 185u, 190u, 128u, 149u, 150u, 
	191u, 128u, 149u, 150u, 159u, 160u, 185u, 186u, 
	191u, 128u, 183u, 184u, 189u, 190u, 191u, 128u, 
	148u, 152u, 129u, 143u, 144u, 179u, 180u, 191u, 
	128u, 159u, 160u, 188u, 189u, 191u, 128u, 149u, 
	150u, 159u, 160u, 178u, 179u, 191u, 128u, 136u, 
	137u, 191u, 128u, 129u, 130u, 131u, 132u, 134u, 
	135u, 154u, 155u, 133u, 191u, 128u, 130u, 131u, 
	183u, 184u, 191u, 128u, 165u, 166u, 175u, 176u, 
	191u, 128u, 130u, 131u, 175u, 176u, 191u, 128u, 
	143u, 144u, 168u, 169u, 175u, 176u, 185u, 186u, 
	191u, 128u, 130u, 131u, 166u, 167u, 181u, 182u, 
	191u, 128u, 130u, 131u, 178u, 179u, 191u, 128u, 
	129u, 132u, 133u, 143u, 144u, 153u, 154u, 191u, 
	128u, 137u, 138u, 191u, 141u, 128u, 140u, 142u, 
	191u, 128u, 174u, 175u, 191u, 144u, 128u, 143u, 
	145u, 191u, 168u, 188u, 189u, 190u, 128u, 159u, 
	160u, 167u, 169u, 191u, 128u, 184u, 185u, 191u, 
	144u, 128u, 132u, 133u, 191u, 128u, 146u, 147u, 
	159u, 160u, 191u, 128u, 129u, 191u, 128u, 129u, 
	130u, 191u, 145u, 146u, 147u, 148u, 149u, 154u, 
	155u, 156u, 157u, 158u, 159u, 128u, 143u, 144u, 
	153u, 160u, 191u, 149u, 128u, 191u, 157u, 162u, 
	173u, 186u, 188u, 128u, 159u, 160u, 164u, 165u, 
	166u, 167u, 168u, 169u, 191u, 132u, 128u, 191u, 
	134u, 149u, 157u, 186u, 191u, 128u, 138u, 139u, 
	140u, 141u, 190u, 133u, 145u, 128u, 134u, 135u, 
	137u, 138u, 191u, 128u, 165u, 166u, 167u, 168u, 
	191u, 129u, 155u, 187u, 128u, 191u, 149u, 181u, 
	128u, 191u, 143u, 175u, 128u, 191u, 137u, 169u, 
	128u, 191u, 131u, 128u, 139u, 140u, 141u, 142u, 
	191u, 184u, 185u, 186u, 128u, 191u, 132u, 160u, 
	163u, 167u, 179u, 184u, 186u, 128u, 164u, 165u, 
	168u, 169u, 187u, 188u, 191u, 130u, 135u, 137u, 
	139u, 144u, 147u, 151u, 153u, 155u, 157u, 159u, 
	163u, 171u, 179u, 184u, 189u, 191u, 128u, 140u, 
	141u, 148u, 149u, 160u, 161u, 164u, 165u, 166u, 
	167u, 190u, 138u, 164u, 170u, 128u, 155u, 156u, 
	160u, 161u, 187u, 188u, 191u, 155u, 128u, 191u, 
	128u, 150u, 151u, 191u, 156u, 160u, 128u, 159u, 
	161u, 191u, 128u, 157u, 158u, 191u, 168u, 128u, 
	159u, 160u, 167u, 169u, 191u, 33u, 58u, 64u, 
	95u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 44u, 46u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 45u, 48u, 
	57u, 65u, 90u, 97u, 122u, 0
};

static const char _czech_tokenizer_single_lengths[] = {
	0, 1, 1, 1, 2, 1, 1, 1, 
	31, 29, 1, 0, 32, 29, 7, 21, 
	26, 5, 3, 2, 15, 0, 16, 28, 
	30, 20, 0, 1, 2, 8, 0, 2, 
	1, 32, 28, 0, 4, 0, 0, 16, 
	2, 2, 1, 6, 1, 1, 3, 7, 
	6, 11, 3, 0, 6, 21, 10, 1, 
	10, 5, 23, 12, 14, 26, 14, 5, 
	1, 7, 6, 2, 3, 2, 1, 0, 
	16, 0, 0, 2, 0, 0, 1, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	1, 2, 8, 2, 16, 3, 3, 1, 
	11, 4, 2, 3, 3, 2, 1, 2, 
	0, 2, 5, 0, 2, 3, 2, 3, 
	2, 3, 2, 2, 3, 2, 2, 2, 
	3, 2, 2, 2, 3, 2, 14, 2, 
	1, 2, 1, 2, 9, 4, 3, 1, 
	3, 7, 6, 11, 3, 10, 1, 10, 
	5, 1, 6, 7, 2, 3, 17, 12, 
	14, 12, 0, 0, 0, 12, 0, 0, 
	10, 0, 0, 6, 1, 3, 1, 5, 
	0, 1, 0, 0, 10, 8, 0, 0, 
	12, 0, 0, 10, 0, 0, 6, 1, 
	3, 1, 5, 0, 1, 0, 5, 6, 
	4, 6, 5, 4, 6, 2, 6, 6, 
	7, 6, 7, 15, 7, 6, 7, 7, 
	7, 7, 8, 7, 6, 6, 7, 6, 
	15, 13, 12, 15, 13, 0, 8, 0, 
	0, 12, 0, 0, 10, 0, 0, 6, 
	1, 3, 1, 5, 0, 1, 0, 3, 
	1, 5, 6, 7, 6, 7, 6, 7, 
	6, 6, 7, 6, 6, 6, 7, 6, 
	6, 6, 7, 6, 3, 0, 0, 2, 
	0, 2, 0, 0, 0, 1, 1, 1, 
	0, 0, 1, 0, 0, 0, 1, 32, 
	0, 0, 1, 0, 0, 1, 1, 1, 
	2, 0, 1, 0, 1, 1, 2, 0, 
	0, 0, 1, 0, 1, 1, 2, 0, 
	0, 5, 1, 4, 0, 0, 1, 40, 
	0, 2, 1, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 3, 1, 0, 15, 2, 0, 
	0, 6, 1, 0, 0, 0, 0, 2, 
	2, 0, 0, 1, 8, 0, 0, 0, 
	0, 0, 0, 1, 0, 1, 0, 20, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 2, 0, 0, 0, 
	0, 0, 2, 0, 0, 17, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 11, 22, 1, 
	0, 0, 1, 0, 0, 0, 1, 0, 
	0, 0, 3, 0, 0, 0, 1, 0, 
	0, 0, 8, 0, 0, 0, 1, 0, 
	1, 4, 0, 0, 0, 1, 0, 14, 
	0, 0, 0, 0, 2, 0, 0, 1, 
	0, 1, 0, 0, 0, 0, 3, 4, 
	12, 0, 1, 0, 2, 1, 1, 1, 
	0, 6, 8, 7, 7, 1, 1, 1, 
	7, 8, 8, 8, 7, 2, 2, 2, 
	2, 6, 7, 7, 6, 0, 2, 2, 
	9, 8, 8, 8, 8, 8, 7, 8, 
	8, 7, 8, 8, 8, 9, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 7, 
	8, 8, 8, 7, 8, 8, 8, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 6, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	6, 7, 7, 7, 7, 7, 7, 7, 
	7, 1, 1, 1, 6, 7, 7, 7, 
	7, 7, 7, 7, 7, 1, 6, 7, 
	7, 7, 7, 7, 7, 7, 7, 1, 
	1, 6, 7, 7, 7, 7, 7, 7, 
	7, 7, 1, 6, 7, 7, 7, 7, 
	7, 7, 7, 6, 7, 7, 7, 7, 
	7, 9, 8, 8, 8, 8, 7, 7, 
	8, 8, 8, 6, 1, 1, 1, 7, 
	8, 7, 8, 8, 7, 6, 7, 8, 
	8, 8, 8, 7, 7, 8, 7, 8, 
	7, 8, 8, 8, 8, 8, 8, 8, 
	7, 8, 8, 8, 8, 8, 8, 8, 
	8, 6, 7, 7, 7, 7, 8, 6, 
	7, 7, 7, 7, 8, 8, 7, 8, 
	8, 7, 8, 8, 8, 7, 8, 8, 
	7, 8, 8, 8, 8, 7, 8, 8, 
	8, 6, 7, 7, 7, 7, 7, 10, 
	7, 6, 8, 8, 8, 7, 2, 2, 
	6, 7, 7, 7, 7, 6, 7, 7, 
	7, 8, 8, 8, 8, 7, 6, 8, 
	8, 7, 7, 8, 8, 6, 7, 7, 
	77, 8, 7, 6, 7, 8, 1, 8, 
	1, 8, 17, 4, 5, 1, 4, 4, 
	4, 4, 5, 4, 4, 17, 14, 12, 
	8, 10, 7, 4, 7, 16, 16, 14, 
	16, 16, 17, 16, 17, 14, 12, 17, 
	17, 18, 17, 14, 37, 35, 35, 7, 
	7, 7, 8, 7, 29, 35, 35, 37, 
	37, 37, 35, 40, 35, 39, 37, 37, 
	35, 37, 37, 37, 35, 37, 37, 35, 
	37, 37, 37, 35, 35, 41, 37, 37, 
	35, 37, 37, 37, 35, 35, 31, 33, 
	33, 31, 31, 30, 30, 33, 31, 30, 
	30, 37, 37, 37, 43, 35, 37, 35, 
	37, 37, 35, 35, 41, 39, 37, 37, 
	37, 37, 37, 35, 37, 37, 37, 37, 
	37, 35, 37, 37, 35, 36, 35, 35, 
	44, 36, 35, 35, 37, 37, 35, 37, 
	35, 41, 37, 37, 35, 37, 35, 35, 
	41, 39, 37, 35, 37, 37, 37, 37, 
	37, 37, 35, 37, 37, 37, 37, 37, 
	37, 35, 37, 37, 37, 35, 37, 37, 
	37, 37, 35, 39, 35, 37, 37, 37, 
	37, 35, 43, 37, 37, 35, 37, 37, 
	35, 37, 35, 37, 37, 37, 37, 35, 
	40, 37, 37, 37, 37, 37, 37, 35, 
	35, 37, 37, 37, 35, 41, 37, 35, 
	39, 37, 37, 35, 35, 37, 37, 35, 
	37, 37, 37, 37, 35, 36, 35, 37, 
	39, 39, 37, 39, 37, 37, 37, 41, 
	37, 0, 4, 8, 29, 2, 0, 2, 
	1, 4, 1, 0, 0, 1, 0, 0, 
	0, 1, 12, 2, 1, 0, 1, 1, 
	30, 3, 0, 1, 1, 3, 3, 2, 
	4, 1, 6, 1, 4, 2, 4, 1, 
	5, 0, 2, 3, 1, 2, 0, 2, 
	0, 11, 1, 1, 1, 0, 44, 1, 
	1, 1, 3, 3, 3, 2, 1, 0, 
	0, 0, 1, 0, 1, 0, 1, 1, 
	0, 2, 0, 0, 1, 0, 0, 0, 
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 1, 0, 4, 3, 2, 
	15, 2, 14, 3, 0, 7, 1, 0, 
	1, 1, 0, 2, 1, 4, 3, 1, 
	8, 1, 1, 1, 0, 0, 0, 2, 
	0, 1, 0, 23, 0, 0, 1, 0, 
	0, 1, 0, 3, 0, 1, 0, 0, 
	0, 1, 0, 2, 1, 1, 2, 0, 
	2, 0, 0, 17, 0, 0, 5, 2, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 1, 1, 0, 11, 21, 4, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	4, 0, 0, 0, 3, 0, 0, 0, 
	9, 0, 0, 0, 0, 0, 0, 1, 
	0, 1, 0, 1, 4, 0, 1, 0, 
	1, 0, 11, 1, 5, 1, 5, 2, 
	0, 3, 2, 2, 2, 1, 3, 7, 
	17, 3, 1, 0, 2, 0, 1, 12, 
	16
};

static const char _czech_tokenizer_range_lengths[] = {
	0, 0, 0, 0, 0, 1, 0, 0, 
	2, 1, 0, 2, 0, 1, 12, 5, 
	2, 1, 0, 4, 3, 1, 0, 0, 
	1, 1, 1, 0, 0, 1, 1, 1, 
	0, 0, 0, 4, 2, 4, 4, 0, 
	2, 0, 0, 6, 0, 0, 0, 0, 
	0, 0, 0, 1, 3, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 1, 
	0, 2, 2, 5, 1, 6, 3, 2, 
	1, 2, 2, 2, 1, 1, 1, 1, 
	0, 0, 1, 0, 0, 3, 0, 0, 
	0, 5, 5, 5, 3, 3, 3, 3, 
	3, 3, 6, 1, 3, 3, 3, 3, 
	3, 3, 3, 3, 4, 4, 3, 3, 
	4, 4, 3, 3, 4, 4, 1, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 7, 5, 
	5, 5, 1, 1, 1, 0, 1, 1, 
	0, 1, 2, 0, 0, 0, 0, 0, 
	1, 0, 1, 1, 1, 1, 1, 1, 
	0, 1, 1, 0, 1, 2, 0, 0, 
	0, 0, 0, 1, 0, 1, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 6, 6, 5, 5, 6, 6, 
	5, 5, 5, 5, 5, 1, 1, 1, 
	1, 0, 1, 1, 0, 1, 2, 0, 
	0, 0, 0, 0, 1, 0, 1, 4, 
	0, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 6, 6, 5, 5, 6, 6, 
	5, 5, 6, 6, 0, 3, 1, 3, 
	3, 3, 2, 2, 2, 2, 2, 4, 
	2, 2, 5, 1, 2, 1, 1, 0, 
	1, 1, 1, 1, 3, 7, 6, 9, 
	5, 8, 4, 8, 6, 10, 3, 7, 
	6, 7, 6, 5, 5, 4, 4, 1, 
	1, 8, 3, 2, 3, 3, 0, 2, 
	3, 3, 5, 5, 3, 3, 2, 2, 
	1, 1, 2, 2, 1, 3, 4, 2, 
	2, 1, 2, 1, 3, 2, 2, 1, 
	2, 2, 0, 2, 2, 1, 2, 2, 
	2, 3, 4, 2, 7, 0, 0, 1, 
	1, 5, 1, 1, 2, 2, 2, 2, 
	1, 5, 5, 0, 1, 4, 4, 2, 
	2, 2, 1, 2, 1, 1, 1, 2, 
	1, 3, 2, 2, 2, 2, 4, 1, 
	1, 2, 2, 2, 0, 1, 3, 4, 
	5, 2, 1, 2, 2, 1, 2, 1, 
	5, 3, 1, 1, 2, 2, 2, 2, 
	1, 1, 2, 1, 4, 1, 1, 4, 
	2, 1, 0, 2, 1, 2, 1, 2, 
	2, 1, 3, 1, 2, 2, 6, 1, 
	2, 1, 0, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 0, 1, 1, 
	3, 3, 1, 2, 6, 2, 6, 3, 
	2, 3, 3, 3, 3, 2, 0, 5, 
	7, 5, 1, 1, 1, 1, 0, 1, 
	1, 5, 5, 5, 5, 0, 0, 0, 
	5, 5, 5, 5, 5, 0, 0, 0, 
	0, 5, 5, 5, 5, 1, 0, 0, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 3, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 0, 0, 0, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 0, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 0, 
	0, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 0, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 0, 0, 0, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 0, 0, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	12, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 7, 3, 6, 1, 3, 3, 
	3, 3, 4, 4, 5, 5, 5, 5, 
	1, 1, 5, 5, 5, 5, 5, 5, 
	5, 5, 6, 6, 5, 5, 1, 5, 
	5, 6, 6, 1, 7, 7, 7, 5, 
	5, 5, 6, 6, 4, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 1, 1, 1, 5, 1, 1, 6, 
	5, 2, 1, 3, 3, 3, 2, 5, 
	2, 5, 2, 8, 3, 2, 2, 5, 
	1, 2, 2, 3, 3, 5, 9, 6, 
	7, 7, 3, 5, 7, 5, 13, 3, 
	3, 7, 6, 3, 6, 5, 2, 2, 
	4, 8, 6, 3, 2, 3, 1, 2, 
	11, 5, 3, 5, 5, 3, 3, 2, 
	3, 2, 1, 3, 3, 2, 4, 4, 
	2, 3, 4, 2, 3, 2, 2, 6, 
	2, 4, 3, 2, 4, 3, 5, 6, 
	2, 2, 6, 5, 5, 6, 1, 11, 
	1, 2, 2, 1, 3, 8, 3, 3, 
	1, 1, 6, 3, 2, 3, 2, 1, 
	2, 7, 3, 1, 4, 4, 2, 1, 
	1, 1, 2, 3, 3, 6, 2, 3, 
	4, 6, 2, 2, 3, 5, 4, 4, 
	3, 3, 2, 6, 6, 8, 8, 4, 
	2, 3, 4, 2, 3, 2, 5, 1, 
	2, 2, 2, 2, 3, 4, 2, 2, 
	5, 3, 1, 9, 3, 3, 1, 4, 
	2, 3, 2, 3, 2, 3, 4, 4, 
	4, 2, 4, 3, 3, 3, 4, 2, 
	1, 3, 3, 3, 5, 4, 3, 4, 
	2, 2, 2, 2, 3, 2, 2, 3, 
	1, 2, 3, 1, 5, 1, 3, 3, 
	3, 1, 1, 1, 1, 3, 1, 4, 
	6, 4, 1, 2, 2, 2, 3, 5, 
	5
};

static const short _czech_tokenizer_index_offsets[] = {
	0, 0, 2, 4, 6, 9, 12, 14, 
	16, 50, 81, 83, 86, 119, 150, 170, 
	197, 226, 233, 237, 244, 263, 265, 282, 
	311, 343, 365, 367, 369, 372, 382, 384, 
	388, 390, 423, 452, 457, 464, 469, 474, 
	491, 496, 499, 501, 514, 516, 518, 522, 
	530, 537, 549, 553, 555, 565, 587, 598, 
	600, 611, 617, 641, 654, 669, 697, 712, 
	718, 720, 728, 735, 739, 743, 746, 748, 
	750, 767, 770, 773, 781, 783, 790, 795, 
	798, 800, 803, 806, 809, 812, 814, 816, 
	818, 820, 823, 833, 836, 853, 860, 864, 
	866, 878, 888, 896, 905, 912, 918, 923, 
	929, 933, 939, 951, 953, 959, 966, 972, 
	979, 985, 992, 998, 1004, 1012, 1019, 1025, 
	1031, 1039, 1046, 1052, 1058, 1066, 1073, 1089, 
	1092, 1094, 1097, 1099, 1102, 1112, 1118, 1122, 
	1124, 1128, 1136, 1143, 1155, 1159, 1170, 1172, 
	1184, 1190, 1192, 1199, 1207, 1210, 1214, 1239, 
	1257, 1277, 1295, 1297, 1299, 1301, 1314, 1316, 
	1318, 1329, 1331, 1334, 1341, 1343, 1347, 1349, 
	1355, 1357, 1359, 1361, 1363, 1375, 1385, 1387, 
	1389, 1402, 1404, 1406, 1417, 1419, 1422, 1429, 
	1431, 1435, 1437, 1443, 1445, 1447, 1449, 1460, 
	1472, 1482, 1494, 1505, 1515, 1527, 1535, 1547, 
	1559, 1572, 1584, 1597, 1618, 1631, 1643, 1656, 
	1669, 1682, 1695, 1710, 1724, 1736, 1748, 1762, 
	1775, 1796, 1815, 1833, 1854, 1873, 1875, 1885, 
	1887, 1889, 1902, 1904, 1906, 1917, 1919, 1922, 
	1929, 1931, 1935, 1937, 1943, 1945, 1947, 1949, 
	1957, 1959, 1970, 1982, 1995, 2007, 2020, 2032, 
	2045, 2057, 2069, 2083, 2096, 2108, 2120, 2134, 
	2147, 2159, 2171, 2185, 2198, 2202, 2206, 2208, 
	2214, 2218, 2224, 2227, 2230, 2233, 2237, 2241, 
	2247, 2250, 2253, 2260, 2262, 2265, 2267, 2270, 
	2303, 2305, 2307, 2310, 2312, 2316, 2325, 2333, 
	2344, 2352, 2361, 2367, 2376, 2384, 2396, 2402, 
	2410, 2417, 2425, 2433, 2439, 2446, 2452, 2459, 
	2461, 2463, 2477, 2482, 2489, 2493, 2497, 2499, 
	2542, 2546, 2552, 2559, 2565, 2570, 2574, 2577, 
	2580, 2582, 2584, 2587, 2590, 2592, 2596, 2601, 
	2605, 2608, 2610, 2613, 2615, 2619, 2622, 2625, 
	2627, 2630, 2634, 2636, 2639, 2642, 2644, 2647, 
	2650, 2653, 2657, 2665, 2669, 2677, 2693, 2696, 
	2698, 2700, 2712, 2715, 2717, 2720, 2723, 2726, 
	2731, 2735, 2741, 2747, 2749, 2759, 2764, 2769, 
	2772, 2775, 2778, 2780, 2784, 2786, 2789, 2791, 
	2814, 2816, 2820, 2824, 2827, 2830, 2833, 2838, 
	2840, 2842, 2846, 2849, 2852, 2855, 2857, 2861, 
	2866, 2872, 2875, 2879, 2882, 2885, 2904, 2907, 
	2909, 2916, 2920, 2922, 2924, 2927, 2930, 2933, 
	2936, 2938, 2940, 2943, 2945, 2950, 2963, 2987, 
	2993, 2996, 2998, 3000, 3003, 3005, 3008, 3011, 
	3014, 3017, 3019, 3026, 3028, 3031, 3034, 3042, 
	3044, 3047, 3049, 3058, 3060, 3062, 3064, 3067, 
	3069, 3072, 3078, 3080, 3083, 3085, 3087, 3089, 
	3105, 3109, 3113, 3115, 3118, 3127, 3130, 3137, 
	3142, 3145, 3150, 3154, 3158, 3162, 3165, 3169, 
	3179, 3199, 3205, 3208, 3210, 3214, 3217, 3219, 
	3222, 3224, 3236, 3250, 3263, 3276, 3278, 3280, 
	3282, 3295, 3309, 3323, 3337, 3350, 3353, 3356, 
	3359, 3362, 3374, 3387, 3400, 3412, 3414, 3417, 
	3420, 3435, 3449, 3463, 3477, 3491, 3505, 3518, 
	3532, 3546, 3559, 3573, 3587, 3601, 3616, 3630, 
	3644, 3658, 3672, 3686, 3700, 3714, 3728, 3742, 
	3755, 3769, 3783, 3797, 3810, 3824, 3838, 3852, 
	3858, 3860, 3862, 3864, 3866, 3868, 3870, 3872, 
	3874, 3878, 3880, 3882, 3884, 3886, 3888, 3890, 
	3892, 3894, 3896, 3898, 3900, 3902, 3904, 3906, 
	3908, 3910, 3912, 3914, 3916, 3918, 3920, 3922, 
	3934, 3947, 3960, 3973, 3986, 3999, 4012, 4025, 
	4038, 4050, 4063, 4076, 4089, 4102, 4115, 4128, 
	4141, 4154, 4156, 4158, 4160, 4172, 4185, 4198, 
	4211, 4224, 4237, 4250, 4263, 4276, 4278, 4290, 
	4303, 4316, 4329, 4342, 4355, 4368, 4381, 4394, 
	4396, 4398, 4410, 4423, 4436, 4449, 4462, 4475, 
	4488, 4501, 4514, 4516, 4528, 4541, 4554, 4567, 
	4580, 4593, 4606, 4619, 4631, 4644, 4657, 4670, 
	4683, 4696, 4711, 4725, 4739, 4753, 4767, 4780, 
	4793, 4807, 4821, 4835, 4847, 4849, 4851, 4853, 
	4866, 4880, 4893, 4907, 4921, 4934, 4946, 4959, 
	4973, 4987, 5001, 5015, 5028, 5041, 5055, 5068, 
	5082, 5095, 5109, 5123, 5137, 5151, 5165, 5179, 
	5193, 5206, 5220, 5234, 5248, 5262, 5276, 5290, 
	5304, 5318, 5330, 5343, 5356, 5369, 5382, 5396, 
	5408, 5421, 5434, 5447, 5460, 5474, 5488, 5501, 
	5515, 5529, 5542, 5556, 5570, 5584, 5597, 5611, 
	5625, 5638, 5652, 5666, 5680, 5694, 5707, 5721, 
	5735, 5749, 5761, 5774, 5787, 5800, 5813, 5826, 
	5842, 5855, 5867, 5881, 5895, 5909, 5922, 5925, 
	5928, 5940, 5953, 5966, 5979, 5992, 6004, 6017, 
	6030, 6043, 6057, 6071, 6085, 6099, 6112, 6124, 
	6138, 6152, 6165, 6178, 6192, 6206, 6218, 6231, 
	6244, 6334, 6343, 6351, 6358, 6366, 6375, 6377, 
	6386, 6388, 6397, 6422, 6430, 6442, 6445, 6453, 
	6461, 6469, 6477, 6487, 6496, 6506, 6529, 6549, 
	6567, 6577, 6589, 6602, 6612, 6625, 6647, 6669, 
	6689, 6711, 6733, 6757, 6780, 6803, 6823, 6837, 
	6860, 6883, 6908, 6932, 6948, 6993, 7036, 7079, 
	7092, 7105, 7118, 7133, 7147, 7181, 7224, 7267, 
	7312, 7357, 7402, 7445, 7493, 7536, 7583, 7628, 
	7673, 7716, 7761, 7806, 7851, 7894, 7939, 7984, 
	8027, 8072, 8117, 8162, 8205, 8248, 8297, 8342, 
	8387, 8430, 8475, 8520, 8565, 8608, 8651, 8687, 
	8725, 8763, 8799, 8835, 8870, 8905, 8943, 8979, 
	9014, 9049, 9094, 9139, 9184, 9235, 9278, 9323, 
	9366, 9411, 9456, 9499, 9542, 9591, 9638, 9683, 
	9728, 9773, 9818, 9863, 9906, 9951, 9996, 10041, 
	10086, 10131, 10174, 10219, 10264, 10307, 10351, 10394, 
	10437, 10489, 10533, 10576, 10619, 10664, 10709, 10752, 
	10797, 10840, 10889, 10934, 10979, 11022, 11067, 11110, 
	11153, 11202, 11249, 11294, 11337, 11382, 11427, 11472, 
	11517, 11562, 11607, 11650, 11695, 11740, 11785, 11830, 
	11875, 11920, 11963, 12008, 12053, 12098, 12141, 12186, 
	12231, 12276, 12321, 12364, 12411, 12454, 12499, 12544, 
	12589, 12634, 12677, 12728, 12773, 12818, 12861, 12906, 
	12951, 12994, 13039, 13082, 13127, 13172, 13217, 13262, 
	13305, 13353, 13398, 13443, 13488, 13533, 13578, 13623, 
	13666, 13709, 13754, 13799, 13844, 13887, 13936, 13981, 
	14024, 14071, 14116, 14161, 14204, 14247, 14292, 14337, 
	14380, 14425, 14470, 14515, 14560, 14603, 14647, 14690, 
	14735, 14782, 14829, 14874, 14921, 14966, 15011, 15056, 
	15105, 15150, 15152, 15158, 15168, 15203, 15207, 15209, 
	15218, 15225, 15232, 15235, 15239, 15243, 15248, 15251, 
	15257, 15260, 15267, 15282, 15293, 15298, 15301, 15305, 
	15312, 15344, 15350, 15353, 15358, 15363, 15372, 15385, 
	15394, 15406, 15415, 15425, 15432, 15444, 15452, 15470, 
	15475, 15484, 15492, 15501, 15508, 15516, 15524, 15527, 
	15532, 15537, 15557, 15565, 15570, 15574, 15578, 15624, 
	15628, 15641, 15648, 15655, 15664, 15673, 15679, 15684, 
	15687, 15691, 15694, 15697, 15701, 15706, 15709, 15715, 
	15721, 15724, 15730, 15735, 15738, 15743, 15746, 15749, 
	15756, 15759, 15765, 15769, 15772, 15778, 15782, 15788, 
	15795, 15798, 15801, 15808, 15815, 15821, 15832, 15837, 
	15851, 15868, 15873, 15890, 15895, 15899, 15915, 15920, 
	15924, 15927, 15930, 15937, 15943, 15947, 15955, 15961, 
	15964, 15975, 15984, 15989, 15992, 15997, 16002, 16005, 
	16009, 16011, 16014, 16017, 16044, 16048, 16055, 16059, 
	16063, 16068, 16076, 16079, 16085, 16089, 16096, 16101, 
	16106, 16110, 16115, 16118, 16127, 16135, 16145, 16156, 
	16161, 16166, 16170, 16175, 16195, 16199, 16202, 16213, 
	16217, 16220, 16223, 16226, 16229, 16233, 16238, 16242, 
	16245, 16251, 16256, 16259, 16269, 16284, 16309, 16315, 
	16320, 16323, 16327, 16330, 16334, 16338, 16342, 16347, 
	16352, 16361, 16364, 16369, 16373, 16380, 16384, 16389, 
	16392, 16403, 16407, 16411, 16415, 16421, 16426, 16430, 
	16436, 16439, 16443, 16446, 16450, 16458, 16461, 16465, 
	16469, 16472, 16475, 16490, 16493, 16504, 16507, 16516, 
	16522, 16526, 16531, 16535, 16539, 16543, 16548, 16553, 
	16565, 16589, 16597, 16600, 16603, 16608, 16611, 16616, 
	16634
};

static const short _czech_tokenizer_indicies[] = {
	1, 0, 2, 0, 1, 0, 3, 4, 
	0, 1, 1, 0, 1, 0, 2, 0, 
	6, 6, 7, 7, 7, 7, 7, 9, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 6, 
	8, 5, 7, 7, 7, 7, 7, 33, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 34, 35, 36, 30, 31, 32, 8, 
	5, 7, 5, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 5, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 5, 37, 
	5, 7, 7, 5, 38, 39, 40, 42, 
	43, 44, 45, 46, 41, 5, 8, 5, 
	8, 8, 8, 5, 7, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 5, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 5, 47, 48, 49, 50, 51, 52, 
	53, 54, 55, 56, 57, 58, 59, 41, 
	60, 61, 5, 7, 7, 7, 7, 5, 
	7, 7, 5, 7, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 5, 8, 5, 7, 7, 
	7, 5, 7, 7, 7, 7, 7, 7, 
	7, 5, 7, 7, 7, 7, 7, 7, 
	5, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 5, 7, 7, 7, 
	5, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 5, 62, 5, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 5, 63, 64, 65, 66, 67, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	68, 69, 70, 71, 72, 5, 7, 5, 
	7, 7, 7, 7, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 5, 7, 
	7, 8, 5, 7, 7, 7, 5, 73, 
	74, 5, 75, 5, 8, 5, 76, 77, 
	78, 79, 80, 81, 82, 83, 84, 85, 
	86, 87, 88, 89, 90, 91, 5, 8, 
	8, 5, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 5, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 5, 8, 8, 5, 8, 5, 
	8, 8, 5, 8, 8, 5, 8, 8, 
	5, 8, 8, 5, 8, 5, 8, 5, 
	8, 5, 8, 5, 6, 7, 5, 38, 
	39, 92, 42, 43, 44, 45, 46, 41, 
	5, 6, 7, 5, 93, 94, 49, 50, 
	51, 52, 53, 54, 55, 56, 57, 58, 
	59, 41, 60, 61, 5, 7, 6, 7, 
	6, 7, 7, 5, 7, 6, 7, 5, 
	95, 5, 6, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 5, 96, 97, 
	98, 96, 96, 96, 96, 96, 96, 5, 
	99, 99, 99, 99, 99, 99, 99, 5, 
	99, 98, 99, 99, 99, 99, 99, 99, 
	5, 100, 101, 102, 103, 104, 104, 5, 
	105, 106, 104, 104, 104, 5, 105, 104, 
	104, 104, 5, 105, 107, 104, 104, 104, 
	5, 104, 108, 109, 5, 105, 107, 104, 
	110, 104, 5, 111, 112, 112, 111, 111, 
	111, 112, 111, 111, 112, 112, 5, 113, 
	5, 105, 107, 104, 104, 114, 5, 115, 
	116, 117, 118, 108, 109, 5, 105, 119, 
	104, 104, 104, 5, 120, 121, 122, 123, 
	108, 109, 5, 105, 124, 104, 104, 104, 
	5, 125, 126, 127, 128, 108, 109, 5, 
	105, 124, 123, 104, 104, 5, 105, 124, 
	120, 104, 104, 5, 105, 124, 129, 123, 
	120, 104, 104, 5, 105, 124, 120, 104, 
	104, 104, 5, 105, 119, 118, 104, 104, 
	5, 105, 119, 115, 104, 104, 5, 105, 
	119, 130, 118, 115, 104, 104, 5, 105, 
	119, 115, 104, 104, 104, 5, 105, 106, 
	103, 104, 104, 5, 105, 106, 100, 104, 
	104, 5, 105, 106, 131, 103, 100, 104, 
	104, 5, 105, 106, 100, 104, 104, 104, 
	5, 132, 132, 133, 133, 133, 133, 133, 
	133, 134, 135, 136, 137, 138, 139, 132, 
	5, 6, 133, 5, 140, 5, 133, 133, 
	5, 141, 5, 6, 133, 5, 142, 143, 
	144, 145, 146, 147, 148, 149, 150, 5, 
	133, 133, 6, 133, 6, 5, 133, 6, 
	133, 5, 133, 5, 133, 133, 133, 5, 
	133, 133, 133, 133, 133, 133, 133, 5, 
	133, 133, 133, 133, 133, 133, 5, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 5, 133, 133, 133, 5, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 5, 151, 5, 6, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 5, 
	152, 153, 154, 155, 156, 5, 133, 5, 
	133, 133, 133, 133, 133, 133, 5, 133, 
	133, 133, 133, 133, 133, 133, 5, 133, 
	133, 5, 133, 133, 133, 5, 132, 132, 
	96, 133, 96, 97, 133, 98, 133, 96, 
	133, 134, 135, 136, 137, 138, 139, 132, 
	96, 157, 96, 96, 96, 96, 5, 96, 
	97, 98, 96, 159, 160, 161, 162, 163, 
	164, 165, 166, 96, 96, 158, 96, 96, 
	5, 96, 167, 167, 97, 98, 96, 169, 
	170, 171, 172, 173, 174, 175, 176, 96, 
	96, 168, 96, 96, 5, 96, 97, 98, 
	96, 169, 170, 171, 172, 173, 174, 175, 
	176, 96, 96, 168, 96, 96, 5, 177, 
	5, 177, 5, 177, 5, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 179, 179, 
	169, 5, 177, 5, 177, 5, 171, 179, 
	169, 179, 180, 179, 181, 179, 170, 181, 
	5, 177, 5, 177, 177, 5, 169, 179, 
	171, 179, 179, 170, 5, 179, 5, 182, 
	183, 184, 5, 169, 5, 178, 170, 185, 
	179, 171, 5, 177, 5, 186, 5, 177, 
	5, 187, 5, 188, 188, 169, 170, 171, 
	172, 173, 174, 175, 176, 177, 5, 169, 
	170, 171, 172, 173, 174, 175, 176, 177, 
	5, 187, 5, 187, 5, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 190, 190, 
	159, 5, 187, 5, 187, 5, 161, 190, 
	159, 190, 191, 190, 192, 190, 160, 192, 
	5, 187, 5, 187, 187, 5, 159, 190, 
	161, 190, 190, 160, 5, 190, 5, 193, 
	194, 195, 5, 159, 5, 189, 160, 196, 
	190, 161, 5, 187, 5, 197, 5, 187, 
	5, 96, 198, 97, 98, 96, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 96, 96, 199, 199, 199, 5, 
	96, 97, 98, 96, 96, 96, 201, 202, 
	203, 5, 96, 204, 205, 97, 98, 96, 
	96, 96, 201, 201, 201, 5, 96, 204, 
	97, 98, 96, 96, 96, 201, 201, 201, 
	5, 96, 97, 98, 96, 96, 96, 201, 
	206, 207, 5, 96, 204, 205, 97, 98, 
	96, 96, 96, 201, 208, 201, 5, 99, 
	99, 99, 99, 209, 99, 99, 5, 96, 
	204, 205, 97, 98, 96, 96, 96, 201, 
	201, 210, 5, 96, 204, 205, 97, 98, 
	96, 96, 96, 201, 211, 201, 5, 96, 
	204, 205, 112, 212, 98, 96, 96, 96, 
	201, 211, 201, 5, 96, 204, 205, 97, 
	98, 96, 96, 96, 201, 201, 213, 5, 
	96, 204, 205, 112, 212, 98, 96, 96, 
	96, 201, 201, 213, 5, 96, 214, 215, 
	216, 97, 98, 96, 159, 160, 161, 162, 
	163, 164, 165, 166, 96, 96, 217, 202, 
	203, 5, 96, 218, 219, 220, 97, 98, 
	96, 96, 96, 221, 206, 207, 5, 96, 
	204, 222, 97, 98, 96, 96, 96, 201, 
	201, 201, 5, 96, 223, 224, 225, 97, 
	98, 96, 96, 96, 226, 206, 207, 5, 
	96, 204, 205, 112, 212, 98, 96, 96, 
	96, 201, 201, 201, 5, 96, 204, 205, 
	112, 212, 98, 96, 96, 96, 226, 201, 
	201, 5, 96, 204, 205, 112, 212, 98, 
	96, 96, 96, 223, 201, 201, 5, 96, 
	204, 205, 112, 227, 212, 98, 96, 96, 
	96, 226, 223, 201, 201, 5, 96, 204, 
	205, 112, 212, 98, 96, 96, 96, 223, 
	201, 201, 201, 5, 96, 204, 222, 97, 
	98, 96, 96, 96, 221, 201, 201, 5, 
	96, 204, 222, 97, 98, 96, 96, 96, 
	218, 201, 201, 5, 96, 204, 222, 228, 
	97, 98, 96, 96, 96, 221, 218, 201, 
	201, 5, 96, 204, 222, 97, 98, 96, 
	96, 96, 218, 201, 201, 201, 5, 96, 
	167, 229, 205, 97, 98, 96, 169, 170, 
	171, 172, 173, 174, 175, 176, 96, 96, 
	230, 201, 201, 5, 96, 204, 97, 98, 
	96, 169, 170, 171, 172, 173, 174, 175, 
	176, 96, 96, 230, 201, 201, 5, 96, 
	97, 98, 96, 159, 160, 161, 162, 163, 
	164, 165, 166, 96, 96, 231, 202, 203, 
	5, 96, 167, 232, 200, 97, 98, 96, 
	169, 170, 171, 172, 173, 174, 175, 176, 
	96, 96, 233, 199, 199, 5, 96, 198, 
	97, 98, 96, 169, 170, 171, 172, 173, 
	174, 175, 176, 96, 96, 233, 199, 199, 
	5, 234, 5, 159, 160, 161, 162, 163, 
	164, 165, 166, 187, 5, 234, 5, 234, 
	5, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 236, 236, 237, 5, 234, 5, 
	234, 5, 238, 236, 237, 236, 239, 236, 
	240, 236, 241, 240, 5, 234, 5, 234, 
	234, 5, 237, 236, 238, 236, 236, 241, 
	5, 236, 5, 242, 243, 244, 5, 237, 
	5, 235, 241, 245, 236, 238, 5, 234, 
	5, 246, 5, 234, 5, 99, 247, 99, 
	99, 99, 99, 99, 5, 248, 5, 96, 
	249, 250, 251, 96, 96, 96, 252, 201, 
	201, 5, 96, 204, 253, 97, 98, 96, 
	96, 96, 201, 201, 201, 5, 96, 254, 
	255, 256, 97, 98, 96, 96, 96, 257, 
	206, 207, 5, 96, 204, 258, 97, 98, 
	96, 96, 96, 201, 201, 201, 5, 96, 
	259, 260, 261, 97, 98, 96, 96, 96, 
	262, 206, 207, 5, 96, 204, 263, 97, 
	98, 96, 96, 96, 201, 201, 201, 5, 
	96, 264, 265, 266, 97, 98, 96, 96, 
	96, 267, 206, 207, 5, 96, 204, 263, 
	97, 98, 96, 96, 96, 262, 201, 201, 
	5, 96, 204, 263, 97, 98, 96, 96, 
	96, 259, 201, 201, 5, 96, 204, 263, 
	268, 97, 98, 96, 96, 96, 262, 259, 
	201, 201, 5, 96, 204, 263, 97, 98, 
	96, 96, 96, 259, 201, 201, 201, 5, 
	96, 204, 258, 97, 98, 96, 96, 96, 
	257, 201, 201, 5, 96, 204, 258, 97, 
	98, 96, 96, 96, 254, 201, 201, 5, 
	96, 204, 258, 269, 97, 98, 96, 96, 
	96, 257, 254, 201, 201, 5, 96, 204, 
	258, 97, 98, 96, 96, 96, 254, 201, 
	201, 201, 5, 96, 204, 253, 97, 98, 
	96, 96, 96, 252, 201, 201, 5, 96, 
	204, 253, 97, 98, 96, 96, 96, 249, 
	201, 201, 5, 96, 204, 253, 270, 97, 
	98, 96, 96, 96, 252, 249, 201, 201, 
	5, 96, 204, 253, 97, 98, 96, 96, 
	96, 249, 201, 201, 201, 5, 271, 271, 
	271, 5, 271, 271, 271, 5, 271, 5, 
	271, 271, 271, 271, 271, 5, 271, 271, 
	271, 5, 271, 271, 271, 271, 271, 5, 
	271, 271, 5, 271, 271, 5, 271, 271, 
	5, 271, 271, 271, 5, 271, 271, 271, 
	5, 271, 271, 271, 271, 271, 5, 271, 
	271, 5, 271, 271, 5, 271, 271, 271, 
	271, 271, 271, 5, 271, 5, 271, 271, 
	5, 271, 5, 271, 271, 5, 272, 273, 
	274, 275, 276, 277, 278, 279, 280, 281, 
	282, 283, 284, 285, 286, 287, 288, 289, 
	290, 291, 292, 293, 294, 295, 296, 297, 
	298, 299, 300, 301, 302, 303, 5, 271, 
	5, 271, 5, 271, 271, 5, 271, 5, 
	271, 271, 271, 5, 271, 271, 271, 271, 
	271, 271, 271, 271, 5, 271, 271, 271, 
	271, 271, 271, 271, 5, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 5, 
	271, 271, 271, 271, 271, 271, 271, 5, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	5, 271, 271, 271, 271, 271, 5, 271, 
	271, 271, 271, 271, 271, 271, 271, 5, 
	271, 271, 271, 271, 271, 271, 271, 5, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 5, 271, 271, 271, 271, 
	271, 5, 271, 271, 271, 271, 271, 271, 
	271, 5, 271, 271, 271, 271, 271, 271, 
	5, 271, 271, 271, 271, 271, 271, 271, 
	5, 271, 271, 271, 271, 271, 271, 271, 
	5, 271, 271, 271, 271, 271, 5, 271, 
	271, 271, 271, 271, 271, 5, 271, 271, 
	271, 271, 271, 5, 271, 271, 271, 271, 
	271, 271, 5, 271, 5, 271, 5, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 5, 271, 271, 271, 
	271, 5, 271, 271, 271, 271, 271, 271, 
	5, 271, 271, 271, 5, 271, 271, 271, 
	5, 271, 5, 304, 305, 306, 307, 308, 
	309, 310, 311, 312, 313, 314, 315, 316, 
	317, 318, 319, 320, 321, 322, 323, 324, 
	325, 326, 327, 328, 329, 330, 331, 276, 
	332, 333, 334, 322, 335, 336, 337, 338, 
	339, 340, 341, 276, 276, 5, 271, 271, 
	271, 5, 271, 271, 271, 271, 271, 5, 
	271, 271, 271, 271, 271, 271, 5, 271, 
	271, 271, 271, 271, 5, 271, 271, 271, 
	271, 5, 271, 271, 271, 5, 271, 271, 
	5, 271, 271, 5, 271, 5, 271, 5, 
	271, 271, 5, 271, 271, 5, 271, 5, 
	271, 271, 271, 5, 271, 271, 271, 271, 
	5, 271, 271, 271, 5, 271, 271, 5, 
	271, 5, 271, 271, 5, 271, 5, 271, 
	271, 271, 5, 271, 271, 5, 271, 271, 
	5, 271, 5, 271, 271, 5, 271, 271, 
	271, 5, 271, 5, 271, 271, 5, 271, 
	271, 5, 271, 5, 271, 271, 5, 271, 
	271, 5, 271, 271, 5, 271, 271, 271, 
	5, 271, 271, 271, 271, 271, 271, 271, 
	5, 271, 271, 271, 5, 271, 271, 271, 
	271, 271, 271, 271, 5, 342, 343, 344, 
	345, 346, 347, 348, 349, 276, 350, 351, 
	352, 353, 354, 355, 5, 271, 271, 5, 
	271, 5, 271, 5, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 5, 
	271, 271, 5, 271, 5, 271, 271, 5, 
	271, 271, 5, 271, 271, 5, 271, 271, 
	271, 271, 5, 271, 271, 271, 5, 271, 
	271, 271, 271, 271, 5, 271, 271, 271, 
	271, 271, 5, 271, 5, 356, 314, 357, 
	358, 359, 276, 360, 361, 276, 5, 271, 
	271, 271, 271, 5, 271, 271, 271, 271, 
	5, 271, 271, 5, 271, 271, 5, 271, 
	271, 5, 271, 5, 324, 276, 276, 5, 
	276, 5, 362, 276, 5, 271, 5, 362, 
	363, 364, 365, 366, 367, 368, 369, 370, 
	371, 334, 372, 373, 374, 375, 376, 377, 
	378, 379, 380, 276, 276, 5, 271, 5, 
	271, 271, 271, 5, 271, 271, 271, 5, 
	271, 271, 5, 271, 271, 5, 271, 271, 
	5, 271, 271, 271, 271, 5, 271, 5, 
	271, 5, 271, 271, 271, 5, 271, 271, 
	5, 271, 271, 5, 271, 271, 5, 271, 
	5, 271, 271, 271, 5, 271, 271, 271, 
	271, 5, 271, 271, 271, 271, 271, 5, 
	271, 271, 5, 381, 382, 276, 5, 271, 
	271, 5, 271, 271, 5, 383, 384, 385, 
	386, 387, 388, 389, 304, 390, 391, 392, 
	393, 394, 395, 396, 397, 398, 276, 5, 
	271, 271, 5, 271, 5, 271, 271, 271, 
	271, 271, 271, 5, 271, 271, 271, 5, 
	271, 5, 271, 5, 271, 271, 5, 271, 
	271, 5, 271, 271, 5, 271, 271, 5, 
	271, 5, 271, 5, 271, 271, 5, 271, 
	5, 271, 271, 271, 271, 5, 399, 400, 
	401, 402, 403, 404, 405, 406, 408, 409, 
	410, 407, 5, 411, 412, 276, 413, 414, 
	415, 416, 417, 418, 419, 420, 421, 422, 
	423, 424, 425, 426, 427, 324, 428, 276, 
	429, 276, 5, 271, 271, 271, 271, 271, 
	5, 271, 271, 5, 271, 5, 271, 5, 
	271, 271, 5, 271, 5, 271, 271, 5, 
	271, 271, 5, 271, 271, 5, 271, 271, 
	5, 271, 5, 271, 271, 271, 271, 271, 
	271, 5, 271, 5, 271, 271, 5, 271, 
	271, 5, 271, 271, 271, 271, 271, 271, 
	271, 5, 271, 5, 271, 271, 5, 271, 
	5, 276, 430, 413, 431, 313, 276, 432, 
	322, 5, 271, 5, 271, 5, 271, 5, 
	433, 276, 5, 271, 5, 433, 276, 5, 
	434, 276, 435, 436, 276, 5, 271, 5, 
	271, 271, 5, 271, 5, 437, 5, 271, 
	5, 438, 439, 440, 441, 442, 443, 444, 
	445, 446, 447, 448, 449, 450, 451, 276, 
	5, 271, 271, 271, 5, 271, 271, 271, 
	5, 271, 5, 271, 271, 5, 271, 271, 
	271, 271, 271, 271, 271, 271, 5, 271, 
	271, 5, 271, 271, 271, 271, 271, 271, 
	5, 271, 271, 271, 271, 5, 271, 271, 
	5, 271, 271, 271, 271, 5, 271, 271, 
	271, 5, 271, 271, 271, 5, 271, 271, 
	271, 5, 271, 271, 5, 452, 453, 454, 
	5, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 5, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 5, 271, 
	271, 271, 271, 271, 5, 455, 276, 5, 
	271, 5, 313, 421, 276, 5, 421, 276, 
	5, 456, 5, 457, 276, 5, 271, 5, 
	96, 198, 97, 98, 458, 96, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 459, 460, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	461, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 462, 96, 96, 
	199, 199, 199, 5, 463, 5, 464, 5, 
	271, 5, 96, 198, 97, 98, 465, 96, 
	465, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 466, 96, 466, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 467, 96, 467, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	468, 96, 468, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 469, 
	96, 96, 199, 199, 199, 5, 470, 470, 
	5, 471, 471, 5, 472, 472, 5, 271, 
	271, 5, 96, 198, 97, 98, 473, 96, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 474, 96, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	462, 96, 96, 96, 199, 199, 199, 5, 
	96, 198, 97, 98, 96, 475, 96, 96, 
	199, 199, 199, 5, 476, 5, 477, 477, 
	5, 271, 271, 5, 96, 198, 97, 98, 
	478, 479, 96, 478, 479, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	480, 96, 480, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 462, 96, 
	462, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 481, 96, 481, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 482, 96, 482, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	462, 96, 462, 96, 96, 199, 199, 199, 
	5, 96, 198, 97, 98, 483, 96, 483, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 484, 96, 484, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 462, 96, 462, 96, 96, 199, 199, 
	199, 5, 96, 198, 97, 98, 485, 96, 
	485, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 486, 96, 486, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 487, 96, 487, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	462, 96, 462, 96, 96, 199, 199, 199, 
	5, 96, 198, 97, 98, 488, 489, 96, 
	488, 489, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 490, 96, 490, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 491, 96, 491, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 492, 96, 492, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 493, 
	96, 493, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 494, 96, 494, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 495, 96, 495, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 462, 96, 462, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 496, 
	96, 496, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 484, 96, 484, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	97, 98, 497, 96, 497, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	498, 96, 498, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 499, 96, 
	499, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 462, 96, 462, 96, 
	96, 199, 199, 199, 5, 96, 198, 97, 
	98, 500, 96, 500, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 501, 
	96, 501, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 502, 96, 502, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 499, 96, 499, 96, 96, 
	199, 199, 199, 5, 503, 503, 271, 271, 
	271, 5, 504, 5, 505, 5, 506, 5, 
	507, 5, 508, 5, 509, 5, 510, 5, 
	511, 5, 271, 271, 271, 5, 512, 5, 
	513, 5, 514, 5, 515, 5, 516, 5, 
	517, 5, 271, 5, 518, 5, 519, 5, 
	520, 5, 521, 5, 522, 5, 523, 5, 
	524, 5, 271, 5, 525, 5, 526, 5, 
	527, 5, 528, 5, 529, 5, 530, 5, 
	271, 5, 96, 198, 97, 98, 531, 96, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 532, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	96, 533, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 96, 534, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 535, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	536, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 537, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 538, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 414, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	97, 98, 539, 96, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	540, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 541, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 542, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 543, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 544, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	96, 545, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 96, 546, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 547, 96, 96, 199, 199, 
	199, 5, 548, 5, 549, 5, 271, 5, 
	96, 198, 97, 98, 550, 96, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 551, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 552, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 553, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	96, 554, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 96, 555, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 556, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	557, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 558, 96, 96, 
	199, 199, 199, 5, 524, 5, 96, 198, 
	97, 98, 559, 96, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	560, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 561, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 562, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 563, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 564, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	96, 565, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 96, 566, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 567, 96, 96, 199, 199, 
	199, 5, 568, 5, 530, 5, 96, 198, 
	97, 98, 569, 96, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	570, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 571, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 572, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 573, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 574, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	96, 575, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 96, 576, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 577, 96, 96, 199, 199, 
	199, 5, 524, 5, 96, 198, 97, 98, 
	578, 96, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 96, 579, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 580, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	581, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 582, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 583, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 584, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 462, 96, 96, 199, 
	199, 199, 5, 96, 198, 97, 98, 585, 
	96, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 586, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 587, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 588, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 589, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	96, 461, 96, 96, 199, 199, 199, 5, 
	96, 198, 97, 98, 590, 591, 96, 590, 
	591, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 462, 96, 462, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 592, 96, 592, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	593, 96, 593, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 462, 96, 
	462, 96, 96, 199, 199, 199, 5, 96, 
	198, 97, 98, 591, 96, 591, 96, 96, 
	199, 199, 199, 5, 96, 198, 97, 98, 
	594, 96, 594, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 595, 96, 
	595, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 596, 96, 596, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 495, 96, 495, 96, 96, 199, 
	199, 199, 5, 96, 198, 97, 98, 96, 
	597, 96, 96, 199, 199, 199, 5, 598, 
	5, 599, 5, 271, 5, 96, 198, 97, 
	98, 600, 96, 600, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 480, 
	96, 480, 96, 96, 199, 199, 199, 5, 
	96, 198, 97, 98, 601, 96, 601, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 602, 96, 602, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	462, 96, 462, 96, 96, 199, 199, 199, 
	5, 96, 198, 97, 98, 603, 96, 603, 
	96, 96, 199, 199, 199, 5, 96, 604, 
	200, 97, 98, 96, 96, 96, 199, 199, 
	199, 5, 96, 198, 97, 98, 605, 96, 
	605, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 606, 96, 606, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 607, 96, 607, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	462, 96, 462, 96, 96, 199, 199, 199, 
	5, 96, 198, 97, 98, 600, 96, 600, 
	475, 96, 96, 199, 199, 199, 5, 96, 
	198, 97, 98, 482, 96, 482, 96, 96, 
	199, 199, 199, 5, 96, 198, 97, 98, 
	608, 96, 608, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 480, 96, 
	480, 96, 96, 199, 199, 199, 5, 96, 
	198, 97, 98, 609, 96, 609, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 462, 96, 462, 96, 96, 199, 199, 
	199, 5, 96, 198, 97, 98, 610, 96, 
	610, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 611, 96, 611, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 612, 96, 612, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	613, 96, 613, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 614, 96, 
	614, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 615, 96, 615, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 616, 96, 616, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	482, 96, 482, 96, 96, 199, 199, 199, 
	5, 96, 198, 97, 98, 617, 96, 617, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 618, 96, 618, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 619, 96, 619, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 620, 
	96, 620, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 621, 96, 621, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 622, 96, 622, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 623, 96, 623, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 624, 
	96, 624, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 495, 96, 495, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	97, 98, 625, 96, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	626, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 96, 627, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 462, 96, 96, 199, 199, 199, 
	5, 96, 198, 97, 98, 628, 96, 628, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 462, 96, 462, 96, 96, 
	199, 199, 199, 5, 96, 198, 97, 98, 
	629, 96, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 96, 630, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 631, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	462, 96, 96, 199, 199, 199, 5, 96, 
	198, 97, 98, 632, 96, 632, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 633, 96, 633, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 487, 
	96, 487, 96, 96, 199, 199, 199, 5, 
	96, 198, 97, 98, 634, 96, 634, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 635, 96, 635, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	595, 96, 595, 96, 96, 199, 199, 199, 
	5, 96, 198, 97, 98, 636, 96, 636, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 637, 96, 637, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 638, 96, 638, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 462, 
	96, 462, 96, 96, 199, 199, 199, 5, 
	96, 198, 97, 98, 639, 96, 639, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 640, 96, 640, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	462, 96, 462, 96, 96, 199, 199, 199, 
	5, 96, 198, 97, 98, 641, 96, 641, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 642, 96, 642, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 643, 96, 643, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 644, 
	96, 644, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 462, 96, 462, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	97, 98, 645, 96, 645, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	646, 96, 646, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 647, 96, 
	647, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 480, 96, 480, 96, 
	96, 199, 199, 199, 5, 96, 198, 97, 
	98, 648, 96, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 649, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 650, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	96, 651, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 96, 652, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 653, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	462, 654, 462, 462, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 96, 
	462, 96, 96, 199, 199, 199, 5, 96, 
	198, 97, 98, 655, 96, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	656, 96, 656, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 657, 96, 
	657, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 658, 96, 658, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 96, 659, 96, 96, 199, 199, 
	199, 5, 660, 660, 5, 271, 271, 5, 
	96, 198, 97, 98, 661, 96, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 662, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 663, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	200, 97, 98, 96, 631, 96, 96, 199, 
	199, 199, 5, 96, 198, 97, 98, 590, 
	96, 590, 96, 96, 199, 199, 199, 5, 
	96, 198, 97, 98, 664, 96, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 96, 665, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 96, 582, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	97, 98, 666, 96, 666, 96, 96, 199, 
	199, 199, 5, 96, 198, 200, 97, 98, 
	667, 96, 667, 96, 96, 199, 199, 199, 
	5, 96, 198, 200, 97, 98, 668, 96, 
	668, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 669, 96, 669, 96, 
	96, 199, 199, 199, 5, 96, 198, 200, 
	97, 98, 484, 96, 484, 96, 96, 199, 
	199, 199, 5, 96, 198, 97, 98, 488, 
	96, 488, 96, 96, 199, 199, 199, 5, 
	96, 198, 97, 98, 670, 96, 96, 96, 
	199, 199, 199, 5, 96, 198, 200, 97, 
	98, 671, 96, 671, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 496, 
	96, 496, 96, 96, 199, 199, 199, 5, 
	96, 198, 97, 98, 647, 96, 647, 96, 
	96, 199, 199, 199, 5, 96, 198, 97, 
	98, 672, 96, 672, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 673, 
	96, 673, 96, 96, 199, 199, 199, 5, 
	96, 198, 200, 97, 98, 609, 96, 609, 
	96, 96, 199, 199, 199, 5, 96, 198, 
	97, 98, 674, 96, 96, 96, 199, 199, 
	199, 5, 96, 198, 200, 97, 98, 675, 
	96, 96, 96, 199, 199, 199, 5, 96, 
	198, 200, 97, 98, 462, 96, 96, 96, 
	199, 199, 199, 5, 1, 677, 678, 1, 
	679, 676, 680, 679, 676, 682, 683, 684, 
	686, 687, 688, 689, 690, 691, 692, 693, 
	694, 695, 697, 698, 699, 700, 701, 702, 
	703, 704, 705, 680, 687, 688, 706, 690, 
	691, 707, 708, 709, 710, 711, 701, 712, 
	714, 715, 717, 713, 718, 719, 720, 721, 
	722, 723, 724, 725, 726, 727, 728, 729, 
	730, 731, 732, 733, 734, 735, 736, 737, 
	739, 740, 741, 742, 743, 680, 744, 680, 
	744, 676, 680, 685, 676, 696, 676, 696, 
	676, 713, 716, 738, 713, 681, 1, 746, 
	747, 1, 748, 749, 750, 751, 745, 1, 
	752, 1, 748, 749, 750, 751, 745, 1, 
	1, 748, 749, 750, 751, 745, 1, 752, 
	1, 748, 749, 750, 751, 745, 1, 753, 
	754, 1, 748, 749, 750, 751, 745, 756, 
	755, 1, 753, 757, 1, 748, 749, 750, 
	751, 745, 756, 755, 1, 754, 757, 1, 
	748, 749, 750, 751, 745, 132, 132, 96, 
	133, 96, 97, 133, 98, 133, 96, 133, 
	134, 135, 136, 137, 138, 139, 132, 96, 
	157, 96, 96, 96, 96, 758, 105, 107, 
	112, 759, 104, 110, 104, 758, 111, 112, 
	112, 111, 111, 111, 112, 111, 111, 112, 
	112, 758, 112, 113, 758, 105, 107, 112, 
	759, 104, 104, 114, 758, 105, 107, 112, 
	759, 104, 104, 104, 758, 105, 107, 112, 
	759, 128, 104, 104, 758, 105, 107, 112, 
	759, 125, 104, 104, 758, 105, 107, 112, 
	760, 759, 128, 125, 104, 104, 758, 105, 
	107, 112, 759, 125, 104, 104, 104, 758, 
	96, 97, 98, 96, 96, 96, 96, 96, 
	96, 758, 96, 761, 198, 762, 97, 98, 
	764, 96, 764, 237, 241, 238, 765, 766, 
	767, 768, 769, 96, 96, 763, 199, 199, 
	758, 96, 97, 98, 770, 96, 770, 159, 
	160, 161, 162, 163, 164, 165, 166, 96, 
	96, 158, 96, 96, 758, 96, 97, 98, 
	96, 169, 170, 171, 172, 173, 174, 175, 
	176, 96, 96, 168, 96, 96, 758, 169, 
	170, 171, 172, 173, 174, 175, 176, 177, 
	758, 771, 771, 159, 160, 161, 162, 163, 
	164, 165, 166, 187, 758, 96, 204, 205, 
	112, 212, 98, 96, 96, 96, 201, 208, 
	201, 758, 99, 112, 98, 99, 99, 99, 
	209, 99, 99, 758, 96, 204, 205, 112, 
	212, 98, 96, 96, 96, 201, 201, 210, 
	758, 96, 204, 772, 97, 98, 773, 96, 
	773, 159, 160, 161, 162, 163, 164, 165, 
	166, 96, 96, 231, 201, 201, 758, 96, 
	204, 205, 97, 98, 773, 96, 773, 159, 
	160, 161, 162, 163, 164, 165, 166, 96, 
	96, 231, 201, 201, 758, 96, 204, 205, 
	97, 98, 96, 169, 170, 171, 172, 173, 
	174, 175, 176, 96, 96, 230, 201, 201, 
	758, 96, 204, 772, 97, 98, 773, 96, 
	773, 159, 160, 161, 162, 163, 164, 165, 
	166, 96, 96, 217, 201, 201, 758, 96, 
	204, 772, 97, 98, 773, 96, 773, 159, 
	160, 161, 162, 163, 164, 165, 166, 96, 
	96, 214, 201, 201, 758, 96, 204, 772, 
	774, 97, 98, 773, 96, 773, 159, 160, 
	161, 162, 163, 164, 165, 166, 96, 96, 
	217, 214, 201, 201, 758, 96, 204, 772, 
	97, 98, 773, 96, 773, 159, 160, 161, 
	162, 163, 164, 165, 166, 96, 96, 214, 
	231, 201, 201, 758, 96, 761, 198, 775, 
	97, 98, 764, 96, 764, 237, 241, 238, 
	765, 766, 767, 768, 769, 96, 96, 763, 
	199, 199, 758, 96, 198, 200, 97, 98, 
	96, 169, 170, 171, 172, 173, 174, 175, 
	176, 96, 96, 233, 199, 199, 758, 776, 
	776, 771, 771, 237, 241, 238, 765, 766, 
	767, 768, 769, 234, 758, 96, 761, 198, 
	762, 97, 98, 764, 96, 764, 237, 241, 
	238, 765, 766, 767, 768, 769, 96, 96, 
	685, 199, 199, 758, 96, 761, 198, 762, 
	97, 98, 764, 96, 764, 237, 241, 238, 
	765, 766, 767, 768, 769, 96, 96, 682, 
	199, 199, 758, 96, 761, 198, 762, 777, 
	97, 98, 764, 96, 764, 237, 241, 238, 
	765, 766, 767, 768, 769, 96, 96, 685, 
	682, 199, 199, 758, 96, 761, 198, 762, 
	97, 98, 764, 96, 764, 237, 241, 238, 
	765, 766, 767, 768, 769, 96, 96, 682, 
	763, 199, 199, 758, 132, 132, 133, 133, 
	133, 133, 133, 133, 134, 135, 136, 137, 
	138, 139, 132, 758, 96, 198, 200, 97, 
	98, 779, 96, 779, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 778, 778, 276, 407, 
	758, 96, 198, 200, 97, 98, 96, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 96, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	204, 205, 112, 212, 98, 96, 96, 96, 
	201, 201, 201, 758, 96, 204, 205, 112, 
	212, 98, 96, 96, 96, 267, 201, 201, 
	758, 96, 204, 205, 112, 212, 98, 96, 
	96, 96, 264, 201, 201, 758, 96, 204, 
	205, 112, 809, 212, 98, 96, 96, 96, 
	267, 264, 201, 201, 758, 96, 204, 205, 
	112, 212, 98, 96, 96, 96, 264, 201, 
	201, 201, 758, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	271, 271, 276, 407, 758, 96, 810, 200, 
	97, 98, 96, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 97, 98, 96, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 462, 462, 
	276, 407, 758, 96, 198, 200, 97, 98, 
	811, 96, 811, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 778, 778, 276, 407, 758, 
	96, 198, 200, 97, 98, 812, 96, 812, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	808, 98, 813, 96, 813, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 814, 200, 808, 98, 96, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	97, 98, 815, 816, 817, 96, 816, 817, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	778, 778, 276, 407, 758, 96, 818, 200, 
	97, 98, 96, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 97, 98, 819, 820, 96, 
	819, 820, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 808, 98, 821, 96, 821, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 822, 96, 822, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 823, 200, 808, 98, 96, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 824, 96, 824, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 808, 98, 825, 96, 
	825, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 826, 96, 826, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 827, 200, 808, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 97, 98, 828, 96, 828, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	829, 96, 829, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 830, 200, 808, 98, 96, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 97, 98, 
	831, 96, 831, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 778, 778, 276, 407, 758, 
	96, 198, 200, 97, 98, 832, 96, 832, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	808, 98, 833, 96, 833, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 834, 200, 808, 98, 96, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 835, 200, 
	97, 98, 96, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 778, 778, 276, 407, 758, 
	96, 198, 200, 97, 98, 836, 837, 838, 
	96, 836, 837, 838, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 778, 778, 276, 407, 
	758, 96, 198, 200, 97, 98, 839, 96, 
	839, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 840, 96, 840, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 841, 200, 808, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 97, 98, 842, 96, 842, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	843, 96, 843, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 808, 98, 844, 96, 844, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 845, 200, 
	808, 98, 96, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 97, 98, 96, 780, 846, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 847, 847, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 271, 271, 276, 407, 758, 848, 
	849, 848, 849, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	271, 271, 276, 407, 758, 850, 851, 850, 
	851, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 271, 271, 
	276, 407, 758, 852, 852, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 271, 271, 276, 407, 758, 853, 
	853, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 271, 271, 
	276, 407, 758, 854, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 271, 271, 276, 407, 758, 855, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 271, 271, 276, 407, 
	758, 856, 857, 856, 857, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 271, 271, 276, 407, 758, 858, 
	858, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 271, 271, 
	276, 407, 758, 859, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 271, 271, 276, 407, 758, 860, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 271, 271, 276, 407, 
	758, 96, 198, 200, 97, 98, 861, 96, 
	861, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 778, 778, 276, 407, 758, 96, 198, 
	200, 97, 98, 862, 96, 862, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	863, 96, 863, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 864, 200, 808, 98, 865, 866, 867, 
	868, 96, 865, 866, 867, 868, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 869, 200, 808, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 870, 96, 870, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 871, 200, 808, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 872, 96, 872, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	873, 96, 873, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 874, 200, 808, 98, 96, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 875, 200, 808, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 97, 98, 876, 877, 878, 96, 876, 
	877, 878, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 778, 778, 276, 407, 758, 96, 
	198, 200, 97, 98, 879, 880, 96, 879, 
	880, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 881, 96, 881, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	833, 96, 833, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 808, 98, 882, 96, 882, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	808, 98, 883, 96, 883, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 808, 98, 884, 
	96, 884, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	885, 200, 808, 98, 96, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 97, 98, 886, 
	96, 886, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 808, 98, 887, 96, 887, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 888, 96, 888, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 808, 98, 889, 96, 
	889, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 890, 96, 890, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 891, 200, 808, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 892, 
	200, 97, 98, 893, 96, 893, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	894, 96, 894, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 895, 200, 808, 98, 96, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 97, 98, 
	896, 96, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 778, 778, 276, 407, 758, 96, 
	897, 200, 97, 98, 96, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 97, 98, 96, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	778, 778, 276, 407, 758, 96, 198, 200, 
	97, 98, 898, 899, 900, 901, 902, 96, 
	899, 900, 901, 902, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 778, 778, 276, 407, 
	758, 96, 198, 200, 97, 98, 903, 96, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 904, 200, 
	808, 98, 96, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 905, 200, 97, 98, 96, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 97, 98, 
	906, 96, 906, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 808, 98, 907, 96, 907, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 908, 200, 
	808, 98, 96, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 97, 98, 909, 96, 909, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 910, 200, 
	808, 98, 96, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 97, 98, 911, 912, 913, 
	96, 911, 912, 913, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 808, 98, 914, 96, 
	914, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 915, 96, 915, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 916, 200, 808, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 917, 96, 917, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 918, 200, 808, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 919, 
	200, 808, 98, 96, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 97, 98, 920, 921, 
	922, 96, 920, 921, 922, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 778, 778, 276, 
	407, 758, 96, 198, 200, 97, 98, 923, 
	924, 96, 923, 924, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 808, 98, 925, 96, 
	925, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 926, 
	200, 808, 98, 96, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 808, 98, 927, 96, 
	927, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 928, 96, 928, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	929, 96, 929, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 808, 98, 930, 96, 930, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	808, 98, 931, 96, 931, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 932, 200, 808, 98, 933, 
	96, 933, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	934, 200, 808, 98, 96, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 97, 98, 935, 
	96, 935, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 808, 98, 936, 96, 936, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 937, 96, 937, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 808, 98, 938, 96, 
	938, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 939, 96, 939, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	940, 96, 940, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 941, 200, 808, 98, 96, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 97, 98, 
	942, 96, 942, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 808, 98, 943, 96, 943, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	808, 98, 944, 96, 944, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 945, 200, 808, 98, 96, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	97, 98, 946, 96, 946, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 778, 778, 276, 
	407, 758, 96, 198, 200, 97, 98, 947, 
	96, 947, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 808, 98, 948, 96, 948, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 949, 96, 949, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 950, 200, 808, 98, 96, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 97, 
	98, 951, 952, 96, 951, 952, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 778, 778, 
	276, 407, 758, 96, 953, 200, 97, 98, 
	96, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 97, 98, 954, 96, 954, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	955, 96, 955, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 808, 98, 956, 96, 956, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	808, 98, 957, 96, 957, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 958, 200, 808, 98, 96, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	97, 98, 959, 960, 961, 962, 96, 959, 
	960, 961, 962, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 778, 778, 276, 407, 758, 
	96, 198, 200, 97, 98, 963, 96, 963, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	808, 98, 964, 96, 964, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 965, 200, 808, 98, 96, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	97, 98, 966, 96, 966, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 808, 98, 967, 
	96, 967, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	968, 200, 808, 98, 96, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 97, 98, 969, 
	96, 969, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	970, 200, 808, 98, 96, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 97, 98, 971, 
	96, 971, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 808, 98, 972, 96, 972, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 973, 96, 973, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 808, 98, 974, 96, 
	974, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 975, 
	200, 808, 98, 96, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 198, 200, 97, 98, 976, 977, 
	978, 96, 976, 978, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 778, 778, 276, 407, 
	758, 96, 198, 200, 97, 98, 979, 96, 
	979, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 980, 96, 980, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	981, 96, 981, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 808, 98, 982, 96, 982, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	808, 98, 983, 96, 983, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 808, 98, 984, 
	96, 984, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	985, 200, 808, 98, 96, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 986, 200, 97, 98, 96, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 198, 200, 
	97, 98, 987, 96, 987, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 808, 98, 988, 
	96, 988, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 808, 98, 989, 96, 989, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 990, 200, 808, 
	98, 96, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 97, 98, 991, 992, 993, 96, 
	991, 992, 993, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 778, 778, 276, 407, 758, 
	96, 198, 200, 97, 98, 994, 96, 994, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	807, 807, 276, 407, 758, 96, 995, 200, 
	808, 98, 96, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 198, 200, 97, 98, 996, 997, 96, 
	996, 997, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 808, 98, 998, 96, 998, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 999, 96, 999, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 1000, 200, 808, 98, 96, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 1001, 200, 808, 
	98, 96, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 807, 807, 276, 407, 758, 96, 
	198, 200, 97, 98, 1002, 96, 1002, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 198, 200, 808, 
	98, 1003, 96, 1003, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 807, 807, 276, 407, 
	758, 96, 1004, 200, 808, 98, 96, 780, 
	781, 782, 783, 784, 785, 786, 787, 788, 
	789, 790, 791, 792, 793, 304, 794, 387, 
	795, 796, 797, 798, 799, 800, 801, 802, 
	803, 804, 805, 806, 96, 96, 199, 807, 
	807, 276, 407, 758, 96, 1005, 200, 97, 
	98, 1006, 96, 1006, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 778, 778, 276, 407, 
	758, 96, 198, 200, 97, 98, 1007, 96, 
	1007, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 808, 98, 1008, 96, 1008, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 198, 200, 808, 98, 
	1009, 96, 1009, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 807, 807, 276, 407, 758, 
	96, 1010, 200, 808, 98, 96, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 807, 807, 
	276, 407, 758, 96, 1011, 200, 97, 98, 
	1012, 96, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 778, 778, 276, 407, 758, 96, 
	1013, 200, 97, 98, 96, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 97, 98, 817, 
	96, 817, 780, 781, 782, 783, 784, 785, 
	786, 787, 788, 789, 790, 791, 792, 793, 
	304, 794, 387, 795, 796, 797, 798, 799, 
	800, 801, 802, 803, 804, 805, 806, 96, 
	96, 199, 778, 778, 276, 407, 758, 96, 
	198, 200, 97, 98, 836, 837, 96, 836, 
	837, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 778, 778, 276, 407, 758, 96, 198, 
	200, 97, 98, 1014, 878, 96, 1014, 878, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 96, 96, 199, 
	778, 778, 276, 407, 758, 96, 198, 200, 
	97, 98, 879, 96, 879, 780, 781, 782, 
	783, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 304, 794, 387, 795, 796, 
	797, 798, 799, 800, 801, 802, 803, 804, 
	805, 806, 96, 96, 199, 807, 807, 276, 
	407, 758, 96, 198, 200, 97, 98, 900, 
	1015, 96, 900, 1015, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 778, 778, 276, 407, 
	758, 96, 198, 200, 97, 98, 912, 96, 
	912, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 96, 198, 
	200, 97, 98, 920, 96, 920, 780, 781, 
	782, 783, 784, 785, 786, 787, 788, 789, 
	790, 791, 792, 793, 304, 794, 387, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 96, 96, 199, 778, 778, 
	276, 407, 758, 96, 198, 200, 97, 98, 
	951, 96, 951, 780, 781, 782, 783, 784, 
	785, 786, 787, 788, 789, 790, 791, 792, 
	793, 304, 794, 387, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	96, 96, 199, 778, 778, 276, 407, 758, 
	96, 198, 200, 97, 98, 991, 1016, 993, 
	96, 991, 1016, 993, 780, 781, 782, 783, 
	784, 785, 786, 787, 788, 789, 790, 791, 
	792, 793, 304, 794, 387, 795, 796, 797, 
	798, 799, 800, 801, 802, 803, 804, 805, 
	806, 96, 96, 199, 778, 778, 276, 407, 
	758, 96, 198, 200, 97, 98, 997, 96, 
	997, 780, 781, 782, 783, 784, 785, 786, 
	787, 788, 789, 790, 791, 792, 793, 304, 
	794, 387, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 804, 805, 806, 96, 96, 
	199, 807, 807, 276, 407, 758, 713, 758, 
	1017, 1018, 1018, 1018, 713, 758, 1, 746, 
	747, 1, 748, 749, 750, 751, 713, 745, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 304, 794, 
	387, 795, 796, 797, 798, 799, 800, 801, 
	802, 803, 804, 805, 806, 271, 271, 713, 
	276, 407, 758, 713, 713, 1018, 758, 1018, 
	758, 1018, 1018, 1018, 713, 1018, 713, 1018, 
	713, 758, 713, 713, 1018, 713, 1018, 713, 
	758, 1018, 713, 713, 713, 713, 1018, 758, 
	713, 1018, 758, 1018, 713, 1018, 758, 1018, 
	713, 1018, 758, 1018, 1018, 713, 1018, 758, 
	1018, 713, 758, 713, 1018, 713, 1018, 713, 
	758, 713, 1018, 758, 713, 1018, 713, 1019, 
	713, 1018, 758, 776, 776, 771, 771, 237, 
	241, 238, 765, 766, 767, 768, 769, 234, 
	713, 758, 713, 1018, 1018, 713, 1018, 713, 
	1018, 1019, 1018, 713, 758, 1018, 713, 1018, 
	713, 758, 713, 1018, 758, 1018, 1018, 713, 
	758, 1018, 1019, 1018, 713, 1018, 713, 758, 
	1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 
	1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 
	1036, 1035, 1037, 1038, 1039, 1040, 1041, 1042, 
	1043, 1044, 1045, 1046, 1047, 1048, 713, 758, 
	1018, 1018, 1018, 1018, 713, 758, 1018, 713, 
	758, 1018, 713, 1018, 713, 758, 1018, 713, 
	1018, 713, 758, 1018, 713, 713, 713, 1018, 
	713, 1019, 1018, 758, 713, 713, 1018, 713, 
	1018, 713, 1018, 713, 1018, 713, 1018, 713, 
	758, 1018, 713, 713, 1018, 713, 1019, 1018, 
	713, 758, 713, 713, 713, 713, 713, 1018, 
	713, 1018, 713, 1018, 713, 758, 713, 713, 
	1018, 713, 1019, 713, 1018, 713, 758, 713, 
	713, 713, 713, 713, 1018, 713, 1018, 713, 
	758, 1018, 713, 1018, 713, 1019, 713, 758, 
	713, 713, 713, 1018, 713, 1018, 713, 1018, 
	713, 1018, 713, 758, 713, 1018, 713, 1018, 
	713, 1019, 713, 758, 1018, 713, 713, 713, 
	713, 1018, 713, 1018, 713, 1018, 713, 1018, 
	713, 1018, 713, 1018, 713, 758, 1018, 713, 
	1019, 713, 758, 713, 713, 713, 713, 1018, 
	713, 1018, 713, 758, 713, 1018, 713, 1018, 
	713, 1019, 713, 758, 1018, 713, 713, 1018, 
	713, 1019, 1018, 713, 758, 713, 713, 1018, 
	713, 1018, 713, 758, 1018, 713, 1018, 713, 
	1019, 713, 1018, 758, 713, 713, 713, 1018, 
	713, 1018, 713, 758, 1018, 713, 758, 713, 
	713, 1018, 713, 758, 1018, 713, 1019, 713, 
	758, 713, 713, 713, 1018, 713, 713, 713, 
	713, 713, 713, 1018, 1018, 713, 1018, 713, 
	1018, 713, 1018, 713, 758, 713, 1018, 713, 
	1019, 713, 1018, 713, 758, 1018, 713, 1019, 
	713, 758, 713, 1018, 713, 758, 713, 1018, 
	713, 758, 1049, 1050, 1051, 1052, 1053, 1054, 
	1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 
	1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 
	1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 
	713, 1079, 1080, 1081, 1082, 1083, 1084, 713, 
	1085, 713, 1086, 1087, 1088, 1089, 716, 758, 
	1018, 1018, 713, 758, 1018, 1019, 713, 1018, 
	713, 1018, 713, 1018, 713, 1018, 713, 1018, 
	758, 1018, 1018, 713, 1019, 713, 1018, 758, 
	713, 1018, 713, 1018, 713, 1018, 758, 713, 
	713, 713, 1018, 713, 1018, 713, 1018, 758, 
	713, 713, 713, 1018, 713, 1018, 713, 1018, 
	758, 713, 713, 1018, 713, 1018, 758, 713, 
	1018, 713, 1018, 758, 1018, 713, 758, 1018, 
	713, 1018, 758, 1018, 713, 758, 713, 1018, 
	758, 1018, 713, 1018, 758, 1017, 1018, 713, 
	1018, 758, 1018, 713, 758, 713, 1018, 713, 
	1018, 713, 758, 713, 1018, 713, 1018, 713, 
	758, 1018, 713, 758, 1018, 1018, 713, 1019, 
	713, 758, 713, 1019, 713, 1018, 758, 1018, 
	713, 758, 713, 1018, 713, 1018, 758, 1018, 
	713, 758, 1018, 713, 758, 713, 1019, 1018, 
	713, 1018, 713, 758, 1018, 713, 758, 713, 
	1018, 713, 1019, 713, 758, 1018, 713, 1018, 
	758, 1018, 713, 758, 1018, 1019, 713, 1019, 
	713, 758, 713, 1018, 713, 758, 713, 1018, 
	713, 1019, 713, 758, 713, 1018, 713, 1018, 
	1019, 1018, 758, 1018, 713, 758, 1018, 713, 
	758, 1019, 713, 1018, 1019, 1018, 713, 758, 
	713, 713, 1018, 713, 1018, 713, 758, 1018, 
	713, 1018, 713, 1018, 758, 713, 713, 713, 
	713, 1018, 713, 1018, 713, 1018, 713, 758, 
	713, 713, 713, 1018, 758, 713, 713, 713, 
	1018, 713, 1018, 713, 1018, 713, 1018, 713, 
	1018, 713, 758, 1090, 1091, 1092, 1093, 1094, 
	1095, 1096, 1097, 716, 1098, 1099, 1100, 1101, 
	1102, 1103, 713, 758, 1104, 1017, 1017, 713, 
	758, 132, 132, 133, 133, 133, 133, 133, 
	133, 134, 135, 136, 137, 138, 139, 132, 
	713, 758, 1017, 1018, 1018, 713, 758, 713, 
	1018, 713, 758, 1018, 1018, 713, 1018, 1018, 
	1018, 713, 713, 1018, 713, 1018, 713, 1018, 
	713, 1018, 758, 1018, 713, 1018, 713, 758, 
	713, 1018, 713, 758, 713, 1018, 758, 713, 
	1018, 758, 1018, 713, 1018, 713, 1018, 713, 
	758, 713, 1018, 1018, 713, 1018, 758, 1018, 
	1018, 713, 758, 713, 713, 713, 713, 1018, 
	713, 1018, 758, 713, 713, 713, 1018, 713, 
	758, 1018, 713, 758, 1105, 1060, 1106, 1107, 
	1108, 716, 1109, 1110, 713, 716, 758, 1017, 
	713, 1018, 713, 1018, 713, 1018, 713, 758, 
	713, 1018, 713, 1018, 758, 713, 1018, 758, 
	713, 1018, 713, 1018, 758, 1018, 713, 1018, 
	713, 758, 713, 1018, 758, 1071, 713, 716, 
	758, 716, 758, 1111, 716, 758, 1018, 713, 
	758, 1111, 1112, 1113, 1114, 1115, 1082, 1116, 
	1117, 1118, 1119, 1066, 1120, 1121, 1122, 1123, 
	1124, 1125, 1126, 1127, 1128, 1129, 1130, 1131, 
	716, 713, 716, 758, 713, 1018, 713, 758, 
	1018, 713, 1018, 1019, 1018, 713, 758, 1018, 
	1018, 713, 758, 1018, 713, 1018, 758, 713, 
	1018, 713, 1018, 758, 713, 1018, 713, 1018, 
	713, 1018, 713, 758, 713, 1018, 758, 713, 
	713, 713, 1018, 713, 758, 713, 1018, 713, 
	758, 1018, 713, 1019, 713, 1018, 713, 758, 
	1019, 1018, 713, 1018, 758, 1018, 713, 1018, 
	713, 758, 713, 1018, 713, 758, 1018, 713, 
	1019, 713, 758, 1018, 713, 758, 713, 1018, 
	1018, 713, 1019, 713, 1018, 713, 758, 713, 
	1018, 713, 1018, 713, 1018, 713, 758, 713, 
	1018, 713, 1018, 713, 1018, 713, 1018, 713, 
	758, 713, 713, 1018, 713, 1018, 713, 1018, 
	713, 1018, 713, 758, 1018, 713, 1019, 713, 
	758, 1132, 1133, 716, 713, 758, 1018, 713, 
	1018, 758, 1018, 713, 1018, 713, 758, 1134, 
	1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 
	1143, 713, 1144, 1145, 1146, 1147, 1148, 1149, 
	713, 716, 758, 1018, 713, 1018, 758, 1018, 
	713, 758, 1018, 713, 713, 713, 713, 1018, 
	713, 1018, 713, 1018, 758, 713, 713, 1018, 
	758, 1018, 713, 758, 713, 1018, 758, 1018, 
	713, 758, 713, 1018, 758, 1018, 713, 1018, 
	758, 1018, 713, 1018, 713, 758, 713, 713, 
	1018, 758, 1018, 713, 758, 713, 1019, 713, 
	1018, 713, 758, 713, 1018, 713, 1018, 758, 
	713, 1018, 758, 713, 1018, 713, 1018, 713, 
	1018, 713, 1018, 713, 758, 1150, 1151, 1152, 
	1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 
	713, 738, 713, 758, 1161, 1162, 716, 1163, 
	1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 
	1172, 1173, 1174, 1175, 1176, 1071, 1177, 716, 
	1178, 713, 716, 713, 758, 713, 713, 713, 
	713, 1018, 758, 1018, 713, 1018, 713, 758, 
	1018, 713, 758, 1018, 713, 1018, 758, 1018, 
	713, 758, 1018, 713, 1018, 758, 713, 1018, 
	713, 758, 1018, 713, 1018, 758, 1018, 713, 
	1018, 713, 758, 1018, 713, 1019, 713, 758, 
	1018, 713, 1018, 1018, 1018, 713, 1018, 713, 
	758, 1018, 713, 758, 1018, 713, 1018, 713, 
	758, 1018, 713, 1018, 758, 1018, 713, 713, 
	713, 1018, 713, 758, 713, 1018, 713, 758, 
	1018, 713, 1018, 713, 758, 1018, 713, 758, 
	1179, 1180, 1181, 1182, 1183, 1184, 1185, 1063, 
	1186, 713, 758, 713, 1018, 713, 758, 713, 
	1019, 713, 758, 713, 1018, 713, 758, 713, 
	1018, 713, 1019, 713, 758, 713, 1018, 713, 
	1019, 758, 713, 1018, 713, 758, 713, 1018, 
	713, 1019, 713, 758, 1019, 713, 758, 1187, 
	716, 713, 758, 1018, 713, 758, 1187, 716, 
	713, 758, 1188, 716, 1189, 1190, 713, 716, 
	713, 758, 1018, 713, 758, 1018, 1018, 713, 
	758, 713, 1018, 713, 758, 1191, 713, 758, 
	1018, 713, 758, 1192, 1193, 1194, 1195, 1196, 
	1197, 1198, 1199, 1200, 1201, 1202, 713, 716, 
	713, 758, 713, 1018, 758, 713, 1018, 713, 
	713, 713, 1018, 713, 1018, 713, 1018, 758, 
	713, 1018, 758, 713, 713, 713, 713, 713, 
	1018, 713, 1018, 758, 713, 713, 1018, 713, 
	1018, 758, 1018, 713, 1018, 758, 713, 713, 
	713, 1018, 758, 713, 713, 1018, 758, 713, 
	713, 1018, 758, 713, 713, 1018, 758, 713, 
	1018, 713, 1019, 758, 1203, 1204, 1205, 713, 
	758, 713, 713, 713, 1018, 713, 713, 713, 
	1018, 713, 1018, 713, 758, 1018, 1018, 1018, 
	1018, 713, 713, 1018, 1018, 1018, 1018, 1018, 
	713, 713, 713, 713, 713, 713, 713, 1018, 
	713, 1018, 713, 1018, 758, 713, 713, 713, 
	1018, 713, 1018, 713, 758, 1206, 716, 758, 
	1018, 713, 758, 1059, 1207, 716, 713, 758, 
	1018, 713, 758, 1207, 713, 716, 713, 758, 
	96, 97, 98, 96, 237, 241, 238, 765, 
	766, 767, 768, 769, 96, 96, 1208, 96, 
	96, 758, 96, 761, 761, 97, 98, 770, 
	96, 770, 237, 241, 238, 765, 766, 767, 
	768, 769, 96, 96, 1208, 96, 96, 758, 
	0
};

static const short _czech_tokenizer_trans_targs[] = {
	744, 745, 3, 5, 6, 744, 8, 9, 
	744, 89, 11, 12, 13, 14, 15, 16, 
	17, 18, 19, 20, 21, 22, 23, 24, 
	25, 26, 27, 90, 92, 95, 57, 63, 
	69, 10, 29, 39, 55, 28, 30, 31, 
	32, 33, 34, 35, 36, 37, 38, 40, 
	41, 42, 43, 44, 45, 46, 47, 48, 
	49, 50, 51, 52, 53, 54, 56, 58, 
	59, 60, 61, 62, 64, 65, 66, 67, 
	68, 70, 72, 71, 73, 74, 75, 76, 
	77, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 91, 93, 94, 96, 
	97, 98, 100, 99, 101, 122, 124, 123, 
	103, 102, 109, 104, 105, 108, 755, 106, 
	756, 757, 758, 110, 118, 120, 119, 111, 
	112, 114, 116, 115, 113, 759, 760, 762, 
	761, 117, 121, 125, 8, 126, 127, 128, 
	130, 132, 142, 144, 129, 131, 133, 134, 
	135, 136, 137, 138, 139, 140, 141, 143, 
	145, 146, 147, 148, 149, 150, 766, 171, 
	174, 175, 176, 179, 182, 183, 184, 153, 
	767, 154, 155, 156, 157, 160, 163, 164, 
	165, 768, 158, 159, 161, 162, 166, 167, 
	169, 168, 170, 769, 173, 177, 178, 180, 
	181, 185, 186, 188, 187, 189, 190, 191, 
	192, 193, 199, 201, 194, 195, 196, 198, 
	770, 771, 772, 200, 197, 202, 773, 776, 
	778, 777, 205, 212, 214, 213, 206, 207, 
	208, 210, 209, 211, 215, 217, 775, 774, 
	220, 781, 782, 226, 227, 221, 224, 229, 
	230, 223, 234, 235, 237, 236, 238, 240, 
	241, 242, 256, 258, 257, 243, 244, 252, 
	254, 253, 245, 246, 248, 250, 249, 247, 
	791, 792, 794, 793, 251, 255, 259, 796, 
	280, 281, 282, 283, 262, 284, 285, 286, 
	287, 288, 289, 290, 291, 292, 293, 294, 
	295, 296, 297, 298, 299, 300, 301, 302, 
	303, 304, 305, 306, 307, 308, 309, 310, 
	275, 312, 313, 314, 315, 316, 317, 318, 
	319, 320, 321, 322, 323, 324, 325, 326, 
	327, 328, 329, 330, 331, 332, 333, 334, 
	335, 336, 337, 338, 339, 340, 341, 342, 
	343, 344, 345, 346, 347, 348, 350, 351, 
	352, 353, 354, 355, 356, 357, 358, 359, 
	360, 361, 362, 363, 365, 366, 367, 368, 
	369, 370, 374, 376, 377, 378, 379, 380, 
	381, 382, 383, 384, 385, 386, 387, 388, 
	389, 390, 391, 392, 393, 395, 396, 398, 
	399, 400, 401, 277, 402, 403, 404, 405, 
	406, 407, 408, 409, 410, 411, 412, 414, 
	434, 438, 440, 441, 445, 447, 462, 372, 
	466, 468, 469, 415, 416, 417, 418, 419, 
	420, 421, 422, 423, 424, 425, 426, 427, 
	428, 429, 430, 431, 432, 433, 435, 436, 
	437, 439, 442, 443, 444, 446, 448, 449, 
	450, 451, 452, 453, 454, 455, 456, 457, 
	458, 459, 460, 461, 463, 464, 465, 467, 
	471, 472, 474, 475, 477, 476, 798, 478, 
	479, 481, 482, 483, 484, 485, 486, 487, 
	488, 490, 491, 493, 494, 495, 497, 499, 
	498, 500, 501, 503, 504, 506, 507, 508, 
	510, 517, 511, 512, 513, 514, 515, 516, 
	518, 520, 521, 522, 524, 525, 526, 830, 
	529, 530, 531, 532, 533, 534, 535, 536, 
	538, 539, 540, 541, 542, 543, 545, 546, 
	547, 548, 549, 550, 551, 553, 554, 555, 
	556, 557, 558, 560, 561, 562, 563, 564, 
	565, 566, 567, 569, 570, 571, 572, 573, 
	574, 575, 576, 577, 578, 579, 581, 582, 
	583, 584, 585, 586, 587, 588, 589, 591, 
	592, 593, 594, 595, 596, 597, 598, 599, 
	600, 602, 603, 604, 605, 606, 607, 608, 
	609, 610, 612, 613, 614, 615, 616, 617, 
	618, 620, 621, 622, 623, 624, 626, 627, 
	628, 629, 632, 633, 634, 636, 637, 638, 
	640, 642, 643, 645, 646, 647, 648, 649, 
	653, 655, 657, 658, 659, 660, 661, 662, 
	663, 665, 666, 667, 668, 669, 670, 671, 
	672, 674, 675, 676, 678, 680, 681, 682, 
	684, 685, 687, 688, 690, 691, 692, 694, 
	695, 697, 698, 699, 700, 702, 703, 704, 
	706, 707, 708, 709, 710, 711, 712, 714, 
	715, 716, 717, 718, 719, 721, 722, 723, 
	726, 727, 729, 730, 731, 732, 735, 736, 
	739, 740, 742, 743, 744, 749, 753, 754, 
	764, 0, 765, 783, 785, 784, 787, 788, 
	799, 803, 816, 820, 821, 841, 852, 869, 
	871, 872, 888, 910, 915, 922, 936, 949, 
	960, 965, 967, 968, 969, 971, 973, 974, 
	975, 977, 978, 981, 982, 983, 984, 985, 
	986, 987, 988, 989, 990, 991, 992, 993, 
	995, 996, 997, 998, 999, 1000, 1030, 1072, 
	1088, 1095, 1096, 1097, 1099, 1120, 1123, 1140, 
	1199, 744, 746, 748, 1, 2, 4, 7, 
	747, 750, 751, 744, 744, 752, 744, 107, 
	763, 151, 203, 780, 219, 225, 228, 231, 
	232, 233, 152, 172, 204, 216, 779, 218, 
	222, 786, 789, 797, 260, 261, 263, 264, 
	265, 266, 267, 268, 269, 270, 271, 272, 
	273, 274, 276, 278, 279, 311, 349, 364, 
	371, 373, 375, 394, 397, 413, 470, 790, 
	239, 795, 473, 800, 801, 802, 480, 804, 
	805, 813, 489, 806, 809, 807, 808, 492, 
	810, 811, 812, 496, 814, 815, 502, 817, 
	818, 819, 505, 509, 822, 825, 829, 823, 
	824, 519, 826, 827, 828, 523, 527, 831, 
	832, 837, 833, 836, 834, 835, 528, 537, 
	838, 840, 839, 544, 552, 842, 843, 844, 
	559, 845, 846, 848, 851, 568, 847, 580, 
	849, 850, 590, 601, 853, 860, 866, 854, 
	856, 855, 857, 858, 859, 611, 861, 862, 
	863, 864, 865, 619, 625, 867, 868, 630, 
	870, 631, 873, 875, 876, 879, 881, 874, 
	635, 639, 877, 878, 641, 880, 644, 882, 
	885, 887, 883, 884, 650, 886, 651, 652, 
	889, 899, 906, 890, 892, 891, 654, 893, 
	894, 895, 896, 897, 656, 898, 664, 900, 
	901, 902, 903, 904, 905, 673, 907, 908, 
	909, 677, 911, 912, 913, 914, 679, 916, 
	917, 683, 918, 919, 920, 921, 686, 923, 
	926, 929, 931, 924, 925, 689, 927, 928, 
	693, 930, 696, 932, 933, 934, 935, 701, 
	937, 944, 945, 938, 939, 940, 941, 942, 
	943, 705, 713, 946, 947, 948, 720, 950, 
	952, 957, 951, 724, 953, 956, 954, 955, 
	725, 728, 958, 959, 733, 734, 961, 962, 
	963, 964, 737, 738, 966, 741, 970, 972, 
	976, 979, 980, 994, 1001, 1002, 1003, 1004, 
	1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 
	1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 
	1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 
	1029, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 
	1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 
	1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 
	1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 
	1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 
	1070, 1071, 1073, 1075, 1076, 1077, 1078, 1079, 
	1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 
	1074, 1089, 1090, 1091, 1092, 1093, 1094, 1098, 
	1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 
	1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 
	1116, 1117, 1118, 1119, 1121, 1122, 1124, 1125, 
	1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 
	1134, 1135, 1136, 1137, 1138, 1139, 1141, 1160, 
	1169, 1171, 1172, 1176, 1178, 1190, 1194, 1196, 
	1198, 1142, 1143, 1144, 1145, 1146, 1147, 1148, 
	1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 
	1157, 1158, 1159, 1161, 1162, 1163, 1164, 1165, 
	1166, 1167, 1168, 1170, 1173, 1174, 1175, 1177, 
	1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 
	1187, 1188, 1189, 1191, 1192, 1193, 1195, 1197, 
	1200
};

static const char _czech_tokenizer_trans_actions[] = {
	1, 2, 0, 0, 0, 3, 0, 0, 
	4, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 0, 
	2, 0, 2, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 2, 2, 2, 
	2, 0, 0, 0, 5, 0, 5, 0, 
	5, 5, 5, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 2, 2, 0, 0, 0, 2, 2, 
	2, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 2, 
	0, 2, 2, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 2, 2, 2, 0, 0, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 8, 2, 2, 2, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 9, 2, 2, 0, 0, 0, 0, 
	2, 0, 2, 10, 11, 0, 12, 0, 
	2, 0, 0, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 0, 
	0, 2, 2, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	0, 2, 0, 2, 2, 2, 0, 2, 
	2, 2, 0, 2, 2, 2, 2, 0, 
	2, 2, 2, 0, 2, 2, 0, 2, 
	2, 2, 0, 0, 2, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 2, 2, 2, 2, 2, 0, 0, 
	2, 2, 2, 0, 0, 2, 2, 2, 
	0, 2, 2, 2, 2, 0, 2, 0, 
	2, 2, 0, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 0, 2, 2, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	0, 0, 2, 2, 0, 2, 0, 2, 
	2, 2, 2, 2, 0, 2, 0, 0, 
	2, 2, 2, 2, 2, 2, 0, 2, 
	2, 2, 2, 2, 0, 2, 0, 2, 
	2, 2, 2, 2, 2, 0, 2, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 2, 2, 2, 2, 0, 2, 2, 
	0, 2, 0, 2, 2, 2, 2, 0, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 0, 0, 2, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 2, 2, 
	0, 0, 2, 2, 0, 0, 2, 2, 
	2, 2, 0, 0, 2, 0, 2, 2, 
	2, 2, 2, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2
};

static const char _czech_tokenizer_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	6, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0
};

static const char _czech_tokenizer_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	7, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0
};

static const short _czech_tokenizer_eof_trans[] = {
	0, 1, 1, 1, 1, 1, 1, 1, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	0, 746, 746, 746, 746, 746, 756, 746, 
	756, 746, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 746, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759
};

static const int czech_tokenizer_start = 744;
static const int czech_tokenizer_first_final = 744;
static const int czech_tokenizer_error = 0;

static const int czech_tokenizer_en_main = 744;




// The list of lower cased words that when preceding eos do not end sentence.
static unordered_set<string> eos_word_exceptions = {
  // Titles
  "prof", "csc", "drsc", "doc", "phd", "ph", "d",
  "judr", "mddr", "mudr", "mvdr", "paeddr", "paedr", "phdr", "rndr", "rsdr", "dr",
  "ing", "arch", "mgr", "bc", "mag", "mba", "bca", "mga",
  "gen", "plk", "pplk", "npor", "por", "ppor", "kpt", "mjr", "sgt", "pls", "p", "s",
  "p", "pí", "fa", "fy", "mr", "mrs", "ms", "miss", "tr", "sv",
  // Geographic names
  "angl", "fr", "čes", "ces", "čs", "cs", "slov", "něm", "nem", "it", "pol", "maď", "mad", "rus",
  "sev", "vých", "vych", "již", "jiz", "záp", "zap",
  // Common abbrevs
  "adr", "č", "c", "eg", "ev", "g", "hod", "j", "kr", "m", "max", "min", "mj", "např", "napr",
  "okr", "popř", "popr", "pozn", "r", "ř", "red", "rep", "resp", "srov", "st", "stř", "str",
  "sv", "tel", "tj", "tzv", "ú", "u", "uh", "ul", "um", "zl", "zn",
};

bool czech_tokenizer::next_sentence(vector<string_piece>& forms) {
  int cs, act;
  const char* ts, *te;
  const char* text_start = text;

  char32_t unary_chr;
  const char* unary_text;
  const char* whitespace = nullptr; // Suppress "may be uninitialized" warning
  
	{
	cs = czech_tokenizer_start;
	ts = 0;
	te = 0;
	act = 0;
	}

	{
	int _klen;
	const short *_keys;
	int _trans;
	short _widec;

	if ( ( text) == ( text_end) )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	switch ( _czech_tokenizer_from_state_actions[cs] ) {
	case 7:
	{ts = ( text);}
	break;
	}

	_widec = ( (unsigned char)*text);
	_klen = _czech_tokenizer_cond_lengths[cs];
	_keys = _czech_tokenizer_cond_keys + (_czech_tokenizer_cond_offsets[cs]*2);
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				switch ( _czech_tokenizer_cond_spaces[_czech_tokenizer_cond_offsets[cs] + ((_mid - _keys)>>1)] ) {
	case 0: {
		_widec = (short)(256u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unary_chr = utf8::first(unary_text, text - unary_text), !utf8::is_L(unary_chr) && !utf8::is_M(unary_chr) && !utf8::is_N(unary_chr) && !utf8::is_Pd(unary_chr))  ) _widec += 256;
		break;
	}
	case 1: {
		_widec = (short)(768u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unary_chr = utf8::first(unary_text, text - unary_text), !utf8::is_L(unary_chr) && !utf8::is_M(unary_chr) && !utf8::is_N(unary_chr) && unary_chr != '+')  ) _widec += 256;
		break;
	}
				}
				break;
			}
		}
	}

	_keys = _czech_tokenizer_trans_keys + _czech_tokenizer_key_offsets[cs];
	_trans = _czech_tokenizer_index_offsets[cs];

	_klen = _czech_tokenizer_single_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( _widec < *_mid )
				_upper = _mid - 1;
			else if ( _widec > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _czech_tokenizer_range_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _czech_tokenizer_indicies[_trans];
_eof_trans:
	cs = _czech_tokenizer_trans_targs[_trans];

	if ( _czech_tokenizer_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _czech_tokenizer_trans_actions[_trans] ) {
	case 5:
	{ whitespace = text; }
	break;
	case 2:
	{te = ( text)+1;}
	break;
	case 8:
	{te = ( text)+1;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 4:
	{te = ( text)+1;{
          // Does this eos character marks end of sentence?
          bool eos_word_exception = false;
          if (!forms.empty()) {
            // Is it single Lut?
            string_piece form = forms.back();
            eos_word_exception = utf8::is_Lut(utf8::decode(form.str, form.len)) && !form.len;

            // Is the lower case variant in eos_word_exceptions?
            buffer.clear(); utf8::lowercase(forms.back().str, forms.back().len, buffer);
            eos_word_exception |= eos_word_exceptions.count(buffer);
          }

          // Add all characters until first space to forms and break if eos.
          for (text = ts; text < whitespace; forms.emplace_back(ts, text - ts), ts = text) utf8_advance(text, whitespace);
          {( text) = (( whitespace))-1;}
          if (!eos_word_exception) {( text)++; goto _out; }
        }}
	break;
	case 11:
	{te = ( text)+1;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 12:
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 9:
	{te = ( text);( text)--;}
	break;
	case 10:
	{te = ( text);( text)--;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 3:
	{{( text) = ((te))-1;}{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 1:
	{{( text) = ((te))-1;}}
	break;
	}

_again:
	switch ( _czech_tokenizer_to_state_actions[cs] ) {
	case 6:
	{ts = 0;}
	break;
	}

	if ( cs == 0 )
		goto _out;
	if ( ++( text) != ( text_end) )
		goto _resume;
	_test_eof: {}
	if ( ( text) == ( text_end) )
	{
	if ( _czech_tokenizer_eof_trans[cs] > 0 ) {
		_trans = _czech_tokenizer_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	_out: {}
	}


  (void)act; // Suppress unused variable warning

  return !forms.empty();
}

} // namespace morphodita
} // namespace ufal


