package Bundle::Math::Symbolic;
use strict;
use warnings;

$VERSION = '1.00';

1;

__END__

=head1 NAME

Bundle::Math::Random - Bundle of modules related to symbolic math

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math::Symbolic'

=head1 CONTENTS

Math::Algebra::Symbols

Math::Symbolic

Math::Symbolic::Custom::CCompiler

Math::Symbolic::Custom::ErrorPropagation

Math::SymbolicX::BigNum

Math::SymbolicX::Complex

Math::SymbolicX::NoSimplification

Math::SymbolicX::ParserExtensionFactory

=head1 DESCRIPTION

This is a bundle of modules related to symbolic math.

Please have a look at L<Bundle::Math>.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
