/* utf32.c
 *  Copyright: (When this is determined...it will go here)
 *  CVS Info
 *     $Id: utf32.c,v 1.1 2001/10/31 22:51:31 tom Exp $
 *  Overview:
 *     This defines the UTF-32 encoding routines.
 *  Data Structure and Algorithms:
 *  History:
 *  Notes:
 *  References:
 */

#include "parrot/parrot.h"
#include "parrot/unicode.h"

#if 0
typedef unsigned long utf32_t;
#endif

static INTVAL
utf32_characters (const void *ptr, INTVAL bytes) {
    return bytes / 4;
}

static INTVAL
utf32_decode (const void *ptr) {
    const utf32_t *u32ptr = ptr;

    return *u32ptr;
}

static void *
utf32_encode (void *ptr, INTVAL c) {
    utf32_t *u32ptr = ptr;

    if (c < 0 || c > 0x10FFFF || UNICODE_IS_SURROGATE(c)) {
        INTERNAL_EXCEPTION(INVALID_CHARACTER,
                           "Invalid character for UTF-32 encoding\n");
    }

    *u32ptr = c;

    return u32ptr + 1;
}

static void *
utf32_skip_forward (void *ptr, INTVAL n) {
    utf32_t *u32ptr = ptr;

    return u32ptr + n;
}

static void *
utf32_skip_backward (void *ptr, INTVAL n) {
    utf32_t *u32ptr = ptr;

    return u32ptr - n;
}

const ENCODING utf32_encoding = {
    "utf32",
    4,
    utf32_characters,
    utf32_decode,
    utf32_encode,
    utf32_skip_forward,
    utf32_skip_backward
};

/*
 * Local variables:
 * c-indentation-style: bsd
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 *
 * vim: expandtab shiftwidth=4:
*/
