#!/usr/bin/perl
require v5.14.0;

use strict;
use warnings;
use Config;

use ExtUtils::MakeMaker 6.64;

# raising the version of makemaker to 6.64 to use TEST_REQUIRES
use constant MIN_MAKEMAKER_VERSION => 6.64;

use constant RUNNING_ON_WINDOWS => ($^O =~ /^(mswin|dos|os2)/oi);
use constant HAS_DBI => eval { require DBI; };

## DEBUG this is a test version which requires taint in perl
die "Taint stuuport in perl is required for this module" unless (!exists($Config{taint_support}) || $Config{taint_support});

# DEBUG cut down tests in this debugging run, only run on linux/unix
die "OS unsupported" if ($^O =~ /^(mswin|dos|os2)/oi);

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
my %makefile = (
    'NAME'         => 'Acme::TaintTest',
    'VERSION_FROM' => 'lib/Acme/TaintTest.pm', # finds $VERSION

    'PL_FILES' => { },

    'PMLIBDIRS' => [ 'lib' ],

    # be quite explicit about this; afaik CPAN.pm is sensible using this
    'PREREQ_PM' => {
        'File::Spec'           => 0.8,           # older versions lack some routines we need
        'File::Copy'           => 2.02,          # this version is shipped with 5.005_03, the oldest version known to work
        'File::Temp'           => 0,             # core module, dependency not needed, here for testing purposes, see bug 8089
        'Pod::Usage'           => 1.10,          # all versions prior to this do seem to be buggy
        'HTML::Parser'         => 3.43,          # the HTML code is based on this parser, older versions have utf-8 bugs
        'Archive::Tar'         => 1.23,          # for sa-update
        'IO::Zlib'             => 1.04,          # for sa-update
        'Mail::DKIM'           => 0.31,
        'Net::DNS'             => 1.10,
        'NetAddr::IP'          => 4.010,
        'Sys::Hostname'        => 0,
        'Time::HiRes'          => 0,
        'Time::Local'          => 0,
        'Errno'                => 0,
    },

    # In case MIN_MAKEMAKER_VERSION is greater than the version bundled in the core of MIN_PERL_VERSION
    # use this to ensure CPAN will automatically upgrade MakeMaker if needed
    'BUILD_REQUIRES' => {
        'ExtUtils::MakeMaker' => MIN_MAKEMAKER_VERSION,
    },

    'CONFIGURE_REQUIRES' => {
        'ExtUtils::MakeMaker' => MIN_MAKEMAKER_VERSION,
    },

    # The modules that are not core or that require a minimum version that are used in default tests
    'TEST_REQUIRES' => {
        'Test::Simple' => 1.302067,
        'Perl::Critic::Policy::TestingAndDebugging::ProhibitNoStrict' => 0,
        'Perl::Critic::Policy::Perlsecret' => 0,
        'Test::UseAllModules' => 0,
        'Net::Ifconfig::Wrapper' => 0,
        'Net::Address::Ethernet' => 0,
    },

    'LICENSE' => 'apache_2_0',

    'dist' => {
        COMPRESS => 'gzip -9f',
        SUFFIX => '.gz',
        TARFLAGS => 'cf',
        DIST_DEFAULT => 'tardist',

        CI => 'svn commit',
        RCS_LABEL => 'true',
    },

    'clean' => { FILES => join(' ' =>

        'doc', 'pod2htm*', '*.cache',

	'version.env',

        't/log',

      )

    },

    'AUTHOR'   => 'The Apache SpamAssassin Project <dev at spamassassin.apache.org>',
    'ABSTRACT' => 'Apache SpamAssassin is an extensible email filter which is used to identify spam',

    # We have only this Makefile.PL and this option keeps MakeMaker from
    # asking all questions twice after a 'make dist*'.
    'NORECURS' => 1,
    'MIN_PERL_VERSION'=> 5.014000,
);


#######################################################################

# See Bug 6131 & 6598 for changes to META_MERGE and increased requirement 
# for MakeMaker version
#
$makefile{META_MERGE} = {

  'meta-spec' => {
    version => '2',
    url     => 'https://metacpan.org/pod/CPAN::Meta::Spec',
  },

  prereqs => {
    runtime => {
      recommends => {
        'MIME::Base64' =>              0,
        'DB_File' =>                   0,
        'Net::SMTP' =>                 0,
        'Net::LibIDN2' =>              0,
        'Net::LibIDN' =>               0,
        'Mail::SPF' =>                 0,
        'MaxMind::DB::Reader' =>       0,
        'MaxMind::DB::Reader::XS' =>   0,
        'Geo::IP' =>                   0,
        'IP::Country::DB_File' =>      0,
        'IP::Country::Fast' =>         0,
        'Razor2::Client::Agent' =>     2.61,
        'IO::Socket::IP' =>            0.09,
        'IO::Socket::INET6' =>         0,
        'IO::Socket::SSL' =>           1.76,
        'Compress::Zlib' =>            0,
        'Mail::DKIM' =>                0.37,
        'DBI' =>                       0,
        'DBD::SQLite' =>               1.59_01,
        'LWP::Protocol::https' =>      0,
        'Encode::Detect::Detector' =>  0,
        'Net::Patricia' =>             1.16,
        'Net::CIDR::Lite' =>           0,
        'BSD::Resource' =>             0,
        'Archive::Zip' =>              0,
        'IO::String' =>                0,
        'Email::Address::XS' =>        0,
        'Mail::DMARC' =>               0,
      },
    },
    test => {
      recommends => {
        'Net::DNS::Nameserver' =>      0,
        'Devel::Cycle' =>              0,
        'Text::Diff' =>                0,
      },
    },
  },
};

#######################################################################

# Now finish the meta hash and dump the Makefile
$makefile{AUTHOR} =~ s/(<.+) at (.+>)/$1\@$2/;
WriteMakefile(%makefile);
print "Makefile written by ExtUtils::MakeMaker $ExtUtils::MakeMaker::VERSION\n";

#######################################################################
