
use strict;
use warnings;

use 5.010001;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Create a nice formatted table using extended ASCII and ANSI colors",
  "AUTHOR" => "Steven Haryanto <stevenharyanto\@gmail.com>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Text-ANSITable",
  "EXE_FILES" => [
    "bin/ansitable-list-color-themes",
    "bin/ansitable-list-border-styles"
  ],
  "LICENSE" => "perl",
  "NAME" => "Text::ANSITable",
  "PREREQ_PM" => {
    "Color::ANSI::Util" => "0.03",
    "Data::Clone" => 0,
    "Data::Unixish::Apply" => "1.33",
    "Data::Unixish::ansi" => "0.02",
    "DateTime" => 0,
    "JSON" => 0,
    "Log::Any" => 0,
    "Module::List" => 0,
    "Moo" => 0,
    "Parse::VarName" => 0,
    "SHARYANTO::Color::Util" => 0,
    "Term::Detect" => "0.02",
    "Text::ANSI::Util" => "0.08",
    "experimental" => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny" => 0,
    "Test::Exception" => 0,
    "Test::More" => "0.98",
    "Test::Script" => "1.05",
    "blib" => 0
  },
  "VERSION" => "0.20",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



