package Data::Sah::Compiler::human::TH;

use Moo;
extends 'Data::Sah::Compiler::TH';

our $VERSION = '0.09'; # VERSION

# not translated

sub clause_name {}
sub clause_summary {}
sub clause_description {}
sub clause_comment {}
sub clause_tags {}

sub clause_prefilters {}
sub clause_postfilters {}

# ignored

sub clause_ok {}

# handled in handle_type()

sub clause_req {}
sub clause_forbidden {}

# handled in after_all_clauses

sub clause_default {}

# default implementation

sub handle_type {
    my ($self, $cd) = @_;
    my $c = $self->compiler;

    # give the class name
    my $pkg = ref($self);
    $pkg =~ s/^Data::Sah::Compiler::human::TH:://;

    $c->add_ccl($cd, {noun => $pkg});
}

1;
# ABSTRACT: Base class for human type handlers


__END__
=pod

=head1 NAME

Data::Sah::Compiler::human::TH - Base class for human type handlers

=head1 VERSION

version 0.09

=for Pod::Coverage ^(compiler|clause_.+|handle_.+)$

=head1 AUTHOR

Steven Haryanto <stevenharyanto@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Steven Haryanto.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

