package CIF::Client::Plugin::Bindzone;

sub type { return 'output'; }

my $default_output = '/etc/namedb/';

sub write_out {
    my $self = shift;
    my $config = shift;
    my $feed = shift;
    my @array = @{$feed->{'feed'}->{'entry'}};
    $config = $config->{'config'};

    my $query = $feed->{'query'};
    $query =~ s/\//_/g;

    if($config->{'bindzone_path'}){
        $default_output = $config->{'bindzone_path'};
    }

    $query = 'cif_'.$query.'.zone'; 
    $default_output .= '/'.$query;
    $default_output =~ s/\/\//\//g;

    my $text = '// generated by: '.$0." at ".time()."\n";
    foreach (@array){
        $text .= 'zone "'.$_->{'address'}.'" {type master; file "'.$default_output.'";};'."\n";
    }
    return $text;
}
1;
