package CIF::Client::Plugin::Iodef::Malware;

sub hash_simple {
    my $class = shift;
    my $hash = shift;

    my ($sha1,$md5);
    my $impact = $hash->{'Assessment'}->{'Impact'};
    if(ref($impact) eq 'HASH'){
        $impact = $impact->{'content'};
    }
    my $ad = $hash->{'EventData'}->{'AdditionalData'};
    return unless($ad);
    my @array;
    if(ref($ad) eq 'ARRAY'){
        @array = @$ad;
    } else {
        push(@array,$ad);
    }
    foreach my $a (@array){
        for(lc($a->{'meaning'})){
            $md5    = $a->{'content'} if(/md5/);
            $sha1   = $a->{'content'} if(/sha1/);
        }
    }
    if($impact eq 'malware'){
        return({
            md5 => $md5,
            sha1    => $sha1
        });
    } else {
        return({
            malware_sha1    => $sha1,
            malware_md5     => $md5,
        });
    }
}
1;

