#!/usr/bin/perl

use Carp;
use PDF;
use File::Basename;
use strict;

use Tk;
require Tk::FileSelect;
require Tk::Dialog;

# initialize global variables
my ($startdir, $top, $menubar, $bottom, $listbox, $box, $file_select,
    $filename, $dirname, $fullname, $fulldir);
my ($PDFversion, $PDFpages, $PDFtitle, $PDFauthor, $PDFsubject, $PDFcreationdate,
    $PDFcreator, $PDFproducer, $PDFmoddate, $PDFkeywords);
my $program="WinPDFdata";
my $company="SANFACE Software";
my $email="sanface\@sanface.com";
my $www="http://www.sanface.com";
my $version="1.1";

# file selector stuff
# $startdir = dirname($ENV{'sourceExe'});
$startdir = '.'; 

$top = MainWindow->new(title => "$program");

# make button bar
$menubar = $top->Frame();
$menubar->Button(text => 'Quit', command => \&Quit)->pack(side => 'left');
$menubar->Button(text => 'Select File', command => \&Select)->pack(side => 'left');
$menubar->Button(text => 'Save As HTML', command => \&saveAs)->pack(side => 'left');
$menubar->Button(text => 'Unselect All', command => \&UnselectAll)->pack(side => 'left');
$menubar->Button(text => 'About', command => \&About)->pack(side => 'left');
$menubar->Button(text => 'Help', command => \&Help)->pack(side => 'left');
$menubar->pack();


# make the list for the PDF attributes
$bottom = $top->Frame();
$bottom->pack(-fill => 'both');
$listbox = $bottom->Scrolled('Listbox', -scrollbars => 'osoe', -height => 20, -width => 53);
$listbox->pack(-fill => 'both');
$listbox->bind('<Double-1>' => \&Unselect);

# file selector
$file_select = $top->FileSelect(-defaultextension => 'pdf', -directory => "$startdir");

MainLoop();
# end of main program

# ask for a data file and read it in
sub Select {
  $fullname = $file_select->Show;
  if(!defined($fullname) || $fullname eq "") {return}
  else {
    my $PDFfile= PDF->new($fullname);
    my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat($fullname);
    $filename=basename($fullname);
    $dirname=dirname($fullname);
    if ($PDFfile->IsaPDF) {
      $PDFversion      = $PDFfile->Version;
      $PDFpages        = $PDFfile->Pages;
      $PDFtitle        = $PDFfile->GetInfo("Title");
      $PDFsubject      = $PDFfile->GetInfo("Subject");
      $PDFauthor       = $PDFfile->GetInfo("Author");
      $PDFcreationdate = $PDFfile->GetInfo("CreationDate");
      $PDFcreator      = $PDFfile->GetInfo("Creator");
      $PDFproducer     = $PDFfile->GetInfo("Producer");
      $PDFcreationdate = $PDFfile->GetInfo("CreationDate");
      $PDFkeywords     = $PDFfile->GetInfo("Keywords");
      $listbox->insert('end',"$filename ++ $size ++ $PDFpages ++ $PDFversion ++ $PDFcreationdate ++ $PDFauthor ++ $PDFtitle ++ $PDFsubject ++ $PDFcreator ++ $PDFproducer ++ $PDFmoddate ++ $PDFkeywords");
      }
    }
  }

# purge listbox
sub UnselectAll {
  $listbox->delete(0, 'end');
  } 

# unselect listbox entry
sub Unselect {
  my $info_dialog_cur_index;
  $info_dialog_cur_index = $listbox->curselection;
  if(!defined($info_dialog_cur_index)) {return}                    
  $listbox->delete($info_dialog_cur_index, $info_dialog_cur_index);
  }

sub saveAs {
  my ($elem,$line);
  my @elem;
  my $file_select=$top->FileSelect(-defaultextension => 'htm', -directory => "$startdir");
  my $selectedfilename = $file_select->Show;
  if(!defined($selectedfilename) || $selectedfilename eq "") {return}
  if(open(OUTPUT, ">$selectedfilename")) {
    print OUTPUT <<EOF;
<!doctype HTML public "-//W3C//DTD HTML 3.2//EN">
<!--  Made by $program $version developed by $company ($email) -->

<HTML>
<HEAD>
<LINK REL="Author" HREF="mailto:$email">
<META NAME="Author" CONTENT="$company">
<META NAME="Description" CONTENT="Index file made by $program $version">
<TITLE>INDEX</TITLE>
</HEAD>
<BODY bgcolor="#FFFFFF">
<H1>Index</H1>
<TABLE>
<TR>
<TD>File name</TD>
<TD>Size</TD>
<TD>Number of pages</TD>
<TD>PDF version</TD>
<TD>Creation Date</TD>
<TD>Author</TD>
<TD>Title</TD>
<TD>Subject</TD>
<TD>Creator</TD>
<TD>Producer</TD>
<TD>Modification Date</TD>
<TD>Keywords</TD>
</TR>
EOF
  foreach $line ($listbox->get(0,'end')) {
    print OUTPUT "<TR>\n";
    @elem=split / \+\+ /,$line;
    foreach $elem (@elem) {print OUTPUT "<TD>$elem</TD>\n"}
    print OUTPUT "</TR>\n";
    $listbox->delete(0,0);
    }
  print OUTPUT <<EOF;
</TABLE>
Generated by <A HREF="$www">$program $version</A><BR>
WinPDFdata is a <A HREF="$www">$company</A> production<BR>\n
Do you need a personalization of the output of this file or a $program customization?<BR>\n
<A HREF="mailto:$email">Don't hesitate to contact us!</n>
</BODY>
</HTML>
EOF
  close(OUTPUT);
  } else {errorDialog("Can't open $selectedfilename!")}
}

sub About {
  $box = $top->Dialog(-title => "About $program",
         -text  => '',
         -default_button => 'OK', -buttons => [qw/OK/]);
  $box -> configure(-wraplength => '4i',
          -text => "$program v. $version is a $company product $www");
  $box -> Show();
  }

sub Help {
  $box = $top->Dialog(-title => 'Help',
                      -text  => '',
                      -default_button => 'OK', -buttons => [qw/OK/]);
  $box -> configure(-wraplength => '4i',
          -text => "$program is a free Windows application that permits you to extract information from PDF files and permits you to generate an HTML. $program supports also the new PDF version 1.3.
$program is composed of 6 buttons and a listbox:
Quit: to close the application
Select File: through a 'file select' window you can select only PDF files (the control is made on the file extension .pdf and on the presence of %PDF in the file). After the selection you see in the list box these fields separated by ' ++ ':
File Name, Size in bytes, Number of pages, PDF version, Creation Date, Author, Title, Subject, Creator, Producer, Modification Date, Keywords.
Save As HTML: through a 'file select' window you can select only a HTML file or introduce (File field) a new HTML file. WinPDFdata'll write all the information about your selected PDF files and will remove them from the listobox.
Uselect All: to clean the listbox.
About
Help
You can remove only one entry form listbox with a double click with the left");
  $box -> Show();
  }

# quit the program
sub Quit {
  exit;
  }

