#!/usr/bin/env perl
use Mojolicious::Lite;
use Mojo::JSON qw/encode_json/;

use FindBin;
BEGIN { unshift @INC, "$FindBin::Bin/lib" }

# Documentation browser under "/perldoc"
plugin 'PODRenderer';

get '/' => sub {
  my $c = shift;
  $c->render(template => 'index');
};

app->start;
__DATA__

@@ index.html.ep
% layout 'default';
% title 'Welcome';
Welcome to the Mojolicious real-time web framework!

@@ layouts/default.html.ep
<!DOCTYPE html>
<html>
  <head><title><%= title %></title></head>
  <body><%= content %></body>
</html>
