use Unicode::Collate::CJK::Korean;
+{
   locale_version => 1.28,
   overrideCJK => \&Unicode::Collate::CJK::Korean::weightKorean,
   entry => <<'ENTRY', # for DUCET v12.1.0
F967      ; [.4018.0021.0002.4E0D][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.4018.0032.0002.4E26][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.4011.0021.0002.4E32][.4097.0020.0002][.4102.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.4023.0021.0002.4E38][.4098.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.4014.0021.0002.4E39][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.4016.0021.0002.4E82][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.4016.0021.0002.4E86][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.4016.0021.0002.4EAE][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.401A.0021.0002.4EC0][.40A3.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.4016.0021.0002.4EE4][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.4016.0021.0002.4F86][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.4016.0021.0002.4F8B][.4096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.4017.0021.0002.4FAE][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.4017.0021.0002.4FAE][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.4021.0023.0002.4FBB][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.4022.0021.0002.4FBF][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.4018.0022.0002.5002][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.4016.0022.0002.502B][.40A0.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.4018.0022.0002.5099][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.401A.0023.0002.50CF][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.4016.0022.0002.50DA][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.401A.0023.0002.50E7][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.401A.0023.0002.50E7][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.401C.0021.0002.5140][.4097.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.401F.0021.0002.5145][.409C.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.4017.0021.0002.514D][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.4017.0021.0002.514D][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F814     ; [.4013.0022.0002.5167][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.401D.0024.0002.5168][.4093.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.4016.0023.0002.5169][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.4016.0021.0002.516D][.40A0.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.4011.0026.0002.5177][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.4011.0024.0002.5180][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.401D.0021.0002.518D][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.4017.0022.0002.5192][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.4017.0022.0002.5195][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.401C.0023.0002.5197][.409B.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.401C.003B.0002.51A4][.409D.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.4014.0022.0002.51AC][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.4016.0021.0002.51B7][.4090.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.4016.0024.0002.51C9][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.4016.0021.0002.51CC][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.4016.0021.0002.51DC][.40A1.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.4023.0022.0002.51DE][.40A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81E     ; [.401C.0023.0002.5203][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.401D.0021.0002.5207][.4093.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.401D.0021.0002.5207][.4093.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.4016.0022.0002.5217][.4095.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.4016.0022.0002.5229][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.401D.0022.0002.523A][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.4011.0021.0002.523B][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.4023.0021.0002.5272][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.401A.002D.0002.5277][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.4016.0021.0002.5289][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.4016.0021.0002.529B][.4095.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.4016.0023.0002.52A3][.4095.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.401C.0024.0002.52C7][.409B.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.401C.0024.0002.52C7][.409B.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.4017.0023.0002.52C9][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.4017.0023.0002.52C9][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.4016.0021.0002.52D2][.40A1.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.4016.0021.0002.52DE][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.4011.0023.0002.52E4][.40A1.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.4011.0023.0002.52E4][.40A1.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.4016.0023.0002.52F5][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.401D.0022.0002.52FA][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.401D.0022.0002.52FA][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.4022.0022.0002.5305][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
F963      ; [.4018.0021.0002.5317][.409C.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.4018.0021.0002.5317][.409C.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.4013.0021.0002.533F][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.4023.0021.0002.5349][.409E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.4018.0025.0002.5351][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.4018.0025.0002.5351][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.4018.0022.0002.535A][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.401D.0022.0002.5373][.40A1.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.4016.0022.0002.5375][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.401D.0021.0002.537D][.40A1.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.4011.0028.0002.537F][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.4011.0028.0002.537F][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.4011.0028.0002.537F][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.401F.0022.0002.53C3][.408F.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.4011.0022.0002.53CA][.40A1.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.401A.005E.0002.53DF][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.4011.002A.0002.53E5][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.4011.0021.0002.53EB][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.401D.0022.0002.53F1][.40A3.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.4016.0024.0002.540F][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.4016.0021.0002.541D][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.4023.0021.0002.5438][.40A1.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.4016.0024.0002.5442][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.401D.0026.0002.5448][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.401D.0028.0002.5468][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.401C.0031.0002.54A2][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.401C.0025.0002.54BD][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.4014.0021.0002.5510][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.4011.0022.0002.5553][.4096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.4023.0024.0002.5563][.408F.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.401A.0024.0002.5584][.4093.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.401A.0024.0002.5584][.4093.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.4016.0021.0002.5587][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.4023.0022.0002.5599][.409E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.4023.0022.0002.5599][.409E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.4011.0022.0002.559D][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.4011.0022.0002.559D][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.4012.0021.0002.55AB][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA7B      ; [.401C.0022.0002.55E2][.4097.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.4021.0022.0002.5606][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.4021.0022.0002.5606][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.4011.0026.0002.5668][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.4018.0023.0002.5674][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.4016.0023.0002.56F9][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.4014.0024.0002.5716][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.4023.0024.0002.578B][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.401A.0021.0002.57CE][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.401A.0021.0002.57F4][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.4018.0023.0002.5831][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.4018.0033.0002.5840][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.401F.0022.0002.585A][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.401F.0022.0002.585A][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.401A.0021.0002.585E][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.4017.0021.0002.58A8][.409C.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.4018.0024.0002.58B3][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.4016.0021.0002.58D8][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.4016.0021.0002.58DF][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.4018.0032.0002.5906][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.4014.0021.0002.591A][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.4017.0021.0002.5922][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.401C.0024.0002.5944][.4093.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.4013.0023.0002.5948][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.4011.0024.0002.5951][.4096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.4018.0025.0002.5954][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.401A.0030.0002.5962][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.4013.0021.0002.5973][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F862     ; [.4023.0026.0002.59EC][.40A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.401C.002C.0002.5A1B][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.4021.0030.0002.5A27][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.4018.0027.0002.5A62][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.4018.002B.0002.5A66][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.401C.0025.0002.5AB5][.40A3.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.401C.0041.0002.5B08][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.401D.003C.0002.5B28][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.4016.0029.0002.5B3E][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.4016.0029.0002.5B3E][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.4014.0021.0002.5B85][.4090.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.401C.0029.0002.5BC3][.409D.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.401F.003B.0002.5BD8][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.4013.0021.0002.5BE7][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.4013.0021.0002.5BE7][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.4013.0021.0002.5BE7][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.4016.0023.0002.5BEE][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
F9BD      ; [.4013.0021.0002.5C3F][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.4014.0028.0002.5C60][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.4016.0023.0002.5C62][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.401F.0021.0002.5C64][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.4016.0026.0002.5C65][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
2F879     ; [.401A.002A.0002.5CC0][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.4016.0023.0002.5D19][.40A0.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.4016.0021.0002.5D50][.408F.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.4016.0025.0002.5DBA][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.401A.0021.0002.5DE1][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.401A.0027.0002.5DE2][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.401A.0022.0002.5DFD][.4097.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.401A.0029.0002.5E28][.4094.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.4017.0025.0002.5E3D][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.4013.0021.0002.5E74][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.4014.002B.0002.5EA6][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.4018.0052.0002.5EB3][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.401A.0025.0002.5EB6][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.4016.0021.0002.5EC9][.4095.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.4016.0021.0002.5ECA][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.4016.0021.0002.5ECA][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.4011.0021.0002.5ED3][.4098.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.4016.0025.0002.5EEC][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
F943      ; [.4016.0022.0002.5F04][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.4014.004B.0002.5F22][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.4014.004B.0002.5F22][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.4023.0025.0002.5F62][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.401F.0025.0002.5F69][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.401D.0027.0002.5F6B][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.4016.0021.0002.5F8B][.40A0.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.4018.0026.0002.5FA9][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.401C.0043.0002.5FAD][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.401C.002A.0002.5FCD][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.401D.0026.0002.5FD7][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.4013.0021.0002.5FF5][.4095.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.4013.0024.0002.6012][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.4016.0026.0002.601C][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.401C.0042.0002.6081][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.4023.0026.0002.6094][.409A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.4023.0026.0002.6094][.409A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.4014.0022.0002.60C7][.4097.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.4017.002D.0002.60D8][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.401C.0025.0002.60E1][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.401C.002E.0002.6108][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.4016.0022.0002.6144][.40A0.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.401D.002A.0002.6148][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.4023.0027.0002.614C][.4098.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.4023.0027.0002.614C][.4098.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA8A      ; [.401C.0047.0002.6160][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.4011.0028.0002.6168][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.4016.0031.0002.617A][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.401D.0022.0002.618E][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.401D.0022.0002.618E][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.401D.0022.0002.618E][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.4016.0021.0002.6190][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.4018.0028.0002.61A4][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.401F.0030.0002.61AF][.408F.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.4023.0021.0002.61B2][.4093.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.4017.0025.0002.61DE][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.401D.0022.0002.61F2][.40A3.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.401D.0022.0002.61F2][.40A3.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.401D.0022.0002.61F2][.40A3.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.4016.0022.0002.61F6][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.4016.0022.0002.61F6][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.4016.0022.0002.6200][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.401A.0026.0002.6210][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
F9D2      ; [.4016.0022.0002.622E][.40A0.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.4014.0029.0002.6234][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.4022.002B.0002.62B1][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.4016.0021.0002.62C9][.408F.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.4013.0024.0002.62CF][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.401F.0026.0002.62D3][.4093.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.4018.0022.0002.62D4][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.401A.0022.0002.62FE][.40A1.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.4017.0027.0002.633D][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.401C.0027.0002.6350][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.401A.0039.0002.6368][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.4013.0024.0002.637B][.4095.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.401A.0029.0002.6383][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.4016.0021.0002.63A0][.4091.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.401C.0025.0002.63A9][.4093.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.401C.0030.0002.63C4][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.401A.0030.0002.641C][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.401D.0025.0002.6422][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
2F8C3     ; [.4017.0021.0002.6469][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.4013.0022.0002.649A][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.4023.0029.0002.649D][.409F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.4016.0023.0002.64C4][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.4017.0025.0002.654F][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.4017.0025.0002.654F][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.401C.0030.0002.6556][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.4011.0030.0002.656C][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.401A.0032.0002.6578][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.4016.0025.0002.6599][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.4016.0028.0002.65C5][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
2F8CB     ; [.4011.0035.0002.65E3][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.401C.0024.0002.6613][.4095.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.401D.0026.0002.6649][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.401F.0022.0002.6674][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.401F.0022.0002.6674][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.4023.002A.0002.6688][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.401A.002B.0002.6691][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.401A.002B.0002.6691][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.4022.0022.0002.66B4][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.4016.0022.0002.66C6][.4095.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.4011.0033.0002.66F4][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.401A.002D.0002.66F8][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.401F.0023.0002.6700][.409A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.4016.0022.0002.6717][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.4016.0022.0002.6717][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.4016.0022.0002.6717][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.4017.0025.0002.671B][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.4017.0025.0002.671B][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.4016.0028.0002.674E][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.4022.0025.0002.6753][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.401D.002E.0002.6756][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.4011.0038.0002.675E][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.4013.0021.0002.677B][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
F9F4      ; [.4016.0021.0002.6797][.40A3.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.4016.0023.0002.67F3][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.4016.0023.0002.6817][.40A0.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.4016.0025.0002.6881][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.4017.0027.0002.6885][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.4017.0027.0002.6885][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.4016.0029.0002.68A8][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.401A.0062.0002.6942][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EA     ; [.4011.002A.0002.69EA][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.401C.0028.0002.6A02][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.401C.0028.0002.6A02][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.401C.0028.0002.6A02][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.4016.0024.0002.6A13][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.4016.0024.0002.6AD3][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.401D.0021.0002.6ADB][.40A1.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.4016.0023.0002.6B04][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.401F.0028.0002.6B21][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.4023.0025.0002.6B54][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.401A.0023.0002.6B72][.4094.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.4016.0023.0002.6B77][.4095.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
F9A5      ; [.4016.0023.0002.6BAE][.4095.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.401A.0023.0002.6BBA][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.401A.0023.0002.6BBA][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.401A.0023.0002.6BBA][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.4018.0025.0002.6C4E][.4093.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.401F.0024.0002.6C88][.40A3.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.401C.002B.0002.6CBF][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.4022.0024.0002.6CCC][.40A3.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.4013.0022.0002.6CE5][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.4016.0021.0002.6D1B][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.4014.002A.0002.6D1E][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.4022.0029.0002.6D3E][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.4016.0025.0002.6D41][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.4016.0025.0002.6D41][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.4016.0025.0002.6D41][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.4023.002E.0002.6D69][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.4016.0023.0002.6D6A][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.4023.002A.0002.6D77][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.4023.002A.0002.6D77][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.401F.0025.0002.6D78][.40A3.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.401C.0022.0002.6D85][.4095.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.4016.0022.0002.6DCB][.40A3.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.4016.0025.0002.6DDA][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.4016.0024.0002.6DEA][.40A0.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.401C.0026.0002.6DF9][.4093.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.401D.002C.0002.6E1A][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.4023.002B.0002.6E2F][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.401C.002B.0002.6E6E][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.4016.0026.0002.6E9C][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.4013.0022.0002.6EBA][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.401D.002B.0002.6ECB][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.401D.002B.0002.6ECB][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.4023.0022.0002.6ED1][.4098.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.4016.0026.0002.6F0F][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.4023.0026.0002.6F22][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.4023.0026.0002.6F22][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.4016.0024.0002.6F23][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.401D.0033.0002.6F6E][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.4018.003C.0002.6FC6][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.4016.0025.0002.6FEB][.408F.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.4016.002A.0002.6FFE][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.401C.002D.0002.701B][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.401D.003D.0002.701E][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.401D.003D.0002.701E][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.4023.002D.0002.7070][.409A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.401D.002B.0002.707D][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.401D.002C.0002.7099][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.4021.0028.0002.70AD][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.4016.0025.0002.70C8][.4095.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.4016.0022.0002.70D9][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.4016.0025.0002.7149][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.401D.002D.0002.716E][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.401D.002D.0002.716E][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.4016.0026.0002.71CE][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.4016.0023.0002.71D0][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.4016.0027.0002.7210][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.4016.0026.0002.721B][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.401F.0036.0002.7228][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.401D.0028.0002.7235][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.401D.0028.0002.7235][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.4016.0023.0002.7262][.409A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.401A.0030.0002.7280][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.4018.0027.0002.72AF][.4093.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.401A.0035.0002.72C0][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.4016.0024.0002.72FC][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.401D.002E.0002.732A][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.401D.002E.0002.732A][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.4016.0021.0002.7375][.4095.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.4014.0023.0002.737A][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.401A.0021.0002.7387][.4097.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.401A.0021.0002.7387][.4097.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.401C.0025.0002.738B][.4098.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.4016.0027.0002.73B2][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.4016.0023.0002.73DE][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.4016.002D.0002.7406][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.4016.0028.0002.7409][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.4021.002B.0002.7422][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.401C.003D.0002.745C][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.4023.002D.0002.7469][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.401D.0057.0002.7471][.4093.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.401D.0057.0002.7471][.4093.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
F994      ; [.4016.0026.0002.7489][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.4016.0024.0002.7498][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.4011.003A.0002.74CA][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
F9CD      ; [.4016.002A.0002.7559][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.4016.0022.0002.7565][.4091.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.401C.002C.0002.7570][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.401C.002C.0002.7570][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.4016.002F.0002.75E2][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.401C.0059.0002.7610][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.401C.0023.0002.761F][.4097.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.4016.0027.0002.7642][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.4016.0023.0002.7669][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.401C.0022.0002.76CA][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.401C.0022.0002.76CA][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.401A.002B.0002.76DB][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.4016.0028.0002.76E7][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.401D.0021.0002.76F4][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.401D.0021.0002.76F4][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.401A.002C.0002.7701][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.401D.0033.0002.771E][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
FAAA      ; [.401F.0023.0002.7740][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.401D.0034.0002.778B][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.4016.002C.0002.786B][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.4016.0021.0002.788C][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.4016.0021.0002.788C][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.4018.0038.0002.7891][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.4016.0024.0002.78CA][.409A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
F964      ; [.4018.0032.0002.78FB][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.4016.002B.0002.792A][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.401A.0046.0002.793E][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.4011.004C.0002.7948][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.401D.0035.0002.7949][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.401C.0032.0002.7950][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.401D.0039.0002.7956][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.401D.0039.0002.7956][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.401F.0023.0002.795D][.409C.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.401A.002C.0002.795E][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.401A.0037.0002.7965][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.4016.0022.0002.797F][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.4023.0027.0002.798D][.4098.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.401D.0044.0002.798E][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.4018.0028.0002.798F][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.4018.0028.0002.798F][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.4016.0023.0002.79AE][.4096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.4013.0023.0002.79CA][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.401F.0024.0002.79EB][.409C.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.4016.0023.0002.7A1C][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.4011.0025.0002.7A40][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.4011.0025.0002.7A40][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
FA55      ; [.4014.0022.0002.7A81][.4097.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.4016.0022.0002.7ACB][.40A3.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.4016.0023.0002.7B20][.40A3.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.401D.0027.0002.7BC0][.4093.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.401D.0027.0002.7BC0][.4093.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.401D.003D.0002.7BC6][.4093.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.401F.0026.0002.7BC9][.409C.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.4016.0025.0002.7C3E][.4095.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.4016.0026.0002.7C60][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.4016.0024.0002.7C92][.40A3.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.401D.0047.0002.7CBE][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.4014.0029.0002.7CD6][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.4016.0029.0002.7CE7][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.4011.004F.0002.7D00][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.4013.0022.0002.7D10][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.401A.0023.0002.7D22][.4090.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.4016.0028.0002.7D2F][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.401D.0063.0002.7D5B][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.4018.0034.0002.7D63][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.4016.0023.0002.7DA0][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.4016.0024.0002.7DBE][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.401F.0030.0002.7DC7][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.4016.0027.0002.7DF4][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.4016.0027.0002.7DF4][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.4016.0027.0002.7DF4][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.401D.0036.0002.7E09][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.4016.0029.0002.7E37][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.4018.0026.0002.7E41][.4093.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.401A.0052.0002.7E45][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.4018.0035.0002.7F3E][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.401A.0035.0002.7F72][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.4016.0031.0002.7F79][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.4016.0024.0002.7F85][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.4016.0029.0002.7F9A][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.401C.0036.0002.7FBD][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.4011.005A.0002.7FFA][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.4016.0029.0002.8001][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.401D.0033.0002.8005][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.401D.0033.0002.8005][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.401D.0033.0002.8005][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.4016.002B.0002.8046][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.4016.0028.0002.806F][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.401F.0028.0002.8070][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.4016.0027.0002.807E][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.4016.0022.0002.808B][.40A1.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.4013.0023.0002.80AD][.409C.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.401C.0024.0002.80B2][.40A0.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.4018.003F.0002.813E][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.4016.0022.0002.81D8][.408F.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.4016.0024.0002.81E8][.40A3.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.401F.002A.0002.81ED][.409F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.401C.002E.0002.8201][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.401C.002E.0002.8201][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
F97C      ; [.4016.002A.0002.826F][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.401C.0037.0002.828B][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.401D.003B.0002.829D][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.4023.0029.0002.82B1][.4098.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.4018.0035.0002.82B3][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.401C.0029.0002.82BD][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.401C.0023.0002.82E5][.4091.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.401C.0023.0002.82E5][.4091.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.4011.003A.0002.82E6][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.401F.002E.0002.831D][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.401C.004C.0002.8323][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.4014.0022.0002.8336][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.4023.0034.0002.8352][.4098.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.4017.002A.0002.83BD][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.4016.0024.0002.83C9][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.4011.0023.0002.83CA][.409C.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.4011.0025.0002.83CC][.40A0.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.401F.0029.0002.83DC][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.4023.002A.0002.83EF][.4098.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.4016.0025.0002.83F1][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.4016.0025.0002.843D][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.401C.0023.0002.8449][.4095.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.401D.0034.0002.8457][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.401D.0034.0002.8457][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.4016.0029.0002.84EE][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.4022.002A.0002.84F1][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
F9C2      ; [.4016.002A.0002.84FC][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.401C.0062.0002.8564][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.4016.0028.0002.85CD][.408F.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.4016.0025.0002.85FA][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.4016.002A.0002.8606][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.4016.0027.0002.862D][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.4016.0025.0002.863F][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.4023.0023.0002.8650][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.4016.002B.0002.865C][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.4016.002B.0002.865C][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.4023.0025.0002.8667][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.401F.0034.0002.86A9][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BC     ; [.401D.0026.0002.8728][.4093.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
F911      ; [.4016.0026.0002.87BA][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
F927      ; [.4016.0023.0002.881F][.408F.0020.0002][.40FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.4023.0025.0002.884C][.4090.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.401C.0030.0002.8863][.40A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.4016.0026.0002.88C2][.4095.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.4016.0034.0002.88CF][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.4016.0035.0002.88E1][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.4016.0027.0002.88F8][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.4011.0028.0002.8910][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.4011.0034.0002.8941][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.4016.0029.0002.8964][.408F.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.4018.002D.0002.8986][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.4011.0028.0002.898B][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.401A.0037.0002.8996][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.401A.0037.0002.8996][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.401A.0031.0002.8AA0][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.401A.002B.0002.8AAA][.4093.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.401A.002B.0002.8AAA][.4093.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.401D.0046.0002.8ABF][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.401F.0026.0002.8ACB][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.4016.002B.0002.8AD2][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.4016.0021.0002.8AD6][.4097.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.401C.0046.0002.8AED][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.401C.0046.0002.8AED][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.401D.0030.0002.8AF8][.4094.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.401D.0030.0002.8AF8][.4094.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.4013.0021.0002.8AFE][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.4013.0021.0002.8AFE][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.401C.0022.0002.8B01][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.401C.0022.0002.8B01][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.4011.002D.0002.8B39][.40A1.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.4011.002D.0002.8B39][.40A1.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.401A.002C.0002.8B58][.40A3.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.4014.002A.0002.8B80][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.4018.0023.0002.8B8A][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.4018.0023.0002.8B8A][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.4011.0057.0002.8C48][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.401A.003B.0002.8C55][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.4011.002E.0002.8CAB][.4098.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.4018.0032.0002.8CC1][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.4016.0025.0002.8CC2][.409A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.4011.0039.0002.8CC8][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.4018.002D.0002.8CD3][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.401D.002B.0002.8D08][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.401D.002B.0002.8D08][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.4011.0039.0002.8D1B][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.4011.0058.0002.8D77][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.4018.0027.0002.8DCB][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.4016.002C.0002.8DEF][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.401F.002D.0002.8ECA][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.4016.002A.0002.8F26][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.4016.0026.0002.8F2A][.40A0.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.401A.004F.0002.8F38][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.401A.004F.0002.8F38][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.4018.002F.0002.8F3B][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.4016.0026.0002.8F62][.4095.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.401D.003E.0002.8FB0][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.4016.002B.0002.9023][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.401C.0027.0002.9038][.40A3.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.401C.0027.0002.9038][.40A3.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.401D.0041.0002.9072][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.4016.002B.0002.907C][.409B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.4016.0028.0002.908F][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
FA2E      ; [.4016.0028.0002.90DE][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
FA26      ; [.4014.0045.0002.90FD][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.4016.0026.0002.916A][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.4016.0024.0002.91B4][.4096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.4016.0036.0002.91CC][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.4016.002D.0002.91CF][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.4011.0021.0002.91D1][.40A3.0020.0002][.40FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.4016.002D.0002.9234][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.4018.002F.0002.9238][.408F.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
2F9EA     ; [.4018.0039.0002.927C][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.4023.003F.0002.92D7][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
F93F      ; [.4016.0025.0002.9304][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.4016.002C.0002.934A][.4095.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EE     ; [.4011.0033.0002.958B][.4090.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.4016.002E.0002.95AD][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.401C.0031.0002.962E][.4098.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.4016.002D.0002.964B][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.4011.0037.0002.964D][.408F.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.4016.0026.0002.9675][.40A1.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.4016.0023.0002.9678][.40A0.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.401D.004E.0002.967C][.4093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.4016.0021.0002.9686][.40A0.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.4016.0027.0002.96A3][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.4016.0025.0002.96B7][.4096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.4016.0026.0002.96B8][.4096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.4016.0038.0002.96E2][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.4013.0023.0002.96E3][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.4013.0023.0002.96E3][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.4016.002E.0002.96F6][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.4016.0028.0002.96F7][.409A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.401C.0031.0002.9723][.409C.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.4016.002E.0002.9732][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.4016.002F.0002.9748][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.401D.0054.0002.9756][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.401D.0054.0002.9756][.4093.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
2F9FA     ; [.4022.0034.0002.97E0][.40A3.0020.0002][.40F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.4023.0026.0002.97FF][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.4023.0026.0002.97FF][.4091.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.4016.0030.0002.9818][.4095.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.4018.002E.0002.983B][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.4018.002E.0002.983B][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.4016.002E.0002.985E][.40A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.4011.005B.0002.98E2][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.4018.0039.0002.98EF][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.401A.005A.0002.98FC][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.4011.0030.0002.9928][.4098.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.4016.0027.0002.99F1][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.4016.0030.0002.9A6A][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.401D.004C.0002.9B12][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.401D.004C.0002.9B12][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.4016.002F.0002.9B6F][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.4016.0028.0002.9C57][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.4023.0025.0002.9DB4][.408F.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.4016.0030.0002.9DFA][.4097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.4016.0028.0002.9E1E][.408F.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.4016.0026.0002.9E7F][.4097.0020.0002][.40ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.4016.0031.0002.9E97][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.4016.0029.0002.9E9F][.40A3.0020.0002][.40F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.4017.0028.0002.9EBB][.408F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.4016.0032.0002.9ECE][.4095.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA1C     ; [.4018.004A.0002.9F3B][.40A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.4016.0021.0002.9F8D][.409B.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.4016.002E.0002.9F8E][.4097.0020.0002][.4101.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.4011.0056.0002.9F9C][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.4011.0056.0002.9F9C][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.4011.0056.0002.9F9C][.409C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
