use Unicode::Collate::CJK::Korean;
+{
   locale_version => 1.17,
   overrideCJK => \&Unicode::Collate::CJK::Korean::weightKorean,
   entry => <<'ENTRY', # for DUCET v8.0.0
F967      ; [.3A65.0021.0002.4E0D][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.3A65.0032.0002.4E26][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.3A5E.0021.0002.4E32][.3AE4.0020.0002][.3B4F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.3A70.0021.0002.4E38][.3AE5.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.3A61.0021.0002.4E39][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.3A63.0021.0002.4E82][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.3A63.0021.0002.4E86][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.3A63.0021.0002.4EAE][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.3A67.0021.0002.4EC0][.3AF0.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.3A63.0021.0002.4EE4][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.3A63.0021.0002.4F86][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.3A63.0021.0002.4F8B][.3AE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.3A64.0021.0002.4FAE][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.3A64.0021.0002.4FAE][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.3A6E.0023.0002.4FBB][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.3A6F.0021.0002.4FBF][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.3A65.0022.0002.5002][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.3A63.0022.0002.502B][.3AED.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.3A65.0022.0002.5099][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.3A67.0023.0002.50CF][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.3A63.0022.0002.50DA][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.3A67.0023.0002.50E7][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.3A67.0023.0002.50E7][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.3A69.0021.0002.5140][.3AE4.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.3A6C.0021.0002.5145][.3AE9.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.3A64.0021.0002.514D][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.3A64.0021.0002.514D][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F814     ; [.3A60.0022.0002.5167][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.3A6A.0024.0002.5168][.3AE0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.3A63.0023.0002.5169][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.3A63.0021.0002.516D][.3AED.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.3A5E.0026.0002.5177][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.3A5E.0024.0002.5180][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.3A6A.0021.0002.518D][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.3A64.0022.0002.5192][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.3A64.0022.0002.5195][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.3A69.0023.0002.5197][.3AE8.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.3A69.003B.0002.51A4][.3AEA.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.3A61.0022.0002.51AC][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.3A63.0021.0002.51B7][.3ADD.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.3A63.0024.0002.51C9][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.3A63.0021.0002.51CC][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.3A63.0021.0002.51DC][.3AEE.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.3A70.0022.0002.51DE][.3AEF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81E     ; [.3A69.0023.0002.5203][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.3A6A.0021.0002.5207][.3AE0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.3A6A.0021.0002.5207][.3AE0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.3A63.0022.0002.5217][.3AE2.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.3A63.0022.0002.5229][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.3A6A.0022.0002.523A][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.3A5E.0021.0002.523B][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.3A70.0021.0002.5272][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.3A67.002D.0002.5277][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.3A63.0021.0002.5289][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.3A63.0021.0002.529B][.3AE2.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.3A63.0023.0002.52A3][.3AE2.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.3A69.0024.0002.52C7][.3AE8.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.3A69.0024.0002.52C7][.3AE8.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.3A64.0023.0002.52C9][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.3A64.0023.0002.52C9][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.3A63.0021.0002.52D2][.3AEE.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.3A63.0021.0002.52DE][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.3A5E.0023.0002.52E4][.3AEE.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.3A5E.0023.0002.52E4][.3AEE.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.3A63.0023.0002.52F5][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.3A6A.0022.0002.52FA][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.3A6A.0022.0002.52FA][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.3A6F.0022.0002.5305][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
F963      ; [.3A65.0021.0002.5317][.3AE9.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.3A65.0021.0002.5317][.3AE9.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.3A60.0021.0002.533F][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.3A70.0021.0002.5349][.3AEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.3A65.0025.0002.5351][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.3A65.0025.0002.5351][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.3A65.0022.0002.535A][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.3A6A.0022.0002.5373][.3AEE.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.3A63.0022.0002.5375][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.3A6A.0021.0002.537D][.3AEE.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.3A5E.0028.0002.537F][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.3A5E.0028.0002.537F][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.3A5E.0028.0002.537F][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.3A6C.0022.0002.53C3][.3ADC.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.3A5E.0022.0002.53CA][.3AEE.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.3A67.005E.0002.53DF][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.3A5E.002A.0002.53E5][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.3A5E.0021.0002.53EB][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.3A6A.0022.0002.53F1][.3AF0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.3A63.0024.0002.540F][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.3A63.0021.0002.541D][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.3A70.0021.0002.5438][.3AEE.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.3A63.0024.0002.5442][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.3A6A.0026.0002.5448][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.3A6A.0028.0002.5468][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.3A69.0031.0002.54A2][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.3A69.0025.0002.54BD][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.3A61.0021.0002.5510][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.3A5E.0022.0002.5553][.3AE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.3A70.0024.0002.5563][.3ADC.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.3A67.0024.0002.5584][.3AE0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.3A67.0024.0002.5584][.3AE0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.3A63.0021.0002.5587][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.3A70.0022.0002.5599][.3AEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.3A70.0022.0002.5599][.3AEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.3A5E.0022.0002.559D][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.3A5E.0022.0002.559D][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.3A5F.0021.0002.55AB][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA7B      ; [.3A69.0022.0002.55E2][.3AE4.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.3A6E.0022.0002.5606][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.3A6E.0022.0002.5606][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.3A5E.0026.0002.5668][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.3A65.0023.0002.5674][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.3A63.0023.0002.56F9][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.3A61.0024.0002.5716][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.3A70.0024.0002.578B][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.3A67.0021.0002.57CE][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.3A67.0021.0002.57F4][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.3A65.0023.0002.5831][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.3A65.0033.0002.5840][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.3A6C.0022.0002.585A][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.3A6C.0022.0002.585A][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.3A67.0021.0002.585E][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.3A64.0021.0002.58A8][.3AE9.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.3A65.0024.0002.58B3][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.3A63.0021.0002.58D8][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.3A63.0021.0002.58DF][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.3A65.0032.0002.5906][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.3A61.0021.0002.591A][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.3A64.0021.0002.5922][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.3A69.0024.0002.5944][.3AE0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.3A60.0023.0002.5948][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.3A5E.0024.0002.5951][.3AE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.3A65.0025.0002.5954][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.3A67.0030.0002.5962][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.3A60.0021.0002.5973][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F862     ; [.3A70.0026.0002.59EC][.3AEF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.3A69.002C.0002.5A1B][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.3A6E.0030.0002.5A27][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.3A65.0027.0002.5A62][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.3A65.002B.0002.5A66][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.3A69.0025.0002.5AB5][.3AF0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.3A69.0041.0002.5B08][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.3A6A.003C.0002.5B28][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.3A63.0029.0002.5B3E][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.3A63.0029.0002.5B3E][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.3A61.0021.0002.5B85][.3ADD.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.3A69.0029.0002.5BC3][.3AEA.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.3A6C.003B.0002.5BD8][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.3A60.0021.0002.5BE7][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.3A60.0021.0002.5BE7][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.3A60.0021.0002.5BE7][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.3A63.0023.0002.5BEE][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
F9BD      ; [.3A60.0021.0002.5C3F][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.3A61.0028.0002.5C60][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.3A63.0023.0002.5C62][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.3A6C.0021.0002.5C64][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.3A63.0026.0002.5C65][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
2F879     ; [.3A67.002A.0002.5CC0][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.3A63.0023.0002.5D19][.3AED.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.3A63.0021.0002.5D50][.3ADC.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.3A63.0025.0002.5DBA][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.3A67.0021.0002.5DE1][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.3A67.0027.0002.5DE2][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.3A67.0022.0002.5DFD][.3AE4.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.3A67.0029.0002.5E28][.3AE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.3A64.0025.0002.5E3D][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.3A60.0021.0002.5E74][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.3A61.002B.0002.5EA6][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.3A65.0052.0002.5EB3][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.3A67.0025.0002.5EB6][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.3A63.0021.0002.5EC9][.3AE2.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.3A63.0021.0002.5ECA][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.3A63.0021.0002.5ECA][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.3A5E.0021.0002.5ED3][.3AE5.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.3A63.0025.0002.5EEC][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
F943      ; [.3A63.0022.0002.5F04][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.3A61.004B.0002.5F22][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.3A61.004B.0002.5F22][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.3A70.0025.0002.5F62][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.3A6C.0025.0002.5F69][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.3A6A.0027.0002.5F6B][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.3A63.0021.0002.5F8B][.3AED.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.3A65.0026.0002.5FA9][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.3A69.0043.0002.5FAD][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.3A69.002A.0002.5FCD][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.3A6A.0026.0002.5FD7][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.3A60.0021.0002.5FF5][.3AE2.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.3A60.0024.0002.6012][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.3A63.0026.0002.601C][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.3A69.0042.0002.6081][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.3A70.0026.0002.6094][.3AE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.3A70.0026.0002.6094][.3AE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.3A61.0022.0002.60C7][.3AE4.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.3A64.002D.0002.60D8][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.3A69.0025.0002.60E1][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.3A69.002E.0002.6108][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.3A63.0022.0002.6144][.3AED.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.3A6A.002A.0002.6148][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.3A70.0027.0002.614C][.3AE5.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.3A70.0027.0002.614C][.3AE5.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA8A      ; [.3A69.0047.0002.6160][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.3A5E.0028.0002.6168][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.3A63.0031.0002.617A][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.3A6A.0022.0002.618E][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.3A6A.0022.0002.618E][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.3A6A.0022.0002.618E][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.3A63.0021.0002.6190][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.3A65.0028.0002.61A4][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.3A6C.0030.0002.61AF][.3ADC.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.3A70.0021.0002.61B2][.3AE0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.3A64.0025.0002.61DE][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.3A6A.0022.0002.61F2][.3AF0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.3A6A.0022.0002.61F2][.3AF0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.3A6A.0022.0002.61F2][.3AF0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.3A63.0022.0002.61F6][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.3A63.0022.0002.61F6][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.3A63.0022.0002.6200][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.3A67.0026.0002.6210][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
F9D2      ; [.3A63.0022.0002.622E][.3AED.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.3A61.0029.0002.6234][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.3A6F.002B.0002.62B1][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.3A63.0021.0002.62C9][.3ADC.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.3A60.0024.0002.62CF][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.3A6C.0026.0002.62D3][.3AE0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.3A65.0022.0002.62D4][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.3A67.0022.0002.62FE][.3AEE.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.3A64.0027.0002.633D][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.3A69.0027.0002.6350][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.3A67.0039.0002.6368][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.3A60.0024.0002.637B][.3AE2.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.3A67.0029.0002.6383][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.3A63.0021.0002.63A0][.3ADE.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.3A69.0025.0002.63A9][.3AE0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.3A69.0030.0002.63C4][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.3A67.0030.0002.641C][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.3A6A.0025.0002.6422][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
2F8C3     ; [.3A64.0021.0002.6469][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.3A60.0022.0002.649A][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.3A70.0029.0002.649D][.3AEC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.3A63.0023.0002.64C4][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.3A64.0025.0002.654F][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.3A64.0025.0002.654F][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.3A69.0030.0002.6556][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.3A5E.0030.0002.656C][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.3A67.0032.0002.6578][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.3A63.0025.0002.6599][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.3A63.0028.0002.65C5][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
2F8CB     ; [.3A5E.0035.0002.65E3][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.3A69.0024.0002.6613][.3AE2.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.3A6A.0026.0002.6649][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.3A6C.0022.0002.6674][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.3A6C.0022.0002.6674][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.3A70.002A.0002.6688][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.3A67.002B.0002.6691][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.3A67.002B.0002.6691][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.3A6F.0022.0002.66B4][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.3A63.0022.0002.66C6][.3AE2.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.3A5E.0033.0002.66F4][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.3A67.002D.0002.66F8][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.3A6C.0023.0002.6700][.3AE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.3A63.0022.0002.6717][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.3A63.0022.0002.6717][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.3A63.0022.0002.6717][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.3A64.0025.0002.671B][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.3A64.0025.0002.671B][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.3A63.0028.0002.674E][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.3A6F.0025.0002.6753][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.3A6A.002E.0002.6756][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.3A5E.0038.0002.675E][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.3A60.0021.0002.677B][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
F9F4      ; [.3A63.0021.0002.6797][.3AF0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.3A63.0023.0002.67F3][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.3A63.0023.0002.6817][.3AED.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.3A63.0025.0002.6881][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.3A64.0027.0002.6885][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.3A64.0027.0002.6885][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.3A63.0029.0002.68A8][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.3A67.0062.0002.6942][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EA     ; [.3A5E.002A.0002.69EA][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.3A69.0028.0002.6A02][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.3A69.0028.0002.6A02][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.3A69.0028.0002.6A02][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.3A63.0024.0002.6A13][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.3A63.0024.0002.6AD3][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.3A6A.0021.0002.6ADB][.3AEE.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.3A63.0023.0002.6B04][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.3A6C.0028.0002.6B21][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.3A70.0025.0002.6B54][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.3A67.0023.0002.6B72][.3AE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.3A63.0023.0002.6B77][.3AE2.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
F9A5      ; [.3A63.0023.0002.6BAE][.3AE2.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.3A67.0023.0002.6BBA][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.3A67.0023.0002.6BBA][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.3A67.0023.0002.6BBA][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.3A65.0025.0002.6C4E][.3AE0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.3A6C.0024.0002.6C88][.3AF0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.3A69.002B.0002.6CBF][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.3A6F.0024.0002.6CCC][.3AF0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.3A60.0022.0002.6CE5][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.3A63.0021.0002.6D1B][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.3A61.002A.0002.6D1E][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.3A6F.0029.0002.6D3E][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.3A63.0025.0002.6D41][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.3A63.0025.0002.6D41][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.3A63.0025.0002.6D41][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.3A70.002E.0002.6D69][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.3A63.0023.0002.6D6A][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.3A70.002A.0002.6D77][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.3A70.002A.0002.6D77][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.3A6C.0025.0002.6D78][.3AF0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.3A69.0022.0002.6D85][.3AE2.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.3A63.0022.0002.6DCB][.3AF0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.3A63.0025.0002.6DDA][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.3A63.0024.0002.6DEA][.3AED.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.3A69.0026.0002.6DF9][.3AE0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.3A6A.002C.0002.6E1A][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.3A70.002B.0002.6E2F][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.3A69.002B.0002.6E6E][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.3A63.0026.0002.6E9C][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.3A60.0022.0002.6EBA][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.3A6A.002B.0002.6ECB][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.3A6A.002B.0002.6ECB][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.3A70.0022.0002.6ED1][.3AE5.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.3A63.0026.0002.6F0F][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.3A70.0026.0002.6F22][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.3A70.0026.0002.6F22][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.3A63.0024.0002.6F23][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.3A6A.0033.0002.6F6E][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.3A65.003C.0002.6FC6][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.3A63.0025.0002.6FEB][.3ADC.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.3A63.002A.0002.6FFE][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.3A69.002D.0002.701B][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.3A6A.003D.0002.701E][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.3A6A.003D.0002.701E][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.3A70.002D.0002.7070][.3AE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.3A6A.002B.0002.707D][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.3A6A.002C.0002.7099][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.3A6E.0028.0002.70AD][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.3A63.0025.0002.70C8][.3AE2.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.3A63.0022.0002.70D9][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.3A63.0025.0002.7149][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.3A6A.002D.0002.716E][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.3A6A.002D.0002.716E][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.3A63.0026.0002.71CE][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.3A63.0023.0002.71D0][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.3A63.0027.0002.7210][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.3A63.0026.0002.721B][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.3A6C.0036.0002.7228][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.3A6A.0028.0002.7235][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.3A6A.0028.0002.7235][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.3A63.0023.0002.7262][.3AE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.3A67.0030.0002.7280][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.3A65.0027.0002.72AF][.3AE0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.3A67.0035.0002.72C0][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.3A63.0024.0002.72FC][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.3A6A.002E.0002.732A][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.3A6A.002E.0002.732A][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.3A63.0021.0002.7375][.3AE2.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.3A61.0023.0002.737A][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.3A67.0021.0002.7387][.3AE4.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.3A67.0021.0002.7387][.3AE4.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.3A69.0025.0002.738B][.3AE5.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.3A63.0027.0002.73B2][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.3A63.0023.0002.73DE][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.3A63.002D.0002.7406][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.3A63.0028.0002.7409][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.3A6E.002B.0002.7422][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.3A69.003D.0002.745C][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.3A70.002D.0002.7469][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.3A6A.0057.0002.7471][.3AE0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.3A6A.0057.0002.7471][.3AE0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
F994      ; [.3A63.0026.0002.7489][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.3A63.0024.0002.7498][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.3A5E.003A.0002.74CA][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
F9CD      ; [.3A63.002A.0002.7559][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.3A63.0022.0002.7565][.3ADE.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.3A69.002C.0002.7570][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.3A69.002C.0002.7570][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.3A63.002F.0002.75E2][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.3A69.0059.0002.7610][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.3A69.0023.0002.761F][.3AE4.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.3A63.0027.0002.7642][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.3A63.0023.0002.7669][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.3A69.0022.0002.76CA][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.3A69.0022.0002.76CA][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.3A67.002B.0002.76DB][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.3A63.0028.0002.76E7][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.3A6A.0021.0002.76F4][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.3A6A.0021.0002.76F4][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.3A67.002C.0002.7701][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.3A6A.0033.0002.771E][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
FAAA      ; [.3A6C.0023.0002.7740][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.3A6A.0034.0002.778B][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.3A63.002C.0002.786B][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.3A63.0021.0002.788C][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.3A63.0021.0002.788C][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.3A65.0038.0002.7891][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.3A63.0024.0002.78CA][.3AE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
F964      ; [.3A65.0032.0002.78FB][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.3A63.002B.0002.792A][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.3A67.0046.0002.793E][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.3A5E.004C.0002.7948][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.3A6A.0035.0002.7949][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.3A69.0032.0002.7950][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.3A6A.0039.0002.7956][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.3A6A.0039.0002.7956][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.3A6C.0023.0002.795D][.3AE9.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.3A67.002C.0002.795E][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.3A67.0037.0002.7965][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.3A63.0022.0002.797F][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.3A70.0027.0002.798D][.3AE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.3A6A.0044.0002.798E][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.3A65.0028.0002.798F][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.3A65.0028.0002.798F][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.3A63.0023.0002.79AE][.3AE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.3A60.0023.0002.79CA][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.3A6C.0024.0002.79EB][.3AE9.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.3A63.0023.0002.7A1C][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.3A5E.0025.0002.7A40][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.3A5E.0025.0002.7A40][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
FA55      ; [.3A61.0022.0002.7A81][.3AE4.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.3A63.0022.0002.7ACB][.3AF0.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.3A63.0023.0002.7B20][.3AF0.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.3A6A.0027.0002.7BC0][.3AE0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.3A6A.0027.0002.7BC0][.3AE0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.3A6A.003D.0002.7BC6][.3AE0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.3A6C.0026.0002.7BC9][.3AE9.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.3A63.0025.0002.7C3E][.3AE2.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.3A63.0026.0002.7C60][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.3A63.0024.0002.7C92][.3AF0.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.3A6A.0047.0002.7CBE][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.3A61.0029.0002.7CD6][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.3A63.0029.0002.7CE7][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.3A5E.004F.0002.7D00][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.3A60.0022.0002.7D10][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.3A67.0023.0002.7D22][.3ADD.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.3A63.0028.0002.7D2F][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.3A6A.0063.0002.7D5B][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.3A65.0034.0002.7D63][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.3A63.0023.0002.7DA0][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.3A63.0024.0002.7DBE][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.3A6C.0030.0002.7DC7][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.3A63.0027.0002.7DF4][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.3A63.0027.0002.7DF4][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.3A63.0027.0002.7DF4][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.3A6A.0036.0002.7E09][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.3A63.0029.0002.7E37][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.3A65.0026.0002.7E41][.3AE0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.3A67.0052.0002.7E45][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.3A65.0035.0002.7F3E][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.3A67.0035.0002.7F72][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.3A63.0031.0002.7F79][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.3A63.0024.0002.7F85][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.3A63.0029.0002.7F9A][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.3A69.0036.0002.7FBD][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.3A5E.005A.0002.7FFA][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.3A63.0029.0002.8001][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.3A6A.0033.0002.8005][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.3A6A.0033.0002.8005][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.3A6A.0033.0002.8005][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.3A63.002B.0002.8046][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.3A63.0028.0002.806F][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.3A6C.0028.0002.8070][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.3A63.0027.0002.807E][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.3A63.0022.0002.808B][.3AEE.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.3A60.0023.0002.80AD][.3AE9.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.3A69.0024.0002.80B2][.3AED.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.3A65.003F.0002.813E][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.3A63.0022.0002.81D8][.3ADC.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.3A63.0024.0002.81E8][.3AF0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.3A6C.002A.0002.81ED][.3AEC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.3A69.002E.0002.8201][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.3A69.002E.0002.8201][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
F97C      ; [.3A63.002A.0002.826F][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.3A69.0037.0002.828B][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.3A6A.003B.0002.829D][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.3A70.0029.0002.82B1][.3AE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.3A65.0035.0002.82B3][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.3A69.0029.0002.82BD][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.3A69.0023.0002.82E5][.3ADE.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.3A69.0023.0002.82E5][.3ADE.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.3A5E.003A.0002.82E6][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.3A6C.002E.0002.831D][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.3A69.004C.0002.8323][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.3A61.0022.0002.8336][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.3A70.0034.0002.8352][.3AE5.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.3A64.002A.0002.83BD][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.3A63.0024.0002.83C9][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.3A5E.0023.0002.83CA][.3AE9.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.3A5E.0025.0002.83CC][.3AED.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.3A6C.0029.0002.83DC][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.3A70.002A.0002.83EF][.3AE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.3A63.0025.0002.83F1][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.3A63.0025.0002.843D][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.3A69.0023.0002.8449][.3AE2.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.3A6A.0034.0002.8457][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.3A6A.0034.0002.8457][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.3A63.0029.0002.84EE][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.3A6F.002A.0002.84F1][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
F9C2      ; [.3A63.002A.0002.84FC][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.3A69.0062.0002.8564][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.3A63.0028.0002.85CD][.3ADC.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.3A63.0025.0002.85FA][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.3A63.002A.0002.8606][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.3A63.0027.0002.862D][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.3A63.0025.0002.863F][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.3A70.0023.0002.8650][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.3A63.002B.0002.865C][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.3A63.002B.0002.865C][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.3A70.0025.0002.8667][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.3A6C.0034.0002.86A9][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BC     ; [.3A6A.0026.0002.8728][.3AE0.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
F911      ; [.3A63.0026.0002.87BA][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
F927      ; [.3A63.0023.0002.881F][.3ADC.0020.0002][.3B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.3A70.0025.0002.884C][.3ADD.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.3A69.0030.0002.8863][.3AEF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.3A63.0026.0002.88C2][.3AE2.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.3A63.0034.0002.88CF][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.3A63.0035.0002.88E1][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.3A63.0027.0002.88F8][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.3A5E.0028.0002.8910][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.3A5E.0034.0002.8941][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.3A63.0029.0002.8964][.3ADC.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.3A65.002D.0002.8986][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.3A5E.0028.0002.898B][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.3A67.0037.0002.8996][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.3A67.0037.0002.8996][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.3A67.0031.0002.8AA0][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.3A67.002B.0002.8AAA][.3AE0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.3A67.002B.0002.8AAA][.3AE0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.3A6A.0046.0002.8ABF][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.3A6C.0026.0002.8ACB][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.3A63.002B.0002.8AD2][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.3A63.0021.0002.8AD6][.3AE4.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.3A69.0046.0002.8AED][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.3A69.0046.0002.8AED][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.3A6A.0030.0002.8AF8][.3AE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.3A6A.0030.0002.8AF8][.3AE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.3A60.0021.0002.8AFE][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.3A60.0021.0002.8AFE][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.3A69.0022.0002.8B01][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.3A69.0022.0002.8B01][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.3A5E.002D.0002.8B39][.3AEE.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.3A5E.002D.0002.8B39][.3AEE.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.3A67.002C.0002.8B58][.3AF0.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.3A61.002A.0002.8B80][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.3A65.0023.0002.8B8A][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.3A65.0023.0002.8B8A][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.3A5E.0057.0002.8C48][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.3A67.003B.0002.8C55][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.3A5E.002E.0002.8CAB][.3AE5.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.3A65.0032.0002.8CC1][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.3A63.0025.0002.8CC2][.3AE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.3A5E.0039.0002.8CC8][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.3A65.002D.0002.8CD3][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.3A6A.002B.0002.8D08][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.3A6A.002B.0002.8D08][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.3A5E.0039.0002.8D1B][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.3A5E.0058.0002.8D77][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.3A65.0027.0002.8DCB][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.3A63.002C.0002.8DEF][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.3A6C.002D.0002.8ECA][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.3A63.002A.0002.8F26][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.3A63.0026.0002.8F2A][.3AED.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.3A67.004F.0002.8F38][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.3A67.004F.0002.8F38][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.3A65.002F.0002.8F3B][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.3A63.0026.0002.8F62][.3AE2.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.3A6A.003E.0002.8FB0][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.3A63.002B.0002.9023][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.3A69.0027.0002.9038][.3AF0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.3A69.0027.0002.9038][.3AF0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.3A6A.0041.0002.9072][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.3A63.002B.0002.907C][.3AE8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.3A63.0028.0002.908F][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
FA2E      ; [.3A63.0028.0002.90DE][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
FA26      ; [.3A61.0045.0002.90FD][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.3A63.0026.0002.916A][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.3A63.0024.0002.91B4][.3AE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.3A63.0036.0002.91CC][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.3A63.002D.0002.91CF][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.3A5E.0021.0002.91D1][.3AF0.0020.0002][.3B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.3A63.002D.0002.9234][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.3A65.002F.0002.9238][.3ADC.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
2F9EA     ; [.3A65.0039.0002.927C][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.3A70.003F.0002.92D7][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
F93F      ; [.3A63.0025.0002.9304][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.3A63.002C.0002.934A][.3AE2.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EE     ; [.3A5E.0033.0002.958B][.3ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.3A63.002E.0002.95AD][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.3A69.0031.0002.962E][.3AE5.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.3A63.002D.0002.964B][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.3A5E.0037.0002.964D][.3ADC.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.3A63.0026.0002.9675][.3AEE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.3A63.0023.0002.9678][.3AED.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.3A6A.004E.0002.967C][.3AE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.3A63.0021.0002.9686][.3AED.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.3A63.0027.0002.96A3][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.3A63.0025.0002.96B7][.3AE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.3A63.0026.0002.96B8][.3AE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.3A63.0038.0002.96E2][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.3A60.0023.0002.96E3][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.3A60.0023.0002.96E3][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.3A63.002E.0002.96F6][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.3A63.0028.0002.96F7][.3AE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.3A69.0031.0002.9723][.3AE9.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.3A63.002E.0002.9732][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.3A63.002F.0002.9748][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.3A6A.0054.0002.9756][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.3A6A.0054.0002.9756][.3AE0.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
2F9FA     ; [.3A6F.0034.0002.97E0][.3AF0.0020.0002][.3B41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.3A70.0026.0002.97FF][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.3A70.0026.0002.97FF][.3ADE.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.3A63.0030.0002.9818][.3AE2.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.3A65.002E.0002.983B][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.3A65.002E.0002.983B][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.3A63.002E.0002.985E][.3AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.3A5E.005B.0002.98E2][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.3A65.0039.0002.98EF][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.3A67.005A.0002.98FC][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.3A5E.0030.0002.9928][.3AE5.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.3A63.0027.0002.99F1][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.3A63.0030.0002.9A6A][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.3A6A.004C.0002.9B12][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.3A6A.004C.0002.9B12][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.3A63.002F.0002.9B6F][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.3A63.0028.0002.9C57][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.3A70.0025.0002.9DB4][.3ADC.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.3A63.0030.0002.9DFA][.3AE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.3A63.0028.0002.9E1E][.3ADC.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.3A63.0026.0002.9E7F][.3AE4.0020.0002][.3B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.3A63.0031.0002.9E97][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.3A63.0029.0002.9E9F][.3AF0.0020.0002][.3B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.3A64.0028.0002.9EBB][.3ADC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.3A63.0032.0002.9ECE][.3AE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA1C     ; [.3A65.004A.0002.9F3B][.3AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.3A63.0021.0002.9F8D][.3AE8.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.3A63.002E.0002.9F8E][.3AE4.0020.0002][.3B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.3A5E.0056.0002.9F9C][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.3A5E.0056.0002.9F9C][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.3A5E.0056.0002.9F9C][.3AE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
