# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

BEGIN { $| = 1; print "1..16\n"; }
END {print "not ok 1\n" unless $loaded;}

use ShiftJIS::String qw(:all);

$^W = 1;
$loaded = 1;
print "ok 1\n";

if($] < 5.005){
  foreach(2..14) { print "ok $_\n"; }
  exit;
}

######################### End of black magic.

print 'abc`abxyz' eq tolower 'AbC`abXYz'
  ? "ok" : "not ok", " 2\n";

print '' eq toupper ''
  ? "ok" : "not ok", " 3\n";

print length '' eq '0'
  ? "ok" : "not ok", " 4\n";

print 9 == length 'Perl̃eXg.'
  ? "ok" : "not ok", " 5\n";

print '.gXelreP' eq strrev 'Perl̃eXg.'
  ? "ok" : "not ok", " 6\n";

print '̓p[̃eXgł' eq kanaH2Z '߰قÃXĂł'
  ? "ok" : "not ok", " 7\n";

print kataZ2H '̓p̃eXgł' eq '߰قýĂł'
  ? "ok" : "not ok", " 8\n";

print '߰ý޽' eq kanaZ2H '̓p̃eXgł'
  ? "ok" : "not ok", " 9\n";

print 'Rnρ[mĂƃfX' eq hiXka '̓p[̃eXgł'
  ? "ok" : "not ok", " 10\n";

print hi2ka '̓p[̃eXgł' eq 'Rnp[meXgfX'
  ? "ok" : "not ok", " 11\n";

print ka2hi '̓p[ýgł'   eq '͂ρ[ýƂł'
  ? "ok" : "not ok", " 12\n";

print spaceH2Z ' @ @  ' eq '@@@@@@'
  ? "ok" : "not ok", " 13\n";

print spaceZ2H ' @ @  ' eq '      '
  ? "ok" : "not ok", " 14\n";

print spaceH2Z '' eq ''
  ? "ok" : "not ok", " 15\n";

print spaceZ2H '' eq ''
  ? "ok" : "not ok", " 16\n";

