#!/usr/bin/env perl

use strict;
use warnings;

die 'must pass a numeric argument' unless @ARGV;

use FindBin qw($Bin);
use lib "$Bin/../lib";

use DataFlow;
use aliased 'DataFlow::Proc::NOP';
use Data::Dumper;

my $flow = DataFlow->new(
    procs => [
        sub {
            my $num = shift;

            #print "AAA: ".$num."\n";
            my @res = map { chr( 64 + $_ ) } ( 1 .. $num );

            #print "BBB: ".Dumper(\@res);;
            return [@res];
        },
        NOP->new( deref => 1 ),
        sub {
            return lc(shift);
        },
    ],
);

$flow->input(shift);

my @res = $flow->flush;
print Dumper(@res);

