use strict;
use ExtUtils::MakeMaker;

# $Id: Makefile.PL,v 1.18 2004/12/10 17:45:13 rs Exp $
$| = 1;

my $quiet    = grep(uc($_) eq 'QUIET', @ARGV);
my $defaults = grep(uc($_) eq 'DEFAULTS', @ARGV);

if(!$quiet)
{
    print <<EOT;
Welcome to the rrdpoller installation script. There is several way to
call me. You can pass some argument to change some Makefile generation
behaviors:

    perl Makefile.PL [OPTIONS]

OPTIONS:

    QUIET       This option removes all help text like this one.
    DEFAULTS    This option will choose all default values instead of
                asking you when a choice is possible.

EOT
    
    my $answer;
    if(!$defaults)
    {
        print "Do you want to continue ? [Y/n]: ";
        $answer = <STDIN>;
        chomp($answer);
        exit if($answer =~ /^n/i);
    }
}

if(!eval {require RRDs; 1})
{
    print <<EOT if not $quiet;

The RRDs perl library seems not installed on your system. This module
can't work without this library. You can download this library on the
following URL: http://rrdtool.cs.pu.edu.tw/download.html. If you install
this module anyway, it won't be usable until the RRDs library won't be
installed.

EOT
    my $answer = 'y';
    if(!$defaults)
    {
        print "Do you want to install rrdpoller anyway [Y/n]: ";
        my $answer = <STDIN>;
        chomp($answer);
    }
    exit 1 if($answer =~ /^n/i);
}

my $answer = 'n';
my %OptionalModules;
if(!$defaults)
{
    print <<EOT if not $quiet;

If you intend to use the network feature of rrdpoller, there is some
additionnal module required. They aren't needed to use rrdpoller as a
local only tool. If you don't want the installation process to complain
about missing modules reply yes to this question.

EOT
    print "Do you want to ignore modules dependancy for network feature [y/N]: ";
    $answer = <STDIN>;
}
chomp($answer);
if($answer !~ /^y/i)
{
    %OptionalModules =
    (
        'XMLRPC::Lite'            => 0,
        'XMLRPC::Transport::HTTP' => 0,
        'Getopt::Long'            => 0,
        'Cwd'                     => 0,
    );
}

WriteMakefile
(
 NAME            => 'rrdpoller',
 DISTNAME        => 'rrdpoller',
 VERSION_FROM    => 'rrdpoller',
 PERL_ARCHLIB    => undef,
 PM              => 
 {
  'Threshold.pm' => '$(INST_LIB)/RRD/Threshold.pm',
  'Query.pm'     => '$(INST_LIB)/RRD/Query.pm',
 },
 EXE_FILES       => [qw(rrdpoller rrdpollerd)],
 PREREQ_PM       =>
 {
  'Error'        => '0.15',
  'RRDs'         => '1.000481',
  'File::Temp'   => '',
  %OptionalModules
 },
 AUTHOR          => 'Olivier Poitrey <rs@mmania.com>',
 dist            =>
 {
  DIST_DEFAULT   => 'checkout all dist_checks changelog README metafile sign tardist checkin_autogenerated',
  COMPRESS       => 'gzip -9f',
 }
);

# if we make sign first and make dist then, then any change to
# META.yml will ruin the signature

# if we make dist first and make sign then, then the correct signature
# will not be part of the tarball

# So we must alter make dist to first write META.yml, then let us
# sign, then do the tarball.

sub MY::postamble {
q{
README: rrdpoller Makefile
	chmod +w $@
	pod2text rrdpoller > $@

changelog ::
	# TODO: generate a changelog

dist_checks ::
	@test $(shell head -1 debian/changelog|perl -pe 's/.*\(|\).*//g') == $(VERSION) || \
  (echo "*** Versions mismatch between changelog and script"; false)
	@echo "Check that all files are commited"
	@! cvs -q up 2>/dev/null|grep ^M || \
  (echo "*** Some files aren't commited into CVS"; false)
	@echo "Tagging CVS"
	@! cvs -q tag V$(subst .,_,$(VERSION))|grep -q ^W || \
  (echo "*** Some files are already tagged with this version"; false)

checkout ::
	cvs -q up -dP >/dev/null 2>&1

checkin_autogenerated ::
	cvs ci -m 'new release' META.yml SIGNATURE README

sign ::
	cpansign -s

}
}
