use utf8;

package SemanticWeb::Schema::CovidTestingFacility;

# ABSTRACT: A CovidTestingFacility is a [[MedicalClinic]] where testing for the COVID-19 Coronavirus disease is available

use Moo;

extends qw/ SemanticWeb::Schema::MedicalClinic /;


use MooX::JSON_LD 'CovidTestingFacility';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v11.1.1';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::CovidTestingFacility - A CovidTestingFacility is a [[MedicalClinic]] where testing for the COVID-19 Coronavirus disease is available

=head1 VERSION

version v11.1.1

=head1 DESCRIPTION

A CovidTestingFacility is a L<SemanticWeb::Schema::MedicalClinic> where testing for the COVID-19 Coronavirus
      disease is available. If the facility is being made available from an established L<SemanticWeb::Schema::Pharmacy>, L<SemanticWeb::Schema::Hotel>, or other
      non-medical organization, multiple types can be listed. This makes it easier to re-use existing schema.org information
      about that place e.g. contact info, address, opening hours. Note that in an emergency, such information may not always be reliable.

=head1 SEE ALSO

L<SemanticWeb::Schema::MedicalClinic>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2021 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
