/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.jmx4perl.AgentServlet;
import org.jmx4perl.Config;
import org.jmx4perl.LogHandler;
import org.jmx4perl.osgi.J4pAuthenticatedHttpContext;
import org.jmx4perl.osgi.J4pHttpContext;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J4pActivator
implements BundleActivator {
    private BundleContext bundleContext;
    private ServiceListener httpServiceListener;
    private ServiceTracker logTracker;
    private static final String CONFIG_PREFIX = "org.jmx4perl";

    public void start(BundleContext pBundleContext) throws Exception {
        this.bundleContext = pBundleContext;
        this.logTracker = new ServiceTracker(pBundleContext, LogService.class.getName(), null);
        this.logTracker.open();
        ServiceReference sRef = pBundleContext.getServiceReference(HttpService.class.getName());
        if (sRef != null) {
            this.registerServlet(sRef, this.getConfig());
        }
        this.httpServiceListener = this.createServiceListener();
        pBundleContext.addServiceListener(this.httpServiceListener, "(objectClass=" + HttpService.class.getName() + ")");
    }

    public void stop(BundleContext pBundleContext) throws Exception {
        assert (pBundleContext.equals(this.bundleContext));
        ServiceReference sRef = pBundleContext.getServiceReference(HttpService.class.getName());
        if (sRef != null) {
            this.unregisterServlet(sRef);
        }
        this.logTracker.close();
        this.logTracker = null;
        this.bundleContext.removeServiceListener(this.httpServiceListener);
        this.bundleContext = null;
    }

    private ServiceListener createServiceListener() {
        return new ServiceListener(){

            public void serviceChanged(ServiceEvent pServiceEvent) {
                block7: {
                    try {
                        if (pServiceEvent.getType() == 1) {
                            J4pActivator.this.registerServlet(pServiceEvent.getServiceReference(), J4pActivator.this.getConfig());
                        } else if (pServiceEvent.getType() == 4) {
                            J4pActivator.this.unregisterServlet(pServiceEvent.getServiceReference());
                        }
                    }
                    catch (ServletException e) {
                        LogService logService = (LogService)J4pActivator.this.logTracker.getService();
                        if (logService != null) {
                            logService.log(1, "Servlet Exception: " + (Object)((Object)e), (Throwable)e);
                        }
                    }
                    catch (NamespaceException e) {
                        LogService logService = (LogService)J4pActivator.this.logTracker.getService();
                        if (logService == null) break block7;
                        logService.log(1, "Namespace Exception: " + (Object)((Object)e), (Throwable)e);
                    }
                }
            }
        };
    }

    private void unregisterServlet(ServiceReference sRef) {
        if (sRef != null) {
            HttpService service = (HttpService)this.bundleContext.getService(sRef);
            service.unregister(this.getConfiguration(Config.AGENT_CONTEXT));
        }
    }

    private void registerServlet(ServiceReference pRef, Dictionary<String, String> pConfig) throws ServletException, NamespaceException {
        HttpService service = (HttpService)this.bundleContext.getService(pRef);
        service.registerServlet(this.getConfiguration(Config.AGENT_CONTEXT), (Servlet)this.createServlet(), pConfig, this.getHttpContext());
    }

    private HttpContext getHttpContext() {
        String user = this.getConfiguration(Config.USER);
        String password = this.getConfiguration(Config.PASSWORD);
        if (user == null) {
            return new J4pHttpContext();
        }
        return new J4pAuthenticatedHttpContext(user, password);
    }

    private AgentServlet createServlet() {
        AgentServlet servlet = new AgentServlet(this.getLogHandler());
        return servlet;
    }

    private LogHandler getLogHandler() {
        return new LogHandler(){

            public void debug(String message) {
                this.log(4, message);
            }

            public void info(String message) {
                this.log(3, message);
            }

            private void log(int level, String message) {
                LogService logService = (LogService)J4pActivator.this.logTracker.getService();
                if (logService != null) {
                    logService.log(level, message);
                }
            }

            public void error(String message, Throwable t) {
                LogService logService = (LogService)J4pActivator.this.logTracker.getService();
                logService.log(1, message, t);
            }
        };
    }

    private Dictionary<String, String> getConfig() {
        Hashtable<String, String> config = new Hashtable<String, String>();
        for (Config key : Config.values()) {
            String value = this.getConfiguration(key);
            if (value == null) continue;
            ((Dictionary)config).put(key.getKeyValue(), value);
        }
        return config;
    }

    private String getConfiguration(Config pKey) {
        String value = this.bundleContext.getProperty("org.jmx4perl." + (Object)((Object)pKey));
        if (value == null) {
            value = pKey.getDefaultValue();
        }
        return value;
    }
}

