#!/usr/bin/perl -w

use strict;
use Switch;

use Graphics::Framebuffer;
use Term::ANSIScreen qw(:cursor);

$| = 1;
my $mali = 0;
my $file = 0;
my $arg = join('',@ARGV);

$mali = 1 if ($arg =~ /mali/i); # Mali GPU correction mode
$file = 1 if ($arg =~ /file/i); # File Handle drawing mode

my $F = Graphics::Framebuffer->new('MALI' => $mali, 'FB_DEVICE' => '/dev/fb0','FILE_MODE' => $file,'SHOW_ERRORS' => 0);

my $screen_width  = $F->{'XRES'};
my $screen_height = $F->{'YRES'};
my $XX            = $screen_width;
my $YY            = $screen_height;
my $center_x      = int($screen_width / 2);
my $center_y      = int($screen_height / 2);
my $wait          = 2;

$F->normal_mode();

print_it($F,'Plotting Test');
foreach my $p (1..1000) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->plot({'x' => rand($screen_width),'y' => rand($screen_height),'pixel_size' => rand(5)+1});
}
sleep $wait;

print_it($F,'Drawto Test');
for(my $l=40;$l < $YY;$l += 40) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->line({'x' => 0,'y' => $l,'xx' =>$XX, 'yy' => $l,'pixel_size' => 1});
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->line({'x' => 0,'y' => $l,'xx' =>$l, 'yy' => 40,'pixel_size' => 1});
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->line({'x' => $XX,'y' => $l,'xx' =>$XX - $l, 'yy' => 40,'pixel_size' => 1});
}
for(my $l=0;$l < $XX;$l += 40) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->line({'x' => $l,'y' => 40,'xx' =>$l, 'yy' => $YY,'pixel_size' => 1});
}
sleep $wait;

print_it($F,'Box Test');
foreach my $p (1..100) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->box({'x' => rand($XX),'y' => rand($YY),'xx' => rand($XX),'yy' => rand($YY)});
}
sleep $wait;

print_it($F,'Filled Box Test');
foreach my $p (1..75) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->box({'x' => rand($XX),'y' => rand($YY),'xx' => rand($XX),'yy' => rand($YY),'filled' => 1,'hatched' => 'DOTTED'});
}
sleep $wait;

print_it($F,'Gradient Box Test');
foreach my $p (1..50) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->box({'x' => rand($XX),'y' => rand($YY),'xx' => rand($XX),'yy' => rand($YY),'filled' => 1,
                'gradient' => {
                    'start' => {
                        'red'   => rand(256),
                        'green' => rand(256),
                        'blue'  => rand(256)
                    },
                    'end' => {
                        'red'   => rand(256),
                        'green' => rand(256),
                        'blue'  => rand(256)
                    }
                }
            }
    );
}
sleep $wait;

print_it($F,'Rounded Box Test');
foreach my $p (1..100) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->box({'x' => rand($XX),'y' => rand($YY),'xx' => rand($XX),'yy' => rand($YY),'radius' => rand(20)+1});
}
sleep $wait;

print_it($F,'Filled Rounded Box Test');
foreach my $p (1..100) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->box({'x' => rand($XX),'y' => rand($YY),'xx' => rand($XX),'yy' => rand($YY),'radius' => rand(80)+1,'filled' => 1});
}
sleep $wait;

print_it($F,'Gradient Rounded Box Test');
foreach my $p (1..100) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->box({'x' => rand($XX),'y' => rand($YY),'xx' => rand($XX),'yy' => rand($YY),'radius' => rand(80)+1,'filled' => 1,
                'gradient' => {
                    'start' => {
                        'red'   => rand(256),
                        'green' => rand(256),
                        'blue'  => rand(256)
                    },
                    'end' => {
                        'red'   => rand(256),
                        'green' => rand(256),
                        'blue'  => rand(256)
                    }
                }
                    }
    );
}
sleep $wait;

print_it($F,'Circle Test');
foreach my $p (1..100) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->circle({'x' => rand($XX),'y' => rand($YY),'radius' => rand($center_y)});
}
sleep $wait;

print_it($F,'Filled Circle Test');
foreach my $p (1..50) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->circle({'x' => rand($XX),'y' => rand($YY),'radius' => rand($center_y),'filled' => 1});
}
sleep $wait;

print_it($F,'Gradient Circle Test');
foreach my $p (1..50) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->circle({'x' => rand($XX),'y' => rand($YY),'radius' => rand($center_y),'filled' => 1,
                   'gradient' => {
                       'start' => {
                           'red'   => rand(256),
                           'green' => rand(256),
                           'blue'  => rand(256)
                       },
                       'end' => {
                           'red'   => rand(256),
                           'green' => rand(256),
                           'blue'  => rand(256)
                       }
                   }
               }
    );
}
sleep $wait;

print_it($F,'Polygon Test');
foreach my $p (1..50) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->polygon({'coordinates' => [rand($XX),rand($YY),rand($XX),rand($YY),rand($XX),rand($YY),rand($XX),rand($YY)]});
}
sleep $wait;

print_it($F,'Filled Polygon Test');
foreach my $p (1..50) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->polygon({'coordinates' => [rand($XX),rand($YY),rand($XX),rand($YY),rand($XX),rand($YY),rand($XX),rand($YY)],'filled' => 1});
}
sleep $wait;

print_it($F,'Gradient Polygon Test');
foreach my $p (1..50) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->polygon({'coordinates' => [rand($XX),rand($YY),rand($XX),rand($YY),rand($XX),rand($YY),rand($XX),rand($YY)],'filled' => 1,
                    'gradient' => {
                        'start' => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        },
                        'end' => {
                            'red'   => rand(256),
                            'green' => rand(256),
                            'blue'  => rand(256)
                        }
                    }
                }
    );
}
sleep $wait;

print_it($F,'Testing Cubic Bezier Curves');

foreach my $z (1..50) {
    $F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
    $F->cubic_bezier({'coordinates' => [rand($XX),rand($YY),rand($XX),rand($YY),rand($XX),rand($YY),rand($XX),rand($YY)],'pixel_size' => rand(6)});
}

print_it($F,'Testing TrueType Font Rendering');

$F->or_mode();
foreach my $c (1..100) {
    my $b = $F->ttf_print(
        {
            'x'            => int(rand(1800)),
            'y'            => int(rand(1080)),
            'height'       => int(rand(200)),
            'color'        => sprintf('%x%x%x%x',int(rand(256)),int(rand(256)),int(rand(256)),int(rand(256))),
            'text'         => 'WEEEE!!',
            'bounding_box' => 1,
            'center'       => 0
        }
    );
    last unless (defined($b));
    $F->ttf_print($b);
}

$F->normal_mode();
print_it($F,'Testing flood fill');
$F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
$F->polygon({'coordinates' => [220,190,$XX-400,40,$center_x+200,$YY,$center_x,$center_y,$center_x-200,$YY]});
$F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
$F->polygon({'coordinates' => [$center_x+310,$center_y+30, $center_x+10,180, 600,500]});

$F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
$F->fill({'x' => $center_x+100, 'y' => $center_y + 100});
$F->set_color({'red' => rand(256),'green' => rand(256),'blue' => rand(256)});
$F->fill({'x' => $center_x, 'y' => $center_y - 100});

exit(0);

sub print_it {
    my $fb      = shift;
    my $message = shift;
    $fb->clip_reset();
    $fb->cls();
    system('clear');
    my $b = $fb->ttf_print(
        {
            'x'            => 5,
            'y'            => 30,
            'height'       => 30,
            'color'        => '00FF00',
            'text'         => $message,
            'bounding_box' => 1,
            'center'       => 0
        }
    );
    if (defined($b)) {
        $fb->ttf_print($b);
    } else {
        print locate(1,1),clline(),$message;
    }
    $fb->clip_set({'x' => 0, 'y' => 40,'xx' => $XX,'yy' => $YY});
}

__END__

