#!/usr/bin/perl

use 5.010;
use strict;
use warnings FATAL => 'all';
use ExtUtils::MakeMaker;


if (defined($ENV{'DISPLAY'})) {
    print qq(

****************************************************************************
* Graphics::Framebuffer should not be installed from within X-Windows!     *
*                                                                          *
* You should install it from the console itself, and not a console window. *
****************************************************************************

If you insist on installing from within X-Windows, please keep in mind that
the tests will show nothing, as they will be unable to draw to the screen,
since X-Windows is using it.  Thus the tests will run in emulation mode only.

);
}

print "\nChecking for 'fbset' binary... ";
my $fbset = `fbset -i 2>&1`;

if ($fbset =~ /mode/) {
    print "FOUND\n\n";
} else {
    print "NOT FOUND\n\nWhile 'fbset' is not required, it is, nevertheless, recommended.\nIt is used as a last resort to get infomration about the framebuffer\nfor the module to render properly.\n\nIf your display is scrambled or skewed, then installing this should fix it.\n\n";
}
print "\nChecking for 'fgconsole' binary... ";
my $fg = `fgconsole 2>&1`;

if ($fg =~ /\d+/ || -e '/bin/fgconsole') {
    print "FOUND\n\n";
} else {
    print "NOT FOUND\n\nWhile 'fgconsole' is not required, it is needed for the 'which_console' method to function.\n\n";
}

my $perl_version = `perl -v`;

if ($perl_version =~ /thread/) {
    print "Threaded Perl detected\n";
} else {
    print "Not a threaded Perl.  Making adjustments...\n";
    my $MOD = slurp_file('lib/Graphics/Framebuffer.pm');
    $MOD =~ s/use threads/\# use threads/sg;
    my $change_from = 'NO_THREADS = FALSE';
    my $change_to   = 'NO_THREADS = TRUE';
    $MOD =~ s/$change_from/$change_to/sg;
    open(my $OUT,'>','lib/Graphics/Framebuffer.pm');
    print $OUT "$MOD\n";
    close($OUT);
    print "Changes complete\n";
}    

WriteMakefile(
    NAME               => 'Graphics::Framebuffer',
    AUTHOR             => q{Richard Kelsch <rich@rk-internet.com>},
    VERSION_FROM       => 'lib/Graphics/Framebuffer.pm',
    ABSTRACT_FROM      => 'lib/Graphics/Framebuffer.pm',
    LICENSE            => 'Artistic_2_0',
    PL_FILES           => {},
    MIN_PERL_VERSION   => 5.010,
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => 0,
    },
    BUILD_REQUIRES => {
        'Test::More' => '0.90',
        'List::Util' => '1.20',
    },
    PREREQ_PM      => {
        'Math::Bezier'   => '0.01',
        'Math::Trig'     => '1.10',
        'Math::Gradient' => '0.03',
        'List::Util'     => '1.20',
        'Sys::Mmap'      => '0.16',
        'Imager'         => '0.91',
    },
    dist  => {COMPRESS => 'gzip -9f', SUFFIX => 'gz',},
    clean => {FILES    => 'Graphics-Framebuffer-*'},
);

print "\nNow run:\n\n\tmake\n";
print "\nUse to test:\n\n\tmake test\n\nUse to install (you may need to do it as root with sudo):\n\n\tmake install\n\n";
print qq{The "examples" directory (in this package) has some handy scripts to help get you started, and show you how to use the module.  Just 'perldoc' each to see how to use them:\n\n};
print "\tmmapvsfile.pl  - This script will tell you which rendering mode is best for your device.  Pass it the device number to test (if it's not 0)\n\n";
print "\tprimitives.pl  - This script will pretty much demonstrate all of the capabilities of this module.\n\n";
print "\tthreadstest.pl - This script demonstrates how to use the module in a threading environment.\n\n";
print "\tslideshow.pl   - This script shows all of the images in a specific path.  It automatically detects all of your framebuffer devices, and dedicates a thread to each.\n\n";
print "\tviewpic.pl     - This script shows one specific image (or animation).\n\n";
print "\tdump.pl        - This script does a diagnostic variable dump to STDERR for the author to help you with troubleshooting.\n\n";

sub slurp_file {
    my $file = shift;

    # Read in a text file without using open
    return (
        do { local (@ARGV, $/) = $file; <> }
    );
}
