#!/usr/bin/perl

use strict;

use Graphics::Framebuffer;
use Time::HiRes qw(sleep);

my $fb = Graphics::Framebuffer->new('SPLASH' => 1,'SHOW_ERRORS'=>1);

my $adj = $fb->{'XRES'} / 1920;

$fb->cls();
# $fb->or_mode();

foreach my $font (sort(keys %{$fb->{'FONTS'}})) {
    $fb->cls();
    my $tprint = {
        'bounding_box' => 1,
        'face'         => $fb->{'FONTS'}->{$font}->{'font'},
        'center'       => 3,
        'text'         => $font,
        'font_path'    => $fb->{'FONTS'}->{$font}->{'path'},
        'color'        => 'FFFFFFFF',
        'height'       => 150 * $adj,
        'antialias'    => 1
    };
    $fb->ttf_print(
        $fb->ttf_print($tprint)
    );
    sleep .5;
}

