#!perl -T

use strict;
use Test::More tests => 210;

use Graphics::Framebuffer;

TODO: {
    local $TODO = "Tests may fail in emulation mode";
    my $fb = Graphics::Framebuffer->new();
    isa_ok($fb, 'Graphics::Framebuffer');

    $fb->cls();

    # This is slow because of the screen memory copies for this test.
    foreach my $y (0..198) {
        my $oldscreen = $fb->{'SCREEN'}; # Make a copy of the screen
        $fb->set_color({'red' => rand(256),'green' => rand(256), 'blue' => rand(256)});
        $fb->plot({'x'=>rand($fb->{'XRES'}),'y'=>rand($fb->{'YRES'}),'pixel_size'=>1 + rand(4)});
        my $ok = ($oldscreen ne $fb->{'SCREEN'});
        ok($ok,"$y,$y Point was plotted");
    }

    my $oldscreen = $fb->{'SCREEN'};
    $fb->plot({'x'=>0,'y'=>0,'pixel_size'=>1});
    $fb->drawto({'x'=>639,'y'=>479,'pixel_size'=>1});
    my $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Line was drawn');

    $fb->cls();

    $oldscreen = $fb->{'SCREEN'};
    $fb->circle({'x'=>$fb->{'XRES'}/2,'y'=>$fb->{'YRES'}/2,'radius'=>$fb->{'YRES'}/2.1,'pixel_size'=>1});
    $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Circle was drawn');

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    $fb->circle({'x'=>$fb->{'XRES'}/2,'y'=>$fb->{'YRES'}/2,'radius'=>$fb->{'YRES'}/3,'pixel_size'=>10});
    $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Bold Circle was drawn');

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    $fb->circle({'x'=>$fb->{'XRES'}/2,'y'=>$fb->{'YRES'}/2,'radius'=>$fb->{'YRES'}/2.1,'filled'=>1});
    $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Filled circle was drawn');

    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    $fb->box({'x'=>10,'y'=>10,'xx'=>600,'yy'=>300,'filled'=>0});
    $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Box frame was drawn');

    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    $fb->rbox({'x'=>20,'y'=>20,'width'=>600,'height'=>300,'filled'=>1});
    $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Filled box was drawn');

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    $fb->polygon({'coordinates'=>[320,10,220,100,440,200,320,10],'pixel_size'=>1});
    $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Polygon was drawn');

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    $fb->polygon({'coordinates'=>[300,10,210,110,420,210,330,20],'pixel_size'=>1, 'filled' => 1});
    $ok = ($oldscreen ne $fb->{'SCREEN'});
    ok($ok,'Filled Polygon was drawn');

    $fb->cls();
    my $pixel = $fb->pixel({'x'=>100,'y'=>200});
    $ok = ($pixel->{'red'} == 0 && $pixel->{'green'} == 0 && $pixel->{'blue'} == 0);
    ok($ok,'Starting color of pixel is black');

    $fb->plot({'x'=>100,'y'=>200,'pixel_size'=>1});
    $pixel = $fb->pixel({'x'=>100,'y'=>200});
    $ok = ($pixel->{'red'} == 255 && $pixel->{'green'} == 255 && $pixel->{'blue'} == 255);
    ok($ok,'Pixel color is now white');
}
