#!/usr/bin/perl -w

use strict;
use Switch;

use Graphics::Framebuffer;
use Term::ANSIScreen qw(:cursor);

$| = 1;
my $F = Graphics::Framebuffer->new('FB_DEVICE' => '/dev/fb0','FILE_MODE' => 0);

my $screen_width  = $F->{'XRES'};
my $screen_height = $F->{'YRES'};
my $XX            = $screen_width;
my $YY            = $screen_height;
my $center_x      = int($screen_width / 2);
my $center_y      = int($screen_height / 2);
my $wait          = 2;

$F->cls();
$F->clip_set({'x' => 0, 'y' => 20,'xx' => $XX,'yy' => $YY});
$F->normal_mode();

print locate(1,1),'Plotting Test                           ';
foreach my $p (1..100) {
    $F->plot({'x' => rand($screen_width),'y' => rand($screen_height)});
}
sleep $wait;

$F->cls();
print locate(1,1),'Drawto Test                             ';
for(my $l=20;$l < $YY;$l += 20) {
    $F->plot({'x' => 0,'y' => $l});
    $F->drawto({'x' =>$XX, 'y' => $l});
}
for(my $l=0;$l < $XX;$l += 20) {
    $F->plot({'x' => $l,'y' => 20});
    $F->drawto({'x' =>$l, 'y' => $YY});
}
sleep $wait;

$F->cls();
print locate(1,1),'Box Test                                   ';
$F->rbox({'x' => 100,'y' => 100,'width' => 400,'height' => 200});
sleep $wait;

$F->cls();
print locate(1,1),'Filled Box Test                            ';
$F->rbox({'x' => 100,'y' => 100,'width' => 400,'height' => 200,'filled' => 1});
sleep $wait;

$F->cls();
print locate(1,1),'Circle Test                                ';
$F->circle({'x' => $center_x,'y' => $center_y,'radius' => 200});
sleep $wait;

$F->cls();
print locate(1,1),'Filled Circle Test                         ';
$F->circle({'x' => $center_x,'y' => $center_y,'radius' => 200,'filled' => 1});
sleep $wait;

$F->cls();
print locate(1,1),'Polygon Test                               ';
$F->polygon({'coordinates' => [40,150,500,60,800,600,500,300]});
sleep $wait;

$F->cls();
print locate(1,1),'Filled Polygon Test                        ';
$F->polygon({'coordinates' => [40,150,500,60,800,600,500,300],'filled' => 1});
sleep $wait;

$F->cls();
print locate(1,1),'Testing fill                               ';
$F->polygon({'coordinates' => [0,20,$XX,20,$center_x+200,$YY,$center_x,$center_y,$center_x-200,$YY]});
$F->fill({'x' => 100, 'y' => 100});
# sleep $wait;

__END__

