use strict;
use ExtUtils::MakeMaker;

sub select_storage
{
    my @methods = @_;

    my ($use_this, $method);

    for $method (@methods)
    {
        print "Searching for $method ...";
        eval "use $method";
        if ($@)
        {
            print " not found\n";
            next;
        }
        else
        {
            print " found.\n";
            $use_this = $method;
            last;
        }
    }

    unless ($use_this)
    {
        print STDERR "I was unable to find any of the supported storage " .
          "methods:\n\n\t";
        print STDERR join("\n\t", sort @methods) . "\n\n";
        print STDERR "You will need at least one of these installed for " .
            "Devel::Coverage to work.\n";
        exit -1;
    }

    $use_this;
}

sub create_excludes { join(':', grep($_ ne '.', @INC)) }

sub write_config
{
    use IO::File;
    my $cfg_file = 'Coverage/coverperl_prefs.pl';

    if (-e "$cfg_file")
    {
        print STDERR "Copying old $cfg_file to $cfg_file.old\n";
        rename "$cfg_file", "$cfg_file.old";
    }

    my $excludes = create_excludes;
    my $storage = select_storage qw(Storable Data::Dumper);
    my $date = scalar localtime;
    my $fh = new IO::File "> $cfg_file";
    die "Error opening $cfg_file to write: $!" unless (defined $fh);

    print $fh <<"END_CONFIG";
#
# $date
#
# Config file $cfg_file auto-generated by $0.
# Do not edit this file, edit $0 instead.
# Changes made here will be lost.
#
package Devel::Coverage;

\$prefs{exclude} = '$excludes';
\$prefs{default_storage} = '$storage';

1;
END_CONFIG

    close $fh;
    1;
}

write_config;

WriteMakefile(
              NAME           => 'Devel::Coverage',
              VERSION_FROM   => 'Coverage.pm',
	      EXE_FILES      => [qw(coverperl)],
              dist           => { COMPRESS => 'gzip -9f', SUFFIX => 'gz' }, 
              realclean      => { FILES =>
                                  'Coverage/coverperl_prefs.pl ' .
                                  'Coverage/coverperl_prefs.pl.old' },
);
