
use strict;
use warnings;



use ExtUtils::MakeMaker 6.31;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'upload things to the CPAN',
  'AUTHOR' => 'Ricardo SIGNES <rjbs@cpan.org>',
  'BUILD_REQUIRES' => {
    'Test::More' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.31'
  },
  'DISTNAME' => 'CPAN-Uploader',
  'EXE_FILES' => [
    'bin/cpan-upload'
  ],
  'LICENSE' => 'perl',
  'NAME' => 'CPAN::Uploader',
  'PREREQ_PM' => {
    'Carp' => '0',
    'Data::Dumper' => '0',
    'File::Basename' => '0',
    'File::Spec' => '0',
    'Getopt::Long::Descriptive' => '0.084',
    'HTTP::Request::Common' => '0',
    'HTTP::Status' => '0',
    'LWP::UserAgent' => '0',
    'Term::ReadKey' => '0'
  },
  'VERSION' => '0.101550',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



