use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name       => 'Statistics::Sequences',
    license           => 'perl',
    dist_author       => 'Roderick Garton <rgarton@cpan.org>',
    dist_version_from => 'lib/Statistics/Sequences.pm',
    dist_abstract =>
'Manage sequences (ordered list of literals) for testing their runs, joins, turns, trinomes, potential energy, etc.',
    configure_requires => {
        'Module::Build' => 0.421,
    },
    build_requires => {
        'Test::More' => '0.98',
    },
    requires => {
        'Statistics::Data'              => '0.09',
        'Statistics::Sequences::Pot'    => '0.13',
        'Statistics::Sequences::Runs'   => '0.21',
        'Statistics::Sequences::Turns'  => '0.11',
        'Statistics::Sequences::Joins'  => '0.11',
        'Statistics::Sequences::Vnomes' => '0.11',
        'Scalar::Util'                  => '1.41',
    },
    add_to_cleanup     => ['Statistics-Sequences-0.13-*'],
    create_makefile_pl => 'traditional',
);

$builder->create_build_script();
1;
