# 4A-assoc_data.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from assoc_data
use strict;
use warnings;

use Test::More tests => 5;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $word2, $dat, $aref, @vals) = (qw/milk cow/);

my %dat_ref = (
    valassoc5 => 0.388,
);

# Test list_associates:
 @vals = $usf->assoc_data($word1, $word2); # assumes ref => 0
 $dat = $vals[5];
 ok( is_equal($dat, $dat_ref{'valassoc5'}), "Seeking $dat_ref{'valassoc5'} associates, got $dat");
 
 @vals = $usf->assoc_data($word1, $word2, {ref => 0});
 $dat = $vals[5];
 ok( is_equal($dat, $dat_ref{'valassoc5'}), "Seeking $dat_ref{'valassoc5'} associates, got $dat");
 
 $aref = $usf->assoc_data($word1, $word2, {ref => 1});
 $dat = $aref->[5];
 ok( is_equal($dat, $dat_ref{'valassoc5'}), "Seeking $dat_ref{'valassoc5'} associates, got $dat");
 
 my $href = $usf->assoc_data($word1, $word2, {ref => 2});
 $dat = $href->{'FSG'};
 ok( is_equal($dat, $dat_ref{'valassoc5'}), "Seeking $dat_ref{'valassoc5'} associates, got $dat");
 

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
