#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::NephoScale
#     ABSTRACT:  identify NephoScale (AS13332 AS32105 AS46717) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::NephoScale;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known NephoScale (AS13332 AS32105 AS46717) IP blocks as of Oct 2014
    $self->ips(qw(
        23.252.240.0 - 23.252.255.255
        64.58.112.0 - 64.58.127.255
        66.242.0.0 - 66.242.15.255
        67.207.192.0 - 67.207.207.255
        68.169.0.0 - 68.169.31.255
        69.50.224.0 - 69.50.255.255
        96.46.176.0 - 96.46.191.255
        142.0.192.0 - 142.0.207.255
        142.0.240.0 - 142.0.255.255
        173.0.144.0 - 173.0.159.255
        173.233.128.0 - 173.233.159.255
        173.237.0.0 - 173.237.79.255
        198.89.96.0 - 198.89.127.255
        198.100.160.0 - 198.100.191.255
        199.188.116.0 - 199.188.119.255
        204.74.224.0 - 204.74.255.255
        208.69.176.0 - 208.69.183.255
        208.78.240.0 - 208.78.247.255
        208.166.48.0 - 208.166.63.255
        209.205.112.0 - 209.205.127.255
    ));
    return $self;
}

sub name {
    return 'NephoScale';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::NephoScale - identify NephoScale (AS13332 AS32105 AS46717) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::NephoScale;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::NephoScale identifies NephoScale (AS13332 AS32105 AS46717) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::NephoScale object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
