package Statocles::Deploy;
# ABSTRACT: Base role for ways to deploy a site
$Statocles::Deploy::VERSION = '0.037';
use Statocles::Base 'Role';


has base_url => (
    is => 'ro',
    isa => Str,
);


requires qw( deploy );

1;

__END__

=pod

=head1 NAME

Statocles::Deploy - Base role for ways to deploy a site

=head1 VERSION

version 0.037

=head1 DESCRIPTION

A Statocles::Deploy deploys a site to a destination, like Git, SFTP, or
otherwise.

=head1 ATTRIBUTES

=head2 base_url

The base URL for this deploy. Site URLs will be automatically rewritten to be
based on this URL.

This allows you to have different versions of the site deployed to different
URLs.

=head1 METHODS

=head2 deploy( FROM_STORE, MESSAGE )

Deploy the site, copying from the given L<store object|Statocles::Store>, optionally
committing with the given message. Returns a list of file paths deployed.

This must be implemented by the composing class.

=head1 SEE ALSO

=over 4

=item L<Statocles::Deploy::File>

=item L<Statocles::Deploy::Git>

=item L<Statocles::Store>

=back

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
