
package ZCS::Admin::Elements::GetServerRequest;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:zimbraAdmin' }

__PACKAGE__->__set_name('GetServerRequest');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS = 'ZCS::Admin::Elements::GetServerRequest::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %server_of :ATTR(:get<server>);

__PACKAGE__->_factory(
    [ qw(        server

    ) ],
    {
        'server' => \%server_of,
    },
    {
        'server' => 'ZCS::Admin::Types::GetServerSpecifier',
    },
    {

        'server' => 'server',
    }
);

} # end BLOCK




package ZCS::Admin::Elements::GetServerRequest::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %applyConfig_of :ATTR(:get<applyConfig>);
my %attrs_of :ATTR(:get<attrs>);

__PACKAGE__->_factory(
    [ qw(
        applyConfig
        attrs
    ) ],
    {

        applyConfig => \%applyConfig_of,

        attrs => \%attrs_of,
    },
    {
        applyConfig => 'ZCS::Admin::Types::IntBool',
        attrs => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    }
);

} # end BLOCK


} # end of BLOCK



1;


=pod

=head1 NAME

ZCS::Admin::Elements::GetServerRequest

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
GetServerRequest from the namespace urn:zimbraAdmin.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * server

 $element->set_server($data);
 $element->get_server();





=back


=head1 METHODS

=head2 new

 my $element = ZCS::Admin::Elements::GetServerRequest->new($data);

Constructor. The following data structure may be passed to new():

 {
   server =>  { value => $some_value },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

