BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Data::Dumper File::Spec File::Temp FindBin strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.008001; 1}) {
    print "Perl 5.008001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.38.
use strict;
use warnings;
use 5.008001;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Alien::Build plugin to download from GitHub",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Alien-Build-Plugin-Download-GitHub",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME"             => "Alien::Build::Plugin::Download::GitHub",
  "PM"               => {
    "lib/Alien/Build/Plugin/Download/GitHub.pm" => "\$(INST_LIB)/Alien/Build/Plugin/Download/GitHub.pm"
  },
  "PREREQ_PM" => {
    "Alien::Build"                              => "1.63",
    "Alien::Build::Plugin"                      => 0,
    "Alien::Build::Plugin::Download::Negotiate" => 0,
    "Alien::Build::Plugin::Extract::Negotiate"  => 0,
    "JSON::PP"                                  => 0,
    "Path::Tiny"                                => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny"      => 0,
    "HTTP::Tiny"         => 0,
    "Test2::V0"          => "0.000060",
    "Test::Alien::Build" => 0
  },
  "VERSION" => "0.04",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Alien::Build"                              => "1.63",
  "Alien::Build::Plugin"                      => 0,
  "Alien::Build::Plugin::Download::Negotiate" => 0,
  "Alien::Build::Plugin::Extract::Negotiate"  => 0,
  "Capture::Tiny"                             => 0,
  "HTTP::Tiny"                                => 0,
  "JSON::PP"                                  => 0,
  "Path::Tiny"                                => 0,
  "Test2::V0"                                 => "0.000060",
  "Test::Alien::Build"                        => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);